DROP TABLE IF EXISTS `avis_language`;
CREATE TABLE IF NOT EXISTS `avis_language` (
  `language_id` int(15) NOT NULL AUTO_INCREMENT,
  `language_name` varchar(255) DEFAULT NULL,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(1) DEFAULT '0',
  `display_order` int(15) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `language_code` varchar(15) DEFAULT NULL,
  `char_set` varchar(15) DEFAULT NULL,
  `direction` tinyint(1) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_language` values (1,'English','',1,0,1,'english.php','en','utf8',0,0);
insert into `avis_language` values (2,'Dutch','',0,0,2,'dutch.php','nl','utf8',0,1);
insert into `avis_language` values (3,'French','',0,0,3,'french.php','fr','utf8',0,1);
insert into `avis_language` values (4,'German','',0,0,4,'german.php','de','utf8',0,1);
insert into `avis_language` values (5,'Russian','',0,0,5,'russian.php','ru','utf8',0,1);
insert into `avis_language` values (6,'Spanish','',0,0,6,'spanish.php','es','utf8',0,1);
insert into `avis_language` values (7,'Swedish','',0,0,7,'swedish.php','se','utf8',0,1);
insert into `avis_language` values (8,'Turkish','',0,0,8,'turkish.php','tr','utf8',0,1);
insert into `avis_language` values (9,'Italian','',0,0,9,'italian.php','it','utf8',0,1);
DROP TABLE IF EXISTS `avis_language_data`;
CREATE TABLE IF NOT EXISTS `avis_language_data` (
  `language_data_id` int(15) NOT NULL AUTO_INCREMENT,
  `location` int(4) NOT NULL DEFAULT '0',
  `title` text,
  `language_id` int(15) DEFAULT NULL,
  `data_id` int(15) DEFAULT NULL,
  PRIMARY KEY (`language_data_id`),
  KEY `location` (`location`,`language_id`,`data_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_language_data` (`location`, `title`, `language_id`, `data_id`) VALUES
(0,'Open',1,1),
(0,'Awaiting',1,2),
(0,'Closed',1,3),
(0,'Open',2,1),
(0,'In afwachting',2,2),
(0,'Gesloten',2,3),
(0,'Ouvert',3,1),
(0,'En attente',3,2),
(0,'Fermé',3,3),
(0,'Geöffnet',4,1),
(0,'Erwartung',4,2),
(0,'Geschlossen',4,3),
(0,'открыто',5,1),
(0,'в ожидании',5,2),
(0,'закрыто',5,3),
(0,'abierto',6,1),
(0,'En espera',6,2),
(0,'cerrado',6,3),
(0,'öppen',7,1),
(0,'Väntar',7,2),
(0,'stängt',7,3),
(0,'açık',8,1),
(0,'Bekleniyor',8,2),
(0,'kapalı',8,3),
(0,'aperto',9,1),
(0,'In attesa',9,2),
(0,'chiuso',9,3),
(1,'Low',1,1),
(1,'Medium',1,2),
(1,'High',1,3),
(1,'Critical',1,4),
(1,'Laag',2,1),
(1,'Hoog',2,2),
(1,'Kritisch',2,3),
(1,'Faible',3,1),
(1,'élevé',3,2),
(1,'Critique',3,3),
(1,'Niedrig',4,1),
(1,'Hoch',4,2),
(1,'Kritisch',4,3),
(1,'низкий',5,1),
(1,'выѿокий',5,2),
(1,'критичеѿкий',5,3),
(1,'bajo',6,1),
(1,'alto',6,2),
(1,'crítico',6,3),
(1,'låg',7,1),
(1,'hög',7,2),
(1,'kritisk',7,3),
(1,'düşük',8,1),
(1,'yüksek',8,2),
(1,'kritik',8,3),
(1,'basso',9,1),
(1,'alto',9,2),
(1,'critico',9,3),
(2,'Issue',1,1),
(2,'Question',1,2),
(2,'Bug',1,3),
(2,'Probleem',2,1),
(2,'Vraag',2,2),
(2,'Kever',2,3),
(2,'Question',3,1),
(2,'Question',3,2),
(2,'Insecte',3,3),
(2,'Ausgabe',4,1),
(2,'Frage',4,2),
(2,'Fehler',4,3),
(2,'проблема',5,1),
(2,'вопроѿ',5,2),
(2,'ошибка',5,3),
(2,'cuestión',6,1),
(2,'pregunta',6,2),
(2,'Bug',6,3),
(2,'Problem',7,1),
(2,'fråga',7,2),
(2,'Bug',7,3),
(2,'konu',8,1),
(2,'soru',8,2),
(2,'böcek',8,3),
(2,'problema',9,1),
(2,'domanda',9,2),
(2,'insetto',9,3),
(3,'White',1,1),
(3,'Red',1,3),
(3,'Green',1,2),
(3,'Wit',2,1),
(3,'Rood',2,3),
(3,'Groen',2,2),
(3,'Blanc',3,1),
(3,'Rouge',3,3),
(3,'Vert',3,2),
(3,'Weiß',4,1),
(3,'Rote',4,3),
(3,'Grün',4,2),
(3,'белый',5,1),
(3,'краѿный',5,3),
(3,'зеленый',5,2),
(3,'blanco',6,1),
(3,'rojo',6,3),
(3,'verde',6,2),
(3,'vit',7,1),
(3,'röd',7,3),
(3,'grön',7,2),
(3,'beyaz',8,1),
(3,'kırmızı',8,3),
(3,'yeşil',8,2),
(3,'bianco',9,1),
(3,'rosso',9,3),
(3,'verde',9,2);
INSERT INTO `avis_language_data` (`location`, `title`, `language_id`, `data_id`) VALUES 
( 5, 'Services', 1, 1),
( 5, 'Diensten', 2, 1),
( 5, 'Services', 3, 1),
( 5, 'Dienstleistungen', 4, 1),
( 5, 'У�?луги', 5, 1),
( 5, 'Servicios', 6, 1),
( 5, 'Tjänster', 7, 1),
( 5, 'Hizmetler', 8, 1),
( 5, 'Servizi', 9, 1),
( 5, 'Hardware', 1, 2),
( 5, 'Hardware', 2, 2),
( 5, 'Matériel', 3, 2),
( 5, 'Hardware', 4, 2),
( 5, '�?ппаратный', 5, 2),
( 5, 'Hardware', 6, 2),
( 5, 'Hårdvara', 7, 2),
( 5, 'Donanım', 8, 2),
( 5, 'Hardware', 9, 2),
( 5, 'Software', 1, 3),
( 5, 'Software', 2, 3),
( 5, 'Logiciel', 3, 3),
( 5, 'Software', 4, 3),
( 5, 'Программное обе�?печение', 5, 3),
( 5, 'Software', 6, 3),
( 5, 'Programvara', 7, 3),
( 5, 'Yazılım', 8, 3),
( 5, 'Software', 9, 3),
( 5, 'Consumable', 1, 4),
( 5, 'Verbruiksartikelen', 2, 4),
( 5, 'Consommable', 3, 4),
( 5, 'Verbrauchsgut', 4, 4),
( 5, 'Потребл�?емый', 5, 4),
( 5, 'Consumible', 6, 4),
( 5, 'Förbrukningsartikel', 7, 4),
( 5, 'Tüketilir', 8, 4),
( 5, 'Consumabili', 9, 4),
( 5, 'Network', 1, 5),
( 5, 'Netwerk', 2, 5),
( 5, 'Réseau', 3, 5),
( 5, 'Netzwerk', 4, 5),
( 5, 'Сеть', 5, 5),
( 5, 'Red', 6, 5),
( 5, 'Nätverk', 7, 5),
( 5, 'şebeke', 8, 5),
( 5, 'Rete', 9, 5),
( 5, 'Document', 1, 6),
( 5, 'Document', 2, 6),
( 5, 'Document', 3, 6),
( 5, 'Dokument', 4, 6),
( 5, 'Документ', 5, 6),
( 5, 'Documento', 6, 6),
( 5, 'Dokument', 7, 6),
( 5, 'Belge', 8, 6),
( 5, 'Documento', 9, 6),
( 5, 'Other', 1, 7),
( 5, 'Ander', 2, 7),
( 5, 'Autre', 3, 7),
( 5, 'Andere', 4, 7),
( 5, 'Другой', 5, 7),
( 5, 'Otro', 6, 7),
( 5, 'Annat', 7, 7),
( 5, 'Diğer', 8, 7),
( 5, 'Altro', 9, 7),
( 6, 'In use', 1, 1),
( 6, 'In gebruik', 2, 1),
( 6, 'Utilisé', 3, 1),
( 6, 'Im Einsatz', 4, 1),
( 6, 'В и�?пользовании', 5, 1),
( 6, 'En uso', 6, 1),
( 6, 'Vid anvÃ¤ndning', 7, 1),
( 6, 'KullanÄ±mda', 8, 1),
( 6, 'In uso', 9, 1),
( 6, 'In Transit', 1, 3),
( 6, 'Onderweg', 2, 3),
( 6, 'En Transit', 3, 3),
( 6, 'In Transit', 4, 3),
( 6, 'В Пути', 5, 3),
( 6, 'En Camino', 6, 3),
( 6, 'I Transit', 7, 3),
( 6, 'Transit Olarak', 8, 3),
( 6, 'In Transito', 9, 3),
( 6, 'In stock', 1, 4),
( 6, 'Op voorraad', 2, 4),
( 6, 'En stock', 3, 4),
( 6, 'Vorrätig', 4, 4),
( 6, 'В наличии', 5, 4),
( 6, 'En existencia', 6, 4),
( 6, 'I lager', 7, 4),
( 6, 'Stokta var', 8, 4),
( 6, 'Disponibile', 9, 4),
( 6, 'Missing', 1, 2),
( 6, 'Vermist', 2, 2),
( 6, 'Manquant', 3, 2),
( 6, 'Fehlt', 4, 2),
( 6, 'От�?ут�?твующий', 5, 2),
( 6, 'Que falta', 6, 2),
( 6, 'Saknas', 7, 2),
( 6, 'Eksik', 8, 2),
( 6, 'Mancante', 9, 2),
( 6, 'Retired', 1, 5),
( 6, 'Gepensioneerd', 2, 5),
( 6, 'Retraité', 3, 5),
( 6, 'Im Ruhestand', 4, 5),
( 6, 'В от�?тавке', 5, 5),
( 6, 'Jubilado', 6, 5),
( 6, 'Pensionerad', 7, 5),
( 6, 'Emekli', 8, 5),
( 6, 'Pensionato', 9, 5),
( 7, 'Open Source', 1, 1),
( 7, 'Open Source', 2, 1),
( 7, 'Open Source', 3, 1),
( 7, 'Open Source', 4, 1),
( 7, 'Открытым и�?ходным кодом', 5, 1),
( 7, 'Código Abierto', 6, 1),
( 7, 'Öppen Källa', 7, 1),
( 7, 'Açık Kaynak', 8, 1),
( 7, 'Open Source', 9, 1),
( 7, 'Commercial', 1, 2),
( 7, 'Commercieel', 2, 2),
( 7, 'Commercial', 3, 2),
( 7, 'Kommerziell', 4, 2),
( 7, 'Коммерче�?ка�?', 5, 2),
( 7, 'Comercial', 6, 2),
( 7, 'Kommersiell', 7, 2),
( 7, 'Ticari', 8, 2),
( 7, 'Commerciale', 9, 2),
( 8, 'Lease', 1, 1),
( 8, 'Huurcontract', 2, 1),
( 8, 'Bail', 3, 1),
( 8, 'Mietvertrag', 4, 1),
( 8, '�?ренда', 5, 1),
( 8, 'Arrendamiento', 6, 1),
( 8, 'Lease', 7, 1),
( 8, 'Kiralama', 8, 1),
( 8, 'Locazione', 9, 1),
( 8, 'Software License', 1, 2),
( 8, 'Software License', 2, 2),
( 8, 'Software License', 3, 2),
( 8, 'Software-Lizenz', 4, 2),
( 8, 'об�?луживание', 5, 2),
( 8, 'Licencia de Software', 6, 2),
( 8, 'Software License', 7, 2),
( 8, 'Yazılım Lisansı', 8, 2),
( 8, 'Software License', 9, 2),
( 8, 'Maintenance', 1, 3),
( 8, 'Onderhoud', 2, 3),
( 8, 'Entretien', 3, 3),
( 8, 'Wartung', 4, 3),
( 8, '�?е�?овершеннолетний', 5, 3),
( 8, 'Mantenimiento', 6, 3),
( 8, 'Underhåll', 7, 3),
( 8, 'Bakım', 8, 3),
( 8, 'Manutenzione', 9, 3),
( 9, 'Low', 1, 1),
( 9, 'Laag', 2, 1),
( 9, 'Faible', 3, 1),
( 9, 'Niedrig', 4, 1),
( 9, 'Вы�?окий', 5, 1),
( 9, 'Bajo', 6, 1),
( 9, 'Låg', 7, 1),
( 9, 'Düşük', 8, 1),
( 9, 'Basso', 9, 1),
( 9, 'Medium', 1, 2),
( 9, 'Medium', 2, 2),
( 9, 'Moyen', 3, 2),
( 9, 'Medium', 4, 2),
( 9, 'Открытым и�?ходным кодом', 5, 2),
( 9, 'Medio', 6, 2),
( 9, 'Medium', 7, 2),
( 9, 'Orta', 8, 2),
( 9, 'Medio', 9, 2),
( 9, 'High', 1, 3),
( 9, 'Hoog', 2, 3),
( 9, 'Élevé', 3, 3),
( 9, 'Hoch', 4, 3),
( 9, 'Коммерче�?ка�?', 5, 3),
( 9, 'Alto', 6, 3),
( 9, 'Hög', 7, 3),
( 9, 'Yüksek', 8, 3),
( 9, 'Alto', 9, 3),
( 10, 'Low', 1, 1),
( 10, 'Laag', 2, 1),
( 10, 'Faible', 3, 1),
( 10, 'Niedrig', 4, 1),
( 10, '�?изкий', 5, 1),
( 10, 'Bajo', 6, 1),
( 10, 'Låg', 7, 1),
( 10, 'Düşük', 8, 1),
( 10, 'Basso', 9, 1),
( 10, 'Medium', 1, 2),
( 10, 'Medium', 2, 2),
( 10, 'Moyen', 3, 2),
( 10, 'Medium', 4, 2),
( 10, 'Среда', 5, 2),
( 10, 'Medio', 6, 2),
( 10, 'Medium', 7, 2),
( 10, 'Orta', 8, 2),
( 10, 'Medio', 9, 2),
( 10, 'High', 1, 3),
( 10, 'Hoog', 2, 3),
( 10, 'Élevé', 3, 3),
( 10, 'Hoch', 4, 3),
( 10, 'Вы�?окий', 5, 3),
( 10, 'Alto', 6, 3),
( 10, 'Hög', 7, 3),
( 10, 'Yüksek', 8, 3),
( 10, 'Alto', 9, 3),
( 10, 'Very high', 1, 4),
( 10, 'Erg hoog', 2, 4),
( 10, 'Très haut', 3, 4),
( 10, 'Sehr hoch', 4, 4),
( 10, 'Очень вы�?око', 5, 4),
( 10, 'Muy alto', 6, 4),
( 10, 'Väldigt högt', 7, 4),
( 10, 'Çok yüksek', 8, 4),
( 10, 'Molto alto', 9, 4),
( 11, 'Minor', 1, 1),
( 11, 'Mineur', 2, 1),
( 11, 'Mineur', 3, 1),
( 11, 'Moll', 4, 1),
( 11, '�?е�?овершеннолетний', 5, 1),
( 11, 'Menor', 6, 1),
( 11, 'Minor', 7, 1),
( 11, 'Küçük', 8, 1),
( 11, 'Minore', 9, 1),
( 11, 'Standard', 1, 2),
( 11, 'Standaard', 2, 2),
( 11, 'Standard', 3, 2),
( 11, 'Standard', 4, 2),
( 11, 'Стандарт', 5, 2),
( 11, 'Estándar', 6, 2),
( 11, 'Standard', 7, 2),
( 11, 'Standart', 8, 2),
( 11, 'Standard', 9, 2),
( 11, 'Major', 1, 3),
( 11, 'Groot', 2, 3),
( 11, 'Majeur', 3, 3),
( 11, 'Dur', 4, 3),
( 11, 'Крупный', 5, 3),
( 11, 'Mayor', 6, 3),
( 11, 'Större', 7, 3),
( 11, 'Büyük', 8, 3),
( 11, 'Maggiore', 9, 3),
( 11, 'Emergency', 1, 4),
( 11, 'Noodgeval', 2, 4),
( 11, 'Urgence', 3, 4),
( 11, 'Notfall', 4, 4),
( 11, '�?варийный', 5, 4),
( 11, 'Emergencia', 6, 4),
( 11, 'Emergencia', 7, 4),
( 11, 'Acil durum', 8, 4),
( 11, 'Emergenza', 9, 4),
( 12, 'Minor', 1, 1),
( 12, 'Mineur', 2, 1),
( 12, 'Mineur', 3, 1),
( 12, 'Moll', 4, 1),
( 12, '�?е�?овершеннолетний', 5, 1),
( 12, 'Menor', 6, 1),
( 12, 'Minor', 7, 1),
( 12, 'Küçük', 8, 1),
( 12, 'Minore', 9, 1),
( 12, 'Major', 1, 3),
( 12, 'Groot', 2, 3),
( 12, 'Majeur', 3, 3),
( 12, 'Dur', 4, 3),
( 12, '�?варийный', 5, 3),
( 12, 'Mayor', 6, 3),
( 12, 'Större', 7, 3),
( 12, 'Büyük', 8, 3),
( 12, 'Maggiore', 9, 3),
( 12, 'Standard', 1, 2),
( 12, 'Standaard', 2, 2),
( 12, 'Standard', 3, 2),
( 12, 'Standard', 4, 2),
( 12, 'Крупный', 5, 2),
( 12, 'Estándar', 6, 2),
( 12, 'Standard', 7, 2),
( 12, 'Standart', 8, 2),
( 12, 'Standard', 9, 2),
( 12, 'Emergency', 1, 4),
( 12, 'Noodgeval', 2, 4),
( 12, 'Urgence', 3, 4),
( 12, 'Notfall', 4, 4),
( 12, 'В производ�?тве', 5, 4),
( 12, 'Emergencia', 6, 4),
( 12, 'Emergency', 7, 4),
( 12, 'Acil durum', 8, 4),
( 12, 'Emergenza', 9, 4),
( 13, 'In production', 1, 1),
( 13, 'In bewerking', 2, 1),
( 13, 'En production', 3, 1),
( 13, 'In Produktion', 4, 1),
( 13, 'В производ�?тве', 5, 1),
( 13, 'En producción', 6, 1),
( 13, 'I produktion', 7, 1),
( 13, 'Üretimde', 8, 1),
( 13, 'In produzione', 9, 1),
( 13, 'In pipeline', 1, 2),
( 13, 'In pipeline', 2, 2),
( 13, 'Dans pipeline', 3, 2),
( 13, 'In Pipeline', 4, 2),
( 13, 'В трубопроводе', 5, 2),
( 13, 'En tubería', 6, 2),
( 13, 'I pipeline', 7, 2),
( 13, 'Boru hattı içinde', 8, 2),
( 13, 'In conduttura', 9, 2),
( 13, 'Retired', 1, 3),
( 13, 'Gepensioneerd', 2, 3),
( 13, 'Retraité', 3, 3),
( 13, 'Im Ruhestand', 4, 3),
( 13, 'В от�?тавке', 5, 3),
( 13, 'Jubilado', 6, 3),
( 13, 'Pensionerad', 7, 3),
( 13, 'Emekli', 8, 3),
( 13, 'Pensionato', 9, 3),
( 14, 'Buy', 1, 1),
( 14, 'Kopen', 2, 1),
( 14, 'Acheter', 3, 1),
( 14, 'Kaufen', 4, 1),
( 14, 'Купить', 5, 1),
( 14, 'Comprar', 6, 1),
( 14, 'Köpa', 7, 1),
( 14, 'Satın almak', 8, 1),
( 14, 'Acquistare', 9, 1),
( 14, 'Both', 1, 3),
( 14, 'Beide', 2, 3),
( 14, 'Les deux', 3, 3),
( 14, 'Beide', 4, 3),
( 14, 'Обе', 5, 3),
( 14, 'Ambos', 6, 3),
( 14, 'Båda', 7, 3),
( 14, 'Her ikisi de', 8, 3),
( 14, 'Entrambi', 9, 3),
( 14, 'Lease', 1, 2),
( 14, 'Huurcontract', 2, 2),
( 14, 'Bail', 3, 2),
( 14, 'Mietvertrag', 4, 2),
( 14, '�?ренда', 5, 2),
( 14, 'Arrendamiento', 6, 2),
( 14, 'Lease', 7, 2),
( 14, 'Kiralama', 8, 2),
( 14, 'Locazione', 9, 2),
( 15, 'General', 1, 1),
( 15, 'algemeen', 2, 1),
( 15, 'général', 3, 1),
( 15, 'General', 4, 1),
( 15, 'Генеральнаѿ', 5, 1),
( 15, 'General', 6, 1),
( 15, 'Allmänt', 7, 1),
( 15, 'genel', 8, 1),
( 15, 'generale', 9, 1),
( 18, 'Software', 1, 1),
( 18, 'Hardware', 1, 2),
( 18, 'Software', 2, 1),
( 18, 'Hardware', 2, 2),
( 18, 'Logiciel', 3, 1),
( 18, 'Matériel', 3, 2),
( 18, 'Software', 4, 1),
( 18, 'Hardware', 4, 2),
( 18, 'программного обеспечения', 5, 1),
( 18, 'аппаратные средства', 5, 2),
( 18, 'Software', 6, 1),
( 18, 'Hardware', 6, 2),
( 18, 'Programvara', 7, 1),
( 18, 'Hårdvara', 7, 2),
( 18, 'Yazılım', 8, 1),
( 18, 'Donanım', 8, 2),
( 18, 'Software', 9, 1),
( 18, 'Hardware', 9, 2),
( 19, 'Photoshop', 1, 1),
( 19, 'Microsoft office', 1, 2),
( 19, 'Printer', 1, 3),
( 19, 'Photoshop', 2, 1),
( 19, 'Microsoft kantoor', 2, 2),
( 19, 'Printer', 2, 3),
( 19, 'Photoshop', 3, 1),
( 19, 'Microsoft Bureau', 3, 2),
( 19, 'Imprimante', 3, 3),
( 19, 'Photoshop', 4, 1),
( 19, 'Microsoft Büro', 4, 2),
( 19, 'Drucker', 4, 3),
( 19, 'фотошоп', 5, 1),
( 19, 'Microsoft офис', 5, 2),
( 19, 'принтер', 5, 3),
( 19, 'Photoshop', 6, 1),
( 19, 'Microsoft oficina', 6, 2),
( 19, 'impresora', 6, 3),
( 19, 'Photoshop', 7, 1),
( 19, 'Microsoft kontor', 7, 2),
( 19, 'Skrivare', 7, 3),
( 19, 'Photoshop', 8, 1),
( 19, 'Microsoft ofis', 8, 2),
( 19, 'Printer', 8, 3),
( 19, 'Photoshop', 9, 1),
( 19, 'Microsoft ufficio', 9, 2),
( 19, 'Stampante', 9, 3),
( 20, 'Install', 1, 1),
( 20, 'Upgrade', 1, 2),
( 20, 'Uninstall', 1, 3),
( 20, 'Install', 1, 4),
( 20, 'Upgrade', 1, 5),
( 20, 'Uninstall', 1, 6),
( 20, 'Installeren', 2, 1),
( 20, 'Upgrade', 2, 2),
( 20, 'Uninstall', 2, 3),
( 20, 'Installeren', 2, 4),
( 20, 'Upgrade', 2, 5),
( 20, 'Uninstall', 2, 6),
( 20, 'Installer', 3, 1),
( 20, 'Amélioration', 3, 2),
( 20, 'Désinstaller', 3, 3),
( 20, 'Installer', 3, 4),
( 20, 'Amélioration', 3, 5),
( 20, 'Désinstaller', 3, 6),
( 20, 'Installieren', 4, 1),
( 20, 'Aktualisierung', 4, 2),
( 20, 'Uninstall', 4, 3),
( 20, 'Installieren', 4, 4),
( 20, 'Aktualisierung', 4, 5),
( 20, 'Uninstall', 4, 6),
( 20, 'устанавливать', 5, 1),
( 20, 'Обновить', 5, 2),
( 20, 'Удаление', 5, 3),
( 20, 'устанавливать', 5, 4),
( 20, 'Обновить', 5, 5),
( 20, 'Удаление', 5, 6),
( 20, 'Instalar', 6, 1),
( 20, 'actualización', 6, 2),
( 20, 'Desinstalar', 6, 3),
( 20, 'Instalar', 6, 4),
( 20, 'actualización', 6, 5),
( 20, 'Desinstalar', 6, 6),
( 20, 'installera', 7, 1),
( 20, 'uppgradering', 7, 2),
( 20, 'avinstallera', 7, 3),
( 20, 'installera', 7, 4),
( 20, 'uppgradering', 7, 5),
( 20, 'avinstallera', 7, 6),
( 20, 'yükleme', 8, 1),
( 20, 'Yükseltme', 8, 2),
( 20, 'Kaldırma', 8, 3),
( 20, 'yükleme', 8, 4),
( 20, 'Yükseltme', 8, 5),
( 20, 'Kaldırma', 8, 6),
( 20, 'installare', 9, 1),
( 20, 'aggiornamento', 9, 2),
( 20, 'Disinstallare', 9, 3),
( 20, 'installare', 9, 4),
( 20, 'aggiornamento', 9, 5),
( 20, 'Disinstallare', 9, 6),
( 21, 'Level1', 1, 1),
( 21, 'Level2', 1, 2),
( 21, 'Level3', 1, 3),
( 21, 'Level1', 2, 1),
( 21, 'Level2', 2, 2),
( 21, 'Level3', 2, 3),
( 21, 'niveau1', 3, 1),
( 21, 'niveau2', 3, 2),
( 21, 'niveau3', 3, 3),
( 21, 'Level1', 4, 1),
( 21, 'Level2', 4, 2),
( 21, 'Level3', 4, 3),
( 21, '1-й уровень', 5, 1),
( 21, 'уровень 2', 5, 2),
( 21, 'Уровень 3', 5, 3),
( 21, 'nivel1', 6, 1),
( 21, 'nivel2', 6, 2),
( 21, 'nivel3', 6, 3),
( 21, 'nivå1', 7, 1),
( 21, 'nivå2', 7, 2),
( 21, 'nivå3', 7, 3),
( 21, 'Seviye1', 8, 1),
( 21, 'Seviye2', 8, 2),
( 21, 'Seviye3', 8, 3),
( 21, 'livello1', 9, 1),
( 21, 'livello2', 9, 2),
( 21, 'livello3', 9, 3),
( 20, 'Installeren', 2, 7),
( 20, 'Installer', 3, 7),
( 20, 'Installieren', 4, 7),
( 20, 'устанавливать', 5, 7),
( 20, 'Instalar', 6, 7),
( 20, 'installera', 7, 7),
( 20, 'yükleme', 8, 7),
( 20, 'Desinstalar', 6, 8),
( 20, 'Удаление', 5, 8),
( 20, 'Uninstall', 4, 8),
( 20, 'Install', 1, 7),
( 20, 'DÃ©sinstaller', 3, 8),
( 20, 'Uninstall', 2, 8),
( 20, 'Uninstall', 1, 8),
( 20, 'avinstallera', 7, 8),
( 20, 'KaldÄ±rma', 8, 8),
( 20, 'Disinstallare', 9, 8),
( 20, 'installare', 9, 7),
( 25, 'Knowledgebase', 1, 1),
( 25, 'Kennis basis', 2, 1),
( 25, 'Base de connaissances', 3, 1),
( 25, 'Wissensbasis', 4, 1),
( 25, 'База знаний', 5, 1),
( 25, 'Base de Conocimiento', 6, 1),
( 25, 'Kunskapsbas', 7, 1),
( 25, 'Bilgi tabanı', 8, 1),
( 25, 'Knowledgebase', 9, 1),
( 25, 'Downloads', 1, 2),
( 25, 'downloads', 2, 2),
( 25, 'Téléchargements', 3, 2),
( 25, 'Downloads', 4, 2),
( 25, 'Загрузки', 5, 2),
( 25, 'descargas', 6, 2),
( 25, 'nedladdningar', 7, 2),
( 25, 'İndirme', 8, 2),
( 25, 'download', 9, 2),
( 23, 'Feedback', 1, 1),
( 23, 'terugkoppeling', 2, 1),
( 23, "Retour d'information", 3, 1),
( 23, 'Feedback', 4, 1),
( 23, 'Обратная связь', 5, 1),
( 23, 'Realimentación', 6, 1),
( 23, 'Återkoppling', 7, 1),
( 23, 'geribesleme', 8, 1),
( 23, 'Risposta', 9, 1);

DROP TABLE IF EXISTS `avis_activitylog`;
CREATE TABLE IF NOT EXISTS `avis_activitylog` (
  `activity_id` int(15) NOT NULL AUTO_INCREMENT,
  `user_id` INT( 4 ) NOT NULL,
		`is_client` TINYINT( 1 ) NOT NULL COMMENT '0 for staff,1 for client',
  `content` text NOT NULL,
  `module_id` int(15) NOT NULL COMMENT 'setting- 0, client -1, self help-2, blab-3, login-4, cmdb-5,relationship-6, ITIL-7,schedule ticket-8,forum-9,task-10,billing-11',
  `activity_date` int(15) NOT NULL,
		`ip` VARCHAR( 31 ) NOT NULL,
		 PRIMARY KEY (`activity_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_adminaccess`;
CREATE TABLE IF NOT EXISTS `avis_adminaccess` (
  `adminaccess_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `domain_access` varchar(511) DEFAULT NULL,
  `level` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`adminaccess_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_adminaccess` values (1, 1, 0, '1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1', 1);
DROP TABLE IF EXISTS `avis_alert`;
CREATE TABLE IF NOT EXISTS `avis_alert` (
  `alert_id` int(15) NOT NULL AUTO_INCREMENT,
  `alert_name` varchar(255) DEFAULT NULL,
  `owner` int(15) DEFAULT NULL,
  `vscope` tinyint(2) DEFAULT '0',
  `sms_enabled` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `concat_type` enum('or','and') DEFAULT 'and',
  `event` varchar(255) DEFAULT NULL,
  `template` int(15) DEFAULT NULL,
  `reciever` varchar(255) DEFAULT NULL,
  `reciever_team` varchar(255) NOT NULL,
  `hipchat_enabled` INT NOT NULL,
  `slack_enabled` INT NOT NULL,
  `slack_chennel_id` TEXT NOT NULL,
  `hipchat_room_ids` TEXT NOT NULL,
  PRIMARY KEY (`alert_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_alert_criteria`;
CREATE TABLE IF NOT EXISTS `avis_alert_criteria` (
  `criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `alert_id` int(15) DEFAULT NULL,
  `base_criteria` int(15) DEFAULT NULL,
  `sub_criteria` int(4) DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_attachment`;
CREATE TABLE IF NOT EXISTS `avis_attachment` (
  `attachment_id` int(15) NOT NULL AUTO_INCREMENT,
  `parent_id` int(15) DEFAULT NULL,
  `parent_type` tinyint(2) DEFAULT '0',
  `file_location` int(15) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `file_size` varchar(255) DEFAULT NULL,
  `file_type` varchar(255) DEFAULT NULL,
  `content` longtext,
  `inline` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`attachment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_auditlog`;
CREATE TABLE IF NOT EXISTS `avis_auditlog` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT NULL,
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` tinytext,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  `channel_id` int(15) NULL DEFAULT '0',
  `department_id` int(11) NULL DEFAULT '0',
  `domain_id` int(11) NULL DEFAULT '0',
  `access_id` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-ticket, 1-problem, 2-changes',
  PRIMARY KEY (`log_id`),
  KEY `ticket_hash` (`ticket_hash`),
  KEY `location` (`location`,`access_id`),
  KEY `log_id` (`log_id`,`entry_date`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_automation`;
CREATE TABLE IF NOT EXISTS `avis_automation` (
  `operation_id` int(15) DEFAULT NULL,
  `operator_id` int(15) DEFAULT NULL,
  `parent_id` int(15) DEFAULT NULL,
  `module_id` int(15) DEFAULT NULL,
  `operation_time` int(15) DEFAULT NULL,
  `is_client` TINYINT( 4 ) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_balance`;
CREATE TABLE IF NOT EXISTS `avis_balance` (
  `balance_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT '0.00',
  `content` text,
  `entry_date` int(15) DEFAULT '0',
  `transaction_id` varchar(255) DEFAULT NULL,
  `invoice_id` int(15) DEFAULT NULL,
  `balance_type` tinyint(1) NOT NULL DEFAULT '0',
  `is_credit` tinyint(1) NOT NULL DEFAULT '0',
  `gateway_id` tinyint(1) NOT NULL,
  PRIMARY KEY (`balance_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_blab`;
CREATE TABLE IF NOT EXISTS `avis_blab` (
  `blab_id` int(15) NOT NULL AUTO_INCREMENT,
  `content` text,
  `owner` int(15) DEFAULT NULL,
  `entry_date` int(15) DEFAULT NULL,
  `is_closed` tinyint(1) DEFAULT '0',
  `access_type` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`blab_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_blab_access`;
CREATE TABLE IF NOT EXISTS `avis_blab_access` (
  `access_id` int(15) NOT NULL AUTO_INCREMENT,
  `blab_id` int(15) DEFAULT NULL,
  `staff_id` int(15) DEFAULT NULL,
  `access_type` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`access_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_blab_comment`;
CREATE TABLE IF NOT EXISTS `avis_blab_comment` (
  `comment_id` int(15) NOT NULL AUTO_INCREMENT,
  `parent_id` int(15) DEFAULT NULL,
  `content` text,
  `entry_date` int(15) DEFAULT NULL,
  `owner` int(15) DEFAULT NULL,
  PRIMARY KEY (`comment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_blab_trend`;
CREATE TABLE IF NOT EXISTS `avis_blab_trend` (
  `trend_id` int(15) NOT NULL AUTO_INCREMENT,
  `blab_id` varchar(255) NOT NULL,
  `trend` varchar(255) DEFAULT NULL,
  `trend_count` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT NULL,
  `modify_date` int(15) DEFAULT NULL,
  PRIMARY KEY (`trend_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_breakline`;
CREATE TABLE IF NOT EXISTS `avis_breakline` (
  `breakline_id` int(15) NOT NULL AUTO_INCREMENT,
  `expression` varchar(255) DEFAULT NULL,
  `is_expression` tinyint(1) DEFAULT '1',
  `is_enabled` tinyint(1) DEFAULT '1',
  `exec_order` int(15) DEFAULT '0',
  PRIMARY KEY (`breakline_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_breakline` values (1,'-- original mail[0-9]* --',1,1,0);
DROP TABLE IF EXISTS `avis_calendar_task`;
CREATE TABLE IF NOT EXISTS `avis_calendar_task` (
  `task_id` int(15) NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) DEFAULT NULL,
  `description` text,
  `start_date` int(11) DEFAULT NULL,
  `end_date` int(11) DEFAULT NULL,
  `task_type` tinyint(1) DEFAULT '1',
  `task_status` varchar(31) DEFAULT NULL,
  `priority` varchar(31) DEFAULT NULL,
  `owner` int(15) DEFAULT NULL,
  `label` varchar(31) DEFAULT NULL,
  `location` varchar(31) DEFAULT NULL,
  PRIMARY KEY (`task_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_channel`;
CREATE TABLE IF NOT EXISTS `avis_channel` (
  `channel_id` int(15) NOT NULL AUTO_INCREMENT,
  `channel_name` varchar(255) DEFAULT NULL,
  `icon_path` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`channel_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_channel` (`channel_id`, `channel_name`, `icon_path`, `is_enabled`, `department_access`) VALUES
(1, 'Email', 'vh vh-ticket vh-brown', 1, '0'),
(2, 'Call', 'vh vh-call vh-green', 1, '0'),
(3, 'Facebook', 'vh vh-facebook vh-facebook-color', 1, '0'),
(4, 'Twitter', 'vh vh-twitter vh-blue', 1, '0'),
(5, 'Portal', 'vh vh-imac', 1, '0'),
(6, 'Chat', 'vh vh-chat vh-yellow', 1, '0'),
(7, 'Service', 'vh vh-service-item', 1, '0'),
(8, 'LiveChatInc', 'vh vh-livechat-inc vh-livechat-inc-color', 1, '0'),
(9, 'LiveZilla', 'vh vh-livezilla vh-livezilla-color', 1, '0'),
(10, 'UserLike', 'vh vh-userlike vh-userlike-color', 1, '0'),
(11, 'Comm100', 'vh vh-comm100 vh-comm100-color', 1, '0'),
(12, 'GoToMeeting', 'vh vh-gotomeeting vh-gotomeeting-color', 1, '0'),
(13, 'GoToAssist', 'vh vh-gotoassist vh-gotoassist-color', 1, '0'),
(14, 'TeamViewer', 'vh vh-teamviewer vh-teamviewer-color', 1, '0'),
(15, 'WebEx', 'vh vh-webex vh-webex-color', 1, '0'),
(16, 'Twilio', 'vh vh-twilio vh-twilio-color', 1, '0'),
(17, 'ClickDesk', 'vh vh-clickdesk vh-clickdesk-color', 1, '0'),
(18, 'Zopim', 'vh vh-zopim vh-zopim-color', 1, '0'),
(19, 'Exotel', 'vh vh-exotel vh-exotel-color', 1, '0'),
(20, 'Google calender', 'vh vh-google vh-google-color', 1, '0'),
(21, 'Crisp', 'vh vh-crisp vh-crisp-color', 1, '0'),
(22, 'Aircall', 'vh vh-aircall vh-aircall-color', 1, '0'),
(23, 'Asterisk', 'vh vh-asterisk vh-asterisk-color', 1, '0');

DROP TABLE IF EXISTS `avis_client`;
CREATE TABLE IF NOT EXISTS `avis_client` (
  `client_id` int(15) NOT NULL AUTO_INCREMENT,
  `group_id` int(15) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `initials` varchar(15) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `authentication` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT 'MD5(RAND())',
  `contact_number` varchar(255) DEFAULT NULL,
  `mobile_number` varchar(255) DEFAULT NULL,
  `temporary_address` text,
  `permanent_address` text,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip_code` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `website` text,
  `fax` varchar(255) DEFAULT NULL,
  `office_name` varchar(255) DEFAULT NULL,
  `office_email` varchar(255) DEFAULT NULL,
  `office_contact_num` varchar(255) DEFAULT NULL,
  `office_address` text,
  `office_phone` varchar(255) DEFAULT NULL,
  `office_fax` varchar(255) DEFAULT NULL,
  `office_website` varchar(255) DEFAULT NULL,
  `job_title` varchar(255) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `gender` tinyint(2) DEFAULT NULL,
  `birthdate` int(15) DEFAULT NULL,
  `netmeetingid` varchar(255) DEFAULT NULL,
  `twitter_id` varchar(255) DEFAULT NULL,
  `facebook_id` varchar(255) DEFAULT NULL,
  `otherim` varchar(255) DEFAULT NULL,
  `is_spam` tinyint(1) DEFAULT '0',
  `is_banned` tinyint(1) DEFAULT '0',
  `is_approved` tinyint(1) DEFAULT '1',
  `is_verified` tinyint(1) DEFAULT '1',
  `parent_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT NULL,
		`optionB_domain_id` int(15) DEFAULT '0',
  `credit` decimal(10,2) DEFAULT '0.00',
  `balance` int(15) DEFAULT '0',
  `image_path` varchar(255) DEFAULT NULL,
  `language` int(15) NOT NULL DEFAULT '1',
  `login_as` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-FB, 2-gmail, 3-twitter,4-whmcs,5-clientexec,6-linkedin,7-sugarcrm,8-wordpress,9-drupal',
  `department_access` varchar(255) DEFAULT '0',
  `client_type` int(1) NOT NULL DEFAULT '0' COMMENT '0 for regular client, 1 for call client',
  `password_auth` int(3) DEFAULT NULL,
  `forum_signature_content` text,
  `forum_email_notification` int(1) NOT NULL DEFAULT '1',
  `is_manager` INT( 1 ) NOT NULL DEFAULT '0' COMMENT '0=No,1=Yes',
  `harvest_id` INT( 11 ) NOT NULL COMMENT 'harvest client registration id',
  `registration_date` INT(15) NULL COMMENT 'client registeration date',
  PRIMARY KEY (`client_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
INSERT INTO `avis_client` (`client_id`, `group_id`, `first_name`, `last_name`, `initials`, `user_name`, `email`, `authentication`, `salt`, `contact_number`, `mobile_number`, `temporary_address`, `permanent_address`, `city`, `state`, `zip_code`, `country`, `website`, `fax`, `office_name`, `office_email`, `office_contact_num`, `office_address`, `office_phone`, `office_fax`, `office_website`, `job_title`, `department`, `gender`, `birthdate`, `netmeetingid`, `twitter_id`, `facebook_id`, `otherim`, `is_spam`, `is_banned`, `is_approved`, `parent_id`, `domain_id`, `credit`, `balance`, `image_path`, `language`, `login_as`, `department_access`, `client_type`, `password_auth`) VALUES ('0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'MD5(RAND())', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '0', '1', '0', NULL, '0.00', '0', NULL, 1, 0, '0', 0, 0);
update `avis_client` set client_id=0 where client_id=LAST_INSERT_ID();
DROP TABLE IF EXISTS `avis_client_group`;
CREATE TABLE IF NOT EXISTS `avis_client_group` (
  `group_id` int(15) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) DEFAULT NULL,
  `group_type` int(4) NOT NULL DEFAULT '0',
  `description` text,
  `is_enable` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT NULL,
  `credit` decimal(10,2) DEFAULT '0.00',
  `debit` decimal(10,2) DEFAULT '0.00',
  `office_email` VARCHAR( 255 ) DEFAULT NULL,
  `office_contact_num` VARCHAR( 255 ) DEFAULT NULL,
  `office_address` TEXT DEFAULT NULL,
  `office_city` VARCHAR( 255 ) DEFAULT NULL,
  `office_state` VARCHAR( 255 ) DEFAULT NULL,
  `office_country` VARCHAR( 255 ) DEFAULT NULL,
  `office_phone` VARCHAR( 255 ) DEFAULT NULL,
  `office_fax` VARCHAR( 255 ) DEFAULT NULL,
  `office_website` VARCHAR( 255 ) DEFAULT NULL,
  `domain_id` INT( 15 ) NULL DEFAULT '0',
  `zip_code` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `domain_list` TEXT NOT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_client_group` VALUES ( 1, 'Default', 0, '', 1, 0 , '0.00', '0.00', NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , NULL,'');
DROP TABLE IF EXISTS `avis_credit`;
CREATE TABLE IF NOT EXISTS `avis_credit` (
  `credit_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) NOT NULL,
  `owner_type` int(1) NOT NULL,
  `creator_id` int(15) NOT NULL,
  `content` text CHARACTER SET utf8,
  `amount` varchar(15) CHARACTER SET utf8 NOT NULL,
  `ticket_balance` tinyint(1) DEFAULT NULL,
  `entry_date` int(15) DEFAULT NULL,
		`ticket_id` INT( 20 ) NOT NULL,
  PRIMARY KEY (`credit_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_customfield`;
CREATE TABLE IF NOT EXISTS `avis_customfield` (
  `customfield_id` int(15) NOT NULL AUTO_INCREMENT,
  `customgroup_id` int(15) DEFAULT NULL,
  `ci_type` INT(4) DEFAULT '0',
  `field_type` int(4) DEFAULT '1',
  `field_group` int(15) DEFAULT NULL,
  `field_name` varchar(255) DEFAULT NULL,
  `field_description` varchar(255) DEFAULT NULL,
  `display_order` int(15) DEFAULT NULL,
  `default_value` varchar(255) DEFAULT NULL,
  `is_selected` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) NOT NULL,
  `is_required` tinyint(1) DEFAULT '0',
  `is_staff_editable` tinyint(1) DEFAULT '0',
  `is_user_editable` tinyint(1) DEFAULT '0',
  `regular_expression` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`customfield_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_customfield` values (1,1,0,3,1,'Ticket feedback','Please comment about support quality.',0,'',0,1,0,1,1,'none');
DROP TABLE IF EXISTS `avis_customfield_data`;
CREATE TABLE IF NOT EXISTS `avis_customfield_data` (
  `customfield_data_id` int(15) NOT NULL AUTO_INCREMENT,
  `parent_id` int(15) DEFAULT NULL,
  `group_type` int(15) DEFAULT NULL,
  `customfield_id` int(15) DEFAULT NULL,
  `content` text,
  `entry_date` int(15) DEFAULT NULL,
  PRIMARY KEY (`customfield_data_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_customgroup`;
CREATE TABLE IF NOT EXISTS `avis_customgroup` (
  `customgroup_id` int(15) NOT NULL AUTO_INCREMENT,
  `customgroup_name` varchar(255) DEFAULT NULL,
  `description` text,
  `display_order` int(15) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `location` tinyint(4) DEFAULT NULL,
  `department_access` varchar(255) DEFAULT NULL,
  `visible_to` INT( 4 ) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customgroup_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_customgroup` values (1,'Feedback',NULL,0,1,3,'0',0);
DROP TABLE IF EXISTS `avis_department`;
CREATE TABLE IF NOT EXISTS `avis_department` (
  `department_id` int(15) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(255) DEFAULT NULL,
  `description` text,
  `domain_id` int(15) NOT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `is_paid` tinyint(1) DEFAULT '0',
  `display_order` int(15) DEFAULT NULL,
  `autoresponder_id` int(15) DEFAULT '2',
  `autoresponder` tinyint(1) DEFAULT '1',
  `registration` tinyint(1) DEFAULT '0',
  `signature` text,
  PRIMARY KEY (`department_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_departmentview`;
CREATE TABLE IF NOT EXISTS `avis_departmentview` (
  `department_vid` int(15) NOT NULL AUTO_INCREMENT,
  `department_id` int(15) DEFAULT NULL,
  `staff_id` int(15) DEFAULT NULL,
  PRIMARY KEY (`department_vid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_device`;
CREATE TABLE IF NOT EXISTS `avis_device` (
  `device_id` int(15) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `device_type` int(4) DEFAULT '0',
  `api_key` varchar(255) DEFAULT NULL,
  `staff_id` int(15) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `badgecount` INT( 15 ) NOT NULL DEFAULT  '0',
  PRIMARY KEY (`device_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_domain`;
CREATE TABLE IF NOT EXISTS `avis_domain` (
  `domain_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `default_email` varchar(255) DEFAULT NULL,
  `domain` varchar(255) NOT NULL,
  `domain_url` varchar(255) DEFAULT NULL,
  `domain_name` varchar(255) NOT NULL,
  `display_order` int(15) DEFAULT NULL,
  `language_id` int(15) DEFAULT '1',
  `timezone` varchar(255) DEFAULT '0',
  `timezone_dst` tinyint(1) DEFAULT '0',
  `theme` varchar(255) NOT NULL DEFAULT 'default',
  `send_mail` int(15) DEFAULT '0',
  `bcc_email` varchar(255) DEFAULT NULL,
  `currency` varchar(4) DEFAULT 'USD',
  `timezone_name` text NOT NULL,
  PRIMARY KEY (`domain_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_emailtemplate`;
CREATE TABLE IF NOT EXISTS `avis_emailtemplate` (
  `etemplate_id` int(15) NOT NULL AUTO_INCREMENT,
  `etemplate_name` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `content` text,
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `default_id` int(4) DEFAULT '0',
  `is_itil` int(11) NULL DEFAULT '0',
  `language` int(15) DEFAULT '1',
  `parent_id` int(11) DEFAULT '0',
  `attachment_setting` TINYINT( 1 ) NOT NULL DEFAULT '1',
  PRIMARY KEY (`etemplate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `is_enabled`, `default_id`, `is_itil`) VALUES
(1, 'Client registration', 'Client registration details', 'Hello {username},<br>Thank you for registering with us.<br><br>Your account has been setup and you can now login to our client portal . <br>Client portal url : <a href="{link}">{link}</a><br>Email: {useremail}<br><br> Please reset your password by using following link <br><a href="{resetlink}">{resetlink}<span></span></a><br>Using client portal you can track your existing tickets, submit new tickets and update your profile.<br>', 1, 1, 0),
(2, 'Auto responder', '[{ticket_hash}]: {subject}', 'Hello {username},<br>           A request for assistance has been received. Our system has created a ticket for your issue.<br><br><strong>Following are ticket details -</strong><br>Ticket ID: {ticket_hash}<br>Subject: {subject}<br>Department: {department}<br>Ticket type: {ticket_type}<br>Priority: {priority}<br>Status: {status}<br>Our staff will assist you shortly.<br>You can update or reply your ticket online at :<br><a href="{link}">{link}</a><br><br>Login URL  as below:<br><span class="nodeLabelBox repTarget "><span class="nodeAttr editGroup "><span class="nodeValue editable "><a href="{login_url}">{login_url}</a></span></span></span>', 1, 2, 0),
(3, 'Staff reply', '[{ticket_hash}]: {subject}', ' {reply_message}<br><br><strong>Ticket details - </strong><br>Ticket ID: {ticket_hash}<br>Subject: {subject}<br>Department: {department}<br>Ticket type: {ticket_type}<br>Priority: {priority}<br>Status: {status}<br></br>You can update or reply your ticket online at : <br><a href="{link}">{link}</a><br><br>Login to client portal using following link: <br><a href="{login_url}">{login_url}</a><br>', 1, 3, 0),
(4, 'Restricted client', 'Restricted client', 'Hello,<br>\r\n<br>\r\nThe email address that you have used to submit ticket is not registered in our client portal. While sending email please make sure you use the same email address that you have used while registering with us.<br>\r\n<br>\r\nIf you have not registered to our client portal, we request you to register it and then submit tickets.<br>\r\n<br>\r\nYou can register to our client portal here - <br>\r\n<a href="{link}">{link}</a><br>', 1, 4, 0),
(5, 'Forgot password', 'Forgot password', 'Hello {username}<br>            As per your password reset request, Please click on following link to reset your password <br><a href="{resetlink}"> {resetlink}</a>', 1, 5, 0),
(6, 'Client approval pending', 'Registration pending for approval', 'Hello {username},<br />\r\n<br />\r\nThank you for registering to our client portal.<br />\r\nYour account is currently being reviewed and once its active you will receive email with login details for our client portal ', 1, 6, 0),
(7, 'Ticket auto close', 'Ticket Auto close', 'This is an automatically generated email alert by our helpdesk system.<br>\r\n<br>\r\nBelow mentioned ticket has not been updated in the last 24 hours and will be automatically closed by the system.<br>\r\nIf your issue is already resolved please ignore this email otherwise update your ticket with further details so that our staff can assist you.<br>\r\n<br>\r\nTicket Id: {ticket_hash}<br>\r\nSubject: {subject}<br>\r\nDepartment: {department}<br>\r\nTicket type: {ticket_type}<br>\r\nPriority: {priority}<br>\r\nStatus: {status}<br>', 1, 7, 0),
(8, 'Alert template', '{alert}[{ticket_hash}]: {subject}', '{ticket_reply}<br>\r\n<br><strong>Ticket details :</strong><br>Ticket Id: {ticket_hash}<br>Subject: {subject}<br>\r\nDepartment: {department}<br>Ticket type: {ticket_type}<br>Priority: {priority}<br>Status: {status}<br>Last replier: {last_replier}<br>', 1, 8, 0),
(9, 'Invoice created', 'Invoice created', 'Dear {username},<br>            This is a notice that an invoice has been generated on {invoice_date}.<br><br>Invoice #{invoice_hash}<br>Amount Due: {currency_symbol}<span></span>{invoice_amount} {currency}<span></span><br>Due Date: {invoice_duedate}<br><br><strong>Invoice Items</strong><br>{description}<br>Total: {currency_symbol}<span></span>{invoice_amount} {currency}<span></span><br>------------------------------------------------------<br><strong>Sub Total</strong>: {currency_symbol}<span></span>{invoice_amount} {currency}<span></span><br><strong>Credit:</strong> {currency_symbol}<span></span>{client_balance}<br><strong>Total:</strong> {currency_symbol}<span></span>{invoice_amount} {currency} <span></span><br>------------------------------------------------------<br>Check invoice details using following link : <br>{invoice_link}<br>', 1, 9, 0),
(10, 'Send email', '[{ticket_hash}]: {subject}', '<strong></strong> {message}', 1, 10, 0),
(11, 'Ticket forward', '[{ticket_hash}]: {subject}', '{reply_message}', 1, 11, 0),
(12, 'No balance', 'Insufficient balance', 'Hello,<br>\r\n<br> \r\n      You have opted to open ticket for a paid department but your account do not have sufficient funds. Please add funds to your account and then re-open the ticket.', 1, 12, 0),
(13, 'Staff registration', 'Staff registration details', 'Hello {staff_name},<br>\r\n<div>\r\n	Welcome to our help desk staff portal.\r\n<br><br>Your account has been setup and you can now login to staff portal using details below.<br><div>\r\nStaff Portal URL: <a href="{manage_portal_link}">{manage_portal_link} </a><br>\r\nUserName: {user_name}<br>\r\n Please reset your  password by using following link<br>\r\n <a href="{resetlink}">{resetlink}</a><br>\r\n<br>\r\nPlease feel free to update your profile, signature and other help desk related settings.<br></div></div>', 1, 13, 0),
(14, 'Parser failed', 'Email not parsed for {mail_queue}: {subject}', '<p>Sender : {from_email}<br> To : {mail_queue}<span></span></p><p>Actual message :<br> {message}</p>', 1, 14, 0),
(15, 'New blab', 'New blab added', 'Hello {first_name} {last_name},<br> New blab added by {staff_name}. <br><strong>Blab content : </strong><br>{message}<br>{company}<br>{view_blab_link}', 1, 15, 0),
(16, 'Client registration verification email', 'Verify email', 'Hello {username},<br> Thank you for registering to our client portal. Please click on following link to verify your email. <br><a href="{verification_link}">{verification_link}</a><br>', 1, 16, 0),
(17, 'Change approval', 'Approval request for change', 'Hello {first_name} {last_name},<br><br>Approval request for change {changes_hash} {changes_name} is waiting for your approval. <br> Please visit <a href="{changes_details_link}">{changes_details_link}</a> and confirm your approval.<span></span><br>', 1, 17, 1),
(18, 'Contract approval', 'Request for contract approval', 'Hello {first_name} {last_name},<br><br>A new contract {contract_name}(#{contract_number}) is waiting for your approval.<br> Please visit <a href="{contract_approval_link}">{contract_approval_link}</a> and confirm your approval.<br><br>', 1, 18, 1),
(19, 'Release approval', 'Approval request for release ', 'Hello {first_name} {last_name},<br><br>Approval request for release {release_hash} {releases_name} is waiting for your approval. <br>Please visit <a href="{releases_approval_link}">{releases_approval_link}</a> and confirm your approval.', 1, 19, 1),
(20, 'Alert ITIL template', '{alert}     [{problem_hash}{change_hash}{release_hash}]: {subject}', 'Alert : {alert}<br>Hash: {problem_hash}{change_hash}{release_hash} <br><br><strong>Properties :</strong><br>Subject: {subject}<br> Department: {department}<br> Priority: {priority}<br> Status: {status}<br>Impact : {impact}<br>Risk : {risk}<br>Type : {type}<br><br>', 1, 20, 1),
(21, 'Contract expiry reminder', 'Contract expiry reminder', 'Hello,<br>{contract_name}(#{contract_number})<span></span> is due for renewal and will  be expired in next {contract_days}  days. <br>Please visit  below contract link to view more details<br><a href="{contract_link}">{contract_link}</a><br>', 1, 21, 1),
(22, 'Client feedback', 'Please give us your valuable feedback on ticket: {ticket_hash}', 'Hello {username},<br><br>We have resolved your ticket, Below are details for your request.<br><br>Ticket Id: {ticket_hash}<br>Subject: {subject}<br>Department: {department}<br>Ticket type: {ticket_type}<br>Priority: {priority}<br>Status: {status}<br>Please give us your feedback on how was your overall experience with our team while resolving your issue.<br>{link}index.php?/feedback/{useremail}/{salt}/{ticket_id}<br><br>Your feedback will help us improve our customer service.<br>', 1, 22, 0);
DROP TABLE IF EXISTS `avis_fetchmail`;
CREATE TABLE IF NOT EXISTS `avis_fetchmail` (
  `fetch_id` int(15) NOT NULL AUTO_INCREMENT,
  `unique_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`fetch_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_filter`;
CREATE TABLE IF NOT EXISTS `avis_filter` (
  `filter_id` int(15) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(255) DEFAULT NULL,
  `vscope` tinyint(2) DEFAULT '1',
  `display_order` int(15) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `filter` longtext,
  `concat_type` enum('and','or') DEFAULT 'and',
  `is_enabled` tinyint(1) DEFAULT '1',
  `search_trash` tinyint(1) DEFAULT '0',
  `search_spam` tinyint(1) DEFAULT '0',
		`is_report` TINYINT( 1 ) NULL DEFAULT '0',
  PRIMARY KEY (`filter_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert INTO `avis_filter` (`filter_id`, `filter_name`, `vscope`, `display_order`, `owner`, `filter`, `concat_type`, `is_enabled`, `search_trash`, `search_spam`) VALUES
(1,'Tickets',1,1,0,'','and',1,0,0),
(2,'New tickets',1,1,0,'','and',1,0,0),
(3,'Overdue tickets',1,1,0,'','and',1,0,0),
(4,'Assigned tickets',1,1,0,'','and',1,0,0),
(5,'Trash',1,1,0,'','and',1,1,1),
(6,'Spam', 1,1,0,'','and',1,0,1),
(7,'Drafts',1,1,0,'','and',1,0,0),
(8, 'Problems', 1, 1, 0, '', 'and', 1, 0, 0),
(9, 'Open', 1, 1, 0, '', 'and', 1, 0, 0),
(10, 'Closed', 1, 1, 0, '', 'and', 1, 0, 0),
(11, 'Assigned', 1, 1, 0, '', 'and', 1, 0, 0),
(12, 'Changes', 1, 1, 0, '', 'and', 1, 0, 0),
(13, 'Open', 1, 1, 0, '', 'and', 1, 0, 0),
(14, 'Closed', 1, 1, 0, '', 'and', 1, 0, 0),
(15, 'Assigned', 1, 1, 0, '', 'and', 1, 0, 0),
(16, 'Releases', 1, 1, 0, '', 'and', 1, 0, 0),
(17, 'Open', 1, 1, 0, '', 'and', 1, 0, 0),
(18, 'Closed', 1, 1, 0, '', 'and', 1, 0, 0),
(19, 'Assigned', 1, 1, 0, '', 'and', 1, 0, 0),
(20, 'Service request', '1', '1', '0', '', 'and', '1', '0', '0'),
(21, 'Schedule ticket', 1, 1, 0, '', 'and', 1, 0, 0),
(22, '30 Minutes overdue', 1, 1, 0, '', 'and', 1, 0, 0),
(23, '60 Minutes overdue', 1, 1, 0, '', 'and', 1, 0, 0),
(24, '1 Day overdue', 1, 1, 0, '', 'and', 1, 0, 0),
(25, 'Open tickets', 1, 1, 0, '', 'and', 1, 0, 0),
(26, 'Critical tickets', 1, 1, 0, '', 'and', 0, 0, 0),
(27, 'Unassigned tickets', 1, 1, 0, '', 'and', 0, 0, 0),
(28, 'Recent replied tickets', 1, 1, 0, '', 'and', 0, 0, 0),
(29, 'Recent closed tickets', 1, 1, 0, '', 'and', 0, 0, 0);
DROP TABLE IF EXISTS `avis_filter_criteria`;
CREATE TABLE IF NOT EXISTS `avis_filter_criteria` (
  `criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `filter_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) DEFAULT '0',
  `content` varchar(255) DEFAULT NULL,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert INTO `avis_filter_criteria` (`criteria_id`, `filter_id`, `base_criteria`, `sub_criteria`, `content`, `concat_type`) VALUES
(1, 1, 8, 1, '3', NULL), 
(2, 2, 8, 1, '3', NULL), 
(3, 2, 17, '1', 'unix_timestamp()', NULL), 
(4, 3, 8, 1, '3', NULL), 
(5, 3, 17, 0, 'unix_timestamp()', NULL), 
(6, 4, 10, 1, 'VIS_STAFF_ID', NULL), 
(7, 2, 13, 0, '1', NULL), 
(8, 3, 13, 0, '1', NULL), 
(9, 4, 8, 1, 3, NULL),
(10, 8, 8, 1, '3', NULL),
(11, 9, 1, 0, '1', NULL),
(12, 10, 1, 0, '3', NULL),
(13, 11, 0, 0, 'VIS_STAFF_ID', NULL),
(14, 12, 8, 1, '3', NULL),
(15, 13, 1, 0, '1', NULL),
(16, 14, 1, 0, '3', NULL),
(17, 15, 0, 0, 'VIS_STAFF_ID', NULL),
(18, 16, 8, 1, '3', NULL),
(19, 17, 1, 0, '1', NULL),
(20, 18, 1, 0, '3', NULL),
(21, 19, 0, 0, 'VIS_STAFF_ID', NULL),
(22, 20, 8, 0, '1', 'and'),
(23, 20, 24, 0, '7', 'and'),
(24, 22, 36, 1, '1800', 'and'),
(25, 23, 36, 1, '3600', 'and'),
(26, 24, 36, 1, '86400', 'and'),
(27, 25, 8, 0, '1', 'and'),
(28, 25, 0, 0, '', 'or'),
(29, 26, 9, 0, '4', 'and'),
(30, 26, 8, 1, '3', 'and'),
(31, 26, 0, 0, '', 'or'),
(32, 27, 10, 0, '0', 'and'),
(33, 27, 8, 0, '3', 'and'),
(34, 27, 0, 0, '', 'or'),
(35, 28, 28, 0, '', 'and'),
(36, 28, 0, 0, '', 'or'),
(37, 29, 8, 0, '3', 'and'),
(38, 29, 0, 0, '', 'or'); 
DROP TABLE IF EXISTS `avis_gateway`;
CREATE TABLE IF NOT EXISTS `avis_gateway` (
  `gateway_id` int(15) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT NULL,
  `field_name` varchar(255) DEFAULT NULL,
  `field_value` text,
  `gateway_name` varchar(255) DEFAULT NULL,
  `gateway_type` tinyint(1) NOT NULL,
  `gateway_mode` tinyint(1) NOT NULL,
  PRIMARY KEY (`gateway_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_gateway_log`;
CREATE TABLE IF NOT EXISTS `avis_gateway_log` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `invoice_hash` int(15) NOT NULL,
  `gateway_id` tinyint(1) NOT NULL,
  `txn_data` text NOT NULL,
  `gateway_status` text NOT NULL,
  `entry_date` int(11) NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_holiday`;
CREATE TABLE IF NOT EXISTS `avis_holiday` (
  `holiday_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text CHARACTER SET utf8 NOT NULL,
  `holiday_date` varchar(255) CHARACTER SET utf8 NOT NULL,
  `is_enabled` tinyint(1) NOT NULL,
  `schedule_id` INT( 15 ) NOT NULL,
  PRIMARY KEY (`holiday_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_integration`;
CREATE TABLE IF NOT EXISTS `avis_integration` (
  `integration_id` int(15) NOT NULL AUTO_INCREMENT,
  `integration_type` int(4) DEFAULT NULL,
  `domain_id` int(15) DEFAULT NULL,
  `department_id` int(15) DEFAULT '0',
  `host_name` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `db_name` varchar(255) DEFAULT NULL,
  `db_password` varchar(255) DEFAULT NULL,
  `db_prefix` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `billing_url` text,
  `admin_user` varchar(255) DEFAULT NULL,
  `admin_password` text DEFAULT NULL,
  `api_key` varchar(255) DEFAULT NULL,
  `con_timeout` VARCHAR( 255 ) NULL ,
  `read_timeout` VARCHAR( 255 ) NULL ,
  `scheme` VARCHAR( 255 ) NULL ,
  `rec_path` TEXT NULL,
  
  PRIMARY KEY (`integration_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_invoice`;
CREATE TABLE IF NOT EXISTS `avis_invoice` (
  `invoice_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) NOT NULL DEFAULT '0',
  `ticket_id` int(15) DEFAULT '0',
  `product_id` int(15) DEFAULT '0',
  `invoice_hash` int(15) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `due_date` int(15) DEFAULT '0',
  `paid_date` int(15) DEFAULT '0',
  `subtotal` decimal(10,2) NOT NULL DEFAULT '0.00',
  `credit` decimal(10,2) NOT NULL DEFAULT '0.00',
  `tax` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `invoice_status` int(4) DEFAULT '0',
  `is_edited` tinyint(1) DEFAULT '0',
  `balance` decimal(10,2) NOT NULL DEFAULT '0.00',
  `order_id` int(15) NOT NULL DEFAULT '0',
  `product_status` int(4) NOT NULL DEFAULT '2',
  PRIMARY KEY (`invoice_id`),
  KEY `client_id` (`client_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_invoice_detail`;
CREATE TABLE IF NOT EXISTS `avis_invoice_detail` (
  `invoice_detail_id` int(15) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(15) DEFAULT NULL,
  `entry_date` int(15) DEFAULT NULL,
  `tax` tinyint(1) DEFAULT '0',
  `description` text,
  `amount` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`invoice_detail_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_asset_state`;
CREATE TABLE IF NOT EXISTS `avis_itil_asset_state` (
  `asset_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`asset_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_asset_state` (`asset_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'In use', 1, 0, 1, 1, '#b86a06', '0'),
(2, 'Missing', 1, 0, 4, 1, '#8c1601', '0'),
(3, 'In Transit', 1, 0, 2, 1, '#c46306', '0'),
(4, 'In stock', 1, 0, 3, 1, '#bbbb00', '0'),
(5, 'Retired', 1, 0, 5, 1, '#d63601', '0');
DROP TABLE IF EXISTS `avis_itil_attach_relationships`;
CREATE TABLE IF NOT EXISTS `avis_itil_attach_relationships` (
  `attach_id` int(11) NOT NULL AUTO_INCREMENT,
  `relation_id` int(11) NOT NULL,
  `assets_id` int(11) NOT NULL,
  `ci_id` int(11) NOT NULL,
  `relation_type` int(11) NOT NULL COMMENT '0-forward,1-reverse',
  PRIMARY KEY (`attach_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_itil_changes`;
CREATE TABLE IF NOT EXISTS `avis_itil_changes` (
  `changes_id` int(15) NOT NULL AUTO_INCREMENT,
  `changes_from` varchar(255) NOT NULL,
  `changes_hash` varchar(250) NOT NULL,
  `subject` text NOT NULL,
  `status_id` int(15) NOT NULL,
  `priority_id` int(15) NOT NULL,
  `impact_id` int(15) NOT NULL,
  `risk_id` int(15) NOT NULL,
  `change_type_id` int(15) NOT NULL,
  `date_created` int(15) NOT NULL,
  `date_modified` int(15) NOT NULL,
  `department_id` int(15) NOT NULL,
  `staff_id` varchar(255) NOT NULL,
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `assets_ci_id` varchar(500) NOT NULL,
  `attachment_id` varchar(255) NOT NULL,
  `domain_id` int(20) NOT NULL,
  `is_enabled` tinyint(2) DEFAULT '0',
  `reason` text,
  `reasons_attachment` varchar(555) DEFAULT NULL,
  `impact_planning` text,
  `impact_attachment` varchar(555) DEFAULT NULL,
  `rollout` text,
  `rollout_attachment` varchar(555) DEFAULT NULL,
  `backout` text,
  `backout_attachment` varchar(555) DEFAULT NULL,
  `category_id` int(11) DEFAULT '0',
  `subcategory_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `location_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`changes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `avis_itil_changes_aprovals`;
CREATE TABLE IF NOT EXISTS `avis_itil_changes_aprovals` (
  `aprovals_id` int(11) NOT NULL AUTO_INCREMENT,
  `aprovals_type` tinyint(2) NOT NULL COMMENT '0-change planning, 1-release acceptance',
  `parent_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `aprovals_status` tinyint(2) NOT NULL COMMENT '0-requested, 1-aproved, 2-cancelled, 3-rejected',
  `send_date` varchar(20) NOT NULL,
  `status_date` varchar(20) NOT NULL,
  `remark` text NOT NULL,
  `is_enabled` int(11) NOT NULL,
  PRIMARY KEY (`aprovals_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_change_type`;
CREATE TABLE IF NOT EXISTS `avis_itil_change_type` (
  `change_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`change_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_change_type` (`change_type_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Minor', 1, 0, 1, 1, '#916106', '0'),
(2, 'Standard', 1, 0, 2, 1, '#695405', '0'),
(3, 'Major', 1, 0, 3, 1, '#ab6106', '0'),
(4, 'Emergency', 1, 0, 4, 1, '#eeee06', '0');
DROP TABLE IF EXISTS `avis_itil_ci_product`;
CREATE TABLE IF NOT EXISTS `avis_itil_ci_product` (
  `product_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `ci_type_id` int(11) NOT NULL,
  `manufacturer` varchar(50) NOT NULL,
  `product_status_id` int(11) NOT NULL,
  `depreciation_type_id` int(11) NULL DEFAULT '0',
  `procurement_id` int(11) NOT NULL,
  `description` text NOT NULL,
  `department_access` varchar(255) NOT NULL,
  `is_enabled` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_ci_product_status`;
CREATE TABLE IF NOT EXISTS `avis_itil_ci_product_status` (
  `product_status_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`product_status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_ci_product_status` (`product_status_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'In Production', 1, 0, 1, 1, '#a15105', '0'),
(2, 'In Pipeline', 1, 0, 2, 1, '#bbdd03', '0'),
(3, 'Retired', 1, 0, 3, 1, '#a32802', '0');
DROP TABLE IF EXISTS `avis_itil_cmdb_assets`;
CREATE TABLE IF NOT EXISTS `avis_itil_cmdb_assets` (
  `assets_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `ci_type_id` int(15) NOT NULL,
  `impact_id` int(15) NOT NULL,
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `location_id` int(15) NOT NULL,
  `staff_id` varchar(255) NOT NULL,
  `department_access` varchar(512) NOT NULL,
  `usedby` varchar(255) NOT NULL,
  `assigned_on` int(20) NOT NULL,
  `attachment_id` varchar(255) NOT NULL,
  `product_id` int(11) NOT NULL,
  `vendor_id` int(11) NOT NULL,
  `warranty_year` int(15) NOT NULL,
  `warranty_month` int(15) NOT NULL,
  `installation_date` int(15) NOT NULL,
  `expiry_date` int(11) NOT NULL,
  `assets_state` int(11) NOT NULL COMMENT 'also use for licence type',
  `asset_tag` varchar(100) NOT NULL COMMENT 'also use for cost',
  `licence_key` varchar(100) NOT NULL COMMENT 'also use for serial number',
  `installation_path` varchar(256) NOT NULL,
  `last_audit_date` int(15) NOT NULL,
  `salvage` varchar(50) NOT NULL,
  `depreciation_type` int(11) NOT NULL,
  `ci_property_type` tinyint(1) NOT NULL COMMENT '1-hardware,2-software',
  PRIMARY KEY (`assets_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_cmdb_contract`;
CREATE TABLE IF NOT EXISTS `avis_itil_cmdb_contract` (
  `contract_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `department_id` int(20) NOT NULL,
  `contract_number` varchar(255) NOT NULL,
  `type` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '0 -draft, 1-pending, 2-Active, 3-Rejected, 4-Canceled, 5-Expired',
  `product` int(11) NOT NULL,
  `vendor` int(11) NOT NULL,
  `license_count` varchar(255) NOT NULL,
  `license_type` int(11) NOT NULL,
  `approver` int(11) NOT NULL,
  `cost` varchar(255) NOT NULL,
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `start_date` int(15) NOT NULL,
  `end_date` int(15) NOT NULL,
  `attach_ci` varchar(700) NOT NULL,
  `attach_file` varchar(255) NOT NULL,
  `if_notify_expiry` int(1) NOT NULL DEFAULT '0',
  `notify_before` varchar(50) NOT NULL,
  `notify_to` varchar(255) NOT NULL,
  `is_enabled` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`contract_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_cmdb_relationships`;
CREATE TABLE IF NOT EXISTS `avis_itil_cmdb_relationships` (
  `relation_id` int(11) NOT NULL AUTO_INCREMENT,
  `forward` varchar(50) NOT NULL,
  `inverse` varchar(50) NOT NULL,
  PRIMARY KEY (`relation_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_cmdb_relationships` (`relation_id`, `forward`, `inverse`) VALUES
(1, 'depend on', 'userd by'),
(2, 'uses', 'used by'),
(3, 'send data to', 'received data from'),
(4, 'runs', 'runs on'),
(5, 'connected to', 'connected by'),
(6, 'subscribes to', 'subscribed by'),
(7, 'impacts', 'impacted by'),
(8, 'submits', 'submitted by'),
(9, 'supports', 'supported by'),
(10, 'author of', 'written by'),
(11, 'hosted on', 'hosts'),
(12, 'enables', 'is enabled by'),
(13, 'includes', 'member of'),
(14, 'contains', 'in rack'),
(15, 'located in', 'houses'),
(16, 'exchanges data with', 'exchanges data with'),
(17, 'managed by', 'manages'),
(18, 'uses', 'owned by'),
(19, 'virtualized by', 'virtualizes'),
(20, 'is edited by', 'editor'),
(21, 'backed up by', 'backed up by'),
(22, 'consists of', 'are part of');
DROP TABLE IF EXISTS `avis_itil_configuration_item`;
CREATE TABLE IF NOT EXISTS `avis_itil_configuration_item` (
  `item_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `parent_id` int(15) DEFAULT '0',
  `display_order` int(4) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `department_access` varchar(512) DEFAULT NULL,
  `is_custom` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_configuration_item` (`item_id`, `description`, `parent_id`, `display_order`, `is_enabled`, `department_access`, `is_custom`) VALUES
(1, 'Services', 0, 0, 1, '0', 0),
(2, 'Hardware', 0, 0, 1, '0', 0),
(3, 'Software', 0, 0, 1, '0', 0),
(4, 'Consumable', 0, 0, 1, '0', 0),
(5, 'Network', 0, 0, 1, '0', 0),
(6, 'Document', 0, 0, 1, '0', 0),
(7, 'Other', 0, 0, 1, '0', 0);
DROP TABLE IF EXISTS `avis_itil_contract_type`;
CREATE TABLE IF NOT EXISTS `avis_itil_contract_type` (
  `contract_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`contract_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_contract_type` (`contract_type_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Lease', 1, 0, 1, 1, '#a13903', '0'),
(2, 'Maintenance', 1, 0, 2, 1, '#99ee00', '0'),
(3, 'Software License', 1, 0, 3, 1, '#b25d0b', '0');
DROP TABLE IF EXISTS `avis_itil_depreciation_type`;
CREATE TABLE IF NOT EXISTS `avis_itil_depreciation_type` (
  `depreciation_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`depreciation_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_depreciation_type` (`depreciation_type_id`, `name`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'SL-5', 'SL-5', 1, 0, 1, 1, '#bd1601', '0'),
(2, 'SYD-5', 'SYD-5', 1, 0, 2, 1, '#b86406', '0');
DROP TABLE IF EXISTS `avis_itil_finance_management`;
CREATE TABLE IF NOT EXISTS `avis_itil_finance_management` (
  `finance_id` int(11) NOT NULL AUTO_INCREMENT,
  `finance_type_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `display_order` int(11) NOT NULL,
  `useful_life` int(11) NOT NULL,
  `description` text NOT NULL,
  `access_type` tinyint(2) NULL DEFAULT '0',
  `department_access` varchar(512) DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`finance_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_finance_management` (`finance_id`, `finance_type_id`, `name`, `display_order`, `useful_life`, `description`, `access_type`, `department_access`, `is_enabled`) VALUES 
(1, 1, 'DT-SL', 1, 5, 'Depreciation type - Straight Line', 0, '0', 1),
(2, 2, 'DT-DB', 2, 5, 'Depreciation type - Declining Balance', 0, '0', 1),
(3, 3, 'DT-DDB', 3, 5, 'Depreciation type - Double Declining Balance', 0, '0', 1),
(4, 4, 'DT-SOD', 4, 5, 'Depreciation type - Sum Of Years Digit', 0, '0', 1);
DROP TABLE IF EXISTS `avis_itil_impact`;
CREATE TABLE IF NOT EXISTS `avis_itil_impact` (
  `impact_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`impact_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_impact` (`impact_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Low', 1, 0, 1, 1, '#39390a', '0'),
(2, 'Medium', 1, 0, 2, 1, '#550009', '0'),
(3, 'High', 1, 0, 3, 1, '#eb0205', '0');
DROP TABLE IF EXISTS `avis_itil_license_type`;
CREATE TABLE IF NOT EXISTS `avis_itil_license_type` (
  `license_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`license_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_license_type` (`license_type_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Open Source', 1, 0, 1, 1, '#fc0200', '0'),
(2, 'Commercial', 1, 0, 2, 1, '#824204', '0');
DROP TABLE IF EXISTS `avis_itil_location`;
CREATE TABLE IF NOT EXISTS `avis_itil_location` (
  `location_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `contact` varchar(50) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address` text NOT NULL,
  `department_access` varchar(512) DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '0',
  `access_type` tinyint(2) NULL DEFAULT '0',
  PRIMARY KEY (`location_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_location` (`location_id`, `name`, `contact`, `parent_id`, `email`, `phone`, `address`, `department_access`, `is_enabled`, `access_type`) VALUES
(1, 'America', '', 0, 'example@example.com', '', '', '0', 1, 0),
(2, 'Asia', '', 0, 'example@example.com', '', '', '0', 1, 0),
(3, 'Australia', '', 0, 'example@example.com', '', '', '0', 1, 0),
(4, 'Europe', '', 0, 'example@example.com', '', '', '0', 1, 0);
DROP TABLE IF EXISTS `avis_itil_problems`;
CREATE TABLE IF NOT EXISTS `avis_itil_problems` (
  `problem_id` int(11) NOT NULL AUTO_INCREMENT,
  `problem_from` varchar(255) NOT NULL,
  `problem_hash` varchar(50) NOT NULL,
  `subject` varchar(555) NOT NULL,
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `status_id` int(2) NOT NULL COMMENT '1-open,3-closed',
  `priority_id` int(2) NOT NULL,
  `impact_id` int(11) NOT NULL,
  `due_by` int(15) NOT NULL,
  `date_created` int(15) NOT NULL,
  `date_modified` int(15) NOT NULL,
  `department_id` int(15) NOT NULL,
  `domain_id` int(20) NOT NULL DEFAULT '0',
  `staff_id` varchar(555) NOT NULL,
  `attachment_id` varchar(555) NOT NULL,
  `is_enabled` tinyint(2) NULL DEFAULT '0',
  `rootcause` text DEFAULT NULL,
  `rootcause_attachment` varchar(450) DEFAULT NULL,
  `impact_analysis` text DEFAULT NULL,
  `impact_attachment` varchar(450) DEFAULT NULL,
  `symptoms` text DEFAULT NULL,
  `symptoms_attachment` varchar(450) DEFAULT NULL,
  `permanent_id` int(11) NULL DEFAULT '0',
  `workaround_id` int(11) NULL DEFAULT '0',
  `category_id` INT( 15  )  NULL DEFAULT  '0',
  `subcategory_id` INT( 15  )  NULL DEFAULT  '0',
  `item_id` INT( 15  )  NULL DEFAULT  '0',
  `location_id` INT( 15  )  NULL DEFAULT  '0',  
  PRIMARY KEY (`problem_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_procurement_mode`;
CREATE TABLE IF NOT EXISTS `avis_itil_procurement_mode` (
  `procurement_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`procurement_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_procurement_mode` (`procurement_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Buy', 1, 0, 1, 1, '#9c3c03', '0'),
(2, 'Lease', 1, 0, 2, 1, '#732402', '0'),
(3, 'Both', 1, 0, 3, 1, '#751701', '0');
DROP TABLE IF EXISTS `avis_itil_product_vendors`;
CREATE TABLE IF NOT EXISTS `avis_itil_product_vendors` (
  `product_vendor_id` int(11) NOT NULL AUTO_INCREMENT,
  `vendor_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `price` varchar(255) NOT NULL,
  `warranty_year` int(11) NOT NULL,
  `warranty_month` int(11) NOT NULL,
  `quantity` varchar(255) NOT NULL,
  PRIMARY KEY (`product_vendor_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_relation`;
CREATE TABLE IF NOT EXISTS `avis_itil_relation` (
  `attach_id` int(15) NOT NULL AUTO_INCREMENT,
  `attach_type` int(4) NOT NULL COMMENT '0 - ticket ci, 1 - ticket - problem, 2 - problem change, 3 - change release, 4 - problem ci, 5 - release ci, 6 - ticket change, 7-cmdb relationships, 8-problem task, 9-changes ci, 10-changes task, 11-release task,12-ticket task,13-contract ci',
  `parent_id` int(4) NOT NULL,
  `child_id` int(11) NOT NULL,
  PRIMARY KEY (`attach_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='0 ticket - ci';
DROP TABLE IF EXISTS `avis_itil_releases`;
CREATE TABLE IF NOT EXISTS `avis_itil_releases` (
  `release_id` int(15) NOT NULL AUTO_INCREMENT,
  `release_hash` varchar(255) NOT NULL,
  `release_from` int(15) NOT NULL,
  `subject` text NOT NULL,
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `planned_start_date` int(15) NOT NULL,
  `planned_end_date` int(15) NOT NULL,
  `status_id` int(15) NOT NULL,
  `priority_id` int(15) NOT NULL,
  `release_type_id` int(15) NOT NULL,
  `domain_id` int(15) NOT NULL,
  `department_id` int(15) NOT NULL,
  `staff_id` varchar(555) NOT NULL,
  `assets_id` int(15) NOT NULL,
  `attachment_id` varchar(525) NOT NULL,
  `date_created` int(15) NOT NULL,
  `date_modified` int(15) NOT NULL,
  `buildplan` text DEFAULT NULL,
  `buildplan_attachment` varchar(450) DEFAULT NULL,
  `testplan` text DEFAULT NULL,
  `testplan_attachment` varchar(450) DEFAULT NULL,
  `is_enabled` tinyint(2) NULL DEFAULT '0',
  `category_id` INT( 15  )  NULL DEFAULT  '0',
  `subcategory_id` INT( 15  )  NULL DEFAULT  '0',
  `item_id` INT( 15  )  NULL DEFAULT  '0',
  `location_id` INT( 15  )  NULL DEFAULT  '0',
  PRIMARY KEY (`release_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_release_type`;
CREATE TABLE IF NOT EXISTS `avis_itil_release_type` (
  `release_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`release_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_release_type` (`release_type_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Minor', 1, 0, 1, 1, '#916106', '0'),
(2, 'Standard', 1, 0, 2, 1, '#695405', '0'),
(3, 'Major', 1, 0, 3, 1, '#ab6106', '0'),
(4, 'Emergency', 1, 0, 4, 1, '#e61201', '0');
DROP TABLE IF EXISTS `avis_itil_request_stage`;
CREATE TABLE IF NOT EXISTS `avis_itil_request_stage` (
  `request_stage_id` int(15)  NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`request_stage_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_request_stage` (`request_stage_id`, `name`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'New', 'New', 1, 0, 1, 1, '#bb0003', '0'),
(2, 'In progress', 'In progress', 1, 0, 2, 1, '#b86c06', '0'),
(3, 'Completed', 'Completed', 1, 0, 3, 1, '#2ee800', '0');
DROP TABLE IF EXISTS `avis_itil_risk`;
CREATE TABLE IF NOT EXISTS `avis_itil_risk` (
  `risk_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`risk_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_risk` (`risk_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Low', 1, 0, 1, 1, '#39390a', '0'),
(2, 'Medium', 1, 0, 2, 1, '#550009', '0'),
(3, 'High', 1, 0, 3, 1, '#eb0205', '0'),
(4, 'Very high', 1, 0, 4, 1, '#f55000', '0');
DROP TABLE IF EXISTS `avis_itil_service_category`;
CREATE TABLE IF NOT EXISTS `avis_itil_service_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `domain_id` int(11) NOT NULL,
  `department_id` int(11) NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_service_category` (`category_id`, `name`, `description`, `domain_id`, `department_id`, `is_enabled`) VALUES
(1, 'Hardware', 'hardware appliances', 0, 0, 1),
(2, 'Software', 'software appliances', 0, 0, 1),
(3, 'User management', 'user management', 0, 0, 1),
(4, 'Data service', 'data service', 0, 0, 1),
(5, 'Application access', 'application access', 0, 0, 1);
DROP TABLE IF EXISTS `avis_itil_service_item`;
CREATE TABLE IF NOT EXISTS `avis_itil_service_item` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `category_id` int(11) NOT NULL,
  `item_department_id` int(11) NULL DEFAULT '0',
  `ci_product_id` int(11) NULL DEFAULT '0',
  `description` text NOT NULL,
  `cost` varchar(50) NOT NULL,
  `estimated_delivery` varchar(50) NOT NULL,
  `estimated_delivery_hrs` INT(2) NOT NULL DEFAULT '0',
  `cost_status` tinyint(1) NOT NULL DEFAULT '0',
  `estimate_status` tinyint(1) NOT NULL DEFAULT '0',
  `quantity_status` tinyint(1) NOT NULL DEFAULT '0',
  `item_image` varchar(50) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_service_ticket`;
CREATE TABLE IF NOT EXISTS `avis_itil_service_ticket` (
  `service_id` int(11) NOT NULL AUTO_INCREMENT,
  `service_item_id` int(11) NOT NULL,
  `ticket_id` int(11) NOT NULL,
  `quantity` varchar(20) NOT NULL,
  `total_cost` varchar(50) NOT NULL,
  PRIMARY KEY (`service_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_vendor`;
CREATE TABLE IF NOT EXISTS `avis_itil_vendor` (
  `vendor_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `primary_contact` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `address` text NOT NULL,
  `access_type` tinyint(2) NOT NULL DEFAULT '0',
  `department_access` varchar(512) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`vendor_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_label`;
CREATE TABLE IF NOT EXISTS `avis_label` (
  `label_id` int(15) NOT NULL AUTO_INCREMENT,
  `label_name` varchar(255) DEFAULT NULL,
  `staff_id` int(4) DEFAULT NULL,
  `group_type` int(4) DEFAULT NULL,
  `creation_date` int(15) DEFAULT NULL,
  `display_order` int(15) DEFAULT NULL,
  `label_color` varchar(63) DEFAULT NULL,
  `is_enabled` TINYINT( 1 ) NOT NULL DEFAULT '1',
  `department_access` varchar(512) DEFAULT '0',
  `visible_to_leftpanel` TINYINT( 1 ) NOT NULL DEFAULT '0',
  PRIMARY KEY (`label_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_label` (`label_id`, `label_name`, `staff_id`, `group_type`, `creation_date`, `display_order`, `label_color`, `is_enabled`, `department_access`) VALUES (1, 'Important', 1, 0, 1426598374, 1, '#e33244', 1, '0');
DROP TABLE IF EXISTS `avis_label_data`;
CREATE TABLE IF NOT EXISTS `avis_label_data` (
  `parent_id` int(4) DEFAULT NULL,
  `label_id` int(15) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_language_values`;
CREATE TABLE IF NOT EXISTS `avis_language_values` (
  `language_values_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL,
  `variable_id` int(11) NOT NULL,
  `description` tinytext CHARACTER SET utf8 NOT NULL,
  `is_custom` INT NOT NULL DEFAULT '0',
  PRIMARY KEY (`language_values_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_language_values` (`language_values_id`, `language_id`, `variable_id`, `description`) VALUES
(1, 0, 1, 'Login'),
(2, 0, 2, 'Client approval pending'),
(3, 0, 3, 'Forgot password'),
(4, 0, 4, 'Register'),
(5, 0, 5, 'Self help'),
(6, 0, 6, 'Posted by'),
(7, 0, 7, 'Posted on'),
(8, 0, 8, 'Tickets'),
(9, 0, 9, 'Creation date'),
(10, 0, 10, 'Modified on'),
(11, 0, 11, 'Data not found'),
(12, 0, 12, 'Change password'),
(13, 0, 13, 'Old password'),
(14, 0, 14, 'New password'),
(15, 0, 15, 'Confirm password'),
(16, 0, 16, 'Update'),
(17, 0, 17, 'Clear'),
(18, 0, 18, 'Client email address already registered'),
(19, 0, 19, 'Add contact'),
(20, 0, 20, 'First name'),
(21, 0, 21, 'Last name'),
(22, 0, 22, 'Email'),
(23, 0, 23, 'User name'),
(24, 0, 24, 'Password'),
(25, 0, 25, 'Access'),
(26, 0, 26, 'Open new ticket'),
(27, 0, 27, 'Email notification for self posted tickets'),
(28, 0, 28, 'View parent and other sub contact tickets'),
(29, 0, 29, 'Can reply tickets posted by parent client and their subcontacts'),
(30, 0, 30, 'Add'),
(31, 0, 31, 'Reset'),
(32, 0, 32, 'Custom fields'),
(33, 0, 33, 'Submit'),
(34, 0, 34, 'Credit for invoice: '),
(35, 0, 35, 'Pay now'),
(36, 0, 36, 'Home'),
(37, 0, 37, 'Submit ticket'),
(38, 0, 38, 'View tickets'),
(39, 0, 39, 'Purchase'),
(40, 0, 40, 'My products'),
(41, 0, 41, 'My invoices'),
(42, 0, 42, 'Search tickets and knowledgebase articles'),
(43, 0, 43, 'Search'),
(44, 0, 44, 'Profile'),
(45, 0, 45, 'Contacts'),
(46, 0, 46, 'Logout'),
(47, 0, 47, 'Unpaid'),
(48, 0, 48, 'Paid'),
(49, 0, 49, 'Cancelled'),
(50, 0, 50, 'In process'),
(51, 0, 51, 'Invoice'),
(52, 0, 52, 'Get PDF'),
(53, 0, 53, 'Phone'),
(54, 0, 54, 'Invoice ID'),
(55, 0, 55, 'Due date'),
(56, 0, 56, 'Status'),
(57, 0, 57, 'Paid date'),
(58, 0, 58, 'Description'),
(59, 0, 59, 'Amount'),
(60, 0, 60, 'Tax'),
(61, 0, 61, 'Total due'),
(62, 0, 62, 'Transaction ID'),
(63, 0, 63, 'Transaction date'),
(64, 0, 64, 'Create date'),
(65, 0, 65, 'Total'),
(66, 0, 66, 'Title'),
(67, 0, 67, 'Billing cycle'),
(68, 0, 68, 'Expiry date'),
(69, 0, 69, 'Validity'),
(70, 0, 70, 'Order now'),
(71, 0, 71, 'Update profile'),
(72, 0, 72, 'Profile image'),
(73, 0, 73, 'Upload image'),
(74, 0, 74, 'Address'),
(75, 0, 75, 'City'),
(76, 0, 76, 'State'),
(77, 0, 77, 'Zip code'),
(78, 0, 78, 'Country'),
(79, 0, 79, 'Website'),
(80, 0, 80, 'Department'),
(81, 0, 81, 'Job title'),
(82, 0, 82, 'Company website'),
(83, 0, 83, 'Language'),
(84, 0, 84, 'Contact number'),
(85, 0, 85, 'Image verification'),
(86, 0, 86, 'Type the two words'),
(87, 0, 87, 'Refresh'),
(88, 0, 88, 'Save'),
(89, 0, 89, 'Attachments'),
(90, 0, 90, 'Rating'),
(91, 0, 91, 'Leave a comment'),
(92, 0, 92, 'Full name'),
(93, 0, 93, 'Suggestion'),
(94, 0, 94, 'Answer'),
(95, 0, 95, 'Comments'),
(96, 0, 96, 'Recent articles'),
(97, 0, 97, 'Featured articles'),
(98, 0, 98, 'Add article'),
(99, 0, 99, 'Details'),
(100, 0, 100, 'Welcome to client support portal'),
(101, 0, 101, 'Update contact'),
(102, 0, 102, 'Deleting client will delete its all tickets and its data.<br />Are you sure you want to proceed?'),
(103, 0, 103, 'Delete'),
(104, 0, 104, 'Company name'),
(105, 0, 105, 'Registration required'),
(106, 0, 106, 'Ticket created successfully'),
(107, 0, 107, 'Priority'),
(108, 0, 108, 'Type'),
(109, 0, 109, 'Subject'),
(110, 0, 110, 'Message'),
(111, 0, 111, 'Attach file'),
(112, 0, 112, 'Edit profile'),
(113, 0, 113, 'Banned'),
(114, 0, 114, 'Domain'),
(115, 0, 115, 'Parent'),
(116, 0, 116, 'Organization'),
(117, 0, 117, 'Unsolved'),
(118, 0, 118, 'Solved'),
(119, 0, 119, 'Billing'),
(120, 0, 120, 'Amount credit'),
(121, 0, 121, 'Unlimited'),
(122, 0, 122, 'Feedback'),
(123, 0, 123, 'Reply'),
(124, 0, 124, 'Created on'),
(125, 0, 125, 'Ticket type'),
(126, 0, 126, 'Assigned to'),
(127, 0, 127, 'SLA'),
(128, 0, 128, 'Overdue'),
(129, 0, 129, 'Undue'),
(130, 0, 130, 'Ticket details'),
(131, 0, 131, 'Reply ticket'),
(132, 0, 132, 'Edit ticket'),
(133, 0, 133, 'Send feedback'),
(134, 0, 134, 'Ticket hash'),
(135, 0, 135, 'Staff'),
(136, 0, 136, 'Client'),
(137, 0, 137, 'Change priority'),
(138, 0, 138, 'Cancel'),
(139, 0, 139, 'Page'),
(140, 0, 140, 'Products'),
(141, 0, 141, 'Title'),
(142, 0, 142, 'Admin type'),
(143, 0, 143, 'Access'),
(144, 0, 144, 'Domain admin'),
(145, 0, 145, 'Super admin'),
(146, 0, 146, 'Admin access'),
(147, 0, 147, 'Full name'),
(148, 0, 148, 'User name'),
(149, 0, 149, 'Password'),
(150, 0, 150, 'Domains access'),
(151, 0, 151, 'Add staff'),
(152, 0, 152, 'Delete staff'),
(153, 0, 153, 'All staff'),
(154, 0, 154, 'Group name'),
(155, 0, 155, 'Status'),
(156, 0, 156, 'Login'),
(157, 0, 157, 'Logout'),
(158, 0, 158, 'Toolbar'),
(159, 0, 159, 'Add staff group'),
(160, 0, 160, 'Delete staff group'),
(161, 0, 161, 'Localization'),
(162, 0, 162, 'Domain access'),
(163, 0, 163, 'All domains'),
(164, 0, 164, 'Module'),
(165, 0, 165, 'System'),
(166, 0, 166, 'Diagnostics'),
(167, 0, 167, 'Manage'),
(168, 0, 168, 'View only'),
(169, 0, 169, 'Delete'),
(170, 0, 170, 'Delete all'),
(171, 0, 171, 'Backup'),
(172, 0, 172, 'License'),
(173, 0, 173, 'License information'),
(174, 0, 174, 'View'),
(175, 0, 175, 'List count'),
(176, 0, 176, 'Currently active'),
(177, 0, 177, 'Department'),
(178, 0, 178, 'Departments'),
(179, 0, 179, 'Priority'),
(180, 0, 180, 'Ticket type'),
(181, 0, 181, 'Channel'),
(182, 0, 182, 'Flag type'),
(183, 0, 183, 'Flag'),
(184, 0, 184, 'Language'),
(185, 0, 185, 'Manage all staff'),
(186, 0, 186, 'Manage domain staff'),
(187, 0, 187, 'Staff group'),
(188, 0, 188, 'Workflow'),
(189, 0, 189, 'SLA'),
(190, 0, 190, 'Add SLA'),
(191, 0, 191, 'Delete SLA'),
(192, 0, 192, 'Schedule'),
(193, 0, 193, 'Email queue'),
(194, 0, 194, 'SMTP'),
(195, 0, 195, 'Email templates'),
(196, 0, 196, 'Custom field'),
(197, 0, 197, 'Custom fields'),
(198, 0, 198, 'Custom field group'),
(199, 0, 199, 'Add custom field group'),
(200, 0, 200, 'Delete custom group'),
(201, 0, 201, 'Single login'),
(202, 0, 202, 'Integrations'),
(203, 0, 203, 'APP ID'),
(204, 0, 204, 'APP secret key'),
(205, 0, 205, 'Canvas URL'),
(206, 0, 206, 'Error log'),
(207, 0, 207, 'Delete error log'),
(208, 0, 208, 'Exception log'),
(209, 0, 209, 'Parser log'),
(210, 0, 210, 'Empty parser log'),
(211, 0, 211, 'Delete parser log'),
(212, 0, 212, 'Sendmail log'),
(213, 0, 213, 'API'),
(214, 0, 214, 'API access'),
(215, 0, 215, 'Logs'),
(216, 0, 216, 'Error'),
(217, 0, 217, 'Parser'),
(218, 0, 218, 'Automation'),
(219, 0, 219, 'Send email'),
(220, 0, 220, 'Ticket details'),
(221, 0, 221, 'Audit log'),
(222, 0, 222, 'History'),
(223, 0, 223, 'Invoices'),
(224, 0, 224, 'Export to PDF'),
(225, 0, 225, 'Export'),
(226, 0, 226, 'Add alert'),
(227, 0, 227, 'Delete alert'),
(228, 0, 228, 'Email template'),
(229, 0, 229, 'All tickets'),
(230, 0, 230, 'New tickets'),
(231, 0, 231, 'Overdue tickets'),
(232, 0, 232, 'Assigned tickets'),
(233, 0, 233, 'Unsolved'),
(234, 0, 234, 'Solved'),
(235, 0, 235, 'Read'),
(236, 0, 236, 'Unread'),
(237, 0, 237, 'Labels'),
(238, 0, 238, 'Event'),
(239, 0, 239, 'Client reply'),
(240, 0, 240, 'Staff reply'),
(241, 0, 241, 'Flag change'),
(242, 0, 242, 'Ticket type change'),
(243, 0, 243, 'Department change'),
(244, 0, 244, 'Status change'),
(245, 0, 245, 'Priority change'),
(246, 0, 246, 'Ticket assign'),
(247, 0, 247, 'Client add'),
(248, 0, 248, 'Client edit'),
(249, 0, 249, 'Client delete'),
(250, 0, 250, 'Ticket department change'),
(251, 0, 251, 'Ticket status change'),
(252, 0, 252, 'Ticket priority change'),
(253, 0, 253, 'Ticket merge'),
(254, 0, 254, 'Add note'),
(255, 0, 255, 'Delete note'),
(256, 0, 256, 'Note add'),
(257, 0, 257, 'Note type'),
(258, 0, 258, 'Billing invoice add'),
(259, 0, 259, 'Ticket post delete'),
(260, 0, 260, 'Ticket delete'),
(261, 0, 261, 'Move to trash'),
(262, 0, 262, 'Reset'),
(263, 0, 263, 'Criteria'),
(264, 0, 264, 'Match any criteria'),
(265, 0, 265, 'Match all criteria'),
(266, 0, 266, 'Add criteria'),
(267, 0, 267, 'Filters'),
(268, 0, 268, 'Search'),
(269, 0, 269, 'Search result'),
(270, 0, 270, 'Match criteria'),
(271, 0, 271, 'Save as filter'),
(272, 0, 272, 'Save as draft'),
(273, 0, 273, 'Subject'),
(274, 0, 274, 'Message'),
(275, 0, 275, 'Ticket note'),
(276, 0, 276, 'Client note'),
(277, 0, 277, 'Ticket comment'),
(278, 0, 278, 'Client name'),
(279, 0, 279, 'Client email'),
(280, 0, 280, 'Owner'),
(281, 0, 281, 'Last activity'),
(282, 0, 282, 'Creation date'),
(283, 0, 283, 'SLA plan'),
(284, 0, 284, 'Response time'),
(285, 0, 285, 'Has attachment'),
(286, 0, 286, 'Billing note'),
(287, 0, 287, 'Add billing note'),
(288, 0, 288, 'Contain'),
(289, 0, 289, 'Does not contain'),
(290, 0, 290, 'Equal'),
(291, 0, 291, 'Not equal'),
(292, 0, 292, 'Less than'),
(293, 0, 293, 'Greater than'),
(294, 0, 294, 'True'),
(295, 0, 295, 'Alerts'),
(296, 0, 296, 'Views'),
(297, 0, 297, 'Submit ticket'),
(298, 0, 298, 'Edit ticket'),
(299, 0, 299, 'Staff'),
(300, 0, 300, 'Client'),
(301, 0, 301, 'Operation'),
(302, 0, 302, 'Date time'),
(303, 0, 303, 'Date'),
(304, 0, 304, 'Operator'),
(305, 0, 305, 'Add credit'),
(306, 0, 306, 'Amount'),
(307, 0, 307, 'Details'),
(308, 0, 308, 'Preferences'),
(309, 0, 309, 'Expiry date'),
(310, 0, 310, 'Billing'),
(311, 0, 311, 'Billing method'),
(312, 0, 312, 'Ticket base'),
(313, 0, 313, 'Time base'),
(314, 0, 314, 'Bill rate'),
(315, 0, 315, 'Currency'),
(316, 0, 316, 'On ticket create'),
(317, 0, 317, 'Do not generate invoice'),
(318, 0, 318, 'Generate invoice'),
(319, 0, 319, 'Generate and send invoice'),
(320, 0, 320, 'Credit required'),
(321, 0, 321, 'Minutes'),
(322, 0, 322, 'Taxable'),
(323, 0, 323, 'Total due'),
(324, 0, 324, 'Tax rule'),
(325, 0, 325, 'Invoice'),
(326, 0, 326, 'View invoice'),
(327, 0, 327, 'Create date'),
(328, 0, 328, 'Paid date'),
(329, 0, 329, 'Due date'),
(330, 0, 330, 'Total'),
(331, 0, 331, 'Unpaid'),
(332, 0, 332, 'Paid'),
(333, 0, 333, 'Cancelled'),
(334, 0, 334, 'Todays due'),
(335, 0, 335, 'Todays paid'),
(336, 0, 336, 'Today'),
(337, 0, 337, 'Month'),
(338, 0, 338, 'Group balance'),
(339, 0, 339, 'Billing URL'),
(340, 0, 340, 'Admin username'),
(341, 0, 341, 'Admin password'),
(342, 0, 342, 'API key'),
(343, 0, 343, 'Blabs'),
(344, 0, 344, 'Add blab'),
(345, 0, 345, 'Trends'),
(346, 0, 346, 'Add image'),
(347, 0, 347, 'Add video'),
(349, 0, 349, 'Share with'),
(350, 0, 350, 'All'),
(351, 0, 351, 'URL'),
(352, 0, 352, 'View blabs'),
(353, 0, 353, 'Add to blab'),
(354, 0, 354, 'Blab count'),
(355, 0, 355, 'Remove from list'),
(356, 0, 356, 'Delete blab'),
(357, 0, 357, 'Break line'),
(358, 0, 358, 'Add breakline'),
(359, 0, 359, 'Delete breakline'),
(360, 0, 360, 'Execution order'),
(361, 0, 361, 'Regular expression'),
(362, 0, 362, 'Add task'),
(363, 0, 363, 'Delete task'),
(364, 0, 364, 'Calendar'),
(365, 0, 365, 'Description'),
(366, 0, 366, 'End date'),
(367, 0, 367, 'Start date'),
(368, 0, 368, 'Planned'),
(369, 0, 369, 'Completed'),
(370, 0, 370, 'In progress'),
(371, 0, 371, 'Not started'),
(372, 0, 372, 'Task type'),
(373, 0, 373, 'Location'),
(374, 0, 374, 'Personal'),
(375, 0, 375, 'Business'),
(376, 0, 376, 'Important'),
(377, 0, 377, 'Label'),
(378, 0, 378, 'Medium'),
(379, 0, 379, 'High'),
(380, 0, 380, 'Low'),
(381, 0, 381, 'Tasks'),
(382, 0, 382, 'Ticket queues'),
(383, 0, 383, 'Filter queues'),
(384, 0, 384, 'Folders'),
(385, 0, 385, 'Select department'),
(386, 0, 386, 'Select domain'),
(387, 0, 387, 'Old password'),
(388, 0, 388, 'New password'),
(389, 0, 389, 'Change password'),
(390, 0, 390, 'Confirm password'),
(391, 0, 391, 'Add channel'),
(392, 0, 392, 'Channel image'),
(393, 0, 393, 'Add language'),
(394, 0, 394, 'Update language'),
(395, 0, 395, 'Delete language'),
(397, 0, 397, 'PHP information'),
(398, 0, 398, 'Add client'),
(399, 0, 399, 'Add contact'),
(400, 0, 400, 'Manage contact'),
(401, 0, 401, 'Feedback'),
(402, 0, 402, 'Send feedback'),
(403, 0, 403, 'Clients'),
(404, 0, 404, 'Contacts'),
(405, 0, 405, 'Action'),
(407, 0, 407, 'Add client group'),
(408, 0, 408, 'Delete client group'),
(409, 0, 409, 'First name'),
(410, 0, 410, 'Last name'),
(411, 0, 411, 'Initials'),
(412, 0, 412, 'Gender'),
(413, 0, 413, 'Male'),
(414, 0, 414, 'Female'),
(415, 0, 415, 'Email'),
(416, 0, 416, 'Contact number'),
(417, 0, 417, 'Mobile number'),
(418, 0, 418, 'Permanent address'),
(419, 0, 419, 'Current address'),
(420, 0, 420, 'City'),
(421, 0, 421, 'State'),
(422, 0, 422, 'Country'),
(423, 0, 423, 'Zip code'),
(424, 0, 424, 'Fax'),
(425, 0, 425, 'Website'),
(426, 0, 426, 'Company name'),
(427, 0, 427, 'Company email'),
(428, 0, 428, 'Company phone 1'),
(429, 0, 429, 'Company phone 2'),
(430, 0, 430, 'Company fax'),
(431, 0, 431, 'Company address'),
(432, 0, 432, 'Company website'),
(433, 0, 433, 'Netmeeting ID'),
(434, 0, 434, 'Other IM'),
(435, 0, 435, 'Other contact'),
(436, 0, 436, 'Other fax'),
(437, 0, 437, 'Job title'),
(438, 0, 438, 'Credit'),
(439, 0, 439, 'Create invoice'),
(440, 0, 440, 'Delete invoice'),
(441, 0, 441, 'Paid department'),
(442, 0, 442, 'Register'),
(443, 0, 443, 'Registered'),
(444, 0, 444, 'Unregistered'),
(445, 0, 445, 'Ban'),
(446, 0, 446, 'Ban client'),
(447, 0, 447, 'Banned'),
(448, 0, 448, 'Remove ban'),
(449, 0, 449, 'Spammer'),
(450, 0, 450, 'Not spam'),
(451, 0, 451, 'Mark spam'),
(452, 0, 452, 'Edit'),
(453, 0, 453, 'Ban and delete'),
(454, 0, 454, 'Email notifications'),
(455, 0, 455, 'Ticket'),
(456, 0, 456, 'Tickets'),
(457, 0, 457, 'View tickets'),
(458, 0, 458, 'Reply ticket'),
(459, 0, 459, 'Reply'),
(460, 0, 460, 'Reply all'),
(461, 0, 461, 'Forward'),
(462, 0, 462, 'Send reply'),
(463, 0, 463, 'Send'),
(464, 0, 464, 'Delete ticket'),
(465, 0, 465, 'Merge ticket'),
(466, 0, 466, 'Delete ticket properties'),
(467, 0, 467, 'Change properties'),
(468, 0, 468, 'Delete ticket post'),
(469, 0, 469, 'Edit ticket post'),
(470, 0, 470, 'Set due time'),
(471, 0, 471, 'Recipients'),
(472, 0, 472, 'Discard'),
(473, 0, 473, 'Ascending'),
(474, 0, 474, 'Descending'),
(475, 0, 475, 'View note'),
(476, 0, 476, 'Manage note'),
(477, 0, 477, 'Open new ticket'),
(478, 0, 478, 'Forward ticket'),
(479, 0, 479, 'Self assigned'),
(480, 0, 480, 'Unassigned'),
(481, 0, 481, 'Assigned'),
(482, 0, 482, 'Assigned to'),
(483, 0, 483, 'Move to'),
(484, 0, 484, 'Unassigned and self assigned'),
(485, 0, 485, 'Overdue'),
(486, 0, 486, 'Undue'),
(487, 0, 487, 'Overdue time'),
(488, 0, 488, 'New'),
(489, 0, 489, 'Note'),
(490, 0, 490, 'From'),
(491, 0, 491, 'To'),
(492, 0, 492, 'Ticket hash'),
(493, 0, 493, 'Ticket ID'),
(494, 0, 494, 'Ticket priority'),
(495, 0, 495, 'Ticket status'),
(496, 0, 496, 'Add status'),
(497, 0, 497, 'Delete ticket status'),
(498, 0, 498, 'Ticket created on'),
(499, 0, 499, 'Ticket modified on'),
(500, 0, 500, 'Resolve time'),
(501, 0, 501, 'SLA ID'),
(502, 0, 502, 'Ticket post count'),
(503, 0, 503, 'Ticket count'),
(504, 0, 504, 'Client first name'),
(505, 0, 505, 'Client last name'),
(506, 0, 506, 'Client contact'),
(507, 0, 507, 'Client company'),
(508, 0, 508, 'Client job title'),
(509, 0, 509, 'Client state'),
(510, 0, 510, 'Client city'),
(511, 0, 511, 'Client zip code'),
(512, 0, 512, 'Client country'),
(513, 0, 513, 'Is spam client'),
(514, 0, 514, 'Is banned client'),
(515, 0, 515, 'Client paid invoice count'),
(516, 0, 516, 'Client unpaid invoice count'),
(517, 0, 517, 'Staff first name'),
(518, 0, 518, 'Staff last name'),
(519, 0, 519, 'Staff email'),
(520, 0, 520, 'Staff job title'),
(521, 0, 521, 'Avg. response time'),
(522, 0, 522, 'Total responses'),
(523, 0, 523, 'Staff group access'),
(524, 0, 524, 'Staff list'),
(525, 0, 525, 'Back'),
(526, 0, 526, 'Sort by'),
(527, 0, 527, 'Select'),
(528, 0, 528, 'Ticket autoclose time'),
(529, 0, 529, 'Ticket average response time'),
(530, 0, 530, 'Ticket follow up count'),
(531, 0, 531, 'Ticket IP address'),
(532, 0, 532, 'Ticket is resolved'),
(533, 0, 533, 'Ticket reply to'),
(534, 0, 534, 'Ticket time worked'),
(535, 0, 535, 'Ticket total replies'),
(536, 0, 536, 'SLA overdue hours'),
(537, 0, 537, 'SLA plan resolution due hours'),
(538, 0, 538, 'Rating'),
(539, 0, 539, 'Attachments'),
(540, 0, 540, 'Resolution time'),
(541, 0, 541, 'Number of attachments'),
(542, 0, 542, 'Allowed attachment extensions'),
(543, 0, 543, 'Max allowed size for attachment (in KB)'),
(544, 0, 544, 'Add merged ticket''s email as recipients'),
(545, 0, 545, 'Visible to client'),
(546, 0, 546, 'Fields available'),
(547, 0, 547, 'Fields selected'),
(548, 0, 548, 'Last replier'),
(549, 0, 549, 'Add view'),
(550, 0, 550, 'Delete view'),
(551, 0, 551, 'Summary'),
(552, 0, 552, 'Profile'),
(553, 0, 553, 'Profile image'),
(554, 0, 554, 'Personal details'),
(555, 0, 555, 'Home details'),
(556, 0, 556, 'Company details'),
(557, 0, 557, 'Reset password'),
(558, 0, 558, 'Add domain'),
(559, 0, 559, 'Update domain'),
(560, 0, 560, 'Domain name'),
(561, 0, 561, 'Domain'),
(562, 0, 562, 'Delete domain'),
(563, 0, 563, 'Add department'),
(564, 0, 564, 'Update department'),
(565, 0, 565, 'Delete department'),
(566, 0, 566, 'Access'),
(567, 0, 567, 'Is paid'),
(568, 0, 568, 'Registration required'),
(569, 0, 569, 'Autoresponder'),
(570, 0, 570, 'Auto responder signature'),
(571, 0, 571, 'Domain URL'),
(572, 0, 572, 'Set'),
(573, 0, 573, 'Client portal URL'),
(574, 0, 574, 'Default email'),
(575, 0, 575, 'Default client portal language'),
(576, 0, 576, 'Client portal theme'),
(577, 0, 577, 'Client portal'),
(578, 0, 578, 'Update client portal'),
(579, 0, 579, 'Outgoing email'),
(580, 0, 580, 'Timezone'),
(581, 0, 581, 'DST setting'),
(582, 0, 582, 'Auto approve registration'),
(583, 0, 583, 'Enable captcha on register'),
(584, 0, 584, 'Approve'),
(585, 0, 585, 'Disapproved'),
(586, 0, 586, 'Pin'),
(587, 0, 587, 'Login as client'),
(588, 0, 588, 'Create ticket'),
(590, 0, 590, 'Group type'),
(591, 0, 591, 'User registration'),
(592, 0, 592, 'User ticket creation'),
(593, 0, 593, 'Staff ticket creation'),
(594, 0, 594, 'Department access'),
(595, 0, 595, 'All departments'),
(596, 0, 596, 'Type'),
(597, 0, 597, 'Add ticket type'),
(598, 0, 598, 'Delete ticket type'),
(599, 0, 599, 'Fields'),
(600, 0, 600, 'Field details'),
(601, 0, 601, 'Field title'),
(602, 0, 602, 'Default value'),
(603, 0, 603, 'Field description'),
(604, 0, 604, 'Is required'),
(605, 0, 605, 'User editable'),
(606, 0, 606, 'Staff editable'),
(608, 0, 608, 'Numeric'),
(609, 0, 609, 'Alphabetic'),
(610, 0, 610, 'Alphanumeric'),
(611, 0, 611, 'Option fields'),
(612, 0, 612, 'Add custom field'),
(613, 0, 613, 'Delete custom field'),
(614, 0, 614, 'Customizations'),
(615, 0, 615, 'HTML tags'),
(616, 0, 616, 'Text box'),
(617, 0, 617, 'Text area'),
(618, 0, 618, 'Checkbox'),
(619, 0, 619, 'Radio'),
(620, 0, 620, 'Select multiple'),
(621, 0, 621, 'File'),
(622, 0, 622, 'Regular expression validation'),
(623, 0, 623, 'Add email template'),
(624, 0, 624, 'Delete email template'),
(625, 0, 625, 'Content'),
(626, 0, 626, 'Add flag'),
(627, 0, 627, 'Delete flag'),
(628, 0, 628, 'Flag name'),
(629, 0, 629, 'Flag color'),
(630, 0, 630, 'Language translation for flag title'),
(631, 0, 631, 'File name'),
(632, 0, 632, 'Language code'),
(633, 0, 633, 'Character set'),
(634, 0, 634, 'Code'),
(635, 0, 635, 'Direction'),
(636, 0, 636, 'Right to left'),
(637, 0, 637, 'Left to right'),
(638, 0, 638, 'Left panel view'),
(639, 0, 639, 'Sent email'),
(640, 0, 640, 'Toggle left panel'),
(641, 0, 641, 'Settings'),
(642, 0, 642, 'Pinned items'),
(643, 0, 643, 'Quick view'),
(644, 0, 644, 'Back to login'),
(645, 0, 645, 'Forgot password'),
(646, 0, 646, 'Mail queues'),
(647, 0, 647, 'Add email queue'),
(648, 0, 648, 'Delete mailqueue'),
(649, 0, 649, 'Fetch type'),
(650, 0, 650, 'Login information'),
(651, 0, 651, 'Host name'),
(652, 0, 652, 'Database name'),
(653, 0, 653, 'Table prefix'),
(654, 0, 654, 'Port'),
(655, 0, 655, 'SSL type'),
(656, 0, 656, 'SMTP authentication'),
(657, 0, 657, 'Leave a copy on server'),
(658, 0, 658, 'Queue title'),
(659, 0, 659, 'From name'),
(660, 0, 660, 'From email'),
(661, 0, 661, 'Queue setting'),
(662, 0, 662, 'Signature'),
(663, 0, 663, 'Leave a comment'),
(664, 0, 664, 'Comment submitted'),
(665, 0, 665, 'Mail details'),
(666, 0, 666, 'Self help'),
(667, 0, 667, 'Categories'),
(668, 0, 668, 'Comments'),
(669, 0, 669, 'Article'),
(670, 0, 670, 'Posted by'),
(671, 0, 671, 'Allow comments'),
(672, 0, 672, 'Allow ratings'),
(673, 0, 673, 'Default home page'),
(674, 0, 674, 'Allow attachment to clients'),
(675, 0, 675, 'Login compulsory to client'),
(676, 0, 676, 'Autosubscribe after comment'),
(677, 0, 677, 'Root'),
(678, 0, 678, 'Parent category'),
(679, 0, 679, 'Knowledgebase'),
(680, 0, 680, 'Suggestion'),
(681, 0, 681, 'Question and answer'),
(682, 0, 682, 'Answer'),
(683, 0, 683, 'Order by'),
(684, 0, 684, 'New first'),
(685, 0, 685, 'Old first'),
(686, 0, 686, 'Modified first'),
(687, 0, 687, 'Visible to'),
(688, 0, 688, 'Everybody'),
(689, 0, 689, 'Staff only'),
(690, 0, 690, 'Logged in client'),
(691, 0, 691, 'Is enabled'),
(692, 0, 692, 'Post article'),
(693, 0, 693, 'Author'),
(694, 0, 694, 'Add category'),
(695, 0, 695, 'Add article'),
(696, 0, 696, 'Article added'),
(697, 0, 697, 'Delete category'),
(698, 0, 698, 'Delete article'),
(699, 0, 699, 'Self help suggestion'),
(700, 0, 700, 'Enable captcha on selfhelp'),
(701, 0, 701, 'Quick insert'),
(702, 0, 702, 'More'),
(703, 0, 703, 'Featured articles'),
(704, 0, 704, 'Welcome'),
(705, 0, 705, 'Welcome to client support portal'),
(706, 0, 706, 'Open and track support ticket'),
(707, 0, 707, 'Check our self help section for helpful articles and latest announcements'),
(708, 0, 708, 'Reports'),
(709, 0, 709, 'Add report'),
(710, 0, 710, 'View result'),
(711, 0, 711, 'Migration'),
(712, 0, 712, 'Advanced search'),
(713, 0, 713, 'Home'),
(714, 0, 714, 'Inbox'),
(715, 0, 715, 'Tags'),
(716, 0, 716, 'Delete tag'),
(717, 0, 717, 'Tag search'),
(718, 0, 718, 'Recent activities'),
(719, 0, 719, 'Add module'),
(720, 0, 720, 'Delete module'),
(721, 0, 721, 'Header title'),
(722, 0, 722, 'Display on quick view'),
(723, 0, 723, 'Clients group'),
(724, 0, 724, 'Add clients group'),
(725, 0, 725, 'Failed'),
(726, 0, 726, 'Success'),
(727, 0, 727, 'Theme'),
(728, 0, 728, 'Session timeout'),
(729, 0, 729, 'In minutes'),
(730, 0, 730, 'Sound alert'),
(731, 0, 731, 'HTML editor'),
(732, 0, 732, 'Color'),
(733, 0, 733, 'Language translation for priority title'),
(734, 0, 734, 'Add priority'),
(735, 0, 735, 'Update priority'),
(736, 0, 736, 'Delete priority'),
(737, 0, 737, 'Purchase or upgrade'),
(738, 0, 738, 'Language translation for status title'),
(739, 0, 739, 'Language translation for ticket type title'),
(740, 0, 740, 'Email notification for self posted tickets'),
(741, 0, 741, 'Email notification for self posted tickets'),
(742, 0, 742, 'View parent and other sub contact tickets'),
(743, 0, 743, 'Reply parent and other sub contact tickets'),
(744, 0, 744, 'Add schedule'),
(745, 0, 745, 'Delete schedule'),
(746, 0, 746, 'Sunday'),
(747, 0, 747, 'Monday'),
(748, 0, 748, 'Tuesday'),
(749, 0, 749, 'Wednesday'),
(750, 0, 750, 'Thursday'),
(751, 0, 751, 'Friday'),
(752, 0, 752, 'Saturday'),
(753, 0, 753, 'Open 24 hours'),
(754, 0, 754, 'Close'),
(755, 0, 755, 'Open'),
(756, 0, 756, 'Custom time'),
(757, 0, 757, 'Hours'),
(758, 0, 758, 'Minutes'),
(759, 0, 759, 'Add workflow'),
(760, 0, 760, 'Delete workflow'),
(761, 0, 761, 'Change department'),
(762, 0, 762, 'No change'),
(763, 0, 763, 'Assign staff'),
(764, 0, 764, 'Change status'),
(765, 0, 765, 'Change priority'),
(766, 0, 766, 'Change flag'),
(767, 0, 767, 'Change ticket type'),
(768, 0, 768, 'Apply SLA'),
(769, 0, 769, 'Ignore email'),
(770, 0, 770, 'Send autoresponder message'),
(771, 0, 771, 'Process ticket alert rules'),
(772, 0, 772, 'Do not parse as ticket reply'),
(773, 0, 773, 'Forward to'),
(774, 0, 774, 'Marked as banned'),
(775, 0, 775, 'Marked as spam'),
(776, 0, 776, 'Image verification'),
(777, 0, 777, 'Type the two words'),
(778, 0, 778, 'Refresh'),
(779, 0, 779, 'Submit'),
(780, 0, 780, 'Change'),
(781, 0, 781, 'Ok'),
(782, 0, 782, 'On'),
(783, 0, 783, 'Cancel'),
(784, 0, 784, 'Options'),
(785, 0, 785, 'None'),
(786, 0, 786, 'Public'),
(787, 0, 787, 'Private'),
(788, 0, 788, 'Posted on'),
(789, 0, 789, 'Created on'),
(790, 0, 790, 'Modified on'),
(791, 0, 791, 'Yes'),
(792, 0, 792, 'No'),
(793, 0, 793, 'Enable'),
(794, 0, 794, 'Disable'),
(795, 0, 795, 'Enabled'),
(796, 0, 796, 'Disabled'),
(797, 0, 797, 'Display order'),
(798, 0, 798, 'Page'),
(799, 0, 799, 'Add'),
(800, 0, 800, 'Update'),
(802, 0, 802, 'Next'),
(803, 0, 803, 'Clear'),
(804, 0, 804, 'Finish'),
(805, 0, 805, 'Deletion of custom field group will delete custom fields in this custom group'),
(806, 0, 806, 'Module should contain character from a to z only in small letters'),
(807, 0, 807, 'To add custom fields you require minimum one custom field group'),
(808, 0, 808, 'Client group can not be deleted until client is assigned to that group'),
(809, 0, 809, 'Deleting department will delete all tickets under that department. This action is irreversible! <br /> Are you sure you want to proceed?'),
(810, 0, 810, 'Deleting domain will delete all departments clients and their tickets from this domain.<br />This operation is irreversible<br />are you sure you want to proceed?'),
(811, 0, 811, 'Deleting category will delete all its articles and comments on that articles. <br />This operation is irreversible. <br />Are you sure you want to proceed?'),
(812, 0, 812, 'Deleting article will delete article and comments on it. <br />This operation is irreversible. <br />Are you sure you want to proceed?'),
(813, 0, 813, 'Ticket has assigned with this status.<br />Can not delete status which assigned to ticket'),
(814, 0, 814, 'Ticket has assigned with this priority.<br />Can not delete priority which assigned to ticket'),
(815, 0, 815, 'Ticket has assigned with this type.<br />Can not delete ticket type which assigned to ticket'),
(816, 0, 816, 'Ticket has assigned with this flag.<br />Can not delete flag which assigned to ticket'),
(817, 0, 817, 'Staff has assigned with this staffgroup.<br />Can not delete staffgroup which assigned to staff'),
(818, 0, 818, 'Required files not found for module'),
(819, 0, 819, '<span class="vis_msg">Image verification mismatch</span>'),
(820, 0, 820, 'Required field module name'),
(821, 0, 821, 'Setting not available'),
(822, 0, 822, 'Empty sent mail log'),
(823, 0, 823, 'Log not selected'),
(824, 0, 824, 'Email approval pending'),
(825, 0, 825, 'Error log is empty'),
(826, 0, 826, 'Exception log is empty'),
(827, 0, 827, 'Required field schedule name'),
(828, 0, 828, 'Incorrect response time'),
(829, 0, 829, 'Incorrect resolution time'),
(830, 0, 830, 'Required field subject'),
(831, 0, 831, 'Amount is missing or invalid format'),
(832, 0, 832, 'Client ID missing'),
(833, 0, 833, 'Client email missing'),
(834, 0, 834, 'Ticket ID missing'),
(835, 0, 835, 'Filter title not set'),
(836, 0, 836, 'Required field title'),
(837, 0, 837, 'Post message not found'),
(838, 0, 838, 'Sender not found'),
(839, 0, 839, 'Required data not submitted'),
(840, 0, 840, 'Tag name missing'),
(841, 0, 841, 'Invalid operation'),
(842, 0, 842, 'Select multiple tickets to merge'),
(843, 0, 843, '<div class="alert-success">Operation completed successfully</div>'),
(844, 0, 844, '<div class="vis_msg_err">Error in operation</div>'),
(845, 0, 845, 'Invoice ID missing'),
(846, 0, 846, 'Invalid old password'),
(847, 0, 847, 'Staff not selected'),
(848, 0, 848, 'Blab ID not found'),
(849, 0, 849, 'Client group ID not found'),
(850, 0, 850, 'Group name is missing'),
(851, 0, 851, 'Password mismatch'),
(852, 0, 852, 'Password reset and sent to email'),
(853, 0, 853, 'Client email address already registered'),
(854, 0, 854, 'Email address missing or invalid email format'),
(855, 0, 855, 'First name missing'),
(856, 0, 856, 'Last name missing'),
(857, 0, 857, 'User name missing'),
(858, 0, 858, 'Field not selected'),
(859, 0, 859, 'Event not selected'),
(860, 0, 860, 'Migration data not selected'),
(861, 0, 861, 'Access denied'),
(862, 0, 862, 'Are you sure you want to proceed?'),
(863, 0, 863, 'Deleting client will delete its all tickets and its data.<br />Are you sure you want to proceed?'),
(864, 0, 864, 'Your add-on domain limit has been reached. If you wish to add more add-on domains you will have to upgrade your vision helpdesk license to higher plan. Please renew'),
(865, 0, 865, 'Core module can not be deleted'),
(866, 0, 866, 'Incomplete information submitted'),
(867, 0, 867, 'Invalid login details'),
(868, 0, 868, 'Quick view widget for this module not found'),
(869, 0, 869, 'Empty error log'),
(870, 0, 870, 'Contact not found'),
(871, 0, 871, 'New client registered'),
(872, 0, 872, 'Client deleted'),
(873, 0, 873, 'Domain not found'),
(874, 0, 874, 'Department not found'),
(875, 0, 875, 'Staff id not found'),
(876, 0, 876, 'Data not found'),
(877, 0, 877, 'New ticket created'),
(878, 0, 878, 'Ticket replied'),
(879, 0, 879, 'Status changed'),
(880, 0, 880, 'Priority changed'),
(881, 0, 881, 'Department changed'),
(882, 0, 882, 'Ticket type changed'),
(883, 0, 883, 'Flag changed'),
(884, 0, 884, 'Ticket assigned'),
(885, 0, 885, 'Ticket moved to trash'),
(886, 0, 886, 'Ticket merged'),
(887, 0, 887, 'Ticket forwarded'),
(888, 0, 888, 'Ticket deleted'),
(889, 0, 889, 'SLA changed'),
(890, 0, 890, 'Spam marked'),
(891, 0, 891, 'Removed spam mark'),
(892, 0, 892, 'Can not remove first criteria'),
(893, 0, 893, 'Required field display order'),
(894, 0, 894, 'Display order must be numeric'),
(895, 0, 895, 'Ticket hash'),
(896, 0, 896, 'Ticket ID'),
(897, 0, 897, 'Subject'),
(898, 0, 898, 'Ticket type'),
(899, 0, 899, 'Domain'),
(900, 0, 900, 'Department'),
(901, 0, 901, 'Status'),
(902, 0, 902, 'Priority'),
(903, 0, 903, 'Created on'),
(904, 0, 904, 'Modified on'),
(905, 0, 905, 'Due time'),
(906, 0, 906, 'Resolution time'),
(907, 0, 907, 'SLA plan'),
(908, 0, 908, 'SLA ID'),
(909, 0, 909, 'Reply count'),
(910, 0, 910, 'Ticket count'),
(911, 0, 911, 'First name'),
(912, 0, 912, 'Last name'),
(913, 0, 913, 'Email'),
(914, 0, 914, 'Contact number'),
(915, 0, 915, 'Job title'),
(916, 0, 916, 'Company'),
(917, 0, 917, 'City'),
(918, 0, 918, 'State'),
(919, 0, 919, 'Country'),
(920, 0, 920, 'Zip code'),
(922, 0, 922, 'Group type'),
(923, 0, 923, 'Is spam'),
(924, 0, 924, 'Is ban'),
(925, 0, 925, 'Credit'),
(926, 0, 926, 'Debit'),
(927, 0, 927, 'Group balance'),
(928, 0, 928, 'Group debit'),
(929, 0, 929, 'Paid invoice count'),
(930, 0, 930, 'Unpaid invoice count'),
(931, 0, 931, 'First name'),
(932, 0, 932, 'Last name'),
(933, 0, 933, 'Email'),
(934, 0, 934, 'Contact number'),
(935, 0, 935, 'Mobile number'),
(936, 0, 936, 'Job title'),
(937, 0, 937, 'Company'),
(938, 0, 938, 'City'),
(939, 0, 939, 'State'),
(940, 0, 940, 'Country'),
(941, 0, 941, 'Zip code'),
(943, 0, 943, 'Domain'),
(945, 0, 945, 'Is spam'),
(946, 0, 946, 'Is ban'),
(947, 0, 947, 'Avg. responses'),
(948, 0, 948, 'Total responses'),
(949, 0, 949, 'Properties'),
(950, 0, 950, 'People'),
(951, 0, 951, 'Or'),
(952, 0, 952, 'Data not available'),
(953, 0, 953, 'Module already exist'),
(954, 0, 954, 'Default view can not delete'),
(955, 0, 955, 'Search trash'),
(956, 0, 956, 'Search spam'),
(957, 0, 957, 'Trash'),
(958, 0, 958, 'Spam'),
(959, 0, 959, 'Print'),
(960, 0, 960, 'Ticket not found may be deleted or not have access'),
(961, 0, 961, 'On overdue'),
(962, 0, 962, 'Option'),
(963, 0, 963, 'Delete filter'),
(964, 0, 964, 'Drafts'),
(965, 0, 965, 'Staff currently reading this ticket'),
(966, 0, 966, 'To share with all do not select staff'),
(967, 0, 967, 'Go'),
(968, 0, 968, 'Delete report'),
(969, 0, 969, 'Staff username and email should be unique'),
(970, 0, 970, 'Delete SMTP'),
(971, 0, 971, 'Delete sent mail log'),
(972, 0, 972, 'Client details'),
(973, 0, 973, 'Client notes'),
(974, 0, 974, 'Products and services'),
(975, 0, 975, 'Package'),
(976, 0, 976, 'Dedicated IP'),
(977, 0, 977, 'WHMCS client notes'),
(978, 0, 978, 'Error in WHMCS database selection'),
(979, 0, 979, 'Error in WHMCS database connection'),
(980, 0, 980, 'WHMCS integration details not set'),
(981, 0, 981, 'Version'),
(982, 0, 982, 'Branding free'),
(983, 0, 983, 'Invoice for ticket'),
(984, 0, 984, 'Credit for invoice'),
(985, 0, 985, 'Insufficient credit'),
(986, 0, 986, 'Invoice for time'),
(987, 0, 987, 'Bill amount'),
(988, 0, 988, 'Edit transaction'),
(989, 0, 989, 'Transactions'),
(990, 0, 990, 'Transaction ID'),
(991, 0, 991, 'Delete transaction'),
(992, 0, 992, 'Add credit'),
(993, 0, 993, 'Rate'),
(994, 0, 994, 'Inclusive'),
(995, 0, 995, 'Exclusive'),
(996, 0, 996, 'Add tax rule'),
(997, 0, 997, 'Edit tax rule'),
(998, 0, 998, 'Invalid rule'),
(999, 0, 999, 'Delete tax rule'),
(1000, 0, 1000, 'View invoice to client'),
(1001, 0, 1001, 'Pay now'),
(1002, 0, 1002, 'Get PDF'),
(1003, 0, 1003, 'Sub total'),
(1004, 0, 1004, 'Invoice to'),
(1005, 0, 1005, 'Move to inbox'),
(1006, 0, 1006, 'Payment gateway'),
(1007, 0, 1007, 'Mark unpaid'),
(1008, 0, 1008, 'Mark cancelled'),
(1009, 0, 1009, 'Greater than or equal'),
(1010, 0, 1010, 'Add item'),
(1011, 0, 1011, 'Email templates mapping'),
(1012, 0, 1012, 'Convert to ticket'),
(1013, 0, 1013, 'Add search'),
(1014, 0, 1014, 'Consumer key'),
(1015, 0, 1015, 'Consumer secret'),
(1016, 0, 1016, 'Access token'),
(1017, 0, 1017, 'Access token secret'),
(1018, 0, 1018, 'Check your ticket details at'),
(1019, 0, 1019, 'Social media'),
(1020, 0, 1020, 'Search content'),
(1021, 0, 1021, 'Add social media'),
(1022, 0, 1022, 'Auto ticket convert if mentioned'),
(1023, 0, 1023, 'Create an app with access read write and direct message from'),
(1024, 0, 1024, 'https'),
(1025, 0, 1025, 'and genereate required details from "Details >> Create my access token"'),
(1026, 0, 1026, 'Hidden'),
(1027, 0, 1027, 'API ID'),
(1028, 0, 1028, 'SMS alert'),
(1029, 0, 1029, 'Generate'),
(1030, 0, 1030, 'Custom'),
(1031, 0, 1031, 'Portal color'),
(1032, 0, 1032, 'Secret key for API'),
(1033, 0, 1033, 'Approved'),
(1034, 0, 1034, 'Unapproved'),
(1035, 0, 1035, 'Can not delete department. Domain atleast need one department'),
(1036, 0, 1036, 'Cc'),
(1037, 0, 1037, 'Display after login'),
(1038, 0, 1038, 'Type here and enter'),
(1039, 0, 1039, 'Requires at least one recipient'),
(1040, 0, 1040, 'Client portal logo'),
(1041, 0, 1041, 'Save reply'),
(1042, 0, 1042, 'Can not delete system default settings'),
(1043, 0, 1043, 'All reports'),
(1044, 0, 1044, 'Graphical'),
(1045, 0, 1045, 'RDN'),
(1046, 0, 1046, 'Base DN'),
(1047, 0, 1047, 'Move tickets to any department'),
(1048, 0, 1048, 'Date format'),
(1049, 0, 1049, 'Date time format'),
(1050, 0, 1050, 'Product'),
(1051, 0, 1051, 'Products'),
(1052, 0, 1052, 'Delete product'),
(1053, 0, 1053, 'Add product'),
(1054, 0, 1054, 'Amount credit'),
(1055, 0, 1055, 'Ticket credit'),
(1056, 0, 1056, 'Price'),
(1057, 0, 1057, 'Credit type'),
(1058, 0, 1058, 'Order now'),
(1059, 0, 1059, 'Orders'),
(1060, 0, 1060, 'Order'),
(1061, 0, 1061, 'Validity'),
(1062, 0, 1062, 'One time'),
(1063, 0, 1063, 'Monthly'),
(1064, 0, 1064, 'Quarterly'),
(1065, 0, 1065, 'Semi annually'),
(1066, 0, 1066, 'Annually'),
(1067, 0, 1067, 'Empty trash'),
(1068, 0, 1068, 'As client'),
(1069, 0, 1069, 'Income'),
(1070, 0, 1070, 'Edit product'),
(1071, 0, 1071, 'Delete facebook integration'),
(1072, 0, 1072, 'Unlimited'),
(1073, 0, 1073, 'Invalid information or format'),
(1074, 0, 1074, 'Avg. SLA'),
(1075, 0, 1075, 'Label already exist'),
(1076, 0, 1076, 'Access denied can not add client'),
(1077, 0, 1077, 'Merge client'),
(1078, 0, 1078, 'Merge as contact'),
(1079, 0, 1079, 'Custom SLA plan'),
(1080, 0, 1080, 'Delete label'),
(1081, 0, 1081, 'On unresolved'),
(1082, 0, 1082, 'Client approval pending'),
(1083, 0, 1083, 'API login id'),
(1084, 0, 1084, 'Transaction key'),
(1085, 0, 1085, 'Gateway mode'),
(1086, 0, 1086, 'In process'),
(1087, 0, 1087, 'Gateway transactions'),
(1088, 0, 1088, 'Gateway transaction response details'),
(1089, 0, 1089, 'Delete gateway transaction log'),
(1090, 0, 1090, 'Empty gateway transaction log'),
(1091, 0, 1091, 'Recurring'),
(1092, 0, 1092, 'Ticket hash generation'),
(1093, 0, 1093, 'Random'),
(1094, 0, 1094, 'Sequential'),
(1095, 0, 1095, 'Ticket hash prefix'),
(1096, 0, 1096, 'Numbering starts from'),
(1097, 0, 1097, 'Alphanumeric prefix data required'),
(1098, 0, 1098, 'Numeric data required for numbering starts from field'),
(1099, 0, 1099, 'Authentication error'),
(1100, 0, 1100, 'Connection error'),
(1101, 0, 1101, 'Authentication or connection error'),
(1102, 0, 1102, 'Client search'),
(1103, 0, 1103, 'Is approved'),
(1104, 0, 1104, 'Search self help articles'),
(1105, 0, 1105, 'Export all'),
(1106, 0, 1106, 'Notifications'),
(1107, 0, 1107, 'Notification icon'),
(1108, 0, 1108, 'Forward failed email'),
(1109, 0, 1109, 'Forward failed email to'),
(1110, 0, 1110, 'Verify email queue'),
(1111, 0, 1111, 'Start timer'),
(1112, 0, 1112, 'Stop timer'),
(1113, 0, 1113, 'Time tracked'),
(1114, 0, 1114, 'Add time tracked'),
(1115, 0, 1115, '#Timetrack'),
(1116, 0, 1116, 'Bill time'),
(1117, 0, 1117, 'Work time'),
(1118, 0, 1118, 'Timetrack ID missing'),
(1119, 0, 1119, 'Delete time tracked'),
(1121, 0, 1121, 'Load more posts'),
(1122, 0, 1122, 'Display inline images'),
(1123, 0, 1123, 'Hide inline images'),
(1124, 0, 1124, 'SLA plan change'),
(1125, 0, 1125, 'Select tickets to export'),
(1126, 0, 1126, 'Search result'),
(1127, 0, 1127, 'Enter minimum 3 characters'),
(1128, 0, 1128, 'Recent messages'),
(1129, 0, 1129, 'Load more...'),
(1130, 0, 1130, 'Export csv'),
(1131, 0, 1131, 'Filter list'),
(1132, 0, 1132, 'List column'),
(1133, 0, 1133, 'Update view'),
(1134, 0, 1134, 'Attachment'),
(1135, 0, 1135, 'Favourite'),
(1136, 0, 1136, 'Latest post'),
(1137, 0, 1137, 'Manage portal'),
(1138, 0, 1138, 'Manage portal logo'),
(1139, 0, 1139, 'Manage portal color'),
(1140, 0, 1140, 'New ticket'),
(1141, 0, 1141, 'Use assigned departments to staffgroup?'),
(1142, 0, 1142, 'Update staff'),
(1143, 0, 1143, 'Permissions'),
(1144, 0, 1144, 'Update staff group'),
(1145, 0, 1145, 'Update admin access'),
(1146, 0, 1146, 'Change owner'),
(1147, 0, 1147, 'Change type'),
(1148, 0, 1148, 'Split ticket'),
(1149, 0, 1149, 'Link unlink tickets'),
(1150, 0, 1150, 'Update status'),
(1151, 0, 1151, 'Update workflow'),
(1152, 0, 1152, 'Holidays'),
(1153, 0, 1153, 'Add holiday'),
(1154, 0, 1154, 'Delete holiday'),
(1155, 0, 1155, 'Update holiday'),
(1156, 0, 1156, 'Update ticket type'),
(1157, 0, 1157, 'Language translation for holiday description'),
(1158, 0, 1158, 'Update schedule'),
(1159, 0, 1159, 'Update flag'),
(1160, 0, 1160, 'Update SLA'),
(1161, 0, 1161, 'Required field description'),
(1162, 0, 1162, 'WHMCS'),
(1163, 0, 1163, 'Add WHMCS'),
(1164, 0, 1164, 'Update WHMCS'),
(1165, 0, 1165, 'Delete WHMCS'),
(1166, 0, 1166, 'Twitter'),
(1167, 0, 1167, 'Add twitter'),
(1168, 0, 1168, 'Update twitter'),
(1169, 0, 1169, 'Delete twitter'),
(1170, 0, 1170, 'Facebook'),
(1171, 0, 1171, 'Add facebook'),
(1172, 0, 1172, 'Update facebook'),
(1173, 0, 1173, 'Delete facebook'),
(1174, 0, 1174, 'SMS'),
(1175, 0, 1175, 'Add SMS'),
(1176, 0, 1176, 'Update SMS'),
(1177, 0, 1177, 'Delete SMS'),
(1178, 0, 1178, 'Clickatell'),
(1179, 0, 1179, 'Two SMS'),
(1180, 0, 1180, 'Select API'),
(1181, 0, 1181, 'Transaction log'),
(1182, 0, 1182, 'Override details'),
(1183, 0, 1183, 'Update email queue'),
(1184, 0, 1184, 'Update SMTP'),
(1185, 0, 1185, 'Add SMTP'),
(1186, 0, 1186, 'Delete SMTP'),
(1187, 0, 1187, 'Organizations'),
(1188, 0, 1188, 'Apply filter'),
(1189, 0, 1189, 'Update custom field'),
(1190, 0, 1190, 'Update custom field group'),
(1191, 0, 1191, 'Phone'),
(1192, 0, 1192, 'Address'),
(1193, 0, 1193, 'Twitter ID'),
(1194, 0, 1194, 'Facebook ID'),
(1195, 0, 1195, 'Organization details'),
(1196, 0, 1196, 'Company'),
(1197, 0, 1197, 'Update email template'),
(1198, 0, 1198, 'Update alert'),
(1199, 0, 1199, 'Label name'),
(1200, 0, 1200, 'Add label'),
(1201, 0, 1201, 'Label color'),
(1202, 0, 1202, 'Update contact'),
(1203, 0, 1203, 'Pages'),
(1204, 0, 1204, 'Fetch pages'),
(1205, 0, 1205, 'Page not found'),
(1206, 0, 1206, 'Update label'),
(1207, 0, 1207, 'Update module'),
(1208, 0, 1208, 'Ticket activity'),
(1209, 0, 1209, 'Edit profile'),
(1210, 0, 1210, 'Preference'),
(1211, 0, 1211, 'Recent blabs'),
(1212, 0, 1212, 'Internal ticket'),
(1213, 0, 1213, 'Add comment'),
(1214, 0, 1214, 'Update invoice'),
(1215, 0, 1215, 'Attach file'),
(1216, 0, 1216, 'Last 7 days ticket activity'),
(1217, 0, 1217, 'Replied'),
(1218, 0, 1218, 'Awaiting'),
(1219, 0, 1219, 'Closed'),
(1220, 0, 1220, 'Staff member'),
(1221, 0, 1221, 'Skills'),
(1223, 0, 1223, 'Phone number'),
(1224, 0, 1224, 'Empty'),
(1225, 0, 1225, 'Sent email log'),
(1226, 0, 1226, 'Gateway transactions log'),
(1227, 0, 1227, 'Core module status can not be changed'),
(1228, 0, 1228, 'Display pages'),
(1229, 0, 1229, 'Product ID'),
(1230, 0, 1230, 'Entry date'),
(1231, 0, 1231, 'Staff comment'),
(1232, 0, 1232, 'Recent activity count'),
(1233, 0, 1233, 'Upload image'),
(1234, 0, 1234, 'Online staff'),
(1235, 0, 1235, 'Post'),
(1236, 0, 1236, 'Insert from URL...'),
(1237, 0, 1237, 'Attached media'),
(1238, 0, 1238, 'Upload from local machine'),
(1239, 0, 1239, 'Attach media'),
(1240, 0, 1240, 'Add organization'),
(1241, 0, 1241, 'Update organization'),
(1242, 0, 1242, 'Billing cycle'),
(4524, 0, 2262, 'Subject missing'),
(1244, 0, 1244, 'Modified date'),
(1245, 0, 1245, 'Department missing'),
(1246, 0, 1246, 'Search tickets and knowledgebase articles'),
(1247, 0, 1247, 'Save filter'),
(1248, 0, 1248, 'Save'),
(1249, 0, 1249, 'Created by'),
(1250, 0, 1250, 'Parent'),
(1251, 0, 1251, 'Filter ID not found'),
(1252, 0, 1252, 'Update filter'),
(1253, 0, 1253, 'Recent articles'),
(1254, 0, 1254, 'Total articles'),
(1255, 0, 1255, 'Total categories'),
(1256, 0, 1256, 'Helpful articles'),
(1257, 0, 1257, 'Most viewed articles'),
(1258, 0, 1258, 'Articles'),
(1260, 0, 1260, 'Category'),
(1261, 0, 1261, 'Comment'),
(1262, 0, 1262, 'Update comment'),
(1263, 0, 1263, 'Update category'),
(1264, 0, 1264, 'Update article'),
(1265, 0, 1265, 'Sorted by'),
(1266, 0, 1266, 'Delete comment'),
(1267, 0, 1267, 'Graphical'),
(1268, 0, 1268, 'Now'),
(1269, 0, 1269, 'Work'),
(1270, 0, 1270, 'Department SLA'),
(1271, 0, 1271, 'Response'),
(1272, 0, 1272, 'Performance'),
(1273, 0, 1273, 'Client SLA'),
(1274, 0, 1274, 'Ticket ratings'),
(1275, 0, 1275, 'Time tracking per staff'),
(1276, 0, 1276, 'Time tracking per department'),
(1277, 0, 1277, 'Staff SLA'),
(1278, 0, 1278, 'Top performer'),
(1279, 0, 1279, 'Department statistics'),
(1280, 0, 1280, 'Duration'),
(1281, 0, 1281, 'Purchase'),
(1282, 0, 1282, 'My products'),
(1283, 0, 1283, 'My invoices'),
(1284, 0, 1284, 'Days'),
(1285, 0, 1285, 'Team'),
(1286, 0, 1286, 'Selected staff'),
(1287, 0, 1287, 'Search blabs'),
(1288, 0, 1288, 'Search staff'),
(1289, 0, 1289, 'Year'),
(1290, 0, 1290, 'Email address'),
(1291, 0, 1291, 'Website url'),
(1292, 0, 1292, 'Logo url'),
(1293, 0, 1293, 'Pay to text'),
(1294, 0, 1294, 'Ship to'),
(1295, 0, 1295, 'Qty'),
(1296, 0, 1296, 'Note color'),
(1297, 0, 1297, 'Update profile'),
(1298, 0, 1298, 'Domain name should be proper and valid'),
(1299, 0, 1299, 'Client portal url should be proper and valid'),
(1300, 0, 1300, 'Required field domain'),
(1301, 0, 1301, 'Required field client portal URL'),
(1302, 0, 1302, 'Required field default email'),
(1303, 0, 1303, 'Required field date format'),
(1304, 0, 1304, 'Required field date time format'),
(1305, 0, 1305, 'Select domain'),
(1306, 0, 1306, 'Mark as super admin'),
(1307, 0, 1307, 'Mark as domain admin'),
(1308, 0, 1308, 'Required field from email'),
(1309, 0, 1309, 'Required field forward failed email to'),
(1310, 0, 1310, 'Invalid email format in forward failed email to field'),
(1311, 0, 1311, 'Invalid email format in from email field'),
(1312, 0, 1312, 'Remove admin access'),
(1313, 0, 1313, 'Admin can not be updated'),
(1314, 0, 1314, 'Labels/tags'),
(1315, 0, 1315, 'Only alphanumeric characters are allowed in title'),
(1317, 0, 1317, 'Select language'),
(1318, 0, 1318, 'Default word/phrases'),
(1319, 0, 1319, 'Dashboard'),
(1320, 0, 1320, 'Channels'),
(1321, 0, 1321, 'Ticket types'),
(1322, 0, 1322, 'Display IP address to staff'),
(1323, 0, 1323, 'Nothing to display here yet...'),
(1324, 0, 1324, 'IP address'),
(1326, 0, 1326, 'Invoice ID'),
(1327, 0, 1327, 'Transaction date'),
(1328, 0, 1328, 'Tax'),
(1329, 0, 1329, 'Note posted by'),
(1330, 0, 1330, 'Comment posted by'),
(1331, 0, 1331, 'Blab count must be numeric'),
(1332, 0, 1332, 'Due time must be in proper format'),
(1333, 0, 1333, 'Recent activity count must be numeric'),
(1334, 0, 1334, 'Number of attachment must be numeric'),
(1335, 0, 1335, 'Maximum size for attachment must be numeric'),
(1336, 0, 1336, 'Ticket hash prefix field is empty'),
(1337, 0, 1337, 'Ticket starts from field is empty'),
(1338, 0, 1338, 'Ticket post count must be numeric'),
(1339, 0, 1339, 'Forward to field is empty'),
(1340, 0, 1340, 'Email address missing or invalid email format in forward to field'),
(1341, 0, 1341, 'Mark as ban'),
(1342, 0, 1342, 'Mark as spam'),
(1343, 0, 1343, 'Required field execution order'),
(1344, 0, 1344, 'Execution order must be numeric'),
(1345, 0, 1345, 'Can not remove default criteria'),
(1346, 0, 1346, 'Autoresponder email'),
(1347, 0, 1347, 'Update product'),
(1348, 0, 1348, 'Update payment gateway'),
(1349, 0, 1349, 'Update tax rule'),
(1350, 0, 1350, 'Paypal'),
(1351, 0, 1351, 'Authorize.net'),
(1352, 0, 1352, 'API login field is empty'),
(1353, 0, 1353, 'Transaction key field is empty'),
(1354, 0, 1354, 'Forwarded to'),
(1355, 0, 1355, 'Replied to'),
(1356, 0, 1356, 'Add localization'),
(1357, 0, 1357, 'Search word/phrases...'),
(1358, 0, 1358, 'Language variable'),
(1359, 0, 1359, 'Language value'),
(1360, 0, 1360, 'Language translation'),
(1361, 0, 1361, 'Language variable should be in capital letters'),
(1362, 0, 1362, 'Required field language value'),
(1363, 0, 1363, 'Language variable is already exist'),
(1364, 0, 1364, 'Enter word/phrases in search box'),
(1365, 0, 1365, 'Delete localization'),
(1366, 0, 1366, 'Per'),
(1367, 0, 1367, 'Week'),
(1368, 0, 1368, 'Tickets by ticket types'),
(1369, 0, 1369, 'Tickets by channels'),
(1370, 0, 1370, 'Tickets by priorities'),
(1371, 0, 1371, 'Created by'),
(1372, 0, 1372, 'via client portal'),
(1373, 0, 1373, 'Points'),
(1374, 0, 1374, 'Ticket replied after overdue time'),
(1375, 0, 1375, 'Ticket replied without SLA'),
(1376, 0, 1376, 'Ticket replied within due time'),
(1377, 0, 1377, 'Select duration'),
(1378, 0, 1378, 'Last 24 hours'),
(1379, 0, 1379, 'Last 7 days'),
(1380, 0, 1380, 'Last 30 days'),
(1381, 0, 1381, 'All domain'),
(1382, 0, 1382, 'Please select duration'),
(1383, 0, 1383, 'Ticket created successfully'),
(1384, 0, 1384, 'Show recipient and people'),
(1385, 0, 1385, 'Hide recipient and people'),
(1386, 0, 1386, 'Update channel'),
(1387, 0, 1387, 'Delete channel'),
(1388, 0, 1388, 'Ticket has assigned with this channel.<br />Can not delete channel which assigned to ticket'),
(1389, 0, 1389, 'Default channel can not be updated'),
(1390, 0, 1390, 'Maximum image upload height/width is 25 px'),
(1391, 0, 1391, 'Image'),
(1392, 0, 1392, 'Core channel status can not be changed'),
(1393, 0, 1393, 'Maintain'),
(1394, 0, 1394, 'Select staff for share'),
(1395, 0, 1395, 'Enable ticket conversion'),
(1396, 0, 1396, 'Record not found'),
(1397, 0, 1397, 'Please enter valid URL'),
(1398, 0, 1398, 'Searching'),
(1399, 0, 1399, 'Required fields are empty'),
(1400, 0, 1400, 'Required field password'),
(1401, 0, 1401, 'Add tag'),
(1402, 0, 1402, 'Delete blab comment'),
(1403, 0, 1403, 'Login time'),
(1404, 0, 1404, 'Online'),
(1405, 0, 1405, 'Offline'),
(1406, 0, 1406, 'Type comment here'),
(1407, 0, 1407, 'Shared with'),
(1408, 0, 1408, 'Reply with quote'),
(1409, 0, 1409, 'Display note(s) on ticket details'),
(1410, 0, 1410, 'Notes'),
(1411, 0, 1411, 'No match found'),
(1412, 0, 1412, 'Enter text'),
(1413, 0, 1413, 'Type to search existing clients email address'),
(1414, 0, 1414, 'Type here and press enter to save'),
(1415, 0, 1415, 'Core organization status can not be changed'),
(1416, 1, 1, 'Login'),
(1417, 1, 2, 'Client approval pending'),
(1418, 1, 3, 'Forgot password'),
(1419, 1, 4, 'Register'),
(1420, 1, 5, 'Solutions'),
(1421, 1, 6, 'Posted by'),
(1422, 1, 7, 'Posted on'),
(1423, 1, 8, 'Tickets'),
(1424, 1, 9, 'Creation date'),
(1425, 1, 10, 'Modified on'),
(1426, 1, 11, 'Data not found'),
(1427, 1, 12, 'Change password'),
(1428, 1, 13, 'Old password'),
(1429, 1, 14, 'New password'),
(1430, 1, 15, 'Confirm password'),
(1431, 1, 16, 'Update'),
(1432, 1, 17, 'Clear'),
(1433, 1, 18, 'Email address already registered'),
(1434, 1, 19, 'Add contact'),
(1435, 1, 20, 'First name'),
(1436, 1, 21, 'Last name'),
(1437, 1, 22, 'Email'),
(1438, 1, 23, 'User name'),
(1439, 1, 24, 'Password'),
(1440, 1, 25, 'Access'),
(1441, 1, 26, 'Open new ticket'),
(1442, 1, 27, 'Email notification for self posted tickets'),
(1443, 1, 28, 'View parent and other sub contact tickets'),
(1444, 1, 29, 'Reply parent and other sub contact tickets'),
(1445, 1, 30, 'Add'),
(1446, 1, 31, 'Reset'),
(1447, 1, 32, 'Custom fields'),
(1448, 1, 33, 'Submit'),
(1449, 1, 34, 'Credit for invoice: '),
(1450, 1, 35, 'Pay now'),
(1451, 1, 36, 'Home'),
(1452, 1, 37, 'Submit ticket'),
(1453, 1, 38, 'View tickets'),
(1454, 1, 39, 'Purchase'),
(1455, 1, 40, 'My packages'),
(1456, 1, 41, 'My invoices'),
(1457, 1, 42, 'Search tickets and knowledgebase articles'),
(1458, 1, 43, 'Search'),
(1459, 1, 44, 'Profile'),
(1460, 1, 45, 'Contacts'),
(1461, 1, 46, 'Logout'),
(1462, 1, 47, 'Unpaid'),
(1463, 1, 48, 'Paid'),
(1464, 1, 49, 'Cancelled'),
(1465, 1, 50, 'In process'),
(1466, 1, 51, 'Invoice'),
(1467, 1, 52, 'Get PDF'),
(1468, 1, 53, 'Phone'),
(1469, 1, 54, 'Invoice ID'),
(1470, 1, 55, 'Due date'),
(1471, 1, 56, 'Status'),
(1472, 1, 57, 'Paid date'),
(1473, 1, 58, 'Description'),
(1474, 1, 59, 'Amount'),
(1475, 1, 60, 'Tax'),
(1476, 1, 61, 'Total due'),
(1477, 1, 62, 'Transaction ID'),
(1478, 1, 63, 'Transaction date'),
(1479, 1, 64, 'Create date'),
(1480, 1, 65, 'Total'),
(1481, 1, 66, 'Title'),
(1482, 1, 67, 'Billing cycle'),
(1483, 1, 68, 'Expiry date'),
(1484, 1, 69, 'Validity'),
(1485, 1, 70, 'Order now'),
(1486, 1, 71, 'Update profile'),
(1487, 1, 72, 'Profile image'),
(1488, 1, 73, 'Upload image'),
(1489, 1, 74, 'Address'),
(1490, 1, 75, 'City'),
(1491, 1, 76, 'State'),
(1492, 1, 77, 'Zip code'),
(1493, 1, 78, 'Country'),
(1494, 1, 79, 'Website'),
(1495, 1, 80, 'Department'),
(1496, 1, 81, 'Job title'),
(1497, 1, 82, 'Company website'),
(1498, 1, 83, 'Language'),
(1499, 1, 84, 'Contact number'),
(1500, 1, 85, 'Image verification'),
(1501, 1, 86, 'Type the two words'),
(1502, 1, 87, 'Refresh'),
(1503, 1, 88, 'Save'),
(1504, 1, 89, 'Attachments'),
(1505, 1, 90, 'Rating'),
(1506, 1, 91, 'Leave a comment'),
(1507, 1, 92, 'Full name'),
(1508, 1, 93, 'Suggestion'),
(1509, 1, 94, 'Answer'),
(1510, 1, 95, 'Comments'),
(1511, 1, 96, 'Recent articles'),
(1512, 1, 97, 'Featured articles'),
(1513, 1, 98, 'Add article'),
(1514, 1, 99, 'Details'),
(1515, 1, 100, 'Welcome to client portal'),
(1516, 1, 101, 'Update contact'),
(1517, 1, 102, 'Deleting client will delete all its ticket and data.'),
(1518, 1, 103, 'Delete'),
(1519, 1, 104, 'Company name'),
(1520, 1, 105, 'Registration required'),
(1521, 1, 106, 'Ticket created successfully'),
(1522, 1, 107, 'Priority'),
(1523, 1, 108, 'Type'),
(1524, 1, 109, 'Subject'),
(1525, 1, 110, 'Message'),
(1526, 1, 111, 'Attach file'),
(1527, 1, 112, 'Edit profile'),
(1528, 1, 113, 'Banned'),
(1529, 1, 114, 'Domain'),
(1530, 1, 115, 'Parent'),
(1531, 1, 116, 'Organization'),
(1532, 1, 117, 'Unsolved'),
(1533, 1, 118, 'Solved'),
(1534, 1, 119, 'Billing'),
(1535, 1, 120, 'Amount credit'),
(1536, 1, 121, 'Unlimited'),
(1537, 1, 122, 'Feedback'),
(1538, 1, 123, 'Reply'),
(1539, 1, 124, 'Created on'),
(1540, 1, 125, 'Ticket type'),
(1541, 1, 126, 'Assigned to'),
(1542, 1, 127, 'SLA'),
(1543, 1, 128, 'Overdue'),
(1544, 1, 129, 'Undue'),
(1545, 1, 130, 'Ticket details'),
(1546, 1, 131, 'Reply ticket'),
(1547, 1, 132, 'Edit ticket'),
(1548, 1, 133, 'Send feedback'),
(1549, 1, 134, 'Ticket hash'),
(1550, 1, 135, 'Staff'),
(1551, 1, 136, 'Client'),
(1552, 1, 137, 'Change priority'),
(1553, 1, 138, 'Cancel'),
(1554, 1, 139, 'Page'),
(1555, 1, 140, 'Packages'),
(1556, 1, 141, 'Title'),
(1557, 1, 142, 'Admin type'),
(1558, 1, 143, 'Access'),
(1559, 1, 144, 'Domain admin'),
(1560, 1, 145, 'Super admin'),
(1561, 1, 146, 'Admin access'),
(1562, 1, 147, 'Full name'),
(1563, 1, 148, 'Username'),
(1564, 1, 149, 'Password'),
(1565, 1, 150, 'Domains access'),
(1566, 1, 151, 'Add staff'),
(1567, 1, 152, 'Delete staff');
INSERT INTO `avis_language_values` (`language_values_id`, `language_id`, `variable_id`, `description`) VALUES
(1568, 1, 153, 'All staff'),
(1569, 1, 154, 'Group name'),
(1570, 1, 155, 'Status'),
(1571, 1, 156, 'Login'),
(1572, 1, 157, 'Logout'),
(1573, 1, 158, 'Toolbar'),
(1574, 1, 159, 'Add team'),
(1575, 1, 160, 'Delete team'),
(1576, 1, 161, 'Localization'),
(1577, 1, 162, 'Domain access'),
(1578, 1, 163, 'All domains'),
(1579, 1, 164, 'Module'),
(1580, 1, 165, 'System'),
(1581, 1, 166, 'Diagnostics'),
(1582, 1, 167, 'Manage'),
(1583, 1, 168, 'View only'),
(1584, 1, 169, 'Delete'),
(1585, 1, 170, 'Delete all'),
(1586, 1, 171, 'Backup'),
(1587, 1, 172, 'License'),
(1588, 1, 173, 'License information'),
(1589, 1, 174, 'View'),
(1590, 1, 175, 'List count'),
(1591, 1, 176, 'Currently active'),
(1592, 1, 177, 'Department'),
(1593, 1, 178, 'Departments'),
(1594, 1, 179, 'Priority'),
(1595, 1, 180, 'Ticket type'),
(1596, 1, 181, 'Channel'),
(1597, 1, 182, 'Flag type'),
(1598, 1, 183, 'Flag'),
(1599, 1, 184, 'Language'),
(1600, 1, 185, 'Manage all staff'),
(1601, 1, 186, 'Manage domain staff'),
(1602, 1, 187, 'Team'),
(1603, 1, 188, 'Workflow'),
(1604, 1, 189, 'SLA'),
(1605, 1, 190, 'Add SLA'),
(1606, 1, 191, 'Delete SLA'),
(1607, 1, 192, 'Schedule'),
(1608, 1, 193, 'Email queue'),
(1609, 1, 194, 'SMTP'),
(1610, 1, 195, 'Email templates'),
(1611, 1, 196, 'Custom field'),
(1612, 1, 197, 'Custom fields'),
(1613, 1, 198, 'Custom field group'),
(1614, 1, 199, 'Add custom field group'),
(1615, 1, 200, 'Delete custom group'),
(1616, 1, 201, 'Single login'),
(1617, 1, 202, 'Integrations'),
(1618, 1, 203, 'APP ID'),
(1619, 1, 204, 'APP secret key'),
(1620, 1, 205, 'Canvas URL'),
(1621, 1, 206, 'Error log'),
(1622, 1, 207, 'Delete error log'),
(1623, 1, 208, 'Exception log'),
(1624, 1, 209, 'Parser log'),
(1625, 1, 210, 'Empty parser log'),
(1626, 1, 211, 'Delete parser log'),
(1627, 1, 212, 'Sendmail log'),
(1628, 1, 213, 'API'),
(1629, 1, 214, 'API access'),
(1630, 1, 215, 'Logs'),
(1631, 1, 216, 'Error'),
(1632, 1, 217, 'Parser'),
(1633, 1, 218, 'Automation'),
(1634, 1, 219, 'Send email'),
(1635, 1, 220, 'Ticket details'),
(1636, 1, 221, 'Audit log'),
(1637, 1, 222, 'History'),
(1638, 1, 223, 'Invoices'),
(1639, 1, 224, 'Export to PDF'),
(1640, 1, 225, 'Export'),
(1641, 1, 226, 'Add alert'),
(1642, 1, 227, 'Delete alert'),
(1643, 1, 228, 'Email template'),
(1644, 1, 229, 'All tickets'),
(1645, 1, 230, 'New tickets'),
(1646, 1, 231, 'Overdue tickets'),
(1647, 1, 232, 'Assigned tickets'),
(1648, 1, 233, 'Unsolved'),
(1649, 1, 234, 'Solved'),
(1650, 1, 235, 'Read'),
(1651, 1, 236, 'Unread'),
(1652, 1, 237, 'Labels'),
(1653, 1, 238, 'Event'),
(1654, 1, 239, 'Client reply'),
(1655, 1, 240, 'Staff reply'),
(1656, 1, 241, 'Flag change'),
(1657, 1, 242, 'Ticket type change'),
(1658, 1, 243, 'Department change'),
(1659, 1, 244, 'Status change'),
(1660, 1, 245, 'Priority change'),
(1661, 1, 246, 'Ticket assign'),
(1662, 1, 247, 'Client add'),
(1663, 1, 248, 'Client edit'),
(1664, 1, 249, 'Client delete'),
(1665, 1, 250, 'Ticket department change'),
(1666, 1, 251, 'Ticket status change'),
(1667, 1, 252, 'Ticket priority change'),
(1668, 1, 253, 'Ticket merge'),
(1669, 1, 254, 'Add note'),
(1670, 1, 255, 'Delete note'),
(1671, 1, 256, 'Note add'),
(1672, 1, 257, 'Note type'),
(1673, 1, 258, 'Billing invoice add'),
(1674, 1, 259, 'Ticket post delete'),
(1675, 1, 260, 'Ticket delete'),
(1676, 1, 261, 'Move to trash'),
(1677, 1, 262, 'Reset'),
(1678, 1, 263, 'Criteria'),
(1679, 1, 264, 'Match any criteria'),
(1680, 1, 265, 'Match all criteria'),
(1681, 1, 266, 'Add criteria'),
(1682, 1, 267, 'Filters'),
(1683, 1, 268, 'Search'),
(1684, 1, 269, 'Search result'),
(1685, 1, 270, 'Match criteria'),
(1686, 1, 271, 'Save as filter'),
(1687, 1, 272, 'Save as draft'),
(1688, 1, 273, 'Subject'),
(1689, 1, 274, 'Message'),
(1690, 1, 275, 'Ticket note'),
(1691, 1, 276, 'Client note'),
(1692, 1, 277, 'Ticket comment'),
(1693, 1, 278, 'Client name'),
(1694, 1, 279, 'Client email'),
(1695, 1, 280, 'Owner'),
(1696, 1, 281, 'Last activity'),
(1697, 1, 282, 'Creation date'),
(1698, 1, 283, 'SLA plan'),
(1699, 1, 284, 'Response time'),
(1700, 1, 285, 'Has attachment'),
(1701, 1, 286, 'Billing note'),
(1702, 1, 287, 'Add billing note'),
(1703, 1, 288, 'Contain'),
(1704, 1, 289, 'Does not contain'),
(1705, 1, 290, 'Equal'),
(1706, 1, 291, 'Not equal'),
(1707, 1, 292, 'Less than '),
(1708, 1, 293, 'Greater than'),
(1709, 1, 294, 'TRUE'),
(1710, 1, 295, 'Alerts'),
(1711, 1, 296, 'Views'),
(1712, 1, 297, 'Submit ticket'),
(1713, 1, 298, 'Edit ticket'),
(1714, 1, 299, 'Staff'),
(1715, 1, 300, 'Client'),
(1716, 1, 301, 'Operation'),
(1717, 1, 302, 'Date time'),
(1718, 1, 303, 'Date'),
(1719, 1, 304, 'Operator'),
(1720, 1, 305, 'Add credit'),
(1721, 1, 306, 'Amount'),
(1722, 1, 307, 'Details'),
(1723, 1, 308, 'Preferences '),
(1724, 1, 309, 'Expiry date'),
(1725, 1, 310, 'Billing'),
(1726, 1, 311, 'Billing method'),
(1727, 1, 312, 'Ticket base'),
(1728, 1, 313, 'Time base'),
(1729, 1, 314, 'Bill rate'),
(1730, 1, 315, 'Currency'),
(1731, 1, 316, 'On ticket create'),
(1732, 1, 317, 'Do not generate invoice'),
(1733, 1, 318, 'Generate invoice'),
(1734, 1, 319, 'Generate and send invoice'),
(1735, 1, 320, 'Credit required'),
(1736, 1, 321, 'Minutes'),
(1737, 1, 322, 'Taxable'),
(1738, 1, 323, 'Total due'),
(1739, 1, 324, 'Tax rule'),
(1740, 1, 325, 'Invoice'),
(1741, 1, 326, 'View invoice'),
(1742, 1, 327, 'Create date'),
(1743, 1, 328, 'Paid date'),
(1744, 1, 329, 'Due date'),
(1745, 1, 330, 'Total'),
(1746, 1, 331, 'Unpaid'),
(1747, 1, 332, 'Paid'),
(1748, 1, 333, 'Cancelled'),
(1749, 1, 334, 'Today''s due'),
(1750, 1, 335, 'Today''s paid'),
(1751, 1, 336, 'Today'),
(1752, 1, 337, 'Month'),
(1753, 1, 338, 'Group balance'),
(1754, 1, 339, 'Billing url'),
(1755, 1, 340, 'Admin username'),
(1756, 1, 341, 'Admin password'),
(1757, 1, 342, 'API key'),
(1758, 1, 343, 'Blabs'),
(1759, 1, 344, 'Add blab'),
(1760, 1, 345, 'Trends'),
(1761, 1, 346, 'Add image'),
(1762, 1, 347, 'Add video'),
(1764, 1, 349, 'Share with'),
(1765, 1, 350, 'All'),
(1766, 1, 351, 'URL'),
(1767, 1, 352, 'View blabs'),
(1768, 1, 353, 'Add to blab'),
(1769, 1, 354, 'Blab count'),
(1770, 1, 355, 'Remove from list'),
(1771, 1, 356, 'Delete blab'),
(1772, 1, 357, 'Break line'),
(1773, 1, 358, 'Add breakline'),
(1774, 1, 359, 'Delete breakline'),
(1775, 1, 360, 'Execution order'),
(1776, 1, 361, 'Regular expression'),
(1777, 1, 362, 'Add task'),
(1778, 1, 363, 'Delete task'),
(1779, 1, 364, 'Calendar'),
(1780, 1, 365, 'Description'),
(1781, 1, 366, 'End date'),
(1782, 1, 367, 'Start date'),
(1783, 1, 368, 'Planned'),
(1784, 1, 369, 'Completed'),
(1785, 1, 370, 'In progress'),
(1786, 1, 371, 'Not started'),
(1787, 1, 372, 'Task type'),
(1788, 1, 373, 'Location'),
(1789, 1, 374, 'Personal'),
(1790, 1, 375, 'Business'),
(1791, 1, 376, 'Important'),
(1792, 1, 377, 'Label'),
(1793, 1, 378, 'Medium'),
(1794, 1, 379, 'High'),
(1795, 1, 380, 'Low'),
(1796, 1, 381, 'Tasks'),
(1797, 1, 382, 'Ticket queues'),
(1798, 1, 383, 'Filter queues'),
(1799, 1, 384, 'Folders'),
(1800, 1, 385, 'Select department'),
(1801, 1, 386, 'Select domain'),
(1802, 1, 387, 'Old password'),
(1803, 1, 388, 'New password'),
(1804, 1, 389, 'Change password'),
(1805, 1, 390, 'Confirm password'),
(1806, 1, 391, 'Add channel'),
(1807, 1, 392, 'Channel image'),
(1808, 1, 393, 'Add language'),
(1809, 1, 394, 'Update language'),
(1810, 1, 395, 'Delete language'),
(1812, 1, 397, 'PHP information'),
(1813, 1, 398, 'Add client'),
(1814, 1, 399, 'Add contact'),
(1815, 1, 400, 'Manage contact'),
(1816, 1, 401, 'Feedback'),
(1817, 1, 402, 'Send feedback'),
(1818, 1, 403, 'Clients'),
(1819, 1, 404, 'Contacts'),
(1820, 1, 405, 'Action'),
(1824, 1, 409, 'First name'),
(1825, 1, 410, 'Last name'),
(1826, 1, 411, 'Initials'),
(1827, 1, 412, 'Gender'),
(1828, 1, 413, 'Male'),
(1829, 1, 414, 'Female'),
(1830, 1, 415, 'Email'),
(1831, 1, 416, 'Contact number'),
(1832, 1, 417, 'Mobile number'),
(1833, 1, 418, 'Permanent address'),
(1834, 1, 419, 'Current address'),
(1835, 1, 420, 'City'),
(1836, 1, 421, 'State'),
(1837, 1, 422, 'Country'),
(1838, 1, 423, 'Zip code'),
(1839, 1, 424, 'Fax'),
(1840, 1, 425, 'Website'),
(1841, 1, 426, 'Company name'),
(1842, 1, 427, 'Company email'),
(1843, 1, 428, 'Company phone 1'),
(1844, 1, 429, 'Company phone 2'),
(1845, 1, 430, 'Company fax'),
(1846, 1, 431, 'Company address'),
(1847, 1, 432, 'Company website'),
(1848, 1, 433, 'Netmeeting ID'),
(1849, 1, 434, 'Other IM'),
(1850, 1, 435, 'Other contact'),
(1851, 1, 436, 'Other fax'),
(1852, 1, 437, 'Job title'),
(1853, 1, 438, 'Credit'),
(1854, 1, 439, 'Create invoice'),
(1855, 1, 440, 'Delete invoice'),
(1856, 1, 441, 'Paid department'),
(1857, 1, 442, 'Register'),
(1858, 1, 443, 'Registered'),
(1859, 1, 444, 'Unregistered'),
(1860, 1, 445, 'Ban'),
(1861, 1, 446, 'Ban client'),
(1862, 1, 447, 'Banned'),
(1863, 1, 448, 'Remove ban'),
(1864, 1, 449, 'Spammer'),
(1865, 1, 450, 'Not spam'),
(1866, 1, 451, 'Mark spam'),
(1867, 1, 452, 'Edit'),
(1868, 1, 453, 'Ban and delete'),
(1869, 1, 454, 'Email notifications'),
(1870, 1, 455, 'Ticket'),
(1871, 1, 456, 'Tickets'),
(1872, 1, 457, 'View tickets'),
(1873, 1, 458, 'Reply ticket'),
(1874, 1, 459, 'Reply'),
(1875, 1, 460, 'Reply all'),
(1876, 1, 461, 'Forward'),
(1877, 1, 462, 'Send reply'),
(1878, 1, 463, 'Send'),
(1879, 1, 464, 'Delete ticket'),
(1880, 1, 465, 'Merge ticket'),
(1881, 1, 466, 'Delete ticket properties'),
(1882, 1, 467, 'Change properties'),
(1883, 1, 468, 'Delete ticket post'),
(1884, 1, 469, 'Edit ticket post'),
(1885, 1, 470, 'Set due time'),
(1886, 1, 471, 'Recipients'),
(1887, 1, 472, 'Discard'),
(1888, 1, 473, 'Ascending'),
(1889, 1, 474, 'Descending'),
(1890, 1, 475, 'View note'),
(1891, 1, 476, 'Manage note'),
(1892, 1, 477, 'Open new ticket'),
(1893, 1, 478, 'Forward ticket'),
(1894, 1, 479, 'Self assigned'),
(1895, 1, 480, 'Nobody'),
(1896, 1, 481, 'Assigned'),
(1897, 1, 482, 'Assigned to'),
(1898, 1, 483, 'Move to'),
(1899, 1, 484, 'Nobody and self assigned'),
(1900, 1, 485, 'Overdue'),
(1901, 1, 486, 'Undue'),
(1902, 1, 487, 'Overdue time'),
(1903, 1, 488, 'New'),
(1904, 1, 489, 'Note'),
(1905, 1, 490, 'From'),
(1906, 1, 491, 'To'),
(1907, 1, 492, 'Ticket hash'),
(1908, 1, 493, 'Ticket ID'),
(1909, 1, 494, 'Ticket priority'),
(1910, 1, 495, 'Ticket status'),
(1911, 1, 496, 'Add status'),
(1912, 1, 497, 'Delete ticket status'),
(1913, 1, 498, 'Ticket created on'),
(1914, 1, 499, 'Ticket modified on'),
(1915, 1, 500, 'Resolve time'),
(1916, 1, 501, 'SLA ID'),
(1917, 1, 502, 'Ticket post count'),
(1918, 1, 503, 'Ticket count'),
(1919, 1, 504, 'Client first name'),
(1920, 1, 505, 'Client last name'),
(1921, 1, 506, 'Client contact'),
(1922, 1, 507, 'Client company'),
(1923, 1, 508, 'Client job title'),
(1924, 1, 509, 'Client state'),
(1925, 1, 510, 'Client city'),
(1926, 1, 511, 'Client zip code'),
(1927, 1, 512, 'Client country'),
(1928, 1, 513, 'Is spam client'),
(1929, 1, 514, 'Is banned client'),
(1930, 1, 515, 'Client paid invoice count'),
(1931, 1, 516, 'Client unpaid invoice count'),
(1932, 1, 517, 'Staff first name'),
(1933, 1, 518, 'Staff last name'),
(1934, 1, 519, 'Staff email'),
(1935, 1, 520, 'Staff job title'),
(1936, 1, 521, 'Avg. response time'),
(1937, 1, 522, 'Total responses'),
(1938, 1, 523, 'Team access'),
(1939, 1, 524, 'Staff list'),
(1940, 1, 525, 'Back'),
(1941, 1, 526, 'Sort by'),
(1942, 1, 527, 'Select'),
(1943, 1, 528, 'Ticket autoclose time'),
(1944, 1, 529, 'Ticket average response time'),
(1945, 1, 530, 'Ticket follow up count'),
(1946, 1, 531, 'Ticket IP address'),
(1947, 1, 532, 'Ticket is resolved'),
(1948, 1, 533, 'Ticket reply to'),
(1949, 1, 534, 'Ticket time worked'),
(1950, 1, 535, 'Ticket total replies'),
(1951, 1, 536, 'SLA overdue hours'),
(1952, 1, 537, 'SLA plan resolution due hours'),
(1953, 1, 538, 'Rating'),
(1954, 1, 539, 'Attachments'),
(1955, 1, 540, 'Resolution time'),
(1956, 1, 541, 'Number of attachments'),
(1957, 1, 542, 'Allowed attachment extensions'),
(1958, 1, 543, 'Max allowed size for attachment (in KB)'),
(1959, 1, 544, 'Add merged ticket''s email as recipients'),
(1960, 1, 545, 'Visible to client'),
(1961, 1, 546, 'Fields available'),
(1962, 1, 547, 'Fields selected'),
(1963, 1, 548, 'Last replier'),
(1964, 1, 549, 'Add view'),
(1965, 1, 550, 'Delete view'),
(1966, 1, 551, 'Summary'),
(1967, 1, 552, 'Profile'),
(1968, 1, 553, 'Profile image'),
(1969, 1, 554, 'Personal details'),
(1970, 1, 555, 'Home details'),
(1971, 1, 556, 'Company details'),
(1972, 1, 557, 'Reset password'),
(1973, 1, 558, 'Add domain'),
(1974, 1, 559, 'Update domain'),
(1975, 1, 560, 'Domain name'),
(1976, 1, 561, 'Domain'),
(1977, 1, 562, 'Delete domain'),
(1978, 1, 563, 'Add department'),
(1979, 1, 564, 'Update department'),
(1980, 1, 565, 'Delete department'),
(1981, 1, 566, 'Access'),
(1982, 1, 567, 'Is paid'),
(1983, 1, 568, 'Registration required'),
(1984, 1, 569, 'Autoresponder'),
(1985, 1, 570, 'Auto responder signature'),
(1986, 1, 571, 'Domain URL'),
(1987, 1, 572, 'Set'),
(1988, 1, 573, 'Client portal URL'),
(1989, 1, 574, 'Default email'),
(1990, 1, 575, 'Default client portal language'),
(1991, 1, 576, 'Client portal theme'),
(1992, 1, 577, 'Client portal'),
(1993, 1, 578, 'Update client portal'),
(1994, 1, 579, 'Outgoing email'),
(1995, 1, 580, 'Timezone'),
(1996, 1, 581, 'DST setting'),
(1997, 1, 582, 'Auto approve registration'),
(1998, 1, 583, 'Enable captcha on register'),
(1999, 1, 584, 'Approve'),
(2000, 1, 585, 'Disapproved'),
(2001, 1, 586, 'Pin'),
(2002, 1, 587, 'Login as client'),
(2003, 1, 588, 'Create ticket'),
(2005, 1, 590, 'Group type'),
(2006, 1, 591, 'User registration'),
(2007, 1, 592, 'User ticket creation'),
(2008, 1, 593, 'Staff ticket creation'),
(2009, 1, 594, 'Department access'),
(2010, 1, 595, 'All departments'),
(2011, 1, 596, 'Type'),
(2012, 1, 597, 'Add ticket type'),
(2013, 1, 598, 'Delete ticket type'),
(2014, 1, 599, 'Fields'),
(2015, 1, 600, 'Field details'),
(2016, 1, 601, 'Field title'),
(2017, 1, 602, 'Default value'),
(2018, 1, 603, 'Field description'),
(2019, 1, 604, 'Is required'),
(2020, 1, 605, 'User editable'),
(2021, 1, 606, 'Staff editable'),
(2023, 1, 608, 'Numeric'),
(2024, 1, 609, 'Alphabetic'),
(2025, 1, 610, 'Alphanumeric'),
(2026, 1, 611, 'Option fields'),
(2027, 1, 612, 'Add custom field'),
(2028, 1, 613, 'Delete custom field'),
(2029, 1, 614, 'Customizations'),
(2030, 1, 615, 'HTML tags'),
(2031, 1, 616, 'Text box'),
(2032, 1, 617, 'Text area'),
(2033, 1, 618, 'Checkbox'),
(2034, 1, 619, 'Radio'),
(2035, 1, 620, 'Select multiple'),
(2036, 1, 621, 'File'),
(2037, 1, 622, 'Regular expression validation'),
(2038, 1, 623, 'Add email template'),
(2039, 1, 624, 'Delete email template'),
(2040, 1, 625, 'Content'),
(2041, 1, 626, 'Add flag'),
(2042, 1, 627, 'Delete flag'),
(2043, 1, 628, 'Flag name'),
(2044, 1, 629, 'Flag color'),
(2045, 1, 630, 'Language translation for flag title'),
(2046, 1, 631, 'File name'),
(2047, 1, 632, 'Language code'),
(2048, 1, 633, 'Character set'),
(2049, 1, 634, 'Code'),
(2050, 1, 635, 'Direction'),
(2051, 1, 636, 'Right to left'),
(2052, 1, 637, 'Left to right'),
(2053, 1, 638, 'Left panel view'),
(2054, 1, 639, 'Sent email'),
(2055, 1, 640, 'Toggle left panel'),
(2056, 1, 641, 'Settings'),
(2057, 1, 642, 'Pinned items'),
(2058, 1, 643, 'Quick view'),
(2059, 1, 644, 'Back to login'),
(2060, 1, 645, 'Forgot password'),
(2061, 1, 646, 'Mail queues'),
(2062, 1, 647, 'Add email queue'),
(2063, 1, 648, 'Delete mailqueue'),
(2064, 1, 649, 'Fetch type'),
(2065, 1, 650, 'Login information'),
(2066, 1, 651, 'Host name'),
(2067, 1, 652, 'Database name'),
(2068, 1, 653, 'Table prefix'),
(2069, 1, 654, 'Port'),
(2070, 1, 655, 'SSL type'),
(2071, 1, 656, 'SMTP authentication'),
(2072, 1, 657, 'Leave a copy on server'),
(2073, 1, 658, 'Queue title'),
(2074, 1, 659, 'From name'),
(2075, 1, 660, 'From email'),
(2076, 1, 661, 'Queue setting'),
(2077, 1, 662, 'Signature'),
(2078, 1, 663, 'Leave a comment'),
(2079, 1, 664, 'Comment submitted'),
(2080, 1, 665, 'Mail details'),
(2081, 1, 666, 'Solutions'),
(2082, 1, 667, 'Categories'),
(2083, 1, 668, 'Comments'),
(2084, 1, 669, 'Article'),
(2085, 1, 670, 'Posted by'),
(2086, 1, 671, 'Allow comments'),
(2087, 1, 672, 'Allow ratings'),
(2088, 1, 673, 'Default home page'),
(2089, 1, 674, 'Allow attachment to clients'),
(2090, 1, 675, 'Login compulsory to client'),
(2091, 1, 676, 'Autosubscribe after comment'),
(2092, 1, 677, 'Root'),
(2093, 1, 678, 'Parent category'),
(2094, 1, 679, 'Knowledgebase'),
(2095, 1, 680, 'Suggestion'),
(2096, 1, 681, 'Question and answer'),
(2097, 1, 682, 'Answer'),
(2098, 1, 683, 'Order by'),
(2099, 1, 684, 'New first'),
(2100, 1, 685, 'Old first'),
(2101, 1, 686, 'Modified first'),
(2102, 1, 687, 'Visible to'),
(2103, 1, 688, 'Everybody'),
(2104, 1, 689, 'Staff only'),
(2105, 1, 690, 'Logged in client'),
(2106, 1, 691, 'Is enabled'),
(2107, 1, 692, 'Post article'),
(2108, 1, 693, 'Author'),
(2109, 1, 694, 'Add category'),
(2110, 1, 695, 'Add article'),
(2111, 1, 696, 'Article added'),
(2112, 1, 697, 'Delete category'),
(2113, 1, 698, 'Delete article'),
(2114, 1, 699, 'Solutions suggestion'),
(2115, 1, 700, 'Enable captcha on solutions'),
(2116, 1, 701, 'Quick insert'),
(2117, 1, 702, 'More'),
(2118, 1, 703, 'Featured articles'),
(2119, 1, 704, 'Welcome'),
(2120, 1, 705, 'Welcome to client support portal'),
(2121, 1, 706, 'Open and track support ticket'),
(2122, 1, 707, 'Check our solutions section for helpful articles and latest announcements'),
(2123, 1, 708, 'Reports'),
(2124, 1, 709, 'Add report'),
(2125, 1, 710, 'View result'),
(2126, 1, 711, 'Migration'),
(2127, 1, 712, 'Advanced search'),
(2128, 1, 713, 'Home'),
(2129, 1, 714, 'Inbox'),
(2130, 1, 715, 'Tags'),
(2131, 1, 716, 'Delete tag'),
(2132, 1, 717, 'Tag search'),
(2133, 1, 718, 'Recent activities'),
(2134, 1, 719, 'Add module'),
(2135, 1, 720, 'Delete module'),
(2136, 1, 721, 'Header title'),
(2137, 1, 722, 'Display on quick view'),
(2140, 1, 725, 'Failed'),
(2141, 1, 726, 'Success'),
(2142, 1, 727, 'Theme'),
(2143, 1, 728, 'Session timeout'),
(2144, 1, 729, 'In minutes'),
(2145, 1, 730, 'Sound alert'),
(2146, 1, 731, 'Html editor'),
(2147, 1, 732, 'Color'),
(2148, 1, 733, 'Language translation for priority title'),
(2149, 1, 734, 'Add priority'),
(2150, 1, 735, 'Update priority'),
(2151, 1, 736, 'Delete priority'),
(2152, 1, 737, 'Purchase or upgrade'),
(2153, 1, 738, 'Language translation for status title'),
(2154, 1, 739, 'Language translation for type title'),
(2155, 1, 740, 'Email notification for self posted tickets'),
(2156, 1, 741, 'Email notification for self posted tickets'),
(2157, 1, 742, 'View parent and other sub contact tickets'),
(2158, 1, 743, 'Reply parent and other sub contact tickets'),
(2159, 1, 744, 'Add schedule'),
(2160, 1, 745, 'Delete schedule'),
(2161, 1, 746, 'Sunday'),
(2162, 1, 747, 'Monday'),
(2163, 1, 748, 'Tuesday'),
(2164, 1, 749, 'Wednesday'),
(2165, 1, 750, 'Thursday'),
(2166, 1, 751, 'Friday'),
(2167, 1, 752, 'Saturday'),
(2168, 1, 753, 'Open 24 hours'),
(2169, 1, 754, 'Close'),
(2170, 1, 755, 'Open'),
(2171, 1, 756, 'Custom time'),
(2172, 1, 757, 'Hours'),
(2173, 1, 758, 'Minutes'),
(2174, 1, 759, 'Add workflow'),
(2175, 1, 760, 'Delete workflow'),
(2176, 1, 761, 'Change department'),
(2177, 1, 762, 'No change'),
(2178, 1, 763, 'Assign staff'),
(2179, 1, 764, 'Change status'),
(2180, 1, 765, 'Change priority'),
(2181, 1, 766, 'Change flag'),
(2182, 1, 767, 'Change ticket type'),
(2183, 1, 768, 'Apply SLA'),
(2184, 1, 769, 'Ignore email'),
(2185, 1, 770, 'Send autoresponder message'),
(2186, 1, 771, 'Process ticket alert rules'),
(2187, 1, 772, 'Do not parse as ticket reply'),
(2188, 1, 773, 'Forward to'),
(2189, 1, 774, 'Marked as banned'),
(2190, 1, 775, 'Marked as spam'),
(2191, 1, 776, 'Image verification'),
(2192, 1, 777, 'Type the two words'),
(2193, 1, 778, 'Refresh'),
(2194, 1, 779, 'Submit'),
(2195, 1, 780, 'Change'),
(2196, 1, 781, 'Ok'),
(2197, 1, 782, 'On'),
(2198, 1, 783, 'Cancel'),
(2199, 1, 784, 'Options'),
(2200, 1, 785, 'None'),
(2201, 1, 786, 'Public'),
(2202, 1, 787, 'Private'),
(2203, 1, 788, 'Posted on'),
(2204, 1, 789, 'Created on'),
(2205, 1, 790, 'Modified on'),
(2206, 1, 791, 'Yes'),
(2207, 1, 792, 'No'),
(2208, 1, 793, 'Enable'),
(2209, 1, 794, 'Disable'),
(2210, 1, 795, 'Enabled'),
(2211, 1, 796, 'Disabled'),
(2212, 1, 797, 'Display order'),
(2213, 1, 798, 'Page'),
(2214, 1, 799, 'Add'),
(2215, 1, 800, 'Update'),
(2217, 1, 802, 'Next'),
(2218, 1, 803, 'Clear'),
(2219, 1, 804, 'Finish'),
(2220, 1, 805, 'Deletion of custom field group will delete custom fields in this custom group'),
(2221, 1, 806, 'Module should contain character from a to z only in small letters'),
(2222, 1, 807, 'To add custom fields you require minimum one custom field group'),
(2223, 1, 808, 'Organization can not be deleted until client is assigned to that organization'),
(2224, 1, 809, 'Deleting department will delete all tickets under that department. This action is irreversible! <br /> Are you sure you want to proceed?'),
(2225, 1, 810, 'Deleting domain will delete all departments clients and their tickets from this domain.<br />This operation is irreversible<br />Are you sure you want to proceed?'),
(2226, 1, 811, 'Deleting category will delete all its articles and comments on that articles. <br />This operation is irreversible. <br />Are you sure you want to proceed?'),
(2227, 1, 812, 'Deleting article will delete article and comments on it. <br />This operation is irreversible. <br />Are you sure you want to proceed?'),
(2228, 1, 813, 'Ticket has assigned with this status.<br />Can not delete status which assigned to ticket'),
(2229, 1, 814, 'Ticket has assigned with this priority.<br />Can not delete priority which assigned to ticket'),
(2230, 1, 815, 'Ticket has assigned with this type.<br />Can not delete ticket type which assigned to ticket'),
(2231, 1, 816, 'Ticket has assigned with this flag.<br />Can not delete flag which assigned to ticket'),
(2232, 1, 817, 'This team is assigned to staff.'),
(2233, 1, 818, 'Required files not found for module'),
(2234, 1, 819, '<span class="vis_msg">Image verification mismatch</span>'),
(2235, 1, 820, 'Required field module name'),
(2236, 1, 821, 'Setting not available'),
(2237, 1, 822, 'Empty sent mail log'),
(2238, 1, 823, 'Log not selected'),
(2239, 1, 824, 'Email approval pending'),
(2240, 1, 825, 'Error log is empty'),
(2241, 1, 826, 'Exception log is empty'),
(2242, 1, 827, 'Required field schedule name'),
(2243, 1, 828, 'Incorrect response time'),
(2244, 1, 829, 'Incorrect resolution time'),
(2245, 1, 830, 'Required field subject'),
(2246, 1, 831, 'Amount is missing or invalid format'),
(2247, 1, 832, 'Client ID missing'),
(2248, 1, 833, 'Client email missing'),
(2249, 1, 834, 'Ticket ID missing'),
(2250, 1, 835, 'Filter title not set'),
(2251, 1, 836, 'Required field title'),
(2252, 1, 837, 'Post message not found'),
(2253, 1, 838, 'Sender not found'),
(2254, 1, 839, 'Required data not submitted'),
(2255, 1, 840, 'Tag name missing'),
(2256, 1, 841, 'Invalid operation'),
(2257, 1, 842, 'Select multiple tickets to merge'),
(2258, 1, 843, '<div class="alert-success">Operation completed successfully</div>'),
(2259, 1, 844, '<div class="vis_msg_err">Error in operation</div>'),
(2260, 1, 845, 'Invoice ID missing'),
(2261, 1, 846, 'Invalid old password'),
(2262, 1, 847, 'Staff not selected'),
(2263, 1, 848, 'Blab ID not found'),
(2264, 1, 849, 'Client group id not found'),
(2265, 1, 850, 'Group name is missing'),
(2266, 1, 851, 'Password mismatch'),
(2267, 1, 852, 'Password reset and sent to email'),
(2268, 1, 853, 'Client email address already registered'),
(2269, 1, 854, 'Email address missing or invalid email format'),
(2270, 1, 855, 'First name missing'),
(2271, 1, 856, 'Last name missing'),
(2272, 1, 857, 'User name missing'),
(2273, 1, 858, 'Field not selected'),
(2274, 1, 859, 'Event not selected'),
(2275, 1, 860, 'Migration data not selected'),
(2276, 1, 861, 'Access denied'),
(2277, 1, 862, 'Are you sure you want to proceed?'),
(2278, 1, 863, 'Deleting client will delete all its tickets and data'),
(4874, 0, 2437, 'Invalid end date'),
(2279, 1, 864, ''),
(3938, 0, 1969, 'Additional fields'),
(3939, 1, 1969, 'Additional fields'),
(3940, 0, 1970, 'Edit'),
(3941, 1, 1970, 'Edit'),
(2280, 1, 865, 'Core module can not be deleted'),
(2281, 1, 866, 'Incomplete information submitted'),
(2282, 1, 867, 'Invalid login details'),
(2283, 1, 868, 'Quick view widget for this module not found'),
(2284, 1, 869, 'Empty error log'),
(2285, 1, 870, 'Contact not found'),
(2286, 1, 871, 'New client registered'),
(2287, 1, 872, 'Client deleted'),
(2288, 1, 873, 'Domain not found'),
(2289, 1, 874, 'Department not found'),
(2290, 1, 875, 'Staff ID not found'),
(2291, 1, 876, 'Data not found'),
(2292, 1, 877, 'New ticket created'),
(2293, 1, 878, 'Ticket replied'),
(2294, 1, 879, 'Status changed'),
(2295, 1, 880, 'Priority changed'),
(2296, 1, 881, 'Department changed'),
(2297, 1, 882, 'Ticket type changed'),
(2298, 1, 883, 'Flag changed'),
(2299, 1, 884, 'Ticket assigned'),
(2300, 1, 885, 'Ticket moved to trash'),
(2301, 1, 886, 'Ticket merged'),
(2302, 1, 887, 'Ticket forwarded'),
(2303, 1, 888, 'Ticket deleted'),
(2304, 1, 889, 'SLA changed'),
(2305, 1, 890, 'Spam marked'),
(2306, 1, 891, 'Removed spam mark'),
(2307, 1, 892, 'Can not remove first criteria'),
(2308, 1, 893, 'Required field display order'),
(2309, 1, 894, 'Display order must be numeric'),
(2310, 1, 895, 'Ticket hash'),
(2311, 1, 896, 'Ticket ID'),
(2312, 1, 897, 'Subject'),
(2313, 1, 898, 'Ticket type'),
(2314, 1, 899, 'Domain'),
(2315, 1, 900, 'Department'),
(2316, 1, 901, 'Status'),
(2317, 1, 902, 'Priority'),
(2318, 1, 903, 'Created on'),
(2319, 1, 904, 'Modified on'),
(2320, 1, 905, 'Due time'),
(2321, 1, 906, 'Resolution time'),
(2322, 1, 907, 'SLA plan'),
(2323, 1, 908, 'SLA ID'),
(2324, 1, 909, 'Reply count'),
(2325, 1, 910, 'Ticket count'),
(2326, 1, 911, 'First name'),
(2327, 1, 912, 'Last name'),
(2328, 1, 913, 'Email'),
(2329, 1, 914, 'Contact number'),
(2330, 1, 915, 'Job title'),
(2331, 1, 916, 'Company'),
(2332, 1, 917, 'City'),
(2333, 1, 918, 'State'),
(2334, 1, 919, 'Country'),
(2335, 1, 920, 'Zip code'),
(2337, 1, 922, 'Group type'),
(2338, 1, 923, 'Is spam'),
(2339, 1, 924, 'Is ban'),
(2340, 1, 925, 'Credit'),
(2341, 1, 926, 'Debit'),
(2342, 1, 927, 'Group balance'),
(2343, 1, 928, 'Group debit'),
(2344, 1, 929, 'Paid invoice count'),
(2345, 1, 930, 'Unpaid invoice count'),
(2346, 1, 931, 'First name'),
(2347, 1, 932, 'Last name'),
(2348, 1, 933, 'Email'),
(2349, 1, 934, 'Contact number'),
(2350, 1, 935, 'Mobile number'),
(2351, 1, 936, 'Job title'),
(2352, 1, 937, 'Company'),
(2353, 1, 938, 'City'),
(2354, 1, 939, 'State'),
(2355, 1, 940, 'Country'),
(2356, 1, 941, 'Zip code'),
(2358, 1, 943, 'Domain'),
(2360, 1, 945, 'Is spam'),
(2361, 1, 946, 'Is ban'),
(2362, 1, 947, 'Avg. responses'),
(2363, 1, 948, 'Total responses'),
(2364, 1, 949, 'Properties'),
(2365, 1, 950, 'People'),
(2366, 1, 951, 'Or'),
(2367, 1, 952, 'Data not available'),
(2368, 1, 953, 'Module already exist'),
(2369, 1, 954, 'Default view can not delete'),
(2370, 1, 955, 'Search trash'),
(2371, 1, 956, 'Search spam'),
(2372, 1, 957, 'Trash'),
(2373, 1, 958, 'Spam'),
(2374, 1, 959, 'Print'),
(2375, 1, 960, 'Ticket not found may be deleted or not have access'),
(2376, 1, 961, 'On overdue'),
(2377, 1, 962, 'Option'),
(2378, 1, 963, 'Delete filter'),
(2379, 1, 964, 'Draft'),
(2380, 1, 965, 'is currently working on this ticket.'),
(2381, 1, 966, 'To share with all do not select staff'),
(2382, 1, 967, 'Go'),
(2383, 1, 968, 'Delete report'),
(2384, 1, 969, 'Staff username and email should be unique'),
(2385, 1, 970, 'Delete SMTP'),
(2386, 1, 971, 'Delete sent mail log'),
(2387, 1, 972, 'Client details'),
(2388, 1, 973, 'Client notes'),
(2389, 1, 974, 'Products and services'),
(2390, 1, 975, 'Package'),
(2391, 1, 976, 'Dedicated IP'),
(2392, 1, 977, 'WHMCS client notes'),
(2393, 1, 978, 'Error in WHMCS database selection'),
(2394, 1, 979, 'Error in WHMCS database connection'),
(2395, 1, 980, 'WHMCS integration details not set'),
(2396, 1, 981, 'Version'),
(2397, 1, 982, 'Branding free'),
(2398, 1, 983, 'Invoice for ticket'),
(2399, 1, 984, 'Credit for invoice'),
(2400, 1, 985, 'Insufficient credit'),
(2401, 1, 986, 'Invoice for time'),
(2402, 1, 987, 'Bill amount'),
(2403, 1, 988, 'Update transaction'),
(2404, 1, 989, 'Transactions'),
(2405, 1, 990, 'Transaction ID'),
(2406, 1, 991, 'Delete transaction'),
(2407, 1, 992, 'Add credit'),
(2408, 1, 993, 'Rate'),
(2409, 1, 994, 'Inclusive'),
(2410, 1, 995, 'Exclusive'),
(2411, 1, 996, 'Add tax rule'),
(2412, 1, 997, 'Edit tax rule'),
(2413, 1, 998, 'Invalid rule'),
(2414, 1, 999, 'Delete tax rule'),
(2415, 1, 1000, 'View invoice to client'),
(2416, 1, 1001, 'Pay now'),
(2417, 1, 1002, 'Get PDF'),
(2418, 1, 1003, 'Subtotal'),
(2419, 1, 1004, 'Invoice to'),
(2420, 1, 1005, 'Move to inbox'),
(2421, 1, 1006, 'Payment gateway'),
(2422, 1, 1007, 'Mark unpaid'),
(2423, 1, 1008, 'Mark cancelled'),
(2424, 1, 1009, 'Greater than or equal'),
(2425, 1, 1010, 'Add item'),
(2426, 1, 1011, 'Email templates mapping'),
(2427, 1, 1012, 'Convert to ticket'),
(2428, 1, 1013, 'Add search'),
(2429, 1, 1014, 'Consumer key'),
(2430, 1, 1015, 'Consumer secret'),
(2431, 1, 1016, 'Access token'),
(2432, 1, 1017, 'Access token secret'),
(2433, 1, 1018, 'Check your ticket details at'),
(2434, 1, 1019, 'Social media'),
(2435, 1, 1020, 'Search content'),
(2436, 1, 1021, 'Add social media'),
(2437, 1, 1022, 'Auto ticket convert if mentioned'),
(2438, 1, 1023, 'Create an app with access read write and direct message from'),
(2439, 1, 1024, 'https'),
(2440, 1, 1025, 'And genereate required details from "details >> Create my access token"'),
(2441, 1, 1026, 'Hidden'),
(2442, 1, 1027, 'API ID'),
(2443, 1, 1028, 'SMS alert'),
(2444, 1, 1029, 'Generate'),
(2445, 1, 1030, 'Custom'),
(2446, 1, 1031, 'Portal color'),
(2447, 1, 1032, 'Secret key for API'),
(2448, 1, 1033, 'Approved'),
(2449, 1, 1034, 'Unapproved'),
(2450, 1, 1035, 'Can not delete department. Domain atleast need one department'),
(2451, 1, 1036, 'Cc'),
(2452, 1, 1037, 'Display after login'),
(2453, 1, 1038, 'Type here and enter'),
(2454, 1, 1039, 'Requires at least one recipient'),
(2455, 1, 1040, 'Client portal logo'),
(2456, 1, 1041, 'Save reply'),
(2457, 1, 1042, 'Can not delete system default settings'),
(2458, 1, 1043, 'All reports'),
(2459, 1, 1044, 'Graphical'),
(2460, 1, 1045, 'RDN'),
(2461, 1, 1046, 'Base DN'),
(2462, 1, 1047, 'Move tickets to any department'),
(2463, 1, 1048, 'Date format'),
(2464, 1, 1049, 'Date time format'),
(2465, 1, 1050, 'Product'),
(2466, 1, 1051, 'Packages'),
(2467, 1, 1052, 'Delete package'),
(2468, 1, 1053, 'Add product'),
(2469, 1, 1054, 'Amount credit'),
(2470, 1, 1055, 'Ticket credit'),
(2471, 1, 1056, 'Price'),
(2472, 1, 1057, 'Credit type'),
(2473, 1, 1058, 'Order now'),
(2474, 1, 1059, 'Orders'),
(2475, 1, 1060, 'Order'),
(2476, 1, 1061, 'Validity'),
(2477, 1, 1062, 'One time'),
(2478, 1, 1063, 'Monthly'),
(2479, 1, 1064, 'Quarterly'),
(2480, 1, 1065, 'Semi annually'),
(2481, 1, 1066, 'Annually'),
(2482, 1, 1067, 'Empty trash'),
(2483, 1, 1068, 'As client'),
(2484, 1, 1069, 'Income'),
(2485, 1, 1070, 'Edit product'),
(2486, 1, 1071, 'Delete facebook integration'),
(2487, 1, 1072, 'Unlimited  '),
(2488, 1, 1073, 'Invalid information or format'),
(2489, 1, 1074, 'Avg. SLA'),
(2490, 1, 1075, 'Label already exists'),
(2491, 1, 1076, 'Access denied can not add client'),
(2492, 1, 1077, 'Merge client'),
(2493, 1, 1078, 'Merge as contact'),
(2494, 1, 1079, 'Custom SLA plan'),
(2495, 1, 1080, 'Delete label'),
(2496, 1, 1081, 'On unresolved'),
(2497, 1, 1082, 'Client approval pending'),
(2498, 1, 1083, 'API login ID'),
(2499, 1, 1084, 'Transaction key'),
(2500, 1, 1085, 'Gateway mode'),
(2501, 1, 1086, 'In process'),
(2502, 1, 1087, 'Gateway transactions'),
(2503, 1, 1088, 'Gateway transaction response details'),
(2504, 1, 1089, 'Delete gateway transaction log'),
(2505, 1, 1090, 'Empty gateway transaction log'),
(2506, 1, 1091, 'Recurring'),
(2507, 1, 1092, 'Ticket hash generation'),
(2508, 1, 1093, 'Random'),
(2509, 1, 1094, 'Sequential'),
(2510, 1, 1095, 'Ticket hash prefix'),
(2511, 1, 1096, 'Numbering starts from'),
(2512, 1, 1097, 'Alphanumeric prefix data required'),
(2513, 1, 1098, 'Numeric data required for numbering starts from field'),
(2514, 1, 1099, 'Authentication error'),
(2515, 1, 1100, 'Connection error'),
(2516, 1, 1101, 'Authentication or connection error'),
(2517, 1, 1102, 'Client search'),
(2518, 1, 1103, 'Is approved'),
(2519, 1, 1104, 'Search solutions'),
(2520, 1, 1105, 'CSV'),
(2521, 1, 1106, 'Notifications'),
(2522, 1, 1107, 'Notification icon'),
(2523, 1, 1108, 'Forward failed email'),
(2524, 1, 1109, 'Forward failed email to'),
(2525, 1, 1110, 'Verify email queue'),
(2526, 1, 1111, 'Start timer'),
(2527, 1, 1112, 'Stop timer'),
(2528, 1, 1113, 'Time tracked'),
(2529, 1, 1114, 'Add time tracked'),
(2530, 1, 1115, '#Timetrack'),
(2531, 1, 1116, 'Bill time'),
(2532, 1, 1117, 'Work time'),
(2533, 1, 1118, 'Timetrack ID missing'),
(2534, 1, 1119, 'Delete time tracked'),
(2536, 1, 1121, 'Load more posts'),
(2537, 1, 1122, 'Display inline images'),
(2538, 1, 1123, 'Hide inline images'),
(2539, 1, 1124, 'SLA plan change'),
(2540, 1, 1125, 'Select tickets to export'),
(2541, 1, 1126, 'Search result'),
(2542, 1, 1127, 'Enter minimum 3 characters'),
(2543, 1, 1128, 'Recent messages'),
(2544, 1, 1129, 'Load more...'),
(2545, 1, 1130, 'Export CSV'),
(2546, 1, 1131, 'Filter list'),
(2547, 1, 1132, 'List column'),
(2548, 1, 1133, 'Update view'),
(2549, 1, 1134, 'Attachment'),
(2550, 1, 1135, 'Favourite'),
(2551, 1, 1136, 'Latest post'),
(2552, 1, 1137, 'Manage portal'),
(2553, 1, 1138, 'Manage portal logo'),
(2554, 1, 1139, 'Manage portal color'),
(2555, 1, 1140, 'New ticket'),
(2556, 1, 1141, 'Use assigned departments to team?'),
(2557, 1, 1142, 'Update staff'),
(2558, 1, 1143, 'Permissions'),
(2559, 1, 1144, 'Update team'),
(2560, 1, 1145, 'Update admin access'),
(2561, 1, 1146, 'Change owner'),
(2562, 1, 1147, 'Change type'),
(2563, 1, 1148, 'Split ticket'),
(2564, 1, 1149, 'Link / unlink tickets'),
(2565, 1, 1150, 'Update status'),
(2566, 1, 1151, 'Update workflow'),
(2567, 1, 1152, 'Holidays'),
(2568, 1, 1153, 'Add holiday'),
(2569, 1, 1154, 'Delete holiday'),
(2570, 1, 1155, 'Update holiday'),
(2571, 1, 1156, 'Update ticket type'),
(2572, 1, 1157, 'Language translation for holiday description'),
(2573, 1, 1158, 'Update schedule'),
(2574, 1, 1159, 'Update flag'),
(2575, 1, 1160, 'Update SLA'),
(2576, 1, 1161, 'Required field description'),
(2577, 1, 1162, 'WHMCS'),
(2578, 1, 1163, 'Add WHMCS'),
(2579, 1, 1164, 'Update WHMCS'),
(2580, 1, 1165, 'Delete WHMCS'),
(2581, 1, 1166, 'Twitter'),
(2582, 1, 1167, 'Add twitter'),
(2583, 1, 1168, 'Update twitter'),
(2584, 1, 1169, 'Delete twitter'),
(2585, 1, 1170, 'Facebook'),
(2586, 1, 1171, 'Add facebook'),
(2587, 1, 1172, 'Update facebook'),
(2588, 1, 1173, 'Delete facebook'),
(2589, 1, 1174, 'SMS'),
(2590, 1, 1175, 'Add SMS'),
(2591, 1, 1176, 'Update SMS'),
(2592, 1, 1177, 'Delete SMS'),
(2593, 1, 1178, 'Clickatell'),
(2594, 1, 1179, 'Two SMS'),
(2595, 1, 1180, 'Select API'),
(2596, 1, 1181, 'Transaction log'),
(2597, 1, 1182, 'Override details'),
(2598, 1, 1183, 'Update email queue'),
(2599, 1, 1184, 'Update SMTP'),
(2600, 1, 1185, 'Add SMTP'),
(2601, 1, 1186, 'Delete SMTP'),
(2602, 1, 1187, 'Organizations'),
(2603, 1, 1188, 'Apply filter'),
(2604, 1, 1189, 'Update custom field'),
(2605, 1, 1190, 'Update custom field group'),
(2606, 1, 1191, 'Phone'),
(2607, 1, 1192, 'Address'),
(2608, 1, 1193, 'Twitter ID'),
(2609, 1, 1194, 'Facebook ID'),
(2610, 1, 1195, 'Organization details'),
(2611, 1, 1196, 'Company'),
(2612, 1, 1197, 'Update email template'),
(2613, 1, 1198, 'Update alert'),
(2614, 1, 1199, 'Label name'),
(2615, 1, 1200, 'Add label'),
(2616, 1, 1201, 'Label color'),
(2617, 1, 1202, 'Update contact'),
(2618, 1, 1203, 'Pages'),
(2619, 1, 1204, 'Fetch pages'),
(2620, 1, 1205, 'Page not found'),
(2621, 1, 1206, 'Update label'),
(2622, 1, 1207, 'Update module'),
(2623, 1, 1208, 'Ticket activity'),
(2624, 1, 1209, 'Edit profile'),
(2625, 1, 1210, 'Preference'),
(2626, 1, 1211, 'Recent blabs'),
(2627, 1, 1212, 'Internal ticket'),
(2628, 1, 1213, 'Add comment'),
(2629, 1, 1214, 'Update invoice'),
(2630, 1, 1215, 'Attach file'),
(2631, 1, 1216, 'Last 7 days ticket activity'),
(2632, 1, 1217, 'Replied'),
(2633, 1, 1218, 'Awaiting'),
(2634, 1, 1219, 'Closed'),
(2635, 1, 1220, 'Staff member'),
(2636, 1, 1221, 'Skills'),
(2638, 1, 1223, 'Phone number'),
(2639, 1, 1224, 'Empty'),
(2640, 1, 1225, 'Sent email log'),
(2641, 1, 1226, 'Gateway transactions log'),
(2642, 1, 1227, 'Core module status can not be changed'),
(2643, 1, 1228, 'Display pages'),
(2644, 1, 1229, 'Package ID'),
(2645, 1, 1230, 'Entry date'),
(2646, 1, 1231, 'Staff comment'),
(2647, 1, 1232, 'Recent activity count'),
(2648, 1, 1233, 'Upload image'),
(2649, 1, 1234, 'Online staff'),
(2650, 1, 1235, 'Post'),
(2651, 1, 1236, 'Insert from URL...'),
(2652, 1, 1237, 'Attached media'),
(2653, 1, 1238, 'Upload from local machine'),
(2654, 1, 1239, 'Attach media'),
(2655, 1, 1240, 'Add organization'),
(2656, 1, 1241, 'Update organization'),
(2657, 1, 1242, 'Billing cycle'),
(4525, 1, 2262, 'Subject missing'),
(2659, 1, 1244, 'Modified date'),
(2660, 1, 1245, 'Department missing'),
(2661, 1, 1246, 'Search tickets and knowledgebase articles'),
(2662, 1, 1247, 'Save filter'),
(2663, 1, 1248, 'Save'),
(2664, 1, 1249, 'Created by'),
(2665, 1, 1250, 'Parent'),
(2666, 1, 1251, 'Filter ID not found'),
(2667, 1, 1252, 'Update filter'),
(2668, 1, 1253, 'Recent articles'),
(2669, 1, 1254, 'Total articles'),
(2670, 1, 1255, 'Total categories'),
(2671, 1, 1256, 'Helpful articles'),
(2672, 1, 1257, 'Most viewed articles'),
(2673, 1, 1258, 'Articles'),
(2675, 1, 1260, 'Category'),
(2676, 1, 1261, 'Comment'),
(2677, 1, 1262, 'Update comment'),
(2678, 1, 1263, 'Update category'),
(2679, 1, 1264, 'Update article'),
(2680, 1, 1265, 'Sorted by'),
(2681, 1, 1266, 'Delete comment'),
(2682, 1, 1267, 'Graphical'),
(2683, 1, 1268, 'Now'),
(2684, 1, 1269, 'Work'),
(2685, 1, 1270, 'Department SLA'),
(2686, 1, 1271, 'Response'),
(2687, 1, 1272, 'Performance'),
(2688, 1, 1273, 'Client SLA'),
(2689, 1, 1274, 'Ticket feedback per department'),
(2690, 1, 1275, 'Time tracking per staff'),
(2691, 1, 1276, 'Time tracking per department'),
(2692, 1, 1277, 'Staff SLA'),
(2693, 1, 1278, 'Top performer'),
(2694, 1, 1279, 'Department statistics'),
(2695, 1, 1280, 'Duration'),
(2696, 1, 1281, 'Purchase'),
(2697, 1, 1282, 'My packages'),
(2698, 1, 1283, 'My invoices'),
(2699, 1, 1284, 'Days'),
(2700, 1, 1285, 'Team'),
(2701, 1, 1286, 'Selected staff'),
(2702, 1, 1287, 'Search blabs'),
(2703, 1, 1288, 'Search staff'),
(2704, 1, 1289, 'Year'),
(2705, 1, 1290, 'Email address'),
(2706, 1, 1291, 'Website URL'),
(2707, 1, 1292, 'Logo URL'),
(2708, 1, 1293, 'Pay to text'),
(2709, 1, 1294, 'Ship to'),
(2710, 1, 1295, 'QTY'),
(2711, 1, 1296, 'Note color'),
(2712, 1, 1297, 'Update profile'),
(2713, 1, 1298, 'Domain name should be proper and valid'),
(2714, 1, 1299, 'Client portal URL should be proper and valid'),
(2715, 1, 1300, 'Required field domain'),
(2716, 1, 1301, 'Required field client portal URL'),
(2717, 1, 1302, 'Required field default email'),
(2718, 1, 1303, 'Required field date format'),
(2719, 1, 1304, 'Required field date time format'),
(2720, 1, 1305, 'Select domain'),
(2721, 1, 1306, 'Mark as super admin'),
(2722, 1, 1307, 'Mark as domain admin'),
(2723, 1, 1308, 'Required field from email'),
(2724, 1, 1309, 'Required field forward failed email to'),
(2725, 1, 1310, 'Invalid email format in forward failed email to field'),
(2726, 1, 1311, 'Invalid email format in from email field'),
(2727, 1, 1312, 'Remove admin access'),
(2728, 1, 1313, 'Admin can not be updated'),
(2729, 1, 1314, 'Labels/Tags'),
(2730, 1, 1315, 'Only alphanumeric characters are allowed in title'),
(2732, 1, 1317, 'Select language'),
(2733, 1, 1318, 'Default word/phrases'),
(2734, 1, 1319, 'Dashboard'),
(2735, 1, 1320, 'Channels'),
(2736, 1, 1321, 'Ticket types'),
(2737, 1, 1322, 'Display IP address to staff'),
(2738, 1, 1323, 'Nothing to display here yet...'),
(2739, 1, 1324, 'IP address'),
(2741, 1, 1326, 'Invoice ID'),
(2742, 1, 1327, 'Transaction date'),
(2743, 1, 1328, 'Tax'),
(2744, 1, 1329, 'Note posted by'),
(2745, 1, 1330, 'Comment posted by'),
(2746, 1, 1331, 'Blab count must be numeric'),
(2747, 1, 1332, 'Due time must be in proper format'),
(2748, 1, 1333, 'Recent activity count must be numeric'),
(2749, 1, 1334, 'Number of attachment must be numeric'),
(2750, 1, 1335, 'Maximum size for attachment must be numeric'),
(2751, 1, 1336, 'Ticket hash prefix field is empty'),
(2752, 1, 1337, 'Ticket starts from field is empty'),
(2753, 1, 1338, 'Ticket post count must be numeric'),
(2754, 1, 1339, 'Forward to field is empty'),
(2755, 1, 1340, 'Email address missing or invalid email format in forward to field'),
(2756, 1, 1341, 'Mark as ban'),
(2757, 1, 1342, 'Mark as spam'),
(2758, 1, 1343, 'Required field execution order'),
(2759, 1, 1344, 'Execution order must be numeric'),
(2760, 1, 1345, 'Can not remove default criteria'),
(2761, 1, 1346, 'Autoresponder email'),
(2762, 1, 1347, 'Update product'),
(2763, 1, 1348, 'Update payment gateway'),
(2764, 1, 1349, 'Update tax rule'),
(2765, 1, 1350, 'Paypal'),
(2766, 1, 1351, 'Authorize.net'),
(2767, 1, 1352, 'API login field is empty'),
(2768, 1, 1353, 'Transaction key field is empty'),
(2769, 1, 1354, 'Forwarded to'),
(2770, 1, 1355, 'Replied to'),
(2771, 1, 1356, 'Add localization'),
(2772, 1, 1357, 'Search word/phrases...'),
(2773, 1, 1358, 'Language variable'),
(2774, 1, 1359, 'Language value'),
(2775, 1, 1360, 'Language translation'),
(2776, 1, 1361, 'Language variable should be in capital letters'),
(2777, 1, 1362, 'Required field language value'),
(2778, 1, 1363, 'Language variable is already exist'),
(2779, 1, 1364, 'Enter word/phrases in search box'),
(2780, 1, 1365, 'Delete localization'),
(2781, 1, 1366, 'per'),
(2782, 1, 1367, 'Week'),
(2783, 1, 1368, 'Tickets by ticket types'),
(2784, 1, 1369, 'Tickets by channels'),
(2785, 1, 1370, 'Tickets by priorities'),
(2786, 1, 1371, 'Created by'),
(2787, 1, 1372, 'via client portal'),
(2788, 1, 1373, 'Points'),
(2789, 1, 1374, 'Ticket replied after overdue time'),
(2790, 1, 1375, 'Ticket replied without SLA'),
(2791, 1, 1376, 'Ticket replied within due time'),
(2792, 1, 1377, 'Select duration'),
(2793, 1, 1378, 'Last 24 hours'),
(2794, 1, 1379, 'Last 7 days'),
(2795, 1, 1380, 'Last 30 days'),
(2796, 1, 1381, 'All domain'),
(2797, 1, 1382, 'Please select duration'),
(2798, 1, 1383, 'Ticket created successfully'),
(2799, 1, 1384, 'Show recipient and people'),
(2800, 1, 1385, 'Hide recipient and people'),
(2801, 1, 1386, 'Update channel'),
(2802, 1, 1387, 'Delete channel'),
(2803, 1, 1388, 'Ticket has assigned with this channel.<br />Can not delete channel which assigned to ticket'),
(2804, 1, 1389, 'Default channel can not be updated'),
(2805, 1, 1390, 'Maximum image upload height/width is 25 px'),
(2806, 1, 1391, 'Image'),
(2807, 1, 1392, 'Core channel status can not be changed'),
(2808, 1, 1393, 'Maintain'),
(2809, 1, 1394, 'Select staff for share'),
(2810, 1, 1395, 'Enable ticket conversion'),
(2811, 1, 1396, 'Record not found'),
(2812, 1, 1397, 'Please enter valid URL'),
(2813, 1, 1398, 'Searching'),
(2814, 1, 1399, 'Required fields are empty'),
(2815, 1, 1400, 'Required field password'),
(2816, 1, 1401, 'Add tag'),
(2817, 1, 1402, 'Delete blab comment'),
(2818, 1, 1403, 'Login time'),
(2819, 1, 1404, 'Online'),
(2820, 1, 1405, 'Offline'),
(2821, 1, 1406, 'Type comment here'),
(2822, 1, 1407, 'Shared with'),
(2823, 1, 1408, 'Reply with quote'),
(2824, 1, 1409, 'Display note(s) on ticket details'),
(2825, 1, 1410, 'Notes'),
(2826, 1, 1411, 'No match found'),
(2827, 1, 1412, 'Enter text'),
(2828, 1, 1413, 'Type to search existing clients email address'),
(2829, 1, 1414, 'Type here and press enter to save'),
(2830, 1, 1415, 'Core organization status can not be changed'),
(2836, 0, 1417, 'Open and track support ticket'),
(2837, 1, 1417, 'Submit new ticket or track your existing tickets'),
(2838, 0, 1418, 'Check our self help section for helpful articles and latest announcements'),
(2839, 1, 1418, 'Check our solutions section for helpful articles and latest announcements'),
(2840, 0, 1419, 'Ticket credit'),
(2841, 1, 1419, 'Ticket credit'),
(2844, 0, 1421, 'Required data not submitted'),
(2845, 1, 1421, 'Required data not submitted'),
(2848, 0, 1425, '<div class="alert-success">Operation completed successfully</div>'),
(2849, 1, 1425, '<div class="alert-success">Operation completed successfully</div>'),
(2850, 0, 1426, '<div class="vis_msg_err">Error in operation</div>'),
(2851, 1, 1426, '<div class="vis_msg_err">Error in operation</div>'),
(2853, 0, 1427, 'Link'),
(2854, 1, 1427, 'Link'),
(2855, 0, 1428, 'relates to'),
(2856, 1, 1428, 'relates to'),
(2857, 0, 1429, 'is related to'),
(2858, 1, 1429, 'is related to'),
(2859, 0, 1430, 'is a parent of'),
(2860, 1, 1430, 'is a parent of'),
(2861, 0, 1431, 'is a child of'),
(2862, 1, 1431, 'is a child of'),
(2863, 0, 1432, 'depends on'),
(2864, 1, 1432, 'depends on'),
(2865, 0, 1433, 'is depended on'),
(2866, 1, 1433, 'is depended on'),
(2867, 0, 1434, 'duplicates'),
(2868, 1, 1434, 'duplicates'),
(2869, 0, 1435, 'is duplicated by'),
(2870, 1, 1435, 'is duplicated by'),
(2871, 0, 1436, 'One time'),
(2872, 1, 1436, 'One time'),
(2873, 0, 1437, 'Monthly'),
(2874, 1, 1437, 'Monthly'),
(2875, 0, 1438, 'Quarterly'),
(2876, 1, 1438, 'Quarterly'),
(2877, 0, 1439, 'Semi annually'),
(2878, 1, 1439, 'Semi annually'),
(2879, 0, 1440, 'Annually'),
(2880, 1, 1440, 'Annually'),
(2881, 0, 1441, 'Profile URL'),
(2882, 1, 1441, 'Profile URL'),
(2923, 0, 1462, 'Delete link'),
(2924, 1, 1462, 'Delete link'),
(2925, 0, 1463, 'Unlink'),
(2926, 1, 1463, 'Unlink'),
(2927, 0, 1464, 'Link ticket'),
(2928, 1, 1464, 'Link ticket'),
(3025, 0, 1513, 'Split'),
(3026, 1, 1513, 'Split'),
(3027, 0, 1514, 'Split ticket post'),
(3028, 1, 1514, 'Split ticket post'),
(3029, 0, 1515, 'Split into'),
(3030, 1, 1515, 'Split into'),
(3031, 0, 1516, 'Existing ticket'),
(3032, 1, 1516, 'Existing ticket'),
(3033, 0, 1517, 'Enter ticket subject'),
(3034, 1, 1517, 'Enter ticket subject'),
(3035, 0, 1518, 'Enter ticket hash'),
(3036, 1, 1518, 'Enter valid ticket hash'),
(3037, 0, 1519, 'Invoice item not found'),
(3038, 1, 1519, 'Invoice item not found'),
(3039, 0, 1520, 'Invoice date'),
(3040, 1, 1520, 'Invoice date'),
(3041, 0, 1521, 'PDF'),
(3042, 1, 1521, 'PDF'),
(3043, 0, 1522, 'Invoice items'),
(3044, 1, 1522, 'Invoice items'),
(3045, 0, 1523, 'Descriptions'),
(3046, 1, 1523, 'Descriptions'),
(3047, 0, 1524, 'Taxed'),
(3048, 1, 1524, 'Taxed'),
(3049, 0, 1525, 'Apply credit'),
(3050, 1, 1525, 'Apply credit'),
(3051, 0, 1526, 'Please select email template'),
(3052, 1, 1526, 'Please select email template'),
(3053, 0, 1527, 'Amount should be numeric'),
(3054, 1, 1527, 'Amount should be numeric'),
(3055, 0, 1528, 'Available credit'),
(3056, 1, 1528, 'Available credit'),
(3057, 0, 1529, 'Delete invoice item'),
(3058, 1, 1529, 'Delete invoice item'),
(3059, 0, 1530, 'Remove credit'),
(3060, 1, 1530, 'Remove credit'),
(3061, 0, 1531, 'Credit applied'),
(3062, 1, 1531, 'Credit applied'),
(3063, 0, 1532, 'Numeric value required for credit applied'),
(3064, 1, 1532, 'Numeric value required for credit applied'),
(3065, 0, 1533, 'Credit to be removed should not be greater than credit applied'),
(3066, 1, 1533, 'Credit to be removed should not be greater than credit applied'),
(3067, 0, 1534, 'You don''t have sufficient credit to apply'),
(3068, 1, 1534, 'You don''t have sufficient credit to apply'),
(3069, 0, 1535, 'Balance'),
(3070, 1, 1535, 'Balance'),
(3071, 0, 1536, 'Select email template'),
(3072, 1, 1536, 'Select email template'),
(3073, 0, 1537, 'Delete order'),
(3074, 1, 1537, 'Delete order'),
(3075, 0, 1538, 'You cannot apply more credit than the invoice total'),
(3076, 1, 1538, 'You cannot apply more credit than the invoice total'),
(3077, 0, 1539, 'Articles are not selected'),
(3078, 1, 1539, 'Articles are not selected'),
(3079, 0, 1540, 'Article content can not be empty'),
(3080, 1, 1540, 'Article content can''t be empty'),
(3081, 0, 1541, 'Disapprove'),
(3082, 1, 1541, 'Disapprove'),
(3083, 0, 1542, 'Comments not selected'),
(3084, 1, 1542, 'Comments not selected'),
(3085, 0, 1543, 'Search articles....'),
(3086, 1, 1543, 'Search articles'),
(3087, 0, 1544, 'Enter article in search box'),
(3088, 1, 1544, 'Enter article in search box'),
(3089, 0, 1545, 'Contact number should be numeric'),
(3090, 1, 1545, 'Contact number should be numeric'),
(3091, 0, 1546, 'Social media details'),
(3092, 1, 1546, 'Social media details'),
(3093, 0, 1547, 'Google ID'),
(3094, 1, 1547, 'Google ID'),
(3095, 0, 1548, 'Linkedin ID'),
(3096, 1, 1548, 'Linkedin ID'),
(3099, 0, 1550, 'Gamification'),
(3100, 1, 1550, 'Gamification'),
(3101, 0, 1551, 'Add point'),
(3102, 1, 1551, 'Add point'),
(3103, 0, 1552, 'Bonus points'),
(3104, 1, 1552, 'Bonus points'),
(3105, 0, 1553, 'Award points'),
(3106, 1, 1553, 'Award points'),
(3107, 0, 1554, 'Staff levels'),
(3108, 1, 1554, 'Staff levels'),
(3109, 0, 1555, 'King'),
(3110, 1, 1555, 'King'),
(3111, 0, 1556, 'Queen'),
(3112, 1, 1556, 'Queen'),
(3113, 0, 1557, 'Rook'),
(3114, 1, 1557, 'Rook'),
(3115, 0, 1558, 'Bishop'),
(3116, 1, 1558, 'Bishop'),
(3117, 0, 1559, 'Knight'),
(3118, 1, 1559, 'Knight'),
(3119, 0, 1560, 'Pawn'),
(3120, 1, 1560, 'Pawn'),
(3121, 0, 1561, 'Points value must be numerical'),
(3122, 1, 1561, 'Points value must be numerical'),
(3123, 0, 1562, 'Quest'),
(3124, 1, 1562, 'Quest'),
(3125, 0, 1563, 'Add quest'),
(3126, 1, 1563, 'Add quest'),
(3127, 0, 1564, 'Quest type'),
(3128, 1, 1564, 'Quest type'),
(3129, 0, 1565, 'Solving tickets'),
(3130, 1, 1565, 'Solving tickets'),
(3131, 0, 1566, 'Quest objectives'),
(3132, 1, 1566, 'Quest objectives'),
(3133, 0, 1567, 'Solve'),
(3134, 1, 1567, 'Solve'),
(3135, 0, 1568, 'Badge'),
(3136, 1, 1568, 'Badge'),
(3137, 0, 1569, 'Name your quest'),
(3138, 1, 1569, 'Name your quest'),
(3139, 0, 1570, 'Quest description'),
(3140, 1, 1570, 'Quest description'),
(3141, 0, 1571, 'Article comment'),
(3142, 1, 1571, 'Article comment'),
(3143, 0, 1572, 'Article rating'),
(3144, 1, 1572, 'Article rating'),
(3145, 0, 1573, 'Tickets in a span of'),
(3146, 1, 1573, 'Tickets in a span of'),
(3147, 0, 1574, 'Matching below conditions'),
(3148, 1, 1574, 'Matching below conditions'),
(3149, 0, 1575, 'knowledge base article in a span of'),
(3150, 1, 1575, 'knowledge base article in a span of'),
(3151, 0, 1576, 'Create'),
(3152, 1, 1576, 'Create'),
(3153, 0, 1577, 'Delete quest'),
(3154, 1, 1577, 'Delete quest'),
(3155, 0, 1578, 'Update quest'),
(3156, 1, 1578, 'Update quest'),
(3157, 0, 1579, 'Select a badge'),
(3158, 1, 1579, 'Select a badge'),
(3159, 0, 1580, 'Badge is required'),
(3160, 1, 1580, 'Badge is required'),
(3170, 0, 1585, 'Invoice not selected'),
(3171, 1, 1585, 'Invoice not selected'),
(3172, 0, 1586, 'This ticket is linked with other'),
(3173, 1, 1586, 'This ticket is linked with other'),
(3174, 0, 1587, 'Transaction'),
(3175, 1, 1587, 'Transaction'),
(3176, 0, 1588, 'Update order'),
(3177, 1, 1588, 'Update order'),
(3178, 0, 1589, 'Active'),
(3179, 1, 1589, 'Active'),
(3180, 0, 1590, 'Pending'),
(3181, 1, 1590, 'Pending'),
(3182, 0, 1591, 'Incomplete'),
(3183, 1, 1591, 'Incomplete'),
(3184, 0, 1592, 'Payment status'),
(3185, 1, 1592, 'Payment status'),
(3186, 0, 1593, 'No invoice'),
(3187, 1, 1593, 'No invoice'),
(3188, 0, 1594, 'Add payment'),
(3189, 1, 1594, 'Add payment'),
(3190, 0, 1595, 'Payment method'),
(3191, 1, 1595, 'Payment method'),
(3192, 0, 1596, 'Numeric value required for all fields'),
(3193, 1, 1596, 'Numeric value required for all fields'),
(3194, 0, 1597, 'Enter text to search'),
(3195, 1, 1597, 'Enter text to search'),
(3196, 0, 1598, 'Nothing to display here yet...'),
(3197, 1, 1598, 'Nothing to display here yet...'),
(3198, 0, 1599, 'Today''s'),
(3199, 1, 1599, 'Today''s'),
(3200, 0, 1600, 'Payment for invoice'),
(3201, 1, 1600, 'Payment for invoice'),
(3202, 0, 1601, 'Search invoice'),
(3203, 1, 1601, 'Search invoice'),
(3204, 0, 1602, 'Filter result');
INSERT INTO `avis_language_values` (`language_values_id`, `language_id`, `variable_id`, `description`) VALUES
(3205, 1, 1602, 'Filter result'),
(3206, 0, 1603, 'Sort by'),
(3207, 1, 1603, 'Sort by'),
(3208, 0, 1604, 'Select staff'),
(3209, 1, 1604, 'Select staff'),
(3210, 0, 1605, 'List count should be numeric'),
(3211, 1, 1605, 'List count should be numeric'),
(3212, 0, 1606, 'Active'),
(3213, 1, 1606, 'Active'),
(3214, 0, 1607, 'Pending'),
(3215, 1, 1607, 'Pending'),
(3216, 0, 1608, 'Incomplete'),
(3217, 1, 1608, 'Incomplete'),
(3218, 0, 1609, 'Invoice due on (days)'),
(3219, 1, 1609, 'Invoice due on (days)'),
(3220, 0, 1610, 'Numeric value required for invoice due on (days) field'),
(3221, 1, 1610, 'Numeric value required for invoice due on (days) field'),
(3222, 0, 1611, 'Numeric value required for bill rate field'),
(3223, 1, 1611, 'Numeric value required for bill rate field'),
(3224, 0, 1612, 'Overview'),
(3225, 1, 1612, 'Overview'),
(3226, 0, 1613, 'Total tickets'),
(3227, 1, 1613, 'Total tickets'),
(3228, 0, 1614, 'Tickets per hour'),
(3229, 1, 1614, 'Tickets per hour'),
(3230, 0, 1615, 'Total tickets replied'),
(3231, 1, 1615, 'Total tickets replied'),
(3232, 0, 1616, 'Tickets replied per hour'),
(3233, 1, 1616, 'Tickets replied per hour'),
(3234, 0, 1617, 'Total tickets closed'),
(3235, 1, 1617, 'Total tickets closed'),
(3236, 0, 1618, 'Tickets closed per hour'),
(3237, 1, 1618, 'Tickets closed per hour'),
(3238, 0, 1619, 'Total overdue tickets'),
(3239, 1, 1619, 'Total overdue tickets'),
(3240, 0, 1620, 'Avg. SLA maintained'),
(3241, 1, 1620, 'Avg. SLA maintained'),
(3242, 0, 1621, 'Yesterday'),
(3243, 1, 1621, 'Yesterday'),
(3244, 0, 1622, 'Selfhelp article'),
(3245, 1, 1622, 'Solutions article'),
(3246, 0, 1623, 'Tickets by status'),
(3247, 1, 1623, 'Tickets by status'),
(3248, 0, 1624, 'Text'),
(3249, 1, 1624, 'Text'),
(3250, 0, 1625, 'Last month'),
(3251, 1, 1625, 'Last month'),
(3252, 0, 1626, 'Last week'),
(3253, 1, 1626, 'Last week'),
(3254, 0, 1627, 'Credit should be numeric'),
(3255, 1, 1627, 'Credit should be numeric'),
(3256, 0, 1628, '<div class="alert-success">Password reseted and new password sent to client<div>'),
(3257, 1, 1628, '<div class="alert-success">Password reset and new password sent to client</div>'),
(3258, 0, 1629, 'Please select domain'),
(3259, 1, 1629, 'Please select domain'),
(3260, 0, 1630, 'Locked'),
(3261, 1, 1630, 'Locked'),
(3262, 0, 1631, 'Unlocked'),
(3263, 1, 1631, 'Unlocked'),
(3264, 0, 1632, 'Client language'),
(3265, 1, 1632, 'Client language'),
(3266, 0, 1633, 'To email'),
(3267, 1, 1633, 'To email'),
(3268, 0, 1634, 'Delete pin'),
(3269, 1, 1634, 'Delete pin'),
(3270, 0, 1635, 'Tickets can not move from one domain to other domain'),
(3271, 1, 1635, 'Tickets can not move from one domain to other domain'),
(3272, 0, 1636, 'Send to'),
(3273, 1, 1636, 'Send to'),
(3274, 0, 1637, 'All team'),
(3275, 1, 1637, 'All teams'),
(3276, 0, 1638, 'More'),
(3277, 1, 1638, 'More'),
(3278, 0, 1639, 'Assigned to'),
(3280, 0, 1640, 'Assigned to'),
(3281, 1, 1640, 'Assigned to'),
(3282, 0, 1641, 'Enter ticket hash to merge'),
(3283, 1, 1641, 'Enter ticket hash to merge'),
(3284, 0, 1642, 'Enter ticket hash for link'),
(3285, 1, 1642, 'Enter ticket hash for link'),
(3286, 0, 1643, 'Multiple owners'),
(3287, 1, 1643, 'Multiple owners'),
(3288, 0, 1644, 'Owners'),
(3289, 1, 1644, 'Owners'),
(3290, 0, 1645, 'Send notification for new blab'),
(3291, 1, 1645, 'Send notification for new blab'),
(3292, 0, 1646, 'Client group tickets'),
(3293, 1, 1646, 'Client group tickets'),
(3294, 0, 1647, 'Change label'),
(3295, 1, 1647, 'Change label'),
(3296, 0, 1648, 'Change channel'),
(3297, 1, 1648, 'Change channel'),
(3298, 0, 1649, 'Tickets from different domain can not be merged'),
(3299, 1, 1649, 'Tickets belonging to other domain should not get merged'),
(3300, 0, 1650, 'Staff name'),
(3301, 1, 1650, 'Staff name'),
(3302, 0, 1651, 'Time track'),
(3303, 1, 1651, 'Time track'),
(3304, 0, 1652, 'Forwarded to'),
(3305, 1, 1652, 'Forwarded to'),
(3306, 0, 1653, 'To'),
(3307, 1, 1653, 'To'),
(3308, 0, 1654, 'Replied to'),
(3309, 1, 1654, 'Replied to'),
(3310, 0, 1655, 'Security'),
(3311, 1, 1655, 'Security'),
(3312, 0, 1656, 'Send registration email'),
(3313, 1, 1656, 'Send registration email'),
(3314, 0, 1657, 'One option value should be required'),
(3315, 1, 1657, 'One option value should be required'),
(3316, 0, 1658, 'Auto generate password'),
(3317, 1, 1658, 'Auto generate password'),
(3318, 0, 1659, 'Add security'),
(3319, 1, 1659, 'Add security'),
(3320, 0, 1660, 'IP security'),
(3321, 1, 1660, 'IP security'),
(3322, 0, 1661, 'Password security'),
(3323, 1, 1661, 'Password security'),
(3324, 0, 1662, 'Is security IP active?'),
(3325, 1, 1662, 'Staff login IP restriction'),
(3326, 0, 1663, 'Is IP range?'),
(3352, 0, 1676, 'Add IP or range'),
(3328, 0, 1664, 'Single'),
(3329, 1, 1664, 'Single'),
(3330, 0, 1665, 'Multiple'),
(3332, 0, 1666, 'Range'),
(3333, 1, 1666, 'Range'),
(3334, 0, 1667, 'From'),
(3335, 1, 1667, 'From'),
(3336, 0, 1668, 'To'),
(3337, 1, 1668, 'To'),
(3338, 0, 1669, 'Password length'),
(3339, 1, 1669, 'Password strength'),
(3340, 0, 1670, 'Password format'),
(3341, 1, 1670, 'Password format'),
(3342, 0, 1671, 'Show password'),
(3343, 1, 1671, 'Show password'),
(3344, 0, 1672, 'Image verification missmatch'),
(3345, 1, 1672, 'Image verification mismatch'),
(3346, 0, 1673, 'Display custom fileds on ticket details'),
(3347, 1, 1673, 'Display custom fields on ticket details'),
(3348, 0, 1674, 'Required field article URL'),
(3349, 1, 1674, 'Required field article URL'),
(3350, 0, 1675, 'More than one post required for split'),
(3351, 1, 1675, 'More than one post required for split'),
(3368, 0, 1684, 'Macros'),
(3354, 0, 1677, 'Add IP or range'),
(3355, 1, 1677, 'Add IP or IP range'),
(3356, 0, 1678, '(Ex. 198.168.1.10-198.168.1.50)'),
(3357, 1, 1678, '(Range eg. 78.68.1.10-78.68.1.50)'),
(3358, 0, 1679, 'IP or IP range'),
(3359, 1, 1679, 'Allowed IP or IP range'),
(3360, 0, 1680, 'Delete security'),
(3361, 1, 1680, 'Delete security'),
(3362, 0, 1681, 'Invalid IP range'),
(3363, 1, 1681, 'Invalid IP address range'),
(3364, 0, 1682, 'Invalid IP address'),
(3365, 1, 1682, 'Invalid IP address'),
(3366, 0, 1683, 'Your IP address is blocked!'),
(3367, 1, 1683, 'Access denied for your IP'),
(3369, 1, 1684, 'Macros'),
(3370, 0, 1685, 'Add macro'),
(3371, 1, 1685, 'Add macro'),
(3372, 0, 1686, 'Update macro'),
(3373, 1, 1686, 'Update macro'),
(3374, 0, 1687, 'IP or IP range'),
(3378, 0, 1689, 'Apply macro'),
(3376, 0, 1688, 'IP or IP range list'),
(3377, 1, 1688, 'IP or IP range list'),
(3379, 1, 1689, 'Apply macro'),
(3380, 0, 1690, 'Password strength'),
(3381, 1, 1690, 'Password strength'),
(3382, 0, 1691, 'Weak'),
(3390, 0, 1695, 'Weak'),
(3384, 0, 1692, 'Medium'),
(3391, 1, 1695, 'Weak'),
(3386, 0, 1693, 'Strong'),
(3387, 1, 1693, 'Strong'),
(3388, 0, 1694, 'Very strong'),
(3389, 1, 1694, 'Very strong'),
(3392, 0, 1696, 'Allowed'),
(3393, 1, 1696, 'Allowed'),
(3394, 0, 1697, 'Not allowed'),
(3395, 1, 1697, 'Not allowed'),
(3396, 0, 1698, 'Password strength not allowed'),
(3397, 1, 1698, 'Password strength not allowed'),
(3398, 0, 1699, 'Password strength'),
(3399, 1, 1699, 'Password strength'),
(3400, 0, 1700, 'Weak'),
(3401, 1, 1700, 'Weak'),
(3402, 0, 1701, 'Medium'),
(3403, 1, 1701, 'Medium'),
(3404, 0, 1702, 'Strong'),
(3405, 1, 1702, 'Strong'),
(3406, 0, 1703, 'Very strong'),
(3407, 1, 1703, 'Very strong'),
(3408, 0, 1704, 'Not allowed'),
(3409, 1, 1704, 'Not allowed'),
(3410, 0, 1705, 'Allowed'),
(3411, 1, 1705, 'Allowed'),
(3412, 0, 1706, 'Password strength not allowed'),
(3413, 1, 1706, 'Password strength not allowed'),
(3414, 0, 1707, 'Gmail'),
(3416, 0, 1708, 'Gmail'),
(3417, 1, 1708, 'Gmail'),
(3418, 0, 1709, 'Active directory'),
(3419, 1, 1709, 'Active directory'),
(3420, 0, 1710, 'Display settings'),
(3421, 1, 1710, 'Display settings'),
(3422, 0, 1711, 'Show priority'),
(3423, 1, 1711, 'Show priority'),
(3424, 0, 1712, 'Show priority'),
(3425, 1, 1712, 'Show priority'),
(3426, 0, 1713, 'Show ticket type'),
(3427, 1, 1713, 'Show ticket type'),
(3428, 0, 1714, 'Show staff name'),
(3429, 1, 1714, 'Show staff name'),
(3430, 0, 1715, 'APP secret'),
(3431, 1, 1715, 'APP secret'),
(3432, 0, 1716, 'Redirect URL'),
(3433, 1, 1716, 'Redirect URL'),
(3434, 0, 1717, 'SLA'),
(3435, 1, 1717, 'Show SLA'),
(3436, 0, 1718, 'Developer key'),
(3437, 1, 1718, 'Developer key'),
(3438, 0, 1719, 'Activity'),
(3440, 0, 1720, 'Activity'),
(3441, 1, 1720, 'Activity log'),
(3442, 0, 1721, 'Activity'),
(3444, 0, 1722, 'Activity'),
(3445, 1, 1722, 'Activity'),
(3446, 0, 1723, 'Empty activity log'),
(3447, 1, 1723, 'Empty activity log'),
(3448, 0, 1724, 'Survey'),
(3449, 1, 1724, 'Survey'),
(3450, 0, 1725, 'Survey group'),
(3451, 1, 1725, 'Survey group'),
(3452, 0, 1726, 'Add survey group'),
(3453, 1, 1726, 'Add survey'),
(3454, 0, 1727, 'Update survey group'),
(3455, 1, 1727, 'Update survey'),
(3456, 0, 1728, 'Delete survey group'),
(3457, 1, 1728, 'Delete survey'),
(3458, 0, 1729, 'Deletion of survey group will delete survey in this survey group'),
(3459, 1, 1729, 'Deletion of survey group will delete survey in this survey group'),
(3460, 0, 1730, 'Deletion of survey group will delete survey in this survey group'),
(3461, 1, 1730, 'Deletion of survey will delete survey fields in this survey'),
(3462, 0, 1731, 'Add survey'),
(3463, 1, 1731, 'Add survey'),
(3464, 0, 1732, 'Testing purpose'),
(3468, 0, 1734, 'Testing testing'),
(3466, 0, 1733, 'Update survey'),
(3467, 1, 1733, 'Update survey'),
(3470, 0, 1735, 'Delete survey'),
(3471, 1, 1735, 'Delete survey'),
(3472, 0, 1736, 'Survey field'),
(3473, 1, 1736, 'Survey field'),
(3474, 0, 1737, 'Add survey field'),
(3475, 1, 1737, 'Add survey field'),
(3476, 0, 1738, 'Delete survey field'),
(3477, 1, 1738, 'Delete survey field'),
(3478, 0, 1739, 'Update survey field'),
(3479, 1, 1739, 'Update survey field'),
(3480, 0, 1740, 'LiveChat'),
(3481, 1, 1740, 'Livechat'),
(3482, 0, 1741, 'Survey'),
(3483, 1, 1741, 'Survey'),
(3484, 0, 1742, 'You have already submited survey'),
(3485, 1, 1742, 'You have already submited survey'),
(3486, 0, 1743, 'Name'),
(3487, 1, 1743, 'Name'),
(3488, 0, 1744, 'Visitor'),
(3489, 1, 1744, 'Visitor'),
(3490, 0, 1745, 'Chats'),
(3508, 0, 1754, 'Password and confrm password miss match'),
(3492, 0, 1746, 'Chat details'),
(3493, 1, 1746, 'Chat details'),
(3494, 0, 1747, 'Chat transcript'),
(3495, 1, 1747, 'Chat transcript'),
(3496, 0, 1748, 'Conversations'),
(3498, 0, 1749, 'Conversations'),
(3499, 1, 1749, 'Conversations'),
(3500, 0, 1750, 'Chat URL'),
(3502, 0, 1751, 'Agent'),
(3504, 0, 1752, 'Duration'),
(3509, 1, 1754, 'Password and confirm password mismatch'),
(3506, 0, 1753, 'Chat'),
(3507, 1, 1753, 'Chat'),
(3510, 0, 1755, 'Script'),
(3512, 0, 1756, 'Script'),
(3513, 1, 1756, 'Script'),
(3514, 0, 1757, 'Date from'),
(3515, 1, 1757, 'Date from'),
(3516, 0, 1758, 'Date to'),
(3517, 1, 1758, 'Date to'),
(3518, 0, 1759, 'Visitor email'),
(3519, 1, 1759, 'Visitor email'),
(3520, 0, 1760, 'Visitor name'),
(3521, 1, 1760, 'Visitor name'),
(3522, 0, 1761, 'Staff name'),
(3523, 1, 1761, 'Staff name'),
(3524, 0, 1762, 'Chat duration'),
(3525, 1, 1762, 'Chat duration'),
(3526, 0, 1763, 'Select module'),
(3527, 1, 1763, 'Select module'),
(3528, 0, 1764, 'Email address missing or invalid email format'),
(3529, 1, 1764, 'Invalid email or email address missing'),
(3530, 0, 1765, 'Invalid login details'),
(3531, 1, 1765, 'Invalid login details'),
(3532, 0, 1766, 'System clean up'),
(3533, 1, 1766, 'Clean up'),
(3534, 0, 1767, 'Convert to ticket'),
(3535, 1, 1767, 'Convert to ticket'),
(3536, 0, 1768, 'System clean up'),
(3537, 1, 1768, 'System clean up'),
(3538, 0, 1769, 'Clean logs before'),
(3539, 1, 1769, 'Clean logs before'),
(3540, 0, 1770, 'Client email missing'),
(3541, 1, 1770, 'Client email missing'),
(3542, 0, 1771, 'This will empty the error log file'),
(3543, 1, 1771, 'This will empty the error log file'),
(3544, 0, 1772, 'Remove parser log before selected date'),
(3545, 1, 1772, 'Remove parser log before selected date'),
(3546, 0, 1773, 'Remove sent email log before selected date'),
(3547, 1, 1773, 'Remove sent email log before selected date'),
(3548, 0, 1774, 'Remove gateway transactions log before selected date'),
(3549, 1, 1774, 'Remove gateway transactions log before selected date'),
(3550, 0, 1775, 'Remove activity log before selected date'),
(3551, 1, 1775, 'Remove activity log before selected date'),
(3552, 0, 1776, 'This will remove tickets audit log before selected date leaving tickets as it is'),
(3553, 1, 1776, 'This will remove tickets audit log before selected date leaving tickets as it is'),
(3554, 0, 1777, 'First name missing'),
(3555, 1, 1777, 'First name missing'),
(3556, 0, 1778, 'Required filed date'),
(3557, 1, 1778, 'Required field date'),
(3558, 0, 1779, 'Required field password'),
(3559, 1, 1779, 'Required field password'),
(3560, 0, 1780, 'Report'),
(3561, 1, 1780, 'Report'),
(3562, 0, 1781, 'Survey is disabled or removed.'),
(3563, 1, 1781, 'Survey is disabled or removed.'),
(3564, 0, 1782, 'Survey is disabled or removed.'),
(3565, 1, 1782, 'Survey is disabled or removed.'),
(3566, 0, 1783, 'Checkout'),
(3567, 1, 1783, 'Checkout'),
(3568, 0, 1784, 'Selected product'),
(3569, 1, 1784, 'Selected package'),
(3570, 0, 1785, 'Subtotal'),
(3571, 1, 1785, 'Subtotal'),
(3572, 0, 1786, 'Livezilla'),
(3573, 1, 1786, 'Livezilla'),
(3574, 0, 1787, 'Select survey'),
(3575, 1, 1787, 'Select survey'),
(3576, 0, 1788, 'Please select survey'),
(3577, 1, 1788, 'Please select survey'),
(3578, 0, 1789, 'Task title'),
(3579, 1, 1789, 'Task title'),
(3580, 0, 1790, 'Import'),
(3581, 1, 1790, 'Import'),
(3582, 0, 1791, 'File type must be CSV'),
(3583, 1, 1791, 'File type must be CSV'),
(3584, 0, 1792, 'Select CSV'),
(3585, 1, 1792, 'Upload CSV'),
(3586, 0, 1793, 'Access denied'),
(3587, 1, 1793, 'Access denied'),
(3588, 0, 1794, 'Search string'),
(3589, 1, 1794, 'Search string'),
(3590, 0, 1795, 'Click here'),
(3591, 1, 1795, 'Click here'),
(3592, 0, 1796, 'Set schedule'),
(3593, 1, 1796, 'Set schedule'),
(3594, 0, 1797, 'Send login details to staff'),
(3595, 1, 1797, 'Send staff registration email'),
(3596, 0, 1798, 'Do not send email'),
(3597, 1, 1798, 'Do not send email'),
(3598, 0, 1799, 'Select client'),
(3599, 1, 1799, 'Select client'),
(3600, 0, 1800, 'GoToMeeting'),
(3601, 1, 1800, 'GoToMeeting'),
(3602, 0, 1801, 'Fields not selected'),
(3603, 1, 1801, 'Fields not selected'),
(3604, 0, 1802, 'Survey date'),
(3605, 1, 1802, 'Survey date'),
(3606, 0, 1803, 'Callback URL'),
(3608, 0, 1804, 'Callback URL'),
(3609, 1, 1804, 'Callback URL'),
(3610, 0, 1805, 'Survey details'),
(3611, 1, 1805, 'Survey details'),
(3612, 0, 1806, 'UserLike'),
(3613, 1, 1806, 'UserLike'),
(3614, 0, 1807, 'Mark as complete'),
(3615, 1, 1807, 'Mark as complete'),
(3616, 0, 1808, 'API token'),
(3617, 1, 1808, 'API token'),
(3618, 0, 1809, 'Or'),
(3619, 1, 1809, 'Or'),
(3620, 0, 1810, 'Edit custom field'),
(3621, 1, 1810, 'Edit custom field'),
(3622, 0, 1811, 'Not specified'),
(3623, 1, 1811, 'Not specified'),
(3624, 0, 1812, 'Chat URL'),
(3625, 1, 1812, 'Chat URL'),
(3626, 0, 1813, 'Meeting ID'),
(3627, 1, 1813, 'Meeting ID'),
(3628, 0, 1814, 'Conference call info'),
(3716, 0, 1858, 'Conference call information'),
(3630, 0, 1815, 'Max participants'),
(3631, 1, 1815, 'Max participants'),
(3632, 0, 1816, 'Meeting key'),
(3633, 1, 1816, 'Meeting key'),
(3634, 0, 1817, 'Meeting type'),
(3635, 1, 1817, 'Meeting type'),
(3636, 0, 1818, 'Meeting unique key'),
(3637, 1, 1818, 'Meeting unique key'),
(3638, 0, 1819, 'Add meeting'),
(3639, 1, 1819, 'Add meeting'),
(3640, 0, 1820, 'Password required'),
(3641, 1, 1820, 'Password required'),
(3642, 0, 1821, 'Immediate'),
(3643, 1, 1821, 'Immediate'),
(3644, 0, 1822, 'Scheduled'),
(3646, 0, 1823, 'Scheduled'),
(3647, 1, 1823, 'Scheduled'),
(3648, 0, 1824, 'Remote access'),
(3649, 1, 1824, 'Remote access'),
(3650, 0, 1825, 'GoToAssist'),
(3651, 1, 1825, 'GoToAssist'),
(3652, 0, 1826, 'TeamViewer'),
(3688, 0, 1844, 'TeamViewer'),
(3654, 0, 1827, 'Comm100'),
(3655, 1, 1827, 'Comm100'),
(3656, 0, 1828, 'Integration APP'),
(3657, 1, 1828, 'Integration APP'),
(3658, 0, 1829, 'Select APP'),
(3659, 1, 1829, 'Select APP'),
(3660, 0, 1830, 'Download'),
(3661, 1, 1830, 'Download'),
(3662, 0, 1831, 'Next overdue tickets'),
(3663, 1, 1831, 'Next overdue tickets'),
(3664, 0, 1832, '15 minutes'),
(3665, 1, 1832, '15 minutes'),
(3666, 0, 1833, '30 minutes'),
(3667, 1, 1833, '30 minutes'),
(3668, 0, 1834, '60 minutes'),
(3669, 1, 1834, '60 minutes'),
(3670, 0, 1835, '1 day'),
(3671, 1, 1835, '1 day'),
(3672, 0, 1836, 'Task'),
(3673, 1, 1836, 'Task'),
(3674, 0, 1837, 'Today''s task'),
(3675, 1, 1837, 'Today''s task'),
(3676, 0, 1838, 'My task'),
(3677, 1, 1838, 'My task'),
(3678, 0, 1839, 'Assigned task'),
(3679, 1, 1839, 'Assigned task'),
(3680, 0, 1840, 'Overdue task'),
(3681, 1, 1840, 'Overdue task'),
(3682, 0, 1841, 'sd'),
(3683, 1, 1841, 'sd'),
(3684, 0, 1842, 'Marked as cancel'),
(3685, 1, 1842, 'Mark as cancel'),
(3686, 0, 1843, 'TeamViewer'),
(3689, 1, 1844, 'TeamViewer'),
(3690, 0, 1845, 'Update task'),
(3691, 1, 1845, 'Update task'),
(3692, 0, 1846, 'This task is already mark as cancelled'),
(3693, 1, 1846, 'This task is already mark as cancelled'),
(3694, 0, 1847, 'This task is already mark as completed'),
(3695, 1, 1847, 'This task is already mark as completed'),
(3696, 0, 1848, 'Delete meeting'),
(3698, 0, 1849, 'Delete meeting'),
(3699, 1, 1849, 'Delete meeting'),
(3700, 0, 1850, 'Status of task is overdue'),
(3701, 1, 1850, 'Status of task is overdue'),
(3702, 0, 1851, 'Add session'),
(3704, 0, 1852, 'Add session'),
(3705, 1, 1852, 'Add session'),
(3706, 0, 1853, 'Add user'),
(3707, 1, 1853, 'Add user'),
(3708, 0, 1854, 'View and manage invoices, orders, packages'),
(3709, 1, 1854, 'View and manage invoices, orders, packages'),
(3710, 0, 1855, 'Participant web link'),
(3711, 1, 1855, 'Participant web link'),
(3712, 0, 1856, 'Search task'),
(3713, 1, 1856, 'Search task'),
(3714, 0, 1857, 'Conference call information'),
(3715, 1, 1857, 'Conference call information'),
(3717, 1, 1858, 'Conference call information'),
(3718, 0, 1859, 'Conference call information'),
(3719, 1, 1859, 'Conference call information'),
(3720, 0, 1860, 'Enter task title in search box'),
(3721, 1, 1860, 'Enter task title in search box'),
(3722, 0, 1861, 'View and manage invoices, orders, packages'),
(3723, 1, 1861, 'View and manage invoices, orders, packages'),
(3724, 0, 1862, 'Create meeting'),
(3725, 1, 1862, 'Create meeting'),
(3726, 0, 1863, 'Create seesion'),
(3727, 1, 1863, 'Create session'),
(3728, 0, 1864, 'Seesion'),
(3729, 1, 1864, 'Session'),
(3730, 0, 1865, 'Meetings'),
(3731, 1, 1865, 'Meetings'),
(3732, 0, 1866, 'Meeting'),
(3733, 1, 1866, 'Meetings'),
(3734, 0, 1867, 'Join URL'),
(3735, 1, 1867, 'Join URL'),
(3736, 0, 1868, 'Join date'),
(3737, 1, 1868, 'Join date'),
(3738, 0, 1869, 'Add assist'),
(3739, 1, 1869, 'Add assist'),
(3740, 0, 1870, 'My favourites'),
(3741, 1, 1870, 'My favourites'),
(3742, 0, 1871, 'Custom data'),
(3743, 1, 1871, 'Custom data'),
(3744, 0, 1872, 'Copy to clipboard'),
(3745, 1, 1872, 'Select to copy'),
(3746, 0, 1873, 'Group ID'),
(3747, 1, 1873, 'Group ID'),
(3748, 0, 1874, 'Set as featured article'),
(3749, 1, 1874, 'Set as featured article'),
(3750, 0, 1875, 'Delete session'),
(3751, 1, 1875, 'Delete session'),
(3752, 0, 1876, 'Assigned user ID'),
(3753, 1, 1876, 'Assigned user ID'),
(3754, 0, 1877, 'Assigned at'),
(3755, 1, 1877, 'Assigned at'),
(3756, 0, 1878, 'End customer link'),
(3757, 1, 1878, 'End customer link'),
(3758, 0, 1879, 'Supporter link'),
(3759, 1, 1879, 'Supporter link'),
(3760, 0, 1880, 'Created at'),
(3761, 1, 1880, 'Created at'),
(3762, 0, 1881, 'Valid until'),
(3763, 1, 1881, 'Valid until'),
(3764, 0, 1882, 'Goto assist session'),
(3766, 0, 1883, 'Goto assist session'),
(3767, 1, 1883, 'Goto assist session'),
(3768, 0, 1884, 'Session token'),
(3769, 1, 1884, 'Session token'),
(3770, 0, 1885, 'Required field category'),
(3771, 1, 1885, 'Required field category'),
(3772, 0, 1886, 'Client username already exist'),
(3773, 1, 1886, 'Client username already exists'),
(3774, 0, 1887, 'Clientexec'),
(3775, 1, 1887, 'Clientexec'),
(3776, 0, 1888, 'Search state'),
(3777, 1, 1888, 'Search state'),
(3778, 0, 1889, 'Expert name'),
(3779, 1, 1889, 'Expert name'),
(3780, 0, 1890, 'Expert email'),
(3781, 1, 1890, 'Expert email'),
(3782, 0, 1891, 'Merge into'),
(3783, 1, 1891, 'Merge into'),
(3784, 0, 1892, 'Reset password'),
(3785, 1, 1892, 'Reset password'),
(3786, 0, 1893, 'Linkedin'),
(3788, 0, 1894, 'LinkedIn'),
(3789, 1, 1894, 'LinkedIn'),
(3790, 0, 1895, 'Unassigned'),
(3791, 1, 1895, 'Nobody'),
(3792, 0, 1896, 'Download queue'),
(3793, 1, 1896, 'Download queue'),
(3794, 0, 1897, 'Add report in download queue'),
(3796, 0, 1898, 'Add report in download queue'),
(3797, 1, 1898, 'Request report'),
(3798, 0, 1899, 'Wordpress'),
(3799, 1, 1899, 'Wordpress'),
(3800, 0, 1900, 'Report title'),
(3801, 1, 1900, 'Report title'),
(3802, 0, 1901, 'Delete selfhelp comment'),
(3803, 1, 1901, 'Delete solutions comment'),
(3804, 0, 1902, 'Completed date'),
(3805, 1, 1902, 'Completed date'),
(3806, 0, 1903, 'WebEx'),
(3807, 1, 1903, 'WebEx'),
(3808, 0, 1904, 'Are you sure you want to proceed?'),
(3809, 1, 1904, 'Are you sure you want to proceed?'),
(3810, 0, 1905, 'Client username already exist'),
(3811, 1, 1905, 'Username already exists'),
(3812, 0, 1906, 'Delete WebEx meeting'),
(3813, 1, 1906, 'Delete WebEx meeting'),
(3814, 0, 1907, 'Site ID'),
(3815, 1, 1907, 'Site ID'),
(3816, 0, 1908, 'Partner ID'),
(3817, 1, 1908, 'Partner ID'),
(3818, 0, 1909, 'Drupal'),
(3819, 1, 1909, 'Drupal'),
(3820, 0, 1910, 'Total posts count'),
(3821, 1, 1910, 'Total posts count'),
(3822, 0, 1911, 'Total tickets replied'),
(3823, 1, 1911, 'Total tickets replied'),
(3824, 0, 1912, 'Total avg. response time'),
(3825, 1, 1912, 'Total avg. response time'),
(3826, 0, 1913, 'Total avg. SLA maintained'),
(3827, 1, 1913, 'Total avg. SLA maintained'),
(3828, 0, 1914, 'Total avg. SLA time'),
(3829, 1, 1914, 'Total avg. SLA time'),
(3830, 0, 1915, 'Total avg. resolve time'),
(3831, 1, 1915, 'Total avg. resolve time'),
(3832, 0, 1916, 'Worst'),
(3833, 1, 1916, 'Worst'),
(3834, 0, 1917, 'Normal'),
(3835, 1, 1917, 'Normal'),
(3836, 0, 1918, 'Good'),
(3837, 1, 1918, 'Good'),
(3838, 0, 1919, 'Better'),
(3839, 1, 1919, 'Better'),
(3840, 0, 1920, 'Best'),
(3841, 1, 1920, 'Best'),
(3842, 0, 1921, 'Total bill time'),
(3843, 1, 1921, 'Total bill time'),
(3844, 0, 1922, 'Total work time'),
(3845, 1, 1922, 'Total work time'),
(3846, 0, 1923, 'Total amount'),
(3847, 1, 1923, 'Total amount'),
(3848, 0, 1924, 'Survey url to add in email template'),
(3849, 1, 1924, 'Survey url to add in email template'),
(3850, 0, 1925, 'SugarCRM'),
(3851, 1, 1925, 'SugarCRM'),
(3852, 0, 1926, 'Article ID not found'),
(3853, 1, 1926, 'Article ID not found'),
(3854, 0, 1927, 'Site URL'),
(3872, 0, 1936, 'Sugarcrm site URL'),
(3856, 0, 1928, 'Maximum image upload width is 1000 px'),
(3857, 1, 1928, 'Maximum image upload width is 1000 px'),
(3858, 0, 1929, 'Report name missing'),
(3859, 1, 1929, 'Report name missing'),
(3860, 0, 1930, 'Please select from date and to date'),
(3861, 1, 1930, 'Please select custom date'),
(3862, 0, 1931, 'Select multiple tickets to link'),
(3870, 0, 1935, 'Select multiple tickets to link'),
(3864, 0, 1932, 'Select fields for generate'),
(3865, 1, 1932, 'Select fields for generate'),
(3866, 0, 1933, 'Select staff for generate'),
(3867, 1, 1933, 'Select staff for generate'),
(3868, 0, 1934, 'Select duration for generate'),
(3869, 1, 1934, 'Select duration for generate'),
(3871, 1, 1935, 'Select multiple tickets to link'),
(3873, 1, 1936, 'SugarCRM site URL'),
(3874, 0, 1937, 'Select department for genearte'),
(3875, 1, 1937, 'Select department for generate'),
(3876, 0, 1938, 'Select domain for result'),
(3877, 1, 1938, 'Select domain for result'),
(3878, 0, 1939, 'HostBill'),
(3880, 0, 1940, 'HostBill'),
(3881, 1, 1940, 'HostBill'),
(3882, 0, 1941, 'Closed tickets'),
(3883, 1, 1941, 'Closed tickets'),
(3884, 0, 1942, 'Select client for generate'),
(3885, 1, 1942, 'Select client for generate'),
(3886, 0, 1943, 'Select organization'),
(3887, 1, 1943, 'Select organization'),
(3888, 0, 1944, 'Twilio'),
(3889, 1, 1944, 'Twilio'),
(3896, 0, 1948, 'Organizations tickets'),
(3890, 0, 1945, 'Account sid'),
(3891, 1, 1945, 'Account sid'),
(3892, 0, 1946, 'Auth token'),
(3893, 1, 1946, 'Auth token'),
(3894, 0, 1947, 'APPs sid'),
(3895, 1, 1947, 'APPs sid'),
(3897, 1, 1948, 'Organization tickets'),
(3898, 0, 1949, 'Operation date'),
(3899, 1, 1949, 'Operation date'),
(3900, 0, 1950, 'Content'),
(3901, 1, 1950, 'Content'),
(3902, 0, 1951, 'Client survey'),
(3903, 1, 1951, 'Client survey'),
(3904, 0, 1952, 'Ticket feedback per client'),
(3905, 1, 1952, 'Ticket feedback per client'),
(3906, 0, 1953, 'Required field title'),
(3907, 1, 1953, 'Required field title'),
(3908, 0, 1954, 'Call'),
(3909, 1, 1954, 'Call'),
(3910, 0, 1955, 'Seconds'),
(3911, 1, 1955, 'Seconds'),
(3912, 0, 1956, 'Price unit'),
(3913, 1, 1956, 'Price unit'),
(3914, 0, 1957, 'Recording'),
(3915, 1, 1957, 'Recording'),
(3916, 0, 1958, 'Incoming'),
(3917, 1, 1958, 'Incoming'),
(3918, 0, 1959, 'Outgoing'),
(3919, 1, 1959, 'Outgoing'),
(3920, 0, 1960, 'Call details'),
(3921, 1, 1960, 'Call details'),
(3922, 0, 1961, 'Twilio message'),
(3923, 1, 1961, 'Twilio message'),
(3924, 0, 1962, 'Send date'),
(3925, 1, 1962, 'Send date'),
(3926, 0, 1963, 'Message details'),
(3927, 1, 1963, 'Message details'),
(3928, 0, 1964, 'Update date'),
(3929, 1, 1964, 'Update date'),
(3930, 0, 1965, 'Send date'),
(3931, 1, 1965, 'Send date'),
(3932, 0, 1966, 'Send message'),
(3933, 1, 1966, 'Send message'),
(3934, 0, 1967, 'Hangup'),
(3935, 1, 1967, 'Hangup'),
(3936, 0, 1968, 'Call list'),
(3937, 1, 1968, 'Call list'),
(3942, 0, 1971, 'Balance'),
(3943, 1, 1971, 'Balance'),
(3944, 0, 1972, 'Resolution time'),
(3945, 1, 1972, 'Resolution time'),
(3946, 0, 1973, 'Response time'),
(3947, 1, 1973, 'Response time'),
(3948, 0, 1974, 'Offline payment'),
(3949, 1, 1974, 'Offline payment'),
(3950, 0, 1975, 'Offline payment'),
(3951, 1, 1975, 'Offline payment'),
(3952, 0, 1976, 'Payment gateway'),
(3953, 1, 1976, 'Payment gateway'),
(3954, 0, 1977, 'Paypal'),
(3955, 1, 1977, 'Paypal'),
(3956, 0, 1978, 'Authorize.net'),
(3957, 1, 1978, 'Authorize.net'),
(3958, 0, 1979, 'Payment method'),
(3959, 1, 1979, 'Payment method'),
(3960, 0, 1980, 'Back'),
(3964, 0, 1982, 'Credit'),
(3962, 0, 1981, 'Leaderboard'),
(3963, 1, 1981, 'Leaderboard'),
(3965, 1, 1982, 'Credit'),
(3966, 0, 1983, 'How can we help?'),
(3967, 1, 1983, 'How can we help you?'),
(3969, 0, 1985, 'Configuration item type'),
(3968, 0, 1984, 'ITIL'),
(3970, 0, 1986, 'Impact'),
(3971, 0, 1987, 'Add impact'),
(3972, 0, 1988, 'Delete configuration item type'),
(3973, 0, 1989, 'Update impact'),
(3974, 0, 1990, 'Update item'),
(3975, 0, 1991, 'Language translation for impact name'),
(3976, 0, 1992, 'Delete impact'),
(3977, 0, 1993, 'Add risk'),
(3978, 0, 1994, 'Risk'),
(3979, 0, 1995, 'Update risk'),
(3980, 0, 1996, 'Language translation for risk name'),
(3981, 0, 1997, 'Required field name'),
(3982, 0, 1998, 'Required field color'),
(3983, 0, 1999, 'Required field description'),
(3984, 0, 2000, 'Delete risk'),
(3985, 0, 2001, 'Delete change type'),
(3986, 0, 2002, 'Add change type'),
(3987, 0, 2003, 'Update change type'),
(3988, 0, 2004, 'Release type'),
(3989, 0, 2005, 'Delete release type'),
(3990, 0, 2006, 'Update release type'),
(3991, 0, 2007, 'Add release type'),
(3992, 0, 2008, 'Contract type'),
(3993, 0, 2009, 'Asset state'),
(3994, 0, 2010, 'Add asset state'),
(3995, 0, 2011, 'Update asset state'),
(3996, 0, 2012, 'Delete asset state'),
(3997, 0, 2013, 'Request stage'),
(3998, 0, 2014, 'Add contract type'),
(3999, 0, 2015, 'Update contract type'),
(4000, 0, 2016, 'Vendor'),
(4001, 0, 2017, 'Add vendor'),
(4002, 0, 2018, 'Update vendor'),
(4003, 0, 2019, 'Delete vendor'),
(4004, 0, 2020, 'Language translation for vendor'),
(4005, 0, 2021, 'Language translation for release type'),
(4006, 0, 2022, 'Language translation for asset state'),
(4007, 0, 2023, 'Language translation for change type'),
(4008, 0, 2024, 'Language translation for contract type'),
(4009, 0, 2025, 'Primary contact'),
(4010, 0, 2026, 'Required field primary contact'),
(4011, 0, 2027, 'Required field address'),
(4012, 0, 2028, 'Delete request stage'),
(4013, 0, 2029, 'Add request stage'),
(4014, 0, 2030, 'Language translation for request stage'),
(4015, 0, 2031, 'Update request stage'),
(4016, 0, 2032, 'Language translation for configuration item title'),
(4017, 0, 2033, 'Finance management'),
(4018, 0, 2034, 'Finance type'),
(4019, 0, 2035, 'Delete finance type'),
(4020, 0, 2036, 'Add finance type'),
(4021, 0, 2037, 'Update finance type'),
(4022, 0, 2038, 'Add new depreciation'),
(4023, 0, 2039, 'Language translation for finance type'),
(4024, 0, 2040, 'Select finance type'),
(4025, 0, 2041, 'Delete finance depreciation'),
(4026, 0, 2042, 'Delete finance'),
(4027, 0, 2043, 'CI custom fields'),
(4028, 0, 2044, 'CI type'),
(4029, 0, 2045, 'CI type'),
(4030, 0, 2046, 'License type'),
(4031, 0, 2047, 'Language translation for license type'),
(4032, 0, 2048, 'Update license type'),
(4033, 0, 2049, 'Add license type'),
(4034, 0, 2050, 'Delete license type'),
(4035, 0, 2051, 'Delete CI custom field'),
(4036, 0, 2052, 'Add service custom field'),
(4037, 0, 2053, 'Product'),
(4038, 0, 2054, 'Add product'),
(4039, 0, 2055, 'Update product'),
(4040, 0, 2056, 'Delete product'),
(4041, 0, 2057, 'Add product status'),
(4042, 0, 2058, 'Product status'),
(4043, 0, 2059, 'Update product status'),
(4044, 0, 2060, 'Update service custom field'),
(4045, 0, 2061, 'Add location'),
(4046, 0, 2062, 'Language translation for CI product status'),
(4047, 0, 2063, 'Mode of procurement'),
(4048, 0, 2064, 'Add mode of procurement'),
(4049, 0, 2065, 'Update mode of procurement'),
(4050, 0, 2066, 'Delete mode of procurement'),
(4051, 0, 2067, 'Language translation for mode of procurement'),
(4052, 0, 2068, 'Depreciation type'),
(4053, 0, 2069, 'Add depreciation type'),
(4054, 0, 2070, 'Update depreciation type'),
(4055, 0, 2071, 'Delete depreciation type'),
(4056, 0, 2072, 'Language translation for depreciation type'),
(4057, 0, 2073, 'Contract'),
(4058, 0, 2074, 'Contract number'),
(4059, 0, 2075, 'Expiry date'),
(4060, 0, 2076, 'Phone number must be numeric'),
(4061, 0, 2077, 'Manufacturer'),
(4062, 0, 2078, 'Required field CI type'),
(4063, 0, 2079, 'Delete location'),
(4064, 0, 2080, 'Add contract'),
(4065, 0, 2081, 'License count'),
(4066, 0, 2082, 'Aprover'),
(4067, 0, 2083, 'Cost'),
(4068, 0, 2084, 'Notify contract expiry'),
(4069, 0, 2085, 'Notify before'),
(4070, 0, 2086, 'Notify to'),
(4071, 0, 2087, 'Choose file'),
(4072, 0, 2088, 'Two factor authentication'),
(4073, 1, 1984, 'ITIL'),
(4074, 1, 1985, 'Configuration item type'),
(4075, 1, 1986, 'Impact'),
(4076, 1, 1987, 'Add impact'),
(4077, 1, 1988, 'Delete configuration item type'),
(4078, 1, 1989, 'Update impact'),
(4079, 1, 1990, 'Update item'),
(4080, 1, 1991, 'Language translation for impact name'),
(4081, 1, 1992, 'Delete impact'),
(4082, 1, 1993, 'Add risk'),
(4083, 1, 1994, 'Risk'),
(4084, 1, 1995, 'Update risk'),
(4085, 1, 1996, 'Language translation for risk name'),
(4086, 1, 1997, 'Required field name'),
(4087, 1, 1998, 'Required field color'),
(4088, 1, 1999, 'Required field description'),
(4089, 1, 2000, 'Delete risk'),
(4090, 1, 2001, 'Delete change type'),
(4091, 1, 2002, 'Add change type'),
(4092, 1, 2003, 'Update change type'),
(4093, 1, 2004, 'Release type'),
(4094, 1, 2005, 'Delete release type'),
(4095, 1, 2006, 'Update release type'),
(4096, 1, 2007, 'Add release type'),
(4097, 1, 2008, 'Contract type'),
(4098, 1, 2009, 'Asset state'),
(4099, 1, 2010, 'Add asset state'),
(4100, 1, 2011, 'Update asset state'),
(4101, 1, 2012, 'Delete asset state'),
(4102, 1, 2013, 'Request stage'),
(4103, 1, 2014, 'Add contract type'),
(4104, 1, 2015, 'Update contract type'),
(4105, 1, 2016, 'Vendor'),
(4106, 1, 2017, 'Add vendor'),
(4107, 1, 2018, 'Update vendor'),
(4108, 1, 2019, 'Delete vendor'),
(4109, 1, 2020, 'Language translation for vendor'),
(4110, 1, 2021, 'Language translation for release type'),
(4111, 1, 2022, 'Language translation for asset state'),
(4112, 1, 2023, 'Language translation for change type'),
(4113, 1, 2024, 'Language translation for contract type'),
(4114, 1, 2025, 'Primary contact'),
(4115, 1, 2026, 'Required field primary contact'),
(4116, 1, 2027, 'Required field address'),
(4117, 1, 2028, 'Delete request stage'),
(4118, 1, 2029, 'Add request stage'),
(4119, 1, 2030, 'Language translation for request stage'),
(4120, 1, 2031, 'Update request stage'),
(4121, 1, 2032, 'Language translation for configuration item title'),
(4122, 1, 2033, 'Financial management'),
(4123, 1, 2034, 'Finance type'),
(4124, 1, 2035, 'Delete finance type'),
(4125, 1, 2036, 'Add finance type'),
(4126, 1, 2037, 'Update finance type'),
(4127, 1, 2038, 'Add new depreciation'),
(4128, 1, 2039, 'Language translation for finance type'),
(4129, 1, 2040, 'Select finance type'),
(4130, 1, 2041, 'Useful life (in years)'),
(4131, 1, 2042, 'Delete finance'),
(4132, 1, 2043, 'CI custom fields'),
(4320, 0, 2160, 'Field name'),
(4134, 1, 2045, 'CI type'),
(4135, 1, 2046, 'License type'),
(4136, 1, 2047, 'Language translation for license type'),
(4137, 1, 2048, 'Update license type'),
(4138, 1, 2049, 'Add license type'),
(4139, 1, 2050, 'Delete license type'),
(4140, 1, 2051, 'Delete CI custom field'),
(4141, 1, 2052, 'Add service custom field'),
(4142, 1, 2053, 'Product'),
(4143, 1, 2054, 'Add product'),
(4144, 1, 2055, 'Update product'),
(4145, 1, 2056, 'Delete product'),
(4146, 1, 2057, 'Add product status'),
(4147, 1, 2058, 'Product status'),
(4148, 1, 2059, 'Update product status'),
(4149, 1, 2060, 'Update service custom field'),
(4150, 1, 2061, 'Add location'),
(4151, 1, 2062, 'Language translation for product status'),
(4152, 1, 2063, 'Mode of procurement'),
(4153, 1, 2064, 'Add mode of procurement'),
(4154, 1, 2065, 'Update mode of procurement'),
(4155, 1, 2066, 'Delete mode of procurement'),
(4156, 1, 2067, 'Language translation for mode of procurement'),
(4157, 1, 2068, 'Depreciation type'),
(4158, 1, 2069, 'Add depreciation type'),
(4159, 1, 2070, 'Update depreciation type'),
(4160, 1, 2071, 'Delete depreciation type'),
(4161, 1, 2072, 'Language translation for depreciation type'),
(4162, 1, 2073, 'Contract'),
(4163, 1, 2074, 'Contract number'),
(4164, 1, 2075, 'Expiry date'),
(4165, 1, 2076, 'Phone number must be numeric'),
(4166, 1, 2077, 'Manufacturer'),
(4167, 1, 2078, 'Required field CI type'),
(4168, 1, 2079, 'Delete location'),
(4169, 1, 2080, 'Add contract'),
(4170, 1, 2081, 'License count'),
(4171, 1, 2082, 'Approver'),
(4172, 1, 2083, 'Cost'),
(4173, 1, 2084, 'Notify contract expiry'),
(4174, 1, 2085, 'Notify before'),
(4175, 1, 2086, 'Notify to'),
(4176, 1, 2087, 'Choose file'),
(4177, 1, 2088, 'Two factor authentication'),
(4178, 0, 2089, 'You have successfully verified your email'),
(4179, 1, 2089, 'You have successfully verified your email'),
(4180, 0, 2090, 'You have already verified your email'),
(4181, 1, 2090, 'You have already verified your email'),
(4182, 0, 2091, 'Client email verification pending'),
(4183, 1, 2091, 'Client email verification pending'),
(4184, 0, 2092, 'Add CIs'),
(4188, 0, 2094, 'Add CI'),
(4186, 0, 2093, 'Update CI'),
(4187, 1, 2093, 'Update CI'),
(4189, 1, 2094, 'Add CI'),
(4190, 0, 2095, 'Used by'),
(4191, 1, 2095, 'Used by'),
(4192, 0, 2096, 'Assets'),
(4193, 1, 2096, 'Assets'),
(4194, 0, 2097, 'Select group type'),
(4195, 1, 2097, 'Select group type'),
(4196, 0, 2098, 'Add URL'),
(4197, 1, 2098, 'Add URL'),
(4198, 0, 2099, 'Update contract'),
(4199, 1, 2099, 'Update contract'),
(4200, 0, 2100, 'Notify before required'),
(4201, 1, 2100, 'Notify before required'),
(4202, 0, 2101, 'Notify to missing'),
(4203, 1, 2101, 'Notify to missing'),
(4204, 0, 2102, 'Date missing'),
(4205, 1, 2102, 'Date missing'),
(4206, 0, 2103, 'Contract cos missing'),
(4207, 1, 2103, 'Contract cost missing'),
(4208, 0, 2104, 'License count missing'),
(4209, 1, 2104, 'Required field license count & must be numeric'),
(4210, 0, 2105, 'Select vendor'),
(4211, 1, 2105, 'Select vendor'),
(4212, 0, 2106, 'Select product type'),
(4213, 1, 2106, 'Select product type'),
(4214, 0, 2107, 'Select contract type'),
(4215, 1, 2107, 'Select contract type'),
(4216, 0, 2108, 'Contract number already used'),
(4217, 1, 2108, 'Contract number already used'),
(4218, 0, 2109, 'Contract number missing'),
(4219, 1, 2109, 'Contract number missing'),
(4220, 0, 2110, 'Status missing'),
(4221, 1, 2110, 'Status missing'),
(4222, 0, 2111, 'Contract name missing'),
(4223, 1, 2111, 'Contract name missing'),
(4224, 0, 2112, 'Delete contract'),
(4225, 1, 2112, 'Delete contract'),
(4226, 0, 2113, 'Auto approve comments'),
(4227, 1, 2113, 'Auto approve comments'),
(4228, 0, 2114, 'Assigned on'),
(4229, 1, 2114, 'Assigned on'),
(4230, 0, 2115, 'Attach CI'),
(4231, 1, 2115, 'Attach CI'),
(4232, 0, 2116, 'Select CI'),
(4233, 1, 2116, 'Select CI'),
(4234, 0, 2117, 'Please select from date'),
(4235, 1, 2117, 'Please select from date'),
(4236, 0, 2118, 'Please select to date'),
(4237, 1, 2118, 'Please select to date'),
(4238, 0, 2119, 'CMDB'),
(4239, 1, 2119, 'CMDB'),
(4240, 0, 2120, 'Edit CI product'),
(4241, 1, 2120, 'Edit CI product'),
(4242, 0, 2121, 'CI vendor'),
(4243, 1, 2121, 'CI vendor'),
(4244, 0, 2122, 'Quantity'),
(4245, 1, 2122, 'Quantity'),
(4246, 0, 2123, 'Warranty/Validity'),
(4247, 1, 2123, 'Warranty/Validity'),
(4248, 0, 2124, 'Select vendor'),
(4249, 1, 2124, 'Select vendor'),
(4250, 0, 2125, 'Select product'),
(4251, 1, 2125, 'Select product'),
(4252, 0, 2126, 'Attach'),
(4253, 1, 2126, 'Attach'),
(4254, 0, 2127, 'Item name'),
(4255, 1, 2127, 'Item name'),
(4256, 0, 2128, 'Required field CI product'),
(4257, 1, 2128, 'Required field CI product'),
(4258, 0, 2129, 'Required field CI vendor'),
(4259, 1, 2129, 'Required field CI vendor'),
(4260, 0, 2130, 'Required field price'),
(4261, 1, 2130, 'Required field price'),
(4262, 0, 2131, 'Price must be numeric'),
(4263, 1, 2131, 'Price must be numeric'),
(4264, 0, 2132, 'Required field quantity'),
(4265, 1, 2132, 'Required field quantity'),
(4266, 0, 2133, 'Quantity must be numeric'),
(4267, 1, 2133, 'Quantity must be numeric'),
(4268, 0, 2134, 'Service category'),
(4269, 1, 2134, 'Service category'),
(4270, 0, 2135, 'Add service category'),
(4271, 1, 2135, 'Add service category'),
(4272, 0, 2136, 'Problems'),
(4273, 1, 2136, 'Problems'),
(4274, 0, 2137, 'Update service category'),
(4275, 1, 2137, 'Update service category'),
(4276, 0, 2138, 'Add problems'),
(4277, 1, 2138, 'Add problems'),
(4278, 0, 2139, 'Search a requester'),
(4279, 1, 2139, 'Search a requester'),
(4280, 0, 2140, 'Service item'),
(4281, 1, 2140, 'Service item'),
(4282, 0, 2141, 'Due by'),
(4283, 1, 2141, 'Due by'),
(4284, 0, 2142, 'Agent'),
(4285, 1, 2142, 'Agent'),
(4286, 0, 2143, 'Add service item'),
(4287, 1, 2143, 'Add service item'),
(4288, 0, 2144, 'Quantity visible'),
(4289, 1, 2144, 'Quantity visible'),
(4290, 0, 2145, 'Published'),
(4291, 1, 2145, 'Published'),
(4292, 0, 2146, 'Visible to client portal'),
(4293, 1, 2146, 'Visible to client portal'),
(4294, 0, 2147, 'Estimated delivery in days'),
(4295, 1, 2147, 'Estimated delivery in days'),
(4296, 0, 2148, 'Problem'),
(4297, 1, 2148, 'Problem'),
(4298, 0, 2149, 'Open new problem'),
(4299, 1, 2149, 'Open new problem'),
(4300, 0, 2150, 'Update service item'),
(4301, 1, 2150, 'Update service item'),
(4302, 0, 2151, 'Cost must be numeric'),
(4303, 1, 2151, 'Cost must be numeric'),
(4304, 0, 2152, 'Required fileld cost'),
(4305, 1, 2152, 'Required field cost'),
(4306, 0, 2153, 'Required field product'),
(4307, 1, 2153, 'Required field product'),
(4308, 0, 2154, 'Delete service item'),
(4309, 1, 2154, 'Delete service item'),
(4310, 0, 2155, 'Delete ticket base'),
(4311, 1, 2155, 'Delete ticket base'),
(4312, 0, 2156, 'Delete time base'),
(4313, 1, 2156, 'Delete time base'),
(4314, 0, 2157, 'Delete payment gateway'),
(4315, 1, 2157, 'Delete payment gateway'),
(4316, 0, 2158, 'Delete service category'),
(4317, 1, 2158, 'Delete service category'),
(4318, 0, 2159, 'Add customfield'),
(4319, 1, 2159, 'Add custom field'),
(4321, 1, 2160, 'Field name'),
(4322, 0, 2161, 'Delete CI'),
(4323, 1, 2161, 'Delete CI'),
(4324, 0, 2162, 'CI'),
(4325, 1, 2162, 'CI'),
(4326, 0, 2163, 'Assignment'),
(4327, 1, 2163, 'Assignment'),
(4328, 0, 2164, 'Delete service custom field'),
(4329, 1, 2164, 'Delete service custom field'),
(4330, 0, 2165, 'Service custom field'),
(4332, 0, 2166, 'Service custom field'),
(4333, 1, 2166, 'Service custom field'),
(4334, 0, 2167, 'Required field service item'),
(4335, 1, 2167, 'Required field service item'),
(4336, 0, 2168, 'aa'),
(4338, 0, 2169, 'Item image'),
(4339, 1, 2169, 'Item image'),
(4342, 0, 2171, 'Changes'),
(4343, 1, 2171, 'Changes'),
(4344, 0, 2172, 'Service catalog'),
(4348, 0, 2174, 'Service catalog'),
(4346, 0, 2173, 'Managed by'),
(4347, 1, 2173, 'Managed by'),
(4349, 1, 2174, 'Service catalog'),
(4350, 0, 2175, 'Select company'),
(4351, 1, 2175, 'Select company'),
(4352, 0, 2176, 'Select aprover'),
(4356, 0, 2178, 'Request'),
(4354, 0, 2177, 'Select aprover'),
(4355, 1, 2177, 'Select approver'),
(4357, 1, 2178, 'Request'),
(4358, 0, 2179, 'Submit for aproval'),
(4359, 1, 2179, 'Submit for approval'),
(4360, 0, 2180, 'Invalid linkedin profile ID.'),
(4361, 1, 2180, 'Invalid linkedin profile ID.'),
(4362, 0, 2181, 'Invalid facebook profile ID.'),
(4363, 1, 2181, 'Invalid facebook profile ID.'),
(4364, 0, 2182, 'Invalid twitter profile ID'),
(4365, 1, 2182, 'Invalid twitter profile ID'),
(4366, 0, 2183, 'Invalid google profile ID'),
(4367, 1, 2183, 'Invalid google profile ID'),
(4368, 0, 2184, 'Item request'),
(4369, 1, 2184, 'Item request'),
(4370, 0, 2185, 'Place request'),
(4371, 1, 2185, 'Place request'),
(4372, 0, 2186, 'Approve'),
(4373, 1, 2186, 'Approve'),
(4374, 0, 2187, 'Reject'),
(4375, 1, 2187, 'Reject'),
(4376, 0, 2188, 'Request for'),
(4377, 1, 2188, 'Request for'),
(4378, 0, 2189, 'Terminate'),
(4379, 1, 2189, 'Terminate'),
(4380, 0, 2190, 'Rejected'),
(4381, 1, 2190, 'Rejected'),
(4382, 0, 2191, 'Canceled'),
(4383, 1, 2191, 'Canceled'),
(4384, 0, 2192, 'Expired'),
(4385, 1, 2192, 'Expired'),
(4386, 0, 2193, 'Request service'),
(4387, 1, 2193, 'Request service'),
(4388, 0, 2194, 'Send email to client'),
(4389, 1, 2194, 'Send email to client'),
(4390, 0, 2195, 'Assign team'),
(4391, 1, 2195, 'Assign team'),
(4392, 0, 2196, 'Creation time'),
(4393, 1, 2196, 'Creation time'),
(4394, 0, 2197, 'After'),
(4395, 1, 2197, 'After'),
(4396, 0, 2198, 'Before'),
(4397, 1, 2198, 'Before'),
(4398, 0, 2199, 'Send email to staff'),
(4399, 1, 2199, 'Send email to staff'),
(4400, 0, 2200, 'Resolution due time'),
(4401, 1, 2200, 'Resolution due time'),
(4402, 0, 2201, 'Core type status can not be changed.'),
(4403, 1, 2201, 'Core type status can not be changed.'),
(4404, 0, 2202, 'Service catalog'),
(4405, 1, 2202, 'Service catalog'),
(4406, 0, 2203, 'Email approval pending'),
(4407, 1, 2203, 'Email approval pending'),
(4408, 1, 2204, 'Invalid file size'),
(4409, 0, 2204, 'Invalid file size'),
(4410, 1, 2205, 'Invalid extension'),
(4411, 0, 2205, 'Invalid extension'),
(4412, 0, 2206, 'Submit new, view and reply self posted tickets'),
(4413, 1, 2206, 'Submit new, view and reply self posted tickets'),
(4414, 0, 2207, 'Submit new, view and reply self posted tickets'),
(4415, 1, 2207, 'Submit new, view and reply self posted tickets'),
(4416, 0, 2208, 'Problem not found may be deleted or not have access'),
(4417, 1, 2208, 'Problem not found may be deleted or not have access'),
(4418, 0, 2209, 'Problem ID missing'),
(4419, 1, 2209, 'Problem ID missing'),
(4420, 0, 2210, 'Root cause'),
(4421, 1, 2210, 'Root cause'),
(4422, 0, 2211, 'Symptoms'),
(4423, 1, 2211, 'Symptoms'),
(4424, 0, 2212, 'Permanent solution'),
(4425, 1, 2212, 'Permanent solution'),
(4426, 0, 2213, 'Workaround solution'),
(4427, 1, 2213, 'Workaround solution'),
(4428, 0, 2214, 'Problem analysis'),
(4429, 1, 2214, 'Problem analysis'),
(4430, 0, 2215, 'Add root cause'),
(4431, 1, 2215, 'Add root cause'),
(4432, 0, 2216, 'Problem details'),
(4433, 1, 2216, 'Problem details'),
(4434, 0, 2217, 'Problem note'),
(4435, 1, 2217, 'Problem note'),
(4436, 0, 2218, 'No root cause available'),
(4437, 1, 2218, 'No root cause available'),
(4438, 0, 2219, 'Add new'),
(4439, 1, 2219, 'Add new'),
(4440, 0, 2220, 'No impact available'),
(4441, 1, 2220, 'No impact available'),
(4442, 0, 2221, 'No symptons available'),
(4443, 1, 2221, 'No symptoms available'),
(4444, 0, 2222, 'Add a new solution'),
(4445, 1, 2222, 'Add a new solution'),
(4446, 0, 2223, 'Link solution to problem'),
(4447, 1, 2223, 'Link solution to problem'),
(4448, 0, 2224, 'Releases'),
(4449, 1, 2224, 'Releases'),
(4450, 0, 2225, 'Select multiple problems to link'),
(4451, 1, 2225, 'Select multiple problems to link'),
(4452, 0, 2226, 'Search problems'),
(4453, 1, 2226, 'Search problems'),
(4454, 0, 2227, 'Search changes'),
(4455, 1, 2227, 'Search changes'),
(4456, 0, 2228, 'Search release'),
(4457, 1, 2228, 'Search release'),
(4458, 0, 2229, 'Post message not found'),
(4459, 1, 2229, 'Post message not found'),
(4460, 0, 2230, 'Service item'),
(4461, 1, 2230, 'Service item'),
(4462, 0, 2231, 'Service request'),
(4463, 1, 2231, 'Service request'),
(4464, 0, 2232, 'No CI attached'),
(4465, 1, 2232, 'No CI attached'),
(4466, 0, 2233, 'No problem linked'),
(4467, 1, 2233, 'No problem linked'),
(4468, 0, 2234, 'Link problem'),
(4469, 1, 2234, 'Link problem'),
(4470, 0, 2235, 'No changes linked'),
(4471, 1, 2235, 'No changes linked'),
(4472, 0, 2236, 'Link changes'),
(4473, 1, 2236, 'Link changes'),
(4474, 0, 2237, 'Detach'),
(4475, 1, 2237, 'Detach'),
(4476, 0, 2238, 'Please search problem'),
(4477, 1, 2238, 'Please search problem'),
(4478, 0, 2239, 'Please search changes'),
(4479, 1, 2239, 'Please search changes'),
(4480, 0, 2240, 'Select CI type'),
(4481, 1, 2240, 'Select CI type'),
(4482, 0, 2241, 'Please select CI type or search CI item'),
(4483, 1, 2241, 'Please select CI type or search CI item'),
(4484, 0, 2242, 'Service request for'),
(4485, 1, 2242, 'Service request for'),
(4486, 0, 2243, 'Recipient and people'),
(4487, 1, 2243, 'Recipient and people'),
(4488, 0, 2244, 'Ticket or time base'),
(4489, 1, 2244, 'Ticket or time base'),
(4492, 0, 2246, 'Show only internal tickets'),
(4493, 1, 2246, 'Show only internal tickets'),
(4494, 0, 2247, 'Username missing'),
(4499, 1, 2249, 'Additional fields'),
(4496, 0, 2248, 'Username missing'),
(4498, 0, 2249, 'Additional fields'),
(4500, 0, 2250, 'Relationships'),
(4501, 1, 2250, 'Relationships'),
(4502, 0, 2251, 'Assets detail'),
(4503, 1, 2251, 'Assets detail'),
(4504, 0, 2252, 'Incidence'),
(4505, 1, 2252, 'Incidence'),
(4506, 0, 2253, 'Add CI vendor'),
(4507, 1, 2253, 'Add CI vendor'),
(4508, 0, 2254, 'Add CI product'),
(4509, 1, 2254, 'Add CI product'),
(4510, 0, 2255, 'Relationships'),
(4511, 1, 2255, 'Relationships'),
(4512, 0, 2256, 'Inverse relationship'),
(4513, 1, 2256, 'Inverse relationship'),
(4514, 0, 2257, 'Attach relationship'),
(4515, 1, 2257, 'Attach relationship'),
(4516, 0, 2258, 'Open new release'),
(4517, 1, 2258, 'Open new release'),
(4518, 0, 2259, 'Release'),
(4519, 1, 2259, 'Release'),
(4520, 0, 2260, 'Planned start date'),
(4521, 1, 2260, 'Planned start date'),
(4522, 0, 2261, 'Planned end date'),
(4523, 1, 2261, 'Planned end date'),
(4526, 0, 2263, 'Match and conditions'),
(4527, 1, 2263, 'Match and conditions'),
(4528, 0, 2264, 'Match or conditions'),
(4529, 1, 2264, 'Match or conditions'),
(4530, 0, 2265, 'Insufficient credit'),
(4531, 1, 2265, 'Insufficient credit'),
(4532, 0, 2266, 'Paid department not found'),
(4533, 1, 2266, 'Paid department not found'),
(4534, 0, 2267, 'Problem solution'),
(4535, 1, 2267, 'Problem solution'),
(4536, 0, 2268, 'Permanent'),
(4537, 1, 2268, 'Permanent'),
(4538, 0, 2269, 'Workaround'),
(4539, 1, 2269, 'Workaround'),
(4540, 0, 2270, 'Search problem solution'),
(4541, 1, 2270, 'Search problem solution'),
(4542, 0, 2271, 'Detach CI'),
(4543, 1, 2271, 'Detach CI'),
(4544, 0, 2272, 'No ticket attached'),
(4545, 1, 2272, 'No ticket attached'),
(4546, 0, 2273, 'Search ticket'),
(4547, 1, 2273, 'Search ticket'),
(4548, 0, 2274, 'Please search ticket'),
(4549, 1, 2274, 'Please search ticket'),
(4550, 0, 2275, 'No changes attached'),
(4551, 1, 2275, 'No changes attached'),
(4552, 0, 2276, 'No task attached'),
(4553, 1, 2276, 'No task attached'),
(4554, 0, 2277, 'Link task'),
(4555, 1, 2277, 'Link task'),
(4556, 0, 2278, 'Add new task'),
(4557, 1, 2278, 'Add new task'),
(4558, 0, 2279, 'Open new change'),
(4559, 1, 2279, 'Open new change'),
(4560, 0, 2280, 'Problem hash'),
(4561, 1, 2280, 'Problem hash'),
(4562, 0, 2281, 'Release hash'),
(4563, 1, 2281, 'Release hash'),
(4564, 0, 2282, 'Change hash'),
(4565, 1, 2282, 'Change hash'),
(4566, 0, 2283, 'Delete changes'),
(4567, 1, 2283, 'Delete changes'),
(4568, 0, 2284, 'Delete problem'),
(4569, 1, 2284, 'Delete problem'),
(4570, 0, 2285, 'Delete problem'),
(4571, 1, 2285, 'Delete problem'),
(4572, 0, 2286, 'Team has assigned with this department.<br />Can not delete department which assigned to team'),
(4573, 1, 2286, 'Team is assigned to this department.<br />Can not delete department which is assigned to team'),
(4574, 0, 2287, 'Apply amount credit'),
(4575, 1, 2287, 'Apply amount credit'),
(4576, 0, 2288, 'Recent activity'),
(4577, 1, 2288, 'Recent activity'),
(4578, 0, 2289, 'Manage credit'),
(4579, 1, 2289, 'Manage credit'),
(4580, 0, 2290, 'Release ID missing'),
(4581, 1, 2290, 'Release ID missing'),
(4582, 0, 2291, 'Release details'),
(4583, 1, 2291, 'Release details'),
(4584, 0, 2292, 'Build plan'),
(4585, 1, 2292, 'Build plan'),
(4586, 0, 2293, 'Test plan'),
(4587, 1, 2293, 'Test plan'),
(4588, 0, 2294, 'No build plan available'),
(4589, 1, 2294, 'No build plan available'),
(4590, 0, 2295, 'No test plan available'),
(4591, 1, 2295, 'No test plan available'),
(4592, 0, 2296, 'Release approval'),
(4593, 1, 2296, 'Release approval'),
(4594, 0, 2297, 'New release'),
(4595, 1, 2297, 'New release'),
(4596, 0, 2298, 'Change filters'),
(4597, 1, 2298, 'Change filters'),
(4598, 0, 2299, 'Release filters'),
(4599, 1, 2299, 'Release filters'),
(4600, 0, 2300, 'Problem filters'),
(4601, 1, 2300, 'Problem filters'),
(4602, 0, 2301, 'Clients can not be merged across different companies'),
(4603, 1, 2301, 'Clients can not be merged across different companies'),
(4604, 0, 2302, 'Delete organization'),
(4605, 1, 2302, 'Delete organization'),
(4606, 0, 2303, 'To add survey fields you require minimum one survey field group'),
(4607, 1, 2303, 'To add survey fields you require minimum one survey field group'),
(4608, 0, 2304, 'Progress'),
(4609, 1, 2304, 'Progress'),
(4610, 0, 2305, 'Email has been sent to reset password'),
(4611, 1, 2305, 'Email has been sent to reset password'),
(4612, 0, 2306, 'Reset password link expired'),
(4613, 1, 2306, 'Reset password link expired'),
(4614, 0, 2307, 'Back to login'),
(4615, 1, 2307, 'Back to login'),
(4616, 0, 2308, 'Core priority status can not be changed'),
(4617, 1, 2308, 'Core priority status can not be changed'),
(4618, 0, 2309, 'Core status can not be changed'),
(4619, 1, 2309, 'Core status can not be changed'),
(4620, 0, 2310, 'Core flag status can not be changed'),
(4621, 1, 2310, 'Core flag status can not be changed'),
(4622, 0, 2311, 'Core view status can not be changed'),
(4623, 1, 2311, 'Core view status can not be changed'),
(4624, 0, 2312, 'Changes ID missing'),
(4625, 1, 2312, 'Changes ID missing'),
(4626, 0, 2313, 'Change not found may be deleted or not have access'),
(4627, 1, 2313, 'Change not found may be deleted or not have access'),
(4628, 0, 2314, 'Add problem'),
(4629, 1, 2314, 'Add problem'),
(4630, 0, 2315, 'Problem can not move from one domain to other domain'),
(4631, 1, 2315, 'Problem can not move from one domain to other domain'),
(4632, 0, 2316, 'Change can not move from one domain to other domain'),
(4633, 1, 2316, 'Change can not move from one domain to other domain'),
(4634, 0, 2317, 'New problem created'),
(4635, 1, 2317, 'New problem created'),
(4636, 0, 2318, 'New change created');
INSERT INTO `avis_language_values` (`language_values_id`, `language_id`, `variable_id`, `description`) VALUES
(4637, 1, 2318, 'New change created'),
(4638, 0, 2319, 'Detach'),
(4639, 1, 2319, 'Detach'),
(4640, 0, 2320, 'Change details'),
(4641, 1, 2320, 'Change details'),
(4642, 0, 2321, 'Link release'),
(4643, 1, 2321, 'Link release'),
(4644, 0, 2322, 'No release attached'),
(4645, 1, 2322, 'No release attached'),
(4646, 0, 2323, 'Please search releases'),
(4647, 1, 2323, 'Please search releases'),
(4648, 0, 2324, 'No problem attached'),
(4649, 1, 2324, 'No problem attached'),
(4650, 0, 2325, 'Link problem'),
(4651, 1, 2325, 'Link problem'),
(4652, 0, 2326, 'Reason for change'),
(4653, 1, 2326, 'Reason for change'),
(4654, 0, 2327, 'No reason available'),
(4655, 1, 2327, 'No reason available'),
(4656, 0, 2328, 'Rollout plan'),
(4657, 1, 2328, 'Rollout plan'),
(4658, 0, 2329, 'Backout plan'),
(4659, 1, 2329, 'Backout plan'),
(4660, 0, 2330, 'No rollout plan available'),
(4661, 1, 2330, 'No rollout plan available'),
(4662, 0, 2331, 'No backout plan available'),
(4663, 1, 2331, 'No backout plan available'),
(4664, 0, 2332, 'Send'),
(4665, 1, 2332, 'Send'),
(4666, 0, 2333, 'Update password'),
(4667, 1, 2333, 'Update password'),
(4668, 0, 2334, 'Select payment gateway'),
(4669, 1, 2334, 'Select payment gateway'),
(4670, 0, 2335, 'Gateway transactions details'),
(4671, 1, 2335, 'Gateway transactions details'),
(4672, 0, 2336, 'Parser details'),
(4673, 1, 2336, 'Parser details'),
(4674, 0, 2337, 'Mail details'),
(4675, 1, 2337, 'Mail details'),
(4676, 0, 2338, 'Select date'),
(4677, 1, 2338, 'Select date'),
(4678, 0, 2339, 'Select month'),
(4679, 1, 2339, 'Select month'),
(4680, 0, 2340, 'January'),
(4681, 1, 2340, 'January'),
(4682, 0, 2341, 'February'),
(4683, 1, 2341, 'February'),
(4684, 0, 2342, 'March'),
(4685, 1, 2342, 'March'),
(4686, 0, 2343, 'April'),
(4687, 1, 2343, 'April'),
(4688, 0, 2344, 'May'),
(4689, 1, 2344, 'May'),
(4690, 0, 2345, 'June'),
(4691, 1, 2345, 'June'),
(4692, 0, 2346, 'July'),
(4693, 1, 2346, 'July'),
(4694, 0, 2347, 'August'),
(4695, 1, 2347, 'August'),
(4696, 0, 2348, 'September'),
(4697, 1, 2348, 'September'),
(4698, 0, 2349, 'October'),
(4699, 1, 2349, 'October'),
(4700, 0, 2350, 'November'),
(4701, 1, 2350, 'November'),
(4702, 0, 2351, 'December'),
(4703, 1, 2351, 'December'),
(4704, 0, 2352, 'Update password'),
(4705, 1, 2352, 'Update password'),
(4706, 0, 2353, 'Reset password link expired'),
(4707, 1, 2353, 'Reset password link expired'),
(4708, 0, 2354, 'Send reset password email'),
(4709, 1, 2354, 'Send reset password email'),
(4710, 0, 2355, 'Send reset password email'),
(4711, 1, 2355, 'Send reset password email'),
(4712, 0, 2356, 'Email has been sent to reset password'),
(4713, 1, 2356, 'Email has been sent to reset password'),
(4714, 0, 2357, 'Delete relationship'),
(4715, 1, 2357, 'Delete relationship'),
(4716, 0, 2358, 'Please select CI item'),
(4717, 1, 2358, 'Please select CI item'),
(4718, 0, 2359, 'No record found'),
(4719, 1, 2359, 'No record found'),
(4720, 0, 2360, 'Detach link problem'),
(4721, 1, 2360, 'Detach link problem'),
(4722, 0, 2361, 'Detach link change'),
(4723, 1, 2361, 'Detach link change'),
(4724, 0, 2362, 'Software properties'),
(4725, 1, 2362, 'Software properties'),
(4726, 0, 2363, 'Warranty'),
(4727, 1, 2363, 'Warranty'),
(4728, 0, 2364, 'Hardware properties'),
(4729, 1, 2364, 'Hardware properties'),
(4730, 0, 2365, 'Acquisition date'),
(4731, 1, 2365, 'Acquisition date'),
(4732, 0, 2366, 'Warranty expiry date'),
(4733, 1, 2366, 'Warranty expiry date'),
(4734, 0, 2367, 'Last audit date'),
(4735, 1, 2367, 'Last audit date'),
(4736, 0, 2368, 'Asset tag'),
(4737, 1, 2368, 'Asset tag'),
(4738, 0, 2369, 'Serial number'),
(4739, 1, 2369, 'Serial number'),
(4740, 0, 2370, 'License validity'),
(4741, 1, 2370, 'License validity'),
(4742, 0, 2371, 'Installation date'),
(4743, 1, 2371, 'Installation date'),
(4744, 0, 2372, 'License expiry date'),
(4745, 1, 2372, 'License expiry date'),
(4746, 0, 2373, 'License key'),
(4747, 1, 2373, 'License key'),
(4748, 0, 2374, 'License type'),
(4749, 1, 2374, 'License type'),
(4750, 0, 2375, 'Installation path'),
(4751, 1, 2375, 'Installation path'),
(4752, 0, 2376, 'Required field asset state'),
(4753, 1, 2376, 'Required field asset state'),
(4754, 0, 2377, 'Straight line'),
(4755, 1, 2377, 'Straight line'),
(4756, 0, 2378, 'Declining balance'),
(4757, 1, 2378, 'Declining balance'),
(4758, 0, 2379, 'Sum of years digit'),
(4759, 1, 2379, 'Sum of years digit'),
(4760, 0, 2380, 'Double declining balance'),
(4761, 1, 2380, 'Double declining balance'),
(4762, 0, 2381, 'Salvage'),
(4763, 1, 2381, 'Salvage'),
(4764, 0, 2382, 'Depreciation type'),
(4765, 1, 2382, 'Depreciation type'),
(4766, 0, 2383, 'Depreciation details'),
(4767, 1, 2383, 'Depreciation details'),
(4768, 0, 2384, 'Useful year must be numeric'),
(4769, 1, 2384, 'Required field useful year and useful year must be numeric'),
(4770, 0, 2385, 'Book value'),
(4771, 1, 2385, 'Book value'),
(4772, 0, 2386, 'Depreciation schedule'),
(4773, 1, 2386, 'Depreciation schedule'),
(4774, 0, 2387, 'Depreciation'),
(4775, 1, 2387, 'Depreciation'),
(4776, 0, 2388, 'Select depreciation method'),
(4777, 1, 2388, 'Select depreciation method'),
(4784, 0, 2392, 'Add remark'),
(4780, 0, 2390, 'Deleted'),
(4781, 1, 2390, 'Deleted'),
(4782, 0, 2391, 'Update staff department'),
(4783, 1, 2391, 'Update staff department'),
(4785, 1, 2392, 'Add remark'),
(4786, 0, 2393, 'ITIL event'),
(4787, 1, 2393, 'ITIL event'),
(4788, 0, 2394, 'New problem'),
(4789, 1, 2394, 'New problem'),
(4790, 0, 2395, 'Update problem department'),
(4791, 1, 2395, 'Update problem department'),
(4792, 0, 2396, 'Update problem status'),
(4793, 1, 2396, 'Update problem status'),
(4794, 0, 2397, 'Update problem priority'),
(4795, 1, 2397, 'Update problem priority'),
(4796, 0, 2398, 'Update problem impact'),
(4797, 1, 2398, 'Update problem impact'),
(4798, 0, 2399, 'Problem assign'),
(4799, 1, 2399, 'Problem assign'),
(4800, 0, 2400, 'Add problem impact'),
(4801, 1, 2400, 'Add problem impact'),
(4802, 0, 2401, 'Add problem symptoms'),
(4803, 1, 2401, 'Add problem symptoms'),
(4804, 0, 2402, 'Link permanent solution'),
(4805, 1, 2402, 'Link permanent solution'),
(4806, 0, 2403, 'Link workaround solution'),
(4807, 1, 2403, 'Link workaround solution'),
(4808, 0, 2404, 'New change'),
(4809, 1, 2404, 'New change'),
(4810, 0, 2405, 'Update change department'),
(4811, 1, 2405, 'Update change department'),
(4812, 0, 2406, 'Update change status'),
(4813, 1, 2406, 'Update change status'),
(4814, 0, 2407, 'Update change priority'),
(4815, 1, 2407, 'Update change priority'),
(4816, 0, 2408, 'Update change impact'),
(4817, 1, 2408, 'Update change impact'),
(4818, 0, 2409, 'Update change risk'),
(4819, 1, 2409, 'Update change risk'),
(4820, 0, 2410, 'Change assign'),
(4821, 1, 2410, 'Change assign'),
(4822, 0, 2411, 'Update change type'),
(4823, 1, 2411, 'Update change type'),
(4824, 0, 2412, 'Add change impact'),
(4825, 1, 2412, 'Add change impact'),
(4826, 0, 2413, 'Add rollout plan'),
(4827, 1, 2413, 'Add rollout plan'),
(4828, 0, 2414, 'Add backout plan'),
(4829, 1, 2414, 'Add backout plan'),
(4830, 0, 2415, 'Update release department'),
(4831, 1, 2415, 'Update release department'),
(4832, 0, 2416, 'Update release status'),
(4833, 1, 2416, 'Update release status'),
(4834, 0, 2417, 'Update release priority'),
(4835, 1, 2417, 'Update release priority'),
(4836, 0, 2418, 'Release assign'),
(4837, 1, 2418, 'Release assign'),
(4838, 0, 2419, 'Add build plan'),
(4839, 1, 2419, 'Add build plan'),
(4840, 0, 2420, 'Add test plan'),
(4841, 1, 2420, 'Add test plan'),
(4842, 0, 2421, 'Change approval'),
(4843, 1, 2421, 'Change approval'),
(4844, 0, 2422, 'Contract approval'),
(4845, 1, 2422, 'Contract approval'),
(4846, 1, 2423, 'Call client'),
(4847, 0, 2423, 'Call client'),
(4848, 1, 2424, 'Email client'),
(4849, 0, 2424, 'Email client'),
(4850, 1, 2425, 'Client type'),
(4851, 0, 2425, 'Client type'),
(4852, 0, 2426, 'Remaining life'),
(4853, 1, 2426, 'Remaining life'),
(4854, 0, 2427, 'Accumulated depreciation'),
(4855, 1, 2427, 'Accumulated depreciation'),
(4856, 0, 2428, 'Depreciation expense'),
(4857, 1, 2428, 'Depreciation expense'),
(4858, 0, 2429, 'URL must be valid'),
(4859, 1, 2429, 'URL must be valid'),
(4860, 0, 2430, 'Restore'),
(4861, 1, 2430, 'Restore'),
(4862, 0, 2431, 'No access'),
(4863, 1, 2431, 'No access'),
(4864, 0, 2432, 'Client username missing'),
(4865, 1, 2432, 'Client username missing'),
(4866, 0, 2433, 'Client username missing'),
(4867, 1, 2433, 'Client username missing'),
(4868, 0, 2434, 'Email client'),
(4869, 1, 2434, 'Email client'),
(4870, 0, 2435, 'Call client'),
(4871, 1, 2435, 'Call client'),
(4872, 0, 2436, 'Select image'),
(4873, 1, 2436, 'Select image'),
(4875, 1, 2437, 'Invalid end date'),
(4876, 0, 2438, 'Delete clientexec'),
(4877, 1, 2438, 'Delete clientexec'),
(4878, 0, 2439, 'Delete contract type'),
(4879, 1, 2439, 'Delete contract type'),
(4880, 0, 2440, 'Modify recipient and people'),
(4881, 1, 2440, 'Modify recipient and people'),
(4882, 0, 2441, 'Time tracking'),
(4883, 1, 2441, 'Time tracking'),
(4884, 0, 2442, 'Add CI type'),
(4885, 1, 2442, 'Add CI type'),
(4886, 0, 2443, 'Update CI type'),
(4887, 1, 2443, 'Update CI type'),
(4888, 0, 2444, 'Update location'),
(4889, 1, 2444, 'Update location'),
(4892, 0, 2446, 'Add package'),
(4890, 0, 2445, 'Product catalog'),
(4891, 1, 2445, 'Product catalog'),
(4893, 1, 2446, 'Add package'),
(4894, 0, 2447, 'Update package'),
(4895, 1, 2447, 'Update package'),
(4896, 0, 2448, 'Delete product status'),
(4897, 1, 2448, 'Delete product status'),
(4898, 0, 2449, 'Deleting service category will also delete its service items'),
(4899, 1, 2449, 'Deleting service category will also delete its service items'),
(4900, 0, 2450, 'Reply / Reply all ticket'),
(4901, 1, 2450, 'Reply / Reply all ticket'),
(4902, 0, 2451, 'This CI type can not be deleted as one or more asset is linked'),
(4903, 1, 2451, 'This CI type can not be deleted as it is linked with one or more assets, product'),
(4904, 0, 2452, 'Edit asset'),
(4905, 1, 2452, 'Edit asset'),
(4906, 0, 2453, 'Warranty expiry date'),
(4907, 1, 2453, 'Warranty expiry date'),
(4909, 0, 2454, 'Approval status'),
(4910, 1, 2454, 'Approval status'),
(4911, 0, 2455, 'Not requested'),
(4912, 1, 2455, 'Not requested'),
(4913, 0, 2456, 'Requested'),
(4914, 1, 2456, 'Requested'),
(4915, 0, 2457, 'Rejected'),
(4916, 1, 2457, 'Rejected'),
(4917, 0, 2458, 'Approvals'),
(4918, 1, 2458, 'Approvals'),
(4919, 0, 2459, 'No approvals available'),
(4920, 1, 2459, 'No approvals available'),
(4921, 0, 2460, 'Request for approvals'),
(4922, 1, 2460, 'Request for approvals'),
(4923, 0, 2461, 'Sent on'),
(4924, 1, 2461, 'Sent on'),
(4925, 0, 2462, 'Approved on'),
(4926, 1, 2462, 'Approved on'),
(4927, 0, 2463, 'Cancelled on'),
(4928, 1, 2463, 'Cancelled on'),
(4929, 0, 2464, 'Rejected on'),
(4930, 1, 2464, 'Rejected on'),
(4931, 0, 2465, 'Send reminder'),
(4932, 1, 2465, 'Send reminder'),
(4933, 0, 2466, 'Remarks'),
(4934, 1, 2466, 'Remarks'),
(4935, 0, 2467, 'Add release'),
(4936, 1, 2467, 'Add release'),
(4937, 0, 2468, 'Change hash'),
(4938, 1, 2468, 'Change hash'),
(7265, 0, 2469, 'Alert message'),
(7266, 1, 2469, 'Alert message'),
(7267, 0, 2470, 'If field already in use,it will not to be disabled'),
(7268, 1, 2470, 'If field already in use,it will not to be disabled'),
(7269, 0, 2471, 'This contract type can not be deleted as one or more contract is linked'),
(7270, 1, 2471, 'This contract type can not be deleted as it is linked with one or more contract'),
(7271, 0, 2472, 'This changes type can not be deleted as one or more changes is linked'),
(7272, 1, 2472, 'This changes type can not be deleted as it is linked with one or more changes'),
(7273, 0, 2473, 'This release type can not be deleted as one or more releases is linked'),
(7274, 1, 2473, 'This release type can not be deleted as it is linked with one or more releases'),
(7275, 0, 2474, 'This assets state can not be deleted as one or more assets is linked'),
(7276, 1, 2474, 'This assets state can not be deleted as it is linked with one or more assets'),
(7277, 0, 2475, 'This license type can not be deleted as one or more assets is linked'),
(7278, 1, 2475, 'This license type can not be deleted as it is linked with one or more assets, contract'),
(7279, 0, 2476, 'This impact can not be deleted as it is linked with one or more problem,change,assets'),
(7280, 1, 2476, 'This impact can not be deleted as it is linked with one or more problem, change, assets'),
(7281, 0, 2477, 'This risk can not be deleted as it is linked with one or more changes'),
(7282, 1, 2477, 'This risk can not be deleted as it is linked with one or more changes'),
(7283, 0, 2478, 'Required field IP or IP range'),
(7284, 1, 2478, 'Required field IP or IP range'),
(7285, 0, 2479, 'Search CI item'),
(7286, 1, 2479, 'Search CI item'),
(7287, 0, 2480, 'Required field depreciation method'),
(7288, 1, 2480, 'Required field depreciation method'),
(7289, 0, 2481, 'Required field product status'),
(7290, 1, 2481, 'Required field product status'),
(7291, 0, 2482, 'Required field mode of procurement'),
(7292, 1, 2482, 'Required field mode of procurement'),
(7293, 0, 2483, 'This procurement can not be deleted as it is linked with one or more product'),
(7294, 1, 2483, 'This procurement can not be deleted as it is linked with one or more product'),
(7295, 0, 2484, 'In progress task'),
(7296, 1, 2484, 'In progress task'),
(7297, 0, 2485, 'Completed task'),
(7298, 1, 2485, 'Completed task'),
(7299, 0, 2486, 'Cancelled task'),
(7300, 1, 2486, 'Cancelled task'),
(7301, 0, 2487, 'Low priority task'),
(7302, 1, 2487, 'Low priority task'),
(7303, 0, 2488, 'Medium priority task'),
(7304, 1, 2488, 'Medium priority task'),
(7305, 0, 2489, 'High priority task'),
(7306, 1, 2489, 'High priority task'),
(7307, 0, 2490, 'This product status can not be deleted as it is linked with one or more product'),
(7308, 1, 2490, 'This product status can not be deleted as it is linked with one or more product'),
(7309, 0, 2491, 'This vendor can not be deleted as it is linked with one or more product'),
(7310, 1, 2491, 'This vendor can not be deleted as it is linked with one or more product'),
(7311, 0, 2492, 'This service item can not be deleted as it is linked with one or more ticket'),
(7312, 1, 2492, 'This service item can not be deleted as it is linked with one or more ticket'),
(7313, 0, 2493, 'Quantity'),
(7314, 1, 2493, 'Quantity'),
(7315, 0, 2494, 'Cost'),
(7316, 1, 2494, 'Cost'),
(7317, 0, 2495, 'Enter task title'),
(7318, 1, 2495, 'Enter task title'),
(7319, 0, 2496, 'Add task description'),
(7320, 1, 2496, 'Add task description'),
(7321, 0, 2497, 'Staff access'),
(7322, 1, 2497, 'Staff access'),
(7323, 0, 2498, 'Search tasks'),
(7324, 1, 2498, 'Search tasks'),
(7325, 0, 2499, 'Search changes'),
(7326, 1, 2499, 'Search changes'),
(7327, 0, 2500, 'Mobile number should be numeric'),
(7328, 1, 2500, 'Mobile number should be numeric'),
(7329, 0, 2501, 'SMTP settings are already added for all departments, please edit or delete existing SMTP settings to add new entry.'),
(7330, 1, 2501, 'SMTP settings are already added for all departments, please edit or delete existing SMTP settings to add new entry.'),
(7331, 0, 2502, 'Client reply'),
(7332, 1, 2502, 'Client reply'),
(7333, 0, 2503, 'Client deleted'),
(7334, 1, 2503, 'Client deleted'),
(7335, 0, 2504, 'Client add'),
(7336, 1, 2504, 'Client add'),
(7337, 0, 2505, 'Delete facebook page'),
(7338, 1, 2505, 'Delete facebook page'),
(7339, 0, 2506, 'ITIL hash generation'),
(7340, 1, 2506, 'ITIL hash generation'),
(7341, 0, 2507, 'Services prefix'),
(7342, 1, 2507, 'Services prefix'),
(7343, 0, 2508, 'Problems prefix'),
(7344, 1, 2508, 'Problems prefix'),
(7345, 0, 2509, 'Changes prefix'),
(7346, 1, 2509, 'Changes prefix'),
(7347, 0, 2510, 'Releases prefix'),
(7348, 1, 2510, 'Releases prefix'),
(7349, 0, 2511, 'Contracts prefix'),
(7350, 1, 2511, 'Contracts prefix'),
(7351, 0, 2512, 'Ticket has assigned with this label.<br />Can not delete label that is assigned to ticket.'),
(7352, 1, 2512, 'Ticket has assigned with this label.<br />Can not delete label that is assigned to ticket.'),
(7353, 0, 2513, 'Ticket moved to inbox from trash'),
(7354, 1, 2513, 'Ticket moved to inbox from trash'),
(7355, 0, 2514, 'SLA time should not be negative'),
(7356, 1, 2514, 'SLA time should not be negative'),
(7357, 0, 2515, 'Edit page'),
(7358, 1, 2515, 'Edit page'),
(7359, 0, 2516, 'Deleting facebook app will also delete its pages'),
(7360, 1, 2516, 'Deleting facebook app will also delete its pages'),
(7361, 0, 2517, 'Gotomeeting details'),
(7362, 1, 2517, 'Gotomeeting details'),
(7363, 0, 2518, 'Enter valid ticket hash'),
(7364, 1, 2518, 'Enter valid ticket hash'),
(7365, 0, 2519, 'Session details'),
(7366, 1, 2519, 'Session details'),
(7367, 0, 2520, 'New client'),
(7368, 1, 2520, 'New client'),
(7369, 0, 2521, 'Client reply'),
(7370, 1, 2521, 'Client reply'),
(7371, 0, 2522, 'New article'),
(7372, 1, 2522, 'New article'),
(7373, 0, 2523, 'New comment'),
(7374, 1, 2523, 'New comment'),
(7375, 0, 2524, 'New blab'),
(7376, 1, 2524, 'New blab'),
(7377, 0, 2525, 'Task assigned'),
(7378, 1, 2525, 'Task assigned'),
(7379, 0, 2526, 'Task comment'),
(7380, 1, 2526, 'Task comment'),
(7381, 0, 2527, 'New order'),
(7382, 1, 2527, 'New order'),
(7383, 0, 2528, 'Invoice created'),
(7384, 1, 2528, 'Invoice created'),
(7385, 0, 2529, 'Invoice description'),
(7386, 1, 2529, 'Invoice description'),
(7387, 0, 2530, 'Delete product vendor'),
(7388, 1, 2530, 'Delete product vendor'),
(7389, 0, 2531, 'Services prefix'),
(7390, 1, 2531, 'Services prefix'),
(7391, 0, 2532, 'Mail details log'),
(7392, 1, 2532, 'Mail details log'),
(7393, 0, 2533, 'Staff name and profile image'),
(7394, 1, 2533, 'Staff name and profile image'),
(7395, 0, 2534, 'Services hash prefix field is empty'),
(7396, 1, 2534, 'Services hash prefix field is empty'),
(7397, 0, 2535, 'Services hash prefix must be alphanumeric'),
(7398, 1, 2535, 'Services hash prefix must be alphanumeric'),
(7399, 0, 2536, 'Problems hash prefix field is empty'),
(7400, 1, 2536, 'Problems hash prefix field is empty'),
(7401, 0, 2537, 'Problems hash prefix must be alphanumeric'),
(7402, 1, 2537, 'Problems hash prefix must be alphanumeric'),
(7403, 0, 2538, 'Changes hash prefix field is empty'),
(7404, 1, 2538, 'Changes hash prefix field is empty'),
(7405, 0, 2539, 'Changes hash prefix must be alphanumeric'),
(7406, 1, 2539, 'Changes hash prefix must be alphanumeric'),
(7407, 0, 2540, 'Releases hash prefix field is empty'),
(7408, 1, 2540, 'Releases hash prefix field is empty'),
(7409, 0, 2541, 'Releases hash prefix must be alphanumeric'),
(7410, 1, 2541, 'Releases hash prefix must be alphanumeric'),
(7411, 0, 2542, 'Contracts hash prefix field is empty'),
(7412, 1, 2542, 'Contracts hash prefix field is empty'),
(7413, 0, 2543, 'Contracts hash prefix must be alphanumeric'),
(7414, 1, 2543, 'Contracts hash prefix must be alphanumeric'),
(7415, 0, 2544, 'Numbering start from field is empty'),
(7416, 1, 2544, 'Numbering start from field is empty'),
(7417, 0, 2545, 'Numbering start from must be alphanumeric'),
(7418, 1, 2545, 'Numbering start from must be alphanumeric'),
(7419, 0, 2546, 'Required field code'),
(7420, 1, 2546, 'Required field code'),
(7421, 0, 2547, 'Required field character set'),
(7422, 1, 2547, 'Required field character set'),
(7423, 0, 2548, 'Post message not found'),
(7424, 1, 2548, 'Post message not found'),
(7425, 0, 2549, 'Values should not be negative'),
(7426, 1, 2549, 'Values should not be negative'),
(7427, 0, 2550, 'Task linked'),
(7428, 1, 2550, 'Task linked'),
(7429, 0, 2551, 'New release'),
(7430, 1, 2551, 'New release'),
(7431, 0, 2552, 'Changes linked'),
(7432, 1, 2552, 'Changes linked'),
(7433, 0, 2553, 'Problem linked'),
(7434, 1, 2553, 'Problem linked'),
(7435, 0, 2554, 'CI linked'),
(7436, 1, 2554, 'CI linked'),
(7437, 0, 2555, 'Ticket split'),
(7438, 1, 2555, 'Ticket split'),
(7439, 0, 2556, 'Ticket linked to'),
(7440, 1, 2556, 'Ticket linked to'),
(7441, 0, 2557, 'Search service item'),
(7442, 1, 2557, 'Search service item'),
(7443, 0, 2558, 'Service category'),
(7444, 1, 2558, 'Service category'),
(7445, 0, 2559, 'Duration must be less than or equal to 3 months'),
(7446, 1, 2559, 'Duration must be less than or equal to 3 months'),
(7447, 0, 2560, 'From date must be less than to date'),
(7448, 1, 2560, 'From date must be less than to date'),
(7449, 0, 2561, 'Service search result'),
(7450, 1, 2561, 'Service result'),
(7451, 0, 2562, 'Mark paid'),
(7452, 1, 2562, 'Mark paid'),
(7453, 0, 2563, 'No match found'),
(7454, 1, 2563, 'No match found'),
(7455, 0, 2564, 'Delete release'),
(7456, 1, 2564, 'Delete release'),
(7457, 0, 2565, 'Ticket rating'),
(7458, 1, 2565, 'Ticket rating'),
(7459, 0, 2566, 'Service request'),
(7460, 1, 2566, 'Service request'),
(7461, 0, 2567, 'Select service category'),
(7462, 1, 2567, 'Select service category'),
(7463, 0, 2568, 'Place request'),
(7464, 1, 2568, 'Place request'),
(7465, 0, 2569, 'Ticket post deleted'),
(7466, 1, 2569, 'Ticket post deleted'),
(7467, 0, 2570, 'Service request for'),
(7468, 1, 2570, 'Service request for'),
(7469, 0, 2571, 'Ticket post not available'),
(7470, 1, 2571, 'Ticket post not available'),
(7471, 0, 2572, 'Department missing'),
(7472, 1, 2572, 'Department missing'),
(7473, 0, 2573, 'Please select service category'),
(7474, 1, 2573, 'Please select service category'),
(7475, 0, 2574, 'Contact must be numeric'),
(7476, 1, 2574, 'Contact must be numeric'),
(7477, 0, 2575, 'Required field department'),
(7478, 1, 2575, 'Required field department'),
(7479, 0, 2576, 'Required field approver'),
(7480, 1, 2576, 'Required field approver'),
(7481, 0, 2577, 'Required field contract type'),
(7482, 1, 2577, 'Required field contract type'),
(7485, 0, 2579, 'Estimated delivery in days'),
(7486, 1, 2579, 'Estimated delivery in days'),
(7487, 0, 2580, 'Required field quantity & must be numeric'),
(7488, 1, 2580, 'Required field quantity & must be numeric'),
(7489, 0, 2581, 'Required field quantity & must be numeric'),
(7490, 1, 2581, 'Required field quantity & must be numeric'),
(7491, 0, 2582, 'Releases can not move from one domain to other domain'),
(7492, 1, 2582, 'Releases can not move from one domain to other domain'),
(7493, 0, 2583, 'Joomla'),
(7494, 1, 2583, 'Joomla'),
(7495, 0, 2584, 'Salesforce'),
(7496, 1, 2584, 'Salesforce'),
(7497, 0, 2585, 'Badge earn'),
(7498, 1, 2585, 'Badge earn'),
(7499, 0, 2586, 'No badge'),
(7500, 1, 2586, 'No badge');
INSERT INTO `avis_language_values` (`language_values_id`, `language_id`, `variable_id`, `description`) VALUES
(7501, 0, 2587, 'Add new twilio number'),
(7502, 1, 2587, 'Add new twilio number'),
(7503, 0, 2588, 'Key'),
(7504, 1, 2588, 'Key'),
(7505, 0, 2589, 'Twilio number'),
(7506, 1, 2589, 'Twilio number'),
(7507, 0, 2590, 'App'),
(7508, 1, 2590, 'App'),
(7509, 0, 2591, 'Welcome message'),
(7510, 1, 2591, 'Welcome message'),
(7511, 0, 2592, 'Invalid phone number'),
(7512, 1, 2592, 'Invalid phone number'),
(7513, 0, 2593, 'Allow outbound calls to contacts'),
(7514, 1, 2593, 'Allow outbound calls to contacts'),
(7515, 0, 2594, 'Required field application sid'),
(7516, 1, 2594, 'Required field application sid'),
(7517, 0, 2595, 'Required field welcome message'),
(7518, 1, 2595, 'Required field welcome message'),
(7519, 0, 2596, 'Call forwarding'),
(7520, 1, 2596, 'Call forwarding'),
(7521, 0, 2597, 'To phone number'),
(7522, 1, 2597, 'To phone number'),
(7523, 0, 2598, 'To staff browser'),
(7524, 1, 2598, 'To staff browser'),
(7525, 0, 2599, 'Forwarding number'),
(7526, 1, 2599, 'Forwarding number'),
(7527, 0, 2600, 'Update twilio number'),
(7528, 1, 2600, 'Update twilio number'),
(7529, 0, 2601, 'Invalid twilio details'),
(7530, 1, 2601, 'Invalid twilio details'),
(7531, 0, 2602, 'Delete twilio'),
(7532, 1, 2602, 'Delete twilio'),
(7533, 0, 2603, 'All'),
(7534, 1, 2603, 'All'),
(7535, 0, 2604, 'Key message'),
(7536, 1, 2604, 'Key message'),
(7537, 0, 2605, 'Required field key message'),
(7538, 1, 2605, 'Required field key message'),
(7539, 0, 2606, 'Press zero to connect to sales department'),
(7540, 1, 2606, 'Press zero to connect to sales department'),
(7541, 0, 2607, 'Comma separated phone numbers e.g. +18007845478,+919865741000'),
(7542, 1, 2607, 'Comma separated phone numbers e.g. +18007845478,+919865741000'),
(7543, 0, 2608, 'Tag already in used'),
(7544, 1, 2608, 'Tag already in used'),
(7545, 0, 2609, 'Client id'),
(7546, 1, 2609, 'Client id'),
(7547, 0, 2610, 'Client secret'),
(7548, 1, 2610, 'Client secret'),
(7549, 0, 2611, 'Language translation for department title'),
(7550, 1, 2611, 'Language translation for department title'),
(7551, 0, 2612, 'Campaigns name'),
(7552, 1, 2612, 'Campaigns name'),
(7553, 0, 2613, 'Do not have an account?'),
(7554, 1, 2613, 'Do not have an account?'),
(7555, 0, 2614, 'Consumer key'),
(7556, 1, 2614, 'Consumer key'),
(7557, 0, 2615, 'Consumer secret'),
(7558, 1, 2615, 'Consumer secret'),
(7559, 0, 2616, 'Close ticket'),
(7560, 1, 2616, 'Close ticket'),
(7561, 0, 2617, 'License owner'),
(7562, 1, 2617, 'License owner'),
(7563, 0, 2618, 'Number of companies'),
(7564, 1, 2618, 'Number of companies'),
(7565, 0, 2619, 'Number of staff agents'),
(7566, 1, 2619, 'Number of staff agents'),
(7567, 0, 2620, 'Copyright'),
(7568, 1, 2620, 'Copyright'),
(7569, 0, 2621, 'MailChimp'),
(7570, 1, 2621, 'MailChimp'),
(7571, 0, 2622, 'Post your comments here...'),
(7572, 1, 2622, 'Post your comments here...');
INSERT INTO `avis_language_values` (`language_values_id`, `language_id`, `variable_id`, `description`, `is_custom`) VALUES
(7573, 0, 2623, 'Status changed from', 0),
(7574, 1, 2623, 'Status changed from', 0),
(7575, 0, 2624, 'Priority changed from', 0),
(7576, 1, 2624, 'Priority changed from', 0),
(7577, 0, 2625, 'Department changed from', 0),
(7578, 1, 2625, 'Department changed from', 0),
(7579, 0, 2626, 'Ticket type changed from', 0),
(7580, 1, 2626, 'Ticket type changed from', 0),
(7581, 0, 2627, 'Flag changed from', 0),
(7582, 1, 2627, 'Flag changed from', 0),
(7583, 0, 2628, 'Ticket unassigned From', 0),
(7584, 1, 2628, 'Ticket unassigned From', 0),
(7585, 0, 2629, 'Ticket assigned to Nobody', 0),
(7586, 1, 2629, 'Ticket assigned to Nobody', 0),
(7587, 0, 2630, 'SLA set to', 0),
(7588, 1, 2630, 'SLA set to', 0),
(7589, 0, 2631, 'Applied custom SLA plan', 0),
(7590, 1, 2631, 'Applied custom SLA plan', 0),
(7591, 0, 2632, 'Not Spam marked', 0),
(7592, 1, 2632, 'Not Spam marked', 0),
(7593, 0, 2633, 'New task attached', 0),
(7594, 1, 2633, 'New task attached', 0),
(7595, 0, 2634, 'Detached attached task', 0),
(7596, 1, 2634, 'Detached attached task', 0),
(7597, 0, 2635, 'New CI Attached', 0),
(7598, 1, 2635, 'New CI Attached', 0),
(7599, 0, 2636, 'Detached attached CI', 0),
(7600, 1, 2636, 'Detached attached CI', 0),
(7601, 0, 2637, 'New problem attached', 0),
(7602, 1, 2637, 'New problem attached', 0),
(7603, 0, 2638, 'Detached attached problem', 0),
(7604, 1, 2638, 'Detached attached problem', 0),
(7605, 0, 2639, 'New change attached', 0),
(7606, 1, 2639, 'New change attached', 0),
(7607, 0, 2640, 'Detached attached change', 0),
(7608, 1, 2640, 'Detached attached change', 0),
(7609, 0, 2641, 'Ticket post split with', 0),
(7610, 1, 2641, 'Ticket post split with', 0),
(7611, 0, 2642, 'SLA changed from', 0),
(7612, 1, 2642, 'SLA changed from', 0),
(7613, 0, 2643, 'linked to', 0),
(7614, 1, 2643, 'linked to', 0),
(7615, 0, 2644, 'Accept', 0),
(7616, 1, 2644, 'Accept', 0),
(7617, 0, 2645, 'Caller on', 0),
(7618, 1, 2645, 'Caller on', 0),
(7619, 0, 2646, 'Connecting', 0),
(7620, 1, 2646, 'Connecting', 0),
(7621, 0, 2647, 'Call connected', 0),
(7622, 1, 2647, 'Call connected', 0),
(7623, 0, 2648, 'Call ended', 0),
(7624, 1, 2648, 'Call ended', 0),
(7625, 0, 2649, 'Search client name or phone number', 0),
(7626, 1, 2649, 'Search client name or phone number', 0),
(7627, 0, 2650, 'E.g. +019876543210', 0),
(7628, 1, 2650, 'E.g. +019876543210', 0),
(7629, 0, 2651, 'Custom report', 0),
(7630, 1, 2651, 'Custom report', 0),
(7631, 0, 2652, 'Access token', 0),
(7632, 1, 2652, 'Access token', 0),
(7633, 0, 2653, 'Ticket unassigned', 0),
(7634, 1, 2653, 'Ticket unassigned', 0),
(7635, 0, 2654, 'Facebook page ID', 0),
(7636, 1, 2654, 'Facebook page ID', 0),
(7637, 0, 2655, 'Widget', 0),
(7638, 1, 2655, 'Widget', 0),
(7639, 0, 2656, 'Button name', 0),
(7640, 1, 2656, 'Button name', 0),
(7641, 0, 2657, 'Clone', 0),
(7642, 1, 2657, 'Clone', 0);
DROP TABLE IF EXISTS `avis_language_variables`;
CREATE TABLE IF NOT EXISTS `avis_language_variables` (
  `variable_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `location_area` int(11) NOT NULL,
  `is_itil` INT NOT NULL DEFAULT '0',
  PRIMARY KEY (`variable_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_language_variables` (`variable_id`, `title`, `location_area`, `is_itil`) VALUES
(1, 'TXTLOGIN', 1, 0),
(2, 'TXTAPPROVALPENDING', 1, 0),
(3, 'TXTFORGOTPASSWORD', 1, 0),
(4, 'TXTREGISTER', 1, 0),
(5, 'TXTSELFHELP', 1, 0),
(6, 'TXTPOSTEDBY', 1, 0),
(7, 'TXTPOSTON', 1, 0),
(8, 'TXTTICKETS', 1, 0),
(9, 'TXTCREATIONDATE', 1, 0),
(10, 'TXTMODIFIEDON', 1, 0),
(11, 'MSGDATANOTFND', 1, 0),
(12, 'TXTCHNGPASS', 1, 0),
(13, 'TXTOLDPASSWORD', 1, 0),
(14, 'TXTNEWPASSWORD', 1, 0),
(15, 'TXTCONFIRMNEWPASSWORD', 1, 0),
(16, 'TXTUPDATE', 1, 0),
(17, 'TXTCLEAR', 1, 0),
(18, 'MSGCLTEMAILEXIST', 1, 0),
(19, 'TXTADDCONTACT', 1, 0),
(20, 'TXTFIRSTNAME', 1, 0),
(21, 'TXTLASTNAME', 1, 0),
(22, 'TXTEMAIL', 1, 0),
(23, 'TXTUSERNAME', 1, 0),
(24, 'TXTPASSWORD', 1, 0),
(25, 'TXTACCESS', 1, 0),
(26, 'TXTOPENNEWTICKETS', 1, 0),
(27, 'TXTNOTISPOGTKT', 1, 0),
(28, 'TXTTKTPSTGRM', 1, 0),
(29, 'TXTRTKTPSTGRM', 1, 0),
(30, 'TXTADD', 1, 0),
(31, 'TXTRESET', 1, 0),
(32, 'TXTCUSTOMFIELDS', 1, 0),
(33, 'TXTSUBMIT', 1, 0),
(34, 'MSGBALFORINV', 1, 0),
(35, 'TXTPAYNOW', 1, 0),
(36, 'TXTHOME', 1, 0),
(37, 'TXTSUBMITTICKET', 1, 0),
(38, 'TXTVIEWTICKETS', 1, 0),
(39, 'TXTPURCHASE', 1, 0),
(40, 'TXTMYPRODUCTS', 1, 0),
(41, 'TXTMYINVOICES', 1, 0),
(42, 'TXTSELFHELPTICKETSEARCH', 1, 0),
(43, 'TXTSEARCH', 1, 0),
(44, 'TXTPROFILE', 1, 0),
(45, 'TXTCONTACTS', 1, 0),
(46, 'TXTLOGOUT', 1, 0),
(47, 'TXTUNPAID', 1, 0),
(48, 'TXTPAID', 1, 0),
(49, 'TXTCANCELED', 1, 0),
(50, 'TXTINPROCESS', 1, 0),
(51, 'TXTINVOICE', 1, 0),
(52, 'TXTGETPDF', 1, 0),
(53, 'TXTPHONE', 1, 0),
(54, 'TXTINVOICEID', 1, 0),
(55, 'TXTDUEDATE', 1, 0),
(56, 'TXTSTATUS', 1, 0),
(57, 'TXTPAIDDATE', 1, 0),
(58, 'TXTDESCRIPTION', 1, 0),
(59, 'TXTAMOUNT', 1, 0),
(60, 'TXTTAXX', 1, 0),
(61, 'TXTTOTALDUE', 1, 0),
(62, 'TXTTRANSACTIONID', 1, 0),
(63, 'TXTTRANSACTIONDATE', 1, 0),
(64, 'TXTCREATEDATE', 1, 0),
(65, 'TXTTOTAL', 1, 0),
(66, 'TXTTITLE', 1, 0),
(67, 'TXTBILLINGCYCLE', 1, 0),
(68, 'TXTEXPIRYDATE', 1, 0),
(69, 'TXTVALIDITY', 1, 0),
(70, 'TXTORDERNOW', 1, 0),
(71, 'TXTUPDATEPROFILE', 1, 0),
(72, 'TXTPROFILEIMG', 1, 0),
(73, 'TXTUPLOADIMG', 1, 0),
(74, 'TXTADDRESS', 1, 0),
(75, 'TXTCITY', 1, 0),
(76, 'TXTSTATE', 1, 0),
(77, 'TXTZIPCODE', 1, 0),
(78, 'TXTCOUNTRY', 1, 0),
(79, 'TXTWEBSITE', 1, 0),
(80, 'TXTDEPARTMENT', 1, 0),
(81, 'TXTJOBTITLE', 1, 0),
(82, 'TXTCOMPANYWEBSITE', 1, 0),
(83, 'TXTLANGUAGE', 1, 0),
(84, 'TXTCONTACTNUMBER', 1, 0),
(85, 'TXTIMGVERIFY', 1, 0),
(86, 'TXTTYPTWWRD', 1, 0),
(87, 'TXTREFRESH', 1, 0),
(88, 'TXTSAVE', 1, 0),
(89, 'TXTATTACHMENTS', 1, 0),
(90, 'TXTRATING', 1, 0),
(91, 'TXTLEAVECOMMENT', 1, 0),
(92, 'TXTFULLNAME', 1, 0),
(93, 'TXTSUGGESTION', 1, 0),
(94, 'TXTANSWER', 1, 0),
(95, 'TXTCOMMENTS', 1, 0),
(96, 'TXTRECENTARTICLES', 1, 0),
(97, 'TXTFEATUREDARTICLES', 1, 0),
(98, 'TXTADDARTICLE', 1, 0),
(99, 'TXTDETAILS', 1, 0),
(100, 'MSGWELCOMELINE', 1, 0),
(101, 'TXTUPDATECONTACT', 1, 0),
(102, 'MSGCLTDELETE', 1, 0),
(103, 'TXTDELETE', 1, 0),
(104, 'TXTCOMPANYNAME', 1, 0),
(105, 'TXTREGISTRATIONREQUIRED', 1, 0),
(106, 'MSGSUCCOTKT', 1, 0),
(107, 'TXTPRIORITY', 1, 0),
(108, 'TXTTYPE', 1, 0),
(109, 'TXTSUBJECT', 1, 0),
(110, 'TXTMESSAGE', 1, 0),
(111, 'TXTATTACHFILE', 1, 0),
(112, 'TXTEDITPROFILE', 1, 0),
(113, 'TXTBANNED', 1, 0),
(114, 'TXTDOMAIN', 1, 0),
(115, 'TXTPARENT', 1, 0),
(116, 'TXTORGANIZATION', 1, 0),
(117, 'TXTUNSOLVED', 1, 0),
(118, 'TXTSOLVED', 1, 0),
(119, 'TXTBILLING', 1, 0),
(120, 'TXTCASHBAL', 1, 0),
(121, 'TXTUNLIMITED', 1, 0),
(122, 'TXTUSERFEEDBACK', 1, 0),
(123, 'TXTREPLY', 1, 0),
(124, 'TXTCREATEDON', 1, 0),
(125, 'TXTTICKETTYPE', 1, 0),
(126, 'TXTASSIGNTO', 1, 0),
(127, 'TXTSLA', 1, 0),
(128, 'TXTOVERDUE', 1, 0),
(129, 'TXTUNDUE', 1, 0),
(130, 'TXTTICKETDETAILS', 1, 0),
(131, 'TXTREPLYTICKET', 1, 0),
(132, 'TXTEDITTICKET', 1, 0),
(133, 'TXTSENDFEEDBACK', 1, 0),
(134, 'TXTTICKETHASH', 1, 0),
(135, 'TXTSTAFF', 1, 0),
(136, 'TXTCLIENT', 1, 0),
(137, 'TXTCHANGEPRIORITY', 1, 0),
(138, 'TXTCANCEL', 1, 0),
(139, 'TXTPAGE', 1, 0),
(140, 'TXTPRODUCTS', 1, 0),
(141, 'TXTTITLE', 2, 0),
(142, 'TXTADMINTYPE', 2, 0),
(143, 'TXTDOMAINSACCESS', 2, 0),
(144, 'TXTDOMAINADMIN', 2, 0),
(145, 'TXTSUPERADMIN', 2, 0),
(146, 'TXTADMINACCESS', 2, 0),
(147, 'TXTFULLNAME', 2, 0),
(148, 'TXTUSERNAME', 2, 0),
(149, 'TXTPASSWORD', 2, 0),
(150, 'TXTDOMAINSACESS', 2, 0),
(151, 'TXTADDSTAFF', 2, 0),
(152, 'TXTDELSTAFF', 2, 0),
(153, 'TXTALLSTAFF', 2, 0),
(154, 'TXTGROUPNAME', 2, 0),
(155, 'TXTSTATUS', 2, 0),
(156, 'TXTLOGIN', 2, 0),
(157, 'TXTLOGOUT', 2, 0),
(158, 'TXTTOOLBAR', 2, 0),
(159, 'TXTADDSTAFFGROUP', 2, 0),
(160, 'TXTDELSTAFFGROUP', 2, 0),
(161, 'TXTLOCALISATION', 2, 0),
(162, 'TXTDOMAINACCESS', 2, 0),
(163, 'TXTALLDOMAINS', 2, 0),
(164, 'TXTMODULE', 2, 0),
(165, 'TXTSYSTEM', 2, 0),
(166, 'TXTDIAGNOSTICS', 2, 0),
(167, 'TXTMANAGE', 2, 0),
(168, 'TXTVIEWONLY', 2, 0),
(169, 'TXTDELETE', 2, 0),
(170, 'TXTDELETEALL', 2, 0),
(171, 'TXTBACKUP', 2, 0),
(172, 'TXTLICENSE', 2, 0),
(173, 'TXTLICENSEINFORMATION', 2, 0),
(174, 'TXTVIEW', 2, 0),
(175, 'TXTLISTCOUNT', 2, 0),
(176, 'TXTCURRENTLYACTIVE', 2, 0),
(177, 'TXTDEPARTMENT', 2, 0),
(178, 'TXTDEPARTMENTS', 2, 0),
(179, 'TXTPRIORITY', 2, 0),
(180, 'TXTTICKETTYPE', 2, 0),
(181, 'TXTCHANNEL', 2, 0),
(182, 'TXTFLAGTYPE', 2, 0),
(183, 'TXTFLAG', 2, 0),
(184, 'TXTLANGUAGE', 2, 0),
(185, 'TXTMANAGEALLSTAFF', 2, 0),
(186, 'TXTMANAGEDOMAINSTAFF', 2, 0),
(187, 'TXTSTAFFGROUP', 2, 0),
(188, 'TXTWORKFLOW', 2, 0),
(189, 'TXTSLA', 2, 0),
(190, 'TXTADDSLA', 2, 0),
(191, 'TXTDELETESLA', 2, 0),
(192, 'TXTSCHEDULE', 2, 0),
(193, 'TXTEMAILQUEUE', 2, 0),
(194, 'TXTSMTP', 2, 0),
(195, 'TXTEMAILTEMPLATES', 2, 0),
(196, 'TXTCUSTOMFIELD', 2, 0),
(197, 'TXTCUSTOMFIELDS', 2, 0),
(198, 'TXTCUSTOMGROUP', 2, 0),
(199, 'TXTADDCUSTOMGROUP', 2, 0),
(200, 'TXTDELETECUSTOMGROUP', 2, 0),
(201, 'TXTSINGLELOGIN', 2, 0),
(202, 'TXTINTEGRATIONS', 2, 0),
(203, 'TXTAPPID', 2, 0),
(204, 'TXTAPPSECRETKEY', 2, 0),
(205, 'TXTCANVASURL', 2, 0),
(206, 'TXTERRORLOG', 2, 0),
(207, 'TXTDELERRLOG', 2, 0),
(208, 'TXTEXPLOG', 2, 0),
(209, 'TXTPARSERLOG', 2, 0),
(210, 'TXTEMTPARSLOG', 2, 0),
(211, 'TXTDELPARSLOG', 2, 0),
(212, 'TXTSENDMAILLOG', 2, 0),
(213, 'TXTAPI', 2, 0),
(214, 'TXTAPIACCESS', 2, 0),
(215, 'TXTLOGS', 2, 0),
(216, 'TXTERROR', 2, 0),
(217, 'TXTPARSER', 2, 0),
(218, 'TXTAUTOMATION', 2, 0),
(219, 'TXTSENDEMAIL', 2, 0),
(220, 'TXTTICKETDETAILS', 2, 0),
(221, 'TXTAUDITLOG', 2, 0),
(222, 'TXTHISTORY', 2, 0),
(223, 'TXTINVOICES', 2, 0),
(224, 'TXTEXPORTTOPDF', 2, 0),
(225, 'TXTEXPORT', 2, 0),
(226, 'TXTADDALERT', 2, 0),
(227, 'TXTDELETEALERT', 2, 0),
(228, 'TXTEMAILTEMPLATE', 2, 0),
(229, 'TXTALLTICKETS', 2, 0),
(230, 'TXTNEWTICKETS', 2, 0),
(231, 'TXTOVERDUETICKET', 2, 0),
(232, 'TXTASSIGNEDTICKETS', 2, 0),
(233, 'TXTUNSOLVED', 2, 0),
(234, 'TXTSOLVED', 2, 0),
(235, 'TXTREAD', 2, 0),
(236, 'TXTUNREAD', 2, 0),
(237, 'TXTLABELS', 2, 0),
(238, 'TXTEVENT', 2, 0),
(239, 'TXTNEWCLIENTREPLY', 2, 0),
(240, 'TXTNEWSTAFFREPLY', 2, 0),
(241, 'TXTFLAGCHANGE', 2, 0),
(242, 'TXTTYPECHANGE', 2, 0),
(243, 'TXTDEPARTMENTCHANGE', 2, 0),
(244, 'TXTSTATUSCHANGE', 2, 0),
(245, 'TXTPRIORITYCHANGE', 2, 0),
(246, 'TXTTICKETASSIGNE', 2, 0),
(247, 'TXTCLIENTADD', 2, 0),
(248, 'TXTCLIENTEDIT', 2, 0),
(249, 'TXTCLIENTDELETE', 2, 0),
(250, 'TXTTICKETDEPARTMENTCHANGE', 2, 0),
(251, 'TXTTICKETSTATUSCHANGE', 2, 0),
(252, 'TXTTICKETPRIORITYCHANGE', 2, 0),
(253, 'TXTTICKETMERGE', 2, 0),
(254, 'TXTNOTEADD', 2, 0),
(255, 'TXTDELETENOTE', 2, 0),
(256, 'TXTNOTEADDED', 2, 0),
(257, 'TXTNOTETYPE', 2, 0),
(258, 'TXTBILLINGINVOICEADD', 2, 0),
(259, 'TXTTICKETPOSTDELETE', 2, 0),
(260, 'TXTTICKETDELETE', 2, 0),
(261, 'TXTMOVETOTRASH', 2, 0),
(262, 'TXTRESET', 2, 0),
(263, 'TXTCRITERIA', 2, 0),
(264, 'TXTMATCHANYCRITERIA', 2, 0),
(265, 'TXTMATCHALLCRITERIA', 2, 0),
(266, 'TXTADDCRITERIA', 2, 0),
(267, 'TXTFILTERS', 2, 0),
(268, 'TXTSEARCH', 2, 0),
(269, 'TXTSEARCHRESULT', 2, 0),
(270, 'TXTMATCHCRITERIA', 2, 0),
(271, 'TXTSAVEASFILTER', 2, 0),
(272, 'TXTSAVEASDRAFT', 2, 0),
(273, 'TXTSUBJECT', 2, 0),
(274, 'TXTMESSAGE', 2, 0),
(275, 'TXTTICKETNOTE', 2, 0),
(276, 'TXTCLIENTNOTE', 2, 0),
(277, 'TXTTICKETCOMMENT', 2, 0),
(278, 'TXTCLIENTNAME', 2, 0),
(279, 'TXTCLIENTEMAIL', 2, 0),
(280, 'TXTOWNER', 2, 0),
(281, 'TXTLASTACTIVITY', 2, 0),
(282, 'TXTCREATIONDATE', 2, 0),
(283, 'TXTSLAPLAN', 2, 0),
(284, 'TXTDUETIME', 2, 0),
(285, 'TXTHASATTACHMENT', 2, 0),
(286, 'TXTBILLINGNOTE', 2, 0),
(287, 'TXTADDBILLINGNOTE', 2, 0),
(288, 'TXTCONTAIN', 2, 0),
(289, 'TXTDOESNOTCONTAIN', 2, 0),
(290, 'TXTEQUAL', 2, 0),
(291, 'TXTNOTEQUAL', 2, 0),
(292, 'TXTLESSTHAN', 2, 0),
(293, 'TXTGREATERTHAN', 2, 0),
(294, 'TXTTRUE', 2, 0),
(295, 'TXTALERTS', 2, 0),
(296, 'TXTVIEWS', 2, 0),
(297, 'TXTSUBMITTICKET', 2, 0),
(298, 'TXTEDITTICKET', 2, 0),
(299, 'TXTSTAFF', 2, 0),
(300, 'TXTCLIENT', 2, 0),
(301, 'TXTOPERATION', 2, 0),
(302, 'TXTDATETIME', 2, 0),
(303, 'TXTDATE', 2, 0),
(304, 'TXTOPERATOR', 2, 0),
(305, 'TXTADDBALANCE', 2, 0),
(306, 'TXTAMOUNT', 2, 0),
(307, 'TXTDETAILS', 2, 0),
(308, 'TXTPREFERENCES', 2, 0),
(309, 'TXTEXPIRYDATE', 2, 0),
(310, 'TXTBILLING', 2, 0),
(311, 'TXTBILLINGMETHOD', 2, 0),
(312, 'TXTTICKETBASE', 2, 0),
(313, 'TXTTIMEBASE', 2, 0),
(314, 'TXTBILLRATE', 2, 0),
(315, 'TXTCURRENCY', 2, 0),
(316, 'TXTONTICKETCREATE', 2, 0),
(317, 'TXTDONOTGENERATEINVOICE', 2, 0),
(318, 'TXTGENERATEINVOICE', 2, 0),
(319, 'TXTGENERATEANDSENDINVOICE', 2, 0),
(320, 'TXTBALANCEREQUIRED', 2, 0),
(321, 'TXTMIN', 2, 0),
(322, 'TXTTAXABLE', 2, 0),
(323, 'TXTTOTALDUE', 2, 0),
(324, 'TXTTAX', 2, 0),
(325, 'TXTINVOICE', 2, 0),
(326, 'TXTVIEWINVOICE', 2, 0),
(327, 'TXTCREATEDATE', 2, 0),
(328, 'TXTPAIDDATE', 2, 0),
(329, 'TXTDUEDATE', 2, 0),
(330, 'TXTTOTAL', 2, 0),
(331, 'TXTUNPAID', 2, 0),
(332, 'TXTPAID', 2, 0),
(333, 'TXTCANCELED', 2, 0),
(334, 'TXTTODAYSDUE', 2, 0),
(335, 'TXTTODAYSPAID', 2, 0),
(336, 'TXTTODAY', 2, 0),
(337, 'TXTMONTH', 2, 0),
(338, 'TXTCLIENTGROUPCREDIT', 2, 0),
(339, 'TXTBILLURL', 2, 0),
(340, 'TXTADMUSER', 2, 0),
(341, 'TXTADMPASS', 2, 0),
(342, 'TXTAPIKEY', 2, 0),
(343, 'TXTBLABS', 2, 0),
(344, 'TXTADDBLAB', 2, 0),
(345, 'TXTTRENDS', 2, 0),
(346, 'TXTADDIMAGE', 2, 0),
(347, 'TXTADDVIDEO', 2, 0),
(349, 'TXTSHAREDWITH', 2, 0),
(350, 'TXTALL', 2, 0),
(351, 'TXTURL', 2, 0),
(352, 'TXTVIEWBLABS', 2, 0),
(353, 'TXTADDTOBLAB', 2, 0),
(354, 'TXTBLABCOUNT', 2, 0),
(355, 'TXTREMOVEFROMLIST', 2, 0),
(356, 'TXTDELETEBLAB', 2, 0),
(357, 'TXTBREAKLINES', 2, 0),
(358, 'TXTADDBREAKLINE', 2, 0),
(359, 'TXTDELBREAKLINE', 2, 0),
(360, 'TXTEXECUTIONORDER', 2, 0),
(361, 'TXTREGULAREXPRESSION', 2, 0),
(362, 'TXTADDTASK', 2, 0),
(363, 'TXTDELETETASK', 2, 0),
(364, 'TXTCALENDAR', 2, 0),
(365, 'TXTDESCRIPTION', 2, 0),
(366, 'TXTENDDATE', 2, 0),
(367, 'TXTSTARTDATE', 2, 0),
(368, 'TXTPLANNED', 2, 0),
(369, 'TXTCOMPLETED', 2, 0),
(370, 'TXTINPROGRESS', 2, 0),
(371, 'TXTNOTSTARTED', 2, 0),
(372, 'TXTTASKTYPE', 2, 0),
(373, 'TXTLOCATION', 2, 0),
(374, 'TXTPERSONAL', 2, 0),
(375, 'TXTBUSINESS', 2, 0),
(376, 'TXTIMPORTANT', 2, 0),
(377, 'TXTLABEL', 2, 0),
(378, 'TXTMEDIUM', 2, 0),
(379, 'TXTHIGH', 2, 0),
(380, 'TXTLOW', 2, 0),
(381, 'TXTTASKS', 2, 0),
(382, 'TXTTICKETQUEUE', 2, 0),
(383, 'TXTFILTERQUEUES', 2, 0),
(384, 'TXTFOLDERS', 2, 0),
(385, 'TXTSELECTDEPARTMENT', 2, 0),
(386, 'TXTSELECTDOMAIN', 2, 0),
(387, 'TXTOLDPASSWORD', 2, 0),
(388, 'TXTNEWPASSWORD', 2, 0),
(389, 'TXTCHNGPASS', 2, 0),
(390, 'TXTCONFIRMNEWPASSWORD', 2, 0),
(391, 'TXTADDCHANNEL', 2, 0),
(392, 'TXTCHANNELIMAGE', 2, 0),
(393, 'TXTADDLANGUAGE', 2, 0),
(394, 'TXTUPDATELANGUAGE', 2, 0),
(395, 'TXTDELLANG', 2, 0),
(397, 'TXTPHPINFORMATION', 2, 0),
(398, 'TXTADDCLIENT', 2, 0),
(399, 'TXTADDCONTACT', 2, 0),
(400, 'TXTMANAGECONTACT', 2, 0),
(401, 'TXTUSERFEEDBACK', 2, 0),
(402, 'TXTSENDFEEDBACK', 2, 0),
(403, 'TXTCLIENTS', 2, 0),
(404, 'TXTCONTACTS', 2, 0),
(405, 'TXTACTION', 2, 0),
(1649, 'MSGTICKFRMDIFFDOMNOTMERGE', 2, 0),
(409, 'TXTFIRSTNAME', 2, 0),
(410, 'TXTLASTNAME', 2, 0),
(411, 'TXTINITIALS', 2, 0),
(412, 'TXTGENDER', 2, 0),
(413, 'TXTMALE', 2, 0),
(414, 'TXTFEMALE', 2, 0),
(415, 'TXTEMAIL', 2, 0),
(416, 'TXTCONTACTNUMBER', 2, 0),
(417, 'TXTMOBILENUMBER', 2, 0),
(418, 'TXTPERMANETADDRESS', 2, 0),
(419, 'TXTCURRENTADDRESS', 2, 0),
(420, 'TXTCITY', 2, 0),
(421, 'TXTSTATE', 2, 0),
(422, 'TXTCOUNTRY', 2, 0),
(423, 'TXTZIPCODE', 2, 0),
(424, 'TXTFAX', 2, 0),
(425, 'TXTWEBSITE', 2, 0),
(426, 'TXTCOMPANYNAME', 2, 0),
(427, 'TXTCOMPANYEMAIL', 2, 0),
(428, 'TXTCOMPANYPHONE1', 2, 0),
(429, 'TXTCOMPANYPHONE2', 2, 0),
(430, 'TXTCOMPANYFAX', 2, 0),
(431, 'TXTCOMPANYADDRESS', 2, 0),
(432, 'TXTCOMPANYWEBSITE', 2, 0),
(433, 'TXTNETMEETINGID', 2, 0),
(434, 'TXTOTHERIM', 2, 0),
(435, 'TXTOTHERCONTACT', 2, 0),
(436, 'TXTOTHERFAX', 2, 0),
(437, 'TXTJOBTITLE', 2, 0),
(438, 'TXTCREDIT', 2, 0),
(439, 'TXTADDINVOICE', 2, 0),
(440, 'TXTDELETEINVOICE', 2, 0),
(441, 'TXTPAIDDEPARTMENT', 2, 0),
(442, 'TXTREGISTER', 2, 0),
(443, 'TXTREGISTERED', 2, 0),
(444, 'TXTUNREGISTERED', 2, 0),
(445, 'TXTBAN', 2, 0),
(446, 'TXTBANCLIENT', 2, 0),
(447, 'TXTBANNED', 2, 0),
(448, 'TXTREMOVEBAN', 2, 0),
(449, 'TXTSPAMMER', 2, 0),
(450, 'TXTREMOVESPAM', 2, 0),
(451, 'TXTMARKSPAM', 2, 0),
(452, 'TXTEDIT', 2, 0),
(453, 'TXTBANANDDELETE', 2, 0),
(454, 'TXTEMAILNOTIFICATIONS', 2, 0),
(455, 'TXTTICKET', 2, 0),
(456, 'TXTTICKETS', 2, 0),
(457, 'TXTVIEWTICKETS', 2, 0),
(458, 'TXTREPLYTICKET', 2, 0),
(459, 'TXTREPLY', 2, 0),
(460, 'TXTREPLYALL', 2, 0),
(461, 'TXTFORWARD', 2, 0),
(462, 'TXTSENDREPLY', 2, 0),
(463, 'TXTSEND', 2, 0),
(464, 'TXTDELETETICKET', 2, 0),
(465, 'TXTMERGETICKET', 2, 0),
(466, 'TXTDELETETICKETPROPERTIES', 2, 0),
(467, 'TXTCHANGEPROPERTIES', 2, 0),
(468, 'TXTDELETETICKETPOST', 2, 0),
(469, 'TXTEDITTICKETPOST', 2, 0),
(470, 'TXTSETDUETIME', 2, 0),
(471, 'TXTRECIPIENTS', 2, 0),
(472, 'TXTDISCARD', 2, 0),
(473, 'TXTASCENDING', 2, 0),
(474, 'TXTDESCENDING', 2, 0),
(475, 'TXTVIEWTICKETNOTE', 2, 0),
(476, 'TXTMANAGETICKETNOTE', 2, 0),
(477, 'TXTOPENNEWTICKETS', 2, 0),
(478, 'TXTFORWARDTICKET', 2, 0),
(479, 'TXTSELFASSIGNED', 2, 0),
(480, 'TXTUNASSIGNED', 2, 0),
(481, 'TXTASSIGNED', 2, 0),
(482, 'TXTASSIGNTO', 2, 0),
(483, 'TXTMOVETO', 2, 0),
(484, 'TXTUNASSIGNEDANDSELFASSIGNED', 2, 0),
(485, 'TXTOVERDUE', 2, 0),
(486, 'TXTUNDUE', 2, 0),
(487, 'TXTOVERDUETIME', 2, 0),
(488, 'TXTNEW', 2, 0),
(489, 'TXTNOTE', 2, 0),
(490, 'TXTFROM', 2, 0),
(491, 'TXTTO', 2, 0),
(492, 'TXTTICKETHASH', 2, 0),
(493, 'TXTTICKETID', 2, 0),
(494, 'TXTTICKETPRIORITY', 2, 0),
(495, 'TXTTICKETSTATUS', 2, 0),
(496, 'TXTADDSTATUS', 2, 0),
(497, 'TXTDELTKTSTATUS', 2, 0),
(498, 'TXTTICKETCREATEDON', 2, 0),
(499, 'TXTTICKETMODIFIEDON', 2, 0),
(500, 'TXTRESOLVETIME', 2, 0),
(501, 'TXTSLAID', 2, 0),
(502, 'TXTTICKETPOSTCOUNT', 2, 0),
(503, 'TXTTICKETCOUNT', 2, 0),
(504, 'TXTCLIENTFIRSTNAME', 2, 0),
(505, 'TXTCLIENTLASTNAME', 2, 0),
(506, 'TXTCLIENTCONTACT', 2, 0),
(507, 'TXTCLIENTCOMPANY', 2, 0),
(508, 'TXTCLIENTJOBTITLE', 2, 0),
(509, 'TXTCLIENTSTATE', 2, 0),
(510, 'TXTCLIENTCITY', 2, 0),
(511, 'TXTCLIENTZIPCODE', 2, 0),
(512, 'TXTCLIENTCOUNTRY', 2, 0),
(513, 'TXTISSPAMCLIENT', 2, 0),
(514, 'TXTISBANNEDCLIENT', 2, 0),
(515, 'TXTCLIENTPAIDINVOICECOUNT', 2, 0),
(516, 'TXTCLIENTUNPAIDINVOICECOUNT', 2, 0),
(517, 'TXTSTAFFFIRSTNAME', 2, 0),
(518, 'TXTSTAFFLASTNAME', 2, 0),
(519, 'TXTSTAFFEMAIL', 2, 0),
(520, 'TXTSTAFFJOBTITLE', 2, 0),
(521, 'TXTAVGRESPONSE', 2, 0),
(522, 'TXTTOTALRESPONSES', 2, 0),
(523, 'TXTSTAFFGROUPACCESS', 2, 0),
(524, 'TXTSTAFFLIST', 2, 0),
(525, 'TXTBACK', 2, 0),
(526, 'TXTSORTBY', 2, 0),
(527, 'TXTSELECT', 2, 0),
(528, 'TXTTICKETAUTOCLOSETIME', 2, 0),
(529, 'TXTTICKETAVERAGERESPONSETIME', 2, 0),
(530, 'TXTTICKETFOLLOWUPCOUNT', 2, 0),
(531, 'TXTTICKETIPADDRESS', 2, 0),
(532, 'TXTTICKETISRESOLVED', 2, 0),
(533, 'TXTTICKETREPLYTO', 2, 0),
(534, 'TXTTICKETTIMEWORKED', 2, 0),
(535, 'TXTTICKETTOTALREPLIES', 2, 0),
(536, 'TXTSLAOVERDUEHOURS', 2, 0),
(537, 'TXTSLAPLANRESOLUTIONDUEHOURS', 2, 0),
(538, 'TXTRATING', 2, 0),
(539, 'TXTATTACHMENTS', 2, 0),
(540, 'TXTRESOLUTIONTIME', 2, 0),
(541, 'TXTNUMBEROFATTACHMENTS', 2, 0),
(542, 'TXTALLOWEDEXTENSIONS', 2, 0),
(543, 'TXTMAXALLOWEDSIZEFORATTACHMENT', 2, 0),
(544, 'TXTADDMERGEDTICKETSEMAILASRECIPENTS', 2, 0),
(545, 'TXTVISIBLETOCLIENT', 2, 0),
(546, 'TXTFIELDSAVAILABLE', 2, 0),
(547, 'TXTFIELDSSELECTED', 2, 0),
(548, 'TXTLASTREPLIER', 2, 0),
(549, 'TXTADDVIEW', 2, 0),
(550, 'TXTDELETEVIEW', 2, 0),
(551, 'TXTSUMMARY', 2, 0),
(552, 'TXTPROFILE', 2, 0),
(553, 'TXTPROFILEIMG', 2, 0),
(554, 'TXTPERSNDET', 2, 0),
(555, 'TXTHMDETAIL', 2, 0),
(556, 'TXTCOMPDETAIL', 2, 0),
(557, 'TXTRESETPASSWORD', 2, 0),
(558, 'TXTADDDOMAIN', 2, 0),
(559, 'TXTUPDATEDOMAIN', 2, 0),
(560, 'TXTDOMAINNAME', 2, 0),
(561, 'TXTDOMAIN', 2, 0),
(562, 'TXTDELDOMAIN', 2, 0),
(563, 'TXTADDDEPARTMENT', 2, 0),
(564, 'TXTUPDATEDEPARTMENT', 2, 0),
(565, 'TXTDELETEDEPARTMENT', 2, 0),
(566, 'TXTACCESS', 2, 0),
(567, 'TXTISPAID', 2, 0),
(568, 'TXTREGISTRATIONREQUIRED', 2, 0),
(569, 'TXTAUTORESPONDER', 2, 0),
(570, 'TXTAUTORESPONDERSIGNATURE', 2, 0),
(571, 'TXTDOMAINURL', 2, 0),
(572, 'TXTSET', 2, 0),
(573, 'TXTSUPPORTPORTALURL', 2, 0),
(574, 'TXTDEFAULTEMAIL', 2, 0),
(575, 'TXTDEFAULTLANGUAGE', 2, 0),
(576, 'TXTCLIENTPORTALTHEME', 2, 0),
(577, 'TXTCLIENTPORTAL', 2, 0),
(578, 'TXTUPDATECLIENTPORTAL', 2, 0),
(579, 'TXTOUTGOINGEMAIL', 2, 0),
(580, 'TXTTIMEZONE', 2, 0),
(581, 'TXTDSTSETTINGS', 2, 0),
(582, 'TXTAUTOAPPROVEREGISTRATION', 2, 0),
(583, 'TXTENABLECAPTCHAONREGISTER', 2, 0),
(584, 'TXTAPPROVE', 2, 0),
(585, 'TXTDISAPPROVED', 2, 0),
(586, 'TXTADDTOPIN', 2, 0),
(587, 'TXTLOGINASCLIENT', 2, 0),
(588, 'TXTADDTICKET', 2, 0),
(590, 'TXTGROUPTYPE', 2, 0),
(591, 'TXTUSERREGISTRATION', 2, 0),
(592, 'TXTUSERTICKETCREATION', 2, 0),
(593, 'TXTSTAFFTICKETCREATION', 2, 0),
(594, 'TXTDEPARTMENTACCESS', 2, 0),
(595, 'TXTALLDEPARTMENTS', 2, 0),
(596, 'TXTTYPE', 2, 0),
(597, 'TXTADDTICKETTYPE', 2, 0),
(598, 'TXTDELTKTTYPE', 2, 0),
(599, 'TXTFIELDS', 2, 0),
(600, 'TXTFIELDDETAILS', 2, 0),
(601, 'TXTFIELDTITLE', 2, 0),
(602, 'TXTDEFAULTVALUE', 2, 0),
(603, 'TXTFIELDDESCRIPTION', 2, 0),
(604, 'TXTISREQUIRED', 2, 0),
(605, 'TXTUSEREDITABLE', 2, 0),
(606, 'TXTSTAFFEDITABLE', 2, 0),
(608, 'TXTNUMERIC', 2, 0),
(609, 'TXTALPHABETIC', 2, 0),
(610, 'TXTALPHANUMERIC', 2, 0),
(611, 'TXTOPTIONFIELDS', 2, 0),
(612, 'TXTADDNEWCUSTOMFIELD', 2, 0),
(613, 'TXTDELETECUSTOMFIELD', 2, 0),
(614, 'TXTCUSTOMIZATIONS', 2, 0),
(615, 'TXTHTMLTAGS', 2, 0),
(616, 'TXTTEXTBOX', 2, 0),
(617, 'TXTTEXTAREA', 2, 0),
(618, 'TXTCHECKBOX', 2, 0),
(619, 'TXTRADIO', 2, 0),
(620, 'TXTSELECTMULTIPLE', 2, 0),
(621, 'TXTFILE', 2, 0),
(622, 'TXTREGULAREXPRESSIONVALIDATION', 2, 0),
(623, 'TXTADDEMAILTEMPLATE', 2, 0),
(624, 'TXTDELETEETEMPLATE', 2, 0),
(625, 'TXTCONTENT', 2, 0),
(626, 'TXTADDFLAG', 2, 0),
(627, 'TXTDELFLAG', 2, 0),
(628, 'TXTFLAGNAME', 2, 0),
(629, 'TXTFLAGCOLOR', 2, 0),
(630, 'MSGLANGTRANSFORFLAG', 2, 0),
(631, 'TXTFILENAME', 2, 0),
(632, 'TXTLANGUGAGECODE', 2, 0),
(633, 'TXTCHARACTERSET', 2, 0),
(634, 'TXTLANGUAGECODE', 2, 0),
(635, 'TXTDIRECTION', 2, 0),
(636, 'TXTRIGHTTOLEFT', 2, 0),
(637, 'TXTLEFTTORIGHT', 2, 0),
(638, 'TXTLEFTPANELVIEW', 2, 0),
(639, 'TXTSENTMAIL', 2, 0),
(640, 'TXTTOGGLELEFTPANEL', 2, 0),
(641, 'TXTSETTINGS', 2, 0),
(642, 'TXTPINNEDITEM', 2, 0),
(643, 'TXTQUICKVIEW', 2, 0),
(644, 'TXTBACKTOLOGIN', 2, 0),
(645, 'TXTFORGOTPASSWORD', 2, 0),
(646, 'TXTMAILQUEUES', 2, 0),
(647, 'TXTADDMAILQUEUE', 2, 0),
(648, 'TXTDELMAILQ', 2, 0),
(649, 'TXTFETCHTYPE', 2, 0),
(650, 'TXTLOGININFORMATION', 2, 0),
(651, 'TXTHOSTNAME', 2, 0),
(652, 'TXTDATABASENAME', 2, 0),
(653, 'TXTTABLEPREFIX', 2, 0),
(654, 'TXTPORT', 2, 0),
(655, 'TXTSSL', 2, 0),
(656, 'TXTSMTPAUTHENTICATION', 2, 0),
(657, 'TXTLEAVEACOPYONSERVER', 2, 0),
(658, 'TXTQUEUETITLE', 2, 0),
(659, 'TXTFROMNAME', 2, 0),
(660, 'TXTFROMEMAIL', 2, 0),
(661, 'TXTQUEUESETTING', 2, 0),
(662, 'TXTSIGNATURE', 2, 0),
(663, 'TXTLEAVECOMMENT', 2, 0),
(664, 'TXTCOMMENTSUB', 2, 0),
(665, 'TXTMAILDETAILS', 2, 0),
(666, 'TXTSELFHELP', 2, 0),
(667, 'TXTCATEGORIES', 2, 0),
(668, 'TXTCOMMENTS', 2, 0),
(669, 'TXTARTICLE', 2, 0),
(670, 'TXTPOSTEDBY', 2, 0),
(671, 'TXTALLOWCOMMENTS', 2, 0),
(672, 'TXTALLOWRATINGS', 2, 0),
(673, 'TXTSTICKTOHOMEPAGE', 2, 0),
(674, 'TXTALLOWATTACHMENTTOCLIENTS', 2, 0),
(675, 'TXTLOGINCOMPULSORYTOCLIENT', 2, 0),
(676, 'TXTAUTOSUBSCRIBEAFTERCOMMENT', 2, 0),
(677, 'TXTROOT', 2, 0),
(678, 'TXTPARENTCATEGORY', 2, 0),
(679, 'TXTKNOWLEDGEBASE', 2, 0),
(680, 'TXTSUGGESTION', 2, 0),
(681, 'TXTQUESTIONANDANSWER', 2, 0),
(682, 'TXTANSWER', 2, 0),
(683, 'TXTORDERBY', 2, 0),
(684, 'TXTNEWFIRST', 2, 0),
(685, 'TXTOLDFIRST', 2, 0),
(686, 'TXTMODIFIEDFIRST', 2, 0),
(687, 'TXTVISIBLETO', 2, 0),
(688, 'TXTEVERYBODY', 2, 0),
(689, 'TXTSTAFFONLY', 2, 0),
(690, 'TXTLOGGEDINCLIENT', 2, 0),
(691, 'TXTISENABLED', 2, 0),
(692, 'TXTPOSTARTICLE', 2, 0),
(693, 'TXTAUTHOR', 2, 0),
(694, 'TXTADDCATEGORY', 2, 0),
(695, 'TXTADDARTICLE', 2, 0),
(696, 'TXTADDEDARTICLE', 2, 0),
(697, 'TXTDELCATEGORY', 2, 0),
(698, 'TXTDELARTICLE', 2, 0),
(699, 'TXTSELFHELPSUGGESTION', 2, 0),
(700, 'TXTENABLECAPTCHAONCOMMENT', 2, 0),
(701, 'TXTQUICKINSERT', 2, 0),
(702, 'TXTMORE', 2, 0),
(703, 'TXTFEATUREDARTICLES', 2, 0),
(704, 'TXTWELCOME', 2, 0),
(705, 'MSGWELCOMELINE', 2, 0),
(706, 'MSGWELCOMELINE1', 2, 0),
(707, 'MSGWELCOMELINE2', 2, 0),
(708, 'TXTREPORTS', 2, 0),
(709, 'TXTADDREPORT', 2, 0),
(710, 'TXTVIEWRESULT', 2, 0),
(711, 'TXTMIGRATION', 2, 0),
(712, 'TXTADVANCEDSEARCH', 2, 0),
(713, 'TXTHOME', 2, 0),
(714, 'TXTINBOX', 2, 0),
(715, 'TXTTAGS', 2, 0),
(716, 'TXTDELETETAGS', 2, 0),
(717, 'TXTTAGSEARCH', 2, 0),
(718, 'TXTRECENTACTIVITIES', 2, 0),
(719, 'TXTADDMODULE', 2, 0),
(720, 'TXTDELMODULE', 2, 0),
(721, 'TXTHEADERTITLE', 2, 0),
(722, 'TXTDISPLAYONQUICKVIEW', 2, 0),
(725, 'TXTFAILED', 2, 0),
(726, 'TXTSUCCESS', 2, 0),
(727, 'TXTTHEME', 2, 0),
(728, 'TXTSESSIONTIMEOUT', 2, 0),
(729, 'TXTINMINUTES', 2, 0),
(730, 'TXTSOUNDALERT', 2, 0),
(731, 'TXTHTMLEDITOR', 2, 0),
(732, 'TXTCOLOR', 2, 0),
(733, 'MSGLANGTRANSFORPRIO', 2, 0),
(734, 'TXTADDPRIORITY', 2, 0),
(735, 'TXTUPDATEPRIORITY', 2, 0),
(736, 'TXTDELPRIORITY', 2, 0),
(737, 'TXTPURCHASEORUPGRADE', 2, 0),
(738, 'MSGLANGTRANSFORSTUS', 2, 0),
(739, 'MSGLANGTRANSFORTYPE', 2, 0),
(740, 'TXTNOTISPOTKT', 2, 0),
(741, 'TXTNOTISPOGTKT', 2, 0),
(742, 'TXTTKTPSTGRM', 2, 0),
(743, 'TXTRTKTPSTGRM', 2, 0),
(744, 'TXTADDSCHEDULE', 2, 0),
(745, 'TXTDELETESCHEDULE', 2, 0),
(746, 'TXTSUNDAY', 2, 0),
(747, 'TXTMONDAY', 2, 0),
(748, 'TXTTUESDAY', 2, 0),
(749, 'TXTWEDNESDAY', 2, 0),
(750, 'TXTTHURSDAY', 2, 0),
(751, 'TXTFRIDAY', 2, 0),
(752, 'TXTSATURDAY', 2, 0),
(753, 'TXTOPEN24HOURS', 2, 0),
(754, 'TXTCLOSE', 2, 0),
(755, 'TXTOPEN', 2, 0),
(756, 'TXTCUSTOMTIME', 2, 0),
(757, 'TXTHOURS', 2, 0),
(758, 'TXTMINUTES', 2, 0),
(759, 'TXTADDWORKFLOW', 2, 0),
(760, 'TXTDELWRKFLOW', 2, 0),
(761, 'TXTCHANGEDEPARTMENT', 2, 0),
(762, 'TXTNOCHANGE', 2, 0),
(763, 'TXTASSIGNSTAFF', 2, 0),
(764, 'TXTCHANGESTATUS', 2, 0),
(765, 'TXTCHANGEPRIORITY', 2, 0),
(766, 'TXTCHANGEFLAG', 2, 0),
(767, 'TXTCHANGETICKETTYPE', 2, 0),
(768, 'TXTCHANGESLA', 2, 0),
(769, 'TXTIGNOREEMAIL', 2, 0),
(770, 'TXTSENDAUTORESPONDERMESSAGE', 2, 0),
(771, 'TXTPROCESSTICKETALERTRULES', 2, 0),
(772, 'MSGDONOTPARSEASTICKETREPLY', 2, 0),
(773, 'TXTFORWORDTO', 2, 0),
(774, 'TXTMARKEDASBANNED', 2, 0),
(775, 'TXTMARKEDASSPAM', 2, 0),
(776, 'TXTIMGVERIFY', 2, 0),
(777, 'TXTTYPTWWRD', 2, 0),
(778, 'TXTREFRESH', 2, 0),
(779, 'TXTSUBMIT', 2, 0),
(780, 'TXTCHANGE', 2, 0),
(781, 'TXTOK', 2, 0),
(782, 'TXTON', 2, 0),
(783, 'TXTCANCEL', 2, 0),
(784, 'TXTOPTIONS', 2, 0),
(785, 'TXTNONE', 2, 0),
(786, 'TXTPUBLIC', 2, 0),
(787, 'TXTPRIVATE', 2, 0),
(788, 'TXTPOSTON', 2, 0),
(789, 'TXTCREATEDON', 2, 0),
(790, 'TXTMODIFIEDON', 2, 0),
(791, 'TXTYES', 2, 0),
(792, 'TXTNO', 2, 0),
(793, 'TXTENABLE', 2, 0),
(794, 'TXTDISABLE', 2, 0),
(795, 'TXTENABLED', 2, 0),
(796, 'TXTDISABLED', 2, 0),
(797, 'TXTDISPLAYORDER', 2, 0),
(798, 'TXTPAGE', 2, 0),
(799, 'TXTADD', 2, 0),
(800, 'TXTUPDATE', 2, 0),
(802, 'TXTNEXT', 2, 0),
(803, 'TXTCLEAR', 2, 0),
(804, 'TXTFINISH', 2, 0),
(805, 'MSGCUSTOMGRPDEL', 2, 0),
(806, 'MSGMODSHCONCHARFRMATOZOLY', 2, 0),
(807, 'MSGCUSTRQGR', 2, 0),
(808, 'MSGCLGRDEL', 2, 0),
(809, 'MSGDEPTDEL', 2, 0),
(810, 'MSGDELDOM', 2, 0),
(811, 'MSGDELCAT', 2, 0),
(812, 'MSGDELART', 2, 0),
(813, 'MSGSTCNDEL', 2, 0),
(814, 'MSGPRCNDEL', 2, 0),
(815, 'MSGTYCNDEL', 2, 0),
(816, 'MSGFLCNDEL', 2, 0),
(817, 'MSGSFCNDEL', 2, 0),
(818, 'MSGREQFILNTFNDFRMOD', 2, 0),
(819, 'MSGIMGVERIFY', 2, 0),
(820, 'MSGREQFILMODNM', 2, 0),
(821, 'MSGSETTUNAVIL', 2, 0),
(822, 'MSGMTMLOG', 2, 0),
(823, 'MSGLGNTSEL', 2, 0),
(824, 'MSGAPPROVEPENDING', 2, 0),
(825, 'MSGERRLGEMT', 2, 0),
(826, 'MSGEXPLGEMT', 2, 0),
(827, 'MSGREQFLDSCHNM', 2, 0),
(828, 'MSGDUETIMENTSET', 2, 0),
(829, 'MSGRESTIMENTSET', 2, 0),
(830, 'MSGREQSUB', 2, 0),
(831, 'MSGINVLAIDAMT', 2, 0),
(832, 'MSGCLIENDIDMISS', 2, 0),
(833, 'MSGCLIENDEMLMISS', 2, 0),
(834, 'MSGTKTIDMISS', 2, 0),
(835, 'MSGFLRTTTMISS', 2, 0),
(836, 'MSGREQFLDTIT', 2, 0),
(837, 'MSGPSTMISS', 2, 0),
(838, 'MSGSNDRMISS', 2, 0),
(839, 'MSGINFOMISS', 2, 0),
(840, 'MSGTAGNMMISS', 2, 0),
(841, 'MSGINVOPT', 2, 0),
(842, 'MSGSNGLTKT', 2, 0),
(843, 'MSGSUCCOPRT', 2, 0),
(844, 'MSGERROPRT', 2, 0),
(845, 'MSGINVMISS', 2, 0),
(846, 'MSGINVLDOLDPWD', 2, 0),
(847, 'MSGSTFNTSEL', 2, 0),
(848, 'MSGBLBIDNTFND', 2, 0),
(849, 'MSGCLGRPIDNTFND', 2, 0),
(850, 'MSGGRNMISS', 2, 0),
(851, 'MSGPASSMISSMTCH', 2, 0),
(852, 'MSGPASSSET', 2, 0),
(853, 'MSGCLTEMAILEXIST', 2, 0),
(854, 'MSGEMAILMISS', 2, 0),
(855, 'MSGFNAMEMISS', 2, 0),
(856, 'MSGLNAMEMISS', 2, 0),
(857, 'MSGUNAMEMISS', 2, 0),
(858, 'MSGFLDNTSEL', 2, 0),
(859, 'MSGEVTNTSEL', 2, 0),
(860, 'MSGMGRTDANTSEL', 2, 0),
(861, 'MSGACCSSDND', 2, 0),
(862, 'MSGSURE', 2, 0),
(863, 'MSGCLTDELETE', 2, 0),
(864, 'MSGPURCHASEORUPGRADEMES', 2, 0),
(865, 'MSGCOREMODULEDELETE', 2, 0),
(866, 'MSGINCOMPLETEINFO', 2, 0),
(867, 'MSGINVALIDLOGINDETAILS', 2, 0),
(868, 'MSGQUICKWIDGETNOTFND', 2, 0),
(869, 'MSGEMPTYERRLOG', 2, 0),
(870, 'MSGCONTACTNOTFOUND', 2, 0),
(871, 'MSGCLIENTADDED', 2, 0),
(872, 'MSGCLIENTREMOVED', 2, 0),
(873, 'MSGDOMAINNOTFOUND', 2, 0),
(874, 'MSGDEPTNTFND', 2, 0),
(875, 'MSGSTFNTFND', 2, 0),
(876, 'MSGDATANOTFND', 2, 0),
(877, 'MSGNEWTKTCRT', 2, 0),
(878, 'MSGTKTRPLD', 2, 0),
(879, 'MSGSTSUPD', 2, 0),
(880, 'MSGPRIOUPD', 2, 0),
(881, 'MSGDEPTCHNG', 2, 0),
(882, 'MSGTKTTYPCHG', 2, 0),
(883, 'MSGFLGCHG', 2, 0),
(884, 'MSGTKTASSIG', 2, 0),
(885, 'MSGTKTTRSH', 2, 0),
(886, 'MSGTKTMRGD', 2, 0),
(887, 'MSGTKTFRWD', 2, 0),
(888, 'MSGTKTDELETED', 2, 0),
(889, 'MSGSLACHG', 2, 0),
(890, 'MSGSPAMMRK', 2, 0),
(891, 'MSGUNSPAM', 2, 0),
(892, 'MSGCANNOTREMOVEFIRSTCRIRERIA', 2, 0),
(893, 'MSGREQFILDISORDER', 2, 0),
(894, 'MSGREQFILDISORDERNUM', 2, 0),
(895, 'vis_ticket_hash', 2, 0),
(896, 'vis_ticket_id', 2, 0),
(897, 'vis_ticket_subject', 2, 0),
(898, 'vis_ticket_type', 2, 0),
(899, 'vis_ticket_domain', 2, 0),
(900, 'vis_ticket_department', 2, 0),
(901, 'vis_ticket_status', 2, 0),
(902, 'vis_ticket_priority', 2, 0),
(903, 'vis_ticket_receive_date', 2, 0),
(904, 'vis_ticket_modify_date', 2, 0),
(905, 'vis_ticket_due_time', 2, 0),
(906, 'vis_ticket_resolution_time', 2, 0),
(907, 'vis_ticket_slaplan', 2, 0),
(908, 'vis_ticket_sla_id', 2, 0),
(909, 'vis_ticket_post_count', 2, 0),
(910, 'vis_ticket_count', 2, 0),
(911, 'vis_client_first_name', 2, 0),
(912, 'vis_client_last_name', 2, 0),
(913, 'vis_client_email', 2, 0),
(914, 'vis_client_contact_number', 2, 0),
(915, 'vis_client_job_title', 2, 0),
(916, 'vis_client_office_name', 2, 0),
(917, 'vis_client_city', 2, 0),
(918, 'vis_client_state', 2, 0),
(919, 'vis_client_country', 2, 0),
(920, 'vis_client_zip_code', 2, 0),
(922, 'vis_client_group_type', 2, 0),
(923, 'vis_client_is_spam', 2, 0),
(924, 'vis_client_is_banned', 2, 0),
(925, 'vis_client_credit', 2, 0),
(926, 'vis_client_debit', 2, 0),
(927, 'vis_client_group_credit', 2, 0),
(928, 'vis_client_group_debit', 2, 0),
(929, 'vis_client_paid_invoice_count', 2, 0),
(930, 'vis_client_unpaid_invoice_count', 2, 0),
(931, 'vis_first_name', 2, 0),
(932, 'vis_last_name', 2, 0),
(933, 'vis_email', 2, 0),
(934, 'vis_contact_number', 2, 0),
(935, 'vis_mobile_number', 2, 0),
(936, 'vis_job_title', 2, 0),
(937, 'vis_office_name', 2, 0),
(938, 'vis_city', 2, 0),
(939, 'vis_state', 2, 0),
(940, 'vis_country', 2, 0),
(941, 'vis_zip_code', 2, 0),
(1648, 'TXTCHANGECHANNEL', 2, 0),
(943, 'vis_domain_name', 2, 0),
(945, 'vis_is_spam', 2, 0),
(946, 'vis_is_banned', 2, 0),
(947, 'vis_avg_response', 2, 0),
(948, 'vis_post_count', 2, 0),
(949, 'TXTPROPERTIES', 2, 0),
(950, 'TXTPEOPLE', 2, 0),
(951, 'TXTOR', 2, 0),
(952, 'MSGRECORDMISS', 2, 0),
(953, 'MSGMDLEXST', 2, 0),
(954, 'MSGVIVCNTDEL', 2, 0),
(955, 'TXTSEARCHTRASH', 2, 0),
(956, 'TXTSEARCHSPAM', 2, 0),
(957, 'TXTTRASH', 2, 0),
(958, 'TXTSPAM', 2, 0),
(959, 'TXTPRINT', 2, 0),
(960, 'MSGTKTNTACC', 2, 0),
(961, 'TXTONOVERDUE', 2, 0),
(962, 'TXTOPTION', 2, 0),
(963, 'TXTDELETEFILTER', 2, 0),
(964, 'TXTDRAFT', 2, 0),
(965, 'TXTTKTLOCK', 2, 0),
(966, 'TXTTOSHAREWITHALLDONOTSELECTSTAFF', 2, 0),
(967, 'TXTGO', 2, 0),
(968, 'TXTDELETEREPORT', 2, 0),
(969, 'MSGSTAFFSAMEDETAILS', 2, 0),
(970, 'TXTDELETESMTP', 2, 0),
(971, 'MSGDELMLOG', 2, 0),
(972, 'TXTCLIENTDETAILS', 2, 0),
(973, 'TXTCLIENTNOTES', 2, 0),
(974, 'TXTPRODANDSER', 2, 0),
(975, 'TXTPACKAGE', 2, 0),
(976, 'TXTDEDICATEDIP', 2, 0),
(977, 'TXTWHMCSCLIENTNOTES', 2, 0),
(978, 'MSGERRINWHDTABASSEL', 2, 0),
(979, 'MSGERRINWHDTABASCON', 2, 0),
(980, 'MSGWHINTDETNTSET', 2, 0),
(981, 'TXTVERSION', 2, 0),
(982, 'TXTBRANDING', 2, 0),
(983, 'MSGINVADDFORTKT', 2, 0),
(984, 'MSGBALFORINV', 2, 0),
(985, 'MSGBALMISS', 2, 0),
(986, 'MSGINVDESC1', 2, 0),
(987, 'MSGINVDESC2', 2, 0),
(988, 'TXTEDITTRANSACTION', 2, 0),
(989, 'TXTTRANSACTIONS', 2, 0),
(990, 'TXTTRANSACTIONID', 2, 0),
(991, 'TXTDELTRANSACTION', 2, 0),
(992, 'TXTADDPAYMENT', 2, 0),
(993, 'TXTRATE', 2, 0),
(994, 'TXTINCLUSIVE', 2, 0),
(995, 'TXTEXCLUSIVE', 2, 0),
(996, 'TXTADDTAX', 2, 0),
(997, 'TXTEDITTAX', 2, 0),
(998, 'MSGINVRATE', 2, 0),
(999, 'TXTDELTAX', 2, 0),
(1000, 'TXTVIEWINVOICETOCLI', 2, 0),
(1001, 'TXTPAYNOW', 2, 0),
(1002, 'TXTGETPDF', 2, 0),
(1003, 'TXTSUBTOTAL', 2, 0),
(1004, 'TXTINVOICETO', 2, 0),
(1005, 'TXTMOVETOINBOX', 2, 0),
(1006, 'TXTGATEWAY', 2, 0),
(1007, 'TXTMARKUNPAID', 2, 0),
(1008, 'TXTMARKCANCEL', 2, 0),
(1009, 'TXTGREATEREQLTHAN', 2, 0),
(1010, 'TXTADDITEM', 2, 0),
(1011, 'TXTEMAILTEMPLATESMAP', 2, 0),
(1012, 'TXTCONVEERTTKT', 2, 0),
(1013, 'TXTADDSEARCH', 2, 0),
(1014, 'TXTCONKEY', 2, 0),
(1015, 'TXTCONSKEY', 2, 0),
(1016, 'TXTUSRKEY', 2, 0),
(1017, 'TXTUSRSKEY', 2, 0),
(1018, 'MSGCHECKTICKETDTL', 2, 0),
(1019, 'TXTSOCIALMEDIA', 2, 0),
(1020, 'TXTSEARCHCONTENT', 2, 0),
(1021, 'TXTADDSOCIALMEDIA', 2, 0),
(1022, 'TXTAUTOTICKETCONVERT', 2, 0),
(1023, 'TXTCREATEAPP', 2, 0),
(1024, 'TXTTWITTERAPPURL', 2, 0),
(1025, 'TXTGENERATEREQDETAILS', 2, 0),
(1026, 'TXTHIDDEN', 2, 0),
(1027, 'TXTAPIID', 2, 0),
(1028, 'TXTSMSALERT', 2, 0),
(1029, 'TXTGENERATE', 2, 0),
(1030, 'TXTCUSTOM', 2, 0),
(1031, 'TXTPORTALCOLOR', 2, 0),
(1032, 'TXTMD5PSS', 2, 0),
(1033, 'TXTAPPROVED', 2, 0),
(1034, 'TXTUNAPPROVED', 2, 0),
(1035, 'MSGDEPTDELLMT', 2, 0),
(1036, 'TXTCC', 2, 0),
(1037, 'TXTVIEWAFTERLOGING', 2, 0),
(1038, 'TXTTYPEHERE', 2, 0),
(1039, 'MSGREQRECPT', 2, 0),
(1040, 'TXTPORTALLOGO', 2, 0),
(1041, 'TXTSAVEREPLY', 2, 0),
(1042, 'MSGDELETEDEF', 2, 0),
(1043, 'TXTDATA', 2, 0),
(1044, 'TXTGRAPICAL', 2, 0),
(1045, 'TXTRDN', 2, 0),
(1046, 'TXTBASEDN', 2, 0),
(1047, 'TXTMOVETICKETS', 2, 0),
(1048, 'TXTDATEFORMAT', 2, 0),
(1049, 'TXTDATETIMEFORMAT', 2, 0),
(1050, 'TXTPRODUCT', 2, 0),
(1051, 'TXTPRODUCTS', 2, 0),
(1052, 'TXTDELPRODUCT', 2, 0),
(1053, 'TXTADDPRODUCT', 2, 0),
(1054, 'TXTCASHBAL', 2, 0),
(1055, 'TXTTKTBAl', 2, 0),
(1056, 'TXTPRICE', 2, 0),
(1057, 'TXTCREDITTYPE', 2, 0),
(1058, 'TXTORDERNOW', 2, 0),
(1059, 'TXTORDERS', 2, 0),
(1060, 'TXTORDER', 2, 0),
(1061, 'TXTVALIDITY', 2, 0),
(1062, 'TXTVALIDITY0', 2, 0),
(1063, 'TXTVALIDITY1', 2, 0),
(1064, 'TXTVALIDITY2', 2, 0),
(1065, 'TXTVALIDITY3', 2, 0),
(1066, 'TXTVALIDITY4', 2, 0),
(1067, 'TXTEMPTYTRASH', 2, 0),
(1068, 'TXTASCLIENT', 2, 0),
(1069, 'TXTINCOME', 2, 0),
(1070, 'TXTEDITPRODUCT', 2, 0),
(1071, 'TXTDELFBINT', 2, 0),
(1072, 'TXTUNLIMITED', 2, 0),
(1073, 'TXTINVLIDFIELD', 2, 0),
(1074, 'TXTAVGSLA', 2, 0),
(1075, 'TXTLABELEXIST', 2, 0),
(1076, 'TXTCNTCLIENTAD', 2, 0),
(1077, 'TKTMRGCLIENT', 2, 0),
(1078, 'TKTMRGCONTACT', 2, 0),
(1079, 'TXTCUSTDUETIME', 2, 0),
(1080, 'TXTDELETELABEL', 2, 0),
(1081, 'TXTONUNRESOLVED', 2, 0),
(1082, 'TXTAPPROVALPENDING', 2, 0),
(1083, 'TXTAPILOGINID', 2, 0),
(1084, 'TXTTRANSACTIONKEY', 2, 0),
(1085, 'TXTGATEWAYMODE', 2, 0),
(1086, 'TXTINPROCESS', 2, 0),
(1087, 'TXTGATEWAYTRANSACTIONS', 2, 0),
(1088, 'TXTGATEWAYTRANSACTIONDETAILS', 2, 0),
(1089, 'MSGDELETEGATEWAYTXNLOG', 2, 0),
(1090, 'MSGTRUNCATEGATEWAYTXNLOG', 2, 0),
(1091, 'TXTRECURRING', 2, 0),
(1092, 'TXTTICKETHASHGENERATION', 2, 0),
(1093, 'TXTRANDOM', 2, 0),
(1094, 'TXTSEQUENTIAL', 2, 0),
(1095, 'TXTPREFIX', 2, 0),
(1096, 'TXTNUMERINGSTARTSFROM', 2, 0),
(1097, 'MSGTICKETHASHPREFIXERROR', 2, 0),
(1098, 'MSGTICKETNUMERINGSTARTSFROMERROR', 2, 0),
(1099, 'TXTAUTHENTICATIONERROR', 2, 0),
(1100, 'TXTCONNECTIONERROR', 2, 0),
(1101, 'TXTSMTPAUTHENTICATIONERROR', 2, 0),
(1102, 'TXTCLIENTSEARCH', 2, 0),
(1103, 'TXTISAPPROVE', 2, 0),
(1104, 'TXTSELFHELPSEARCH', 2, 0),
(1105, 'TXTEXPORTALL', 2, 0),
(1106, 'TXTNOTIFICATION', 2, 0),
(1107, 'TXTDISPLAYNOTIFICATION', 2, 0),
(1108, 'TXTISFORWARDEMAIL', 2, 0),
(1109, 'TXTFORWARDEMAIL', 2, 0),
(1110, 'TXTVERIFYEMAILQUEUE', 2, 0),
(1111, 'TXTSTARTTIMER', 2, 0),
(1112, 'TXTSTOPTIMER', 2, 0),
(1113, 'TXTTIMETRACK', 2, 0),
(1114, 'TXTADDTIMETRACK', 2, 0),
(1115, 'TXTTIMETRACKID', 2, 0),
(1116, 'TXTBILLTIME', 2, 0),
(1117, 'TXTWORKTIME', 2, 0),
(1118, 'MSGTTVMISS', 2, 0),
(1119, 'TXTDELETETIMETRACK', 2, 0),
(1121, 'TXTLOADMOREPOST', 2, 0),
(1122, 'TXTSHOWINLINEIMG', 2, 0),
(1123, 'TXTHIDEINLINEIMG', 2, 0),
(1124, 'TXTSLACHANGE', 2, 0),
(1125, 'MSGSNGLTKTEXPORT', 2, 0),
(1126, 'TXTGLOBALSEARCHRESULT', 2, 0),
(1127, 'TXTGLOBALSEARCHERROR', 2, 0),
(1128, 'TXTSTAFFNOTIFICATION', 2, 0),
(1129, 'TXTLOADMORE', 2, 0),
(1130, 'TXTEXPORTCSV', 2, 0),
(1131, 'TXTFILTERLIST', 2, 0),
(1132, 'TXTLISTCOLUMN', 2, 0),
(1133, 'TXTUPDATEVIEW', 2, 0),
(1134, 'TXTATTACHMENT', 2, 0),
(1135, 'TXTSTAR', 2, 0),
(1136, 'TXTLATESTPOST', 2, 0),
(1137, 'TXTMANAGEPORTAL', 2, 0),
(1138, 'TXTMANAGEPORTALLOGO', 2, 0),
(1139, 'TXTMANAGEPORTALCOLOR', 2, 0),
(1140, 'TXTNEWTICKET', 2, 0),
(1141, 'TXTASGNDEPT', 2, 0),
(1142, 'TXTUPDATESTAFF', 2, 0),
(1143, 'TXTPERMISSION', 2, 0),
(1144, 'TXTUPDATESTAFFGROUP', 2, 0),
(1145, 'TXTUPDATEADMINACCESS', 2, 0),
(1146, 'TXTCHANGEOWNER', 2, 0),
(1147, 'TXTCHANGETYPE', 2, 0),
(1148, 'TXTSPLITTICKET', 2, 0),
(1149, 'TXTLINKUNLINKTICKET', 2, 0),
(1150, 'TXTUPDATESTATUS', 2, 0),
(1151, 'TXTUPDATEWORKFLOW', 2, 0),
(1152, 'TXTHOLIDAYS', 2, 0),
(1153, 'TXTADDHOLIDAY', 2, 0),
(1154, 'TXTDELETEHOLIDAY', 2, 0),
(1155, 'TXTUPDATEHOLIDAY', 2, 0),
(1156, 'TXTUPDATETYPE', 2, 0),
(1157, 'MSGLANGTRANSFORHOLI', 2, 0),
(1158, 'TXTUPDATESCHEDULE', 2, 0),
(1159, 'TXTUPDATEFLAG', 2, 0),
(1160, 'TXTUPDATESLA', 2, 0),
(1161, 'MSGREQFLDDESC', 2, 0),
(1162, 'TXTWHMCS', 2, 0),
(1163, 'TXTADDWHMCS', 2, 0),
(1164, 'TXTUPDATEWHMCS', 2, 0),
(1165, 'TXTDELWHMCS', 2, 0),
(1166, 'TXTTWITTER', 2, 0),
(1167, 'TXTADDTWITTER', 2, 0),
(1168, 'TXTUPDATETWITTER', 2, 0),
(1169, 'TXTDELTWITTER', 2, 0),
(1170, 'TXTFACEBOOK', 2, 0),
(1171, 'TXTADDFACEBOOK', 2, 0),
(1172, 'TXTUPDATEFACEBOOK', 2, 0),
(1173, 'TXTDELFACEBOOK', 2, 0),
(1174, 'TXTSMS', 2, 0),
(1175, 'TXTADDSMS', 2, 0),
(1176, 'TXTUPDATESMS', 2, 0),
(1177, 'TXTDELSMS', 2, 0),
(1178, 'TXTCLICKATELL', 2, 0),
(1179, 'TXTTWOSMS', 2, 0),
(1180, 'TXTSELECTAPI', 2, 0),
(1181, 'TXTTRANSACTIONLOG', 2, 0),
(1182, 'TXTOVERRIDEDETAILS', 2, 0),
(1183, 'TXTUPDATEMAILQUEUE', 2, 0),
(1184, 'TXTUPDATESMTP', 2, 0),
(1185, 'TXTADDSMTP', 2, 0),
(1186, 'TXTDELSMTP', 2, 0),
(1187, 'TXTORGANIZATION', 2, 0),
(1188, 'TXTAPPLYFILTER', 2, 0),
(1189, 'TXTUPDATECUSTOMFIELD', 2, 0),
(1190, 'TXTUPDATECUSTOMGROUP', 2, 0),
(1191, 'TXTPHONE', 2, 0),
(1192, 'TXTADDRESS', 2, 0),
(1193, 'TXTTWITTERID', 2, 0),
(1194, 'TXTFACEBOOKID', 2, 0),
(1195, 'TXTORGANIZATIONDETAILS', 2, 0),
(1196, 'TXTCOMPANY', 2, 0),
(1197, 'TXTUPDATEEMAILTEMPLATE', 2, 0),
(1198, 'TXTUPDATEALERT', 2, 0),
(1199, 'TXTLABELNAME', 2, 0),
(1200, 'TXTADDLABEL', 2, 0),
(1201, 'TXTLABELCOLOR', 2, 0),
(1202, 'TXTUPDATECONTACT', 2, 0),
(1203, 'TXTPAGES', 2, 0),
(1204, 'TXTFETCHPAGES', 2, 0),
(1205, 'TXTPAGENOTFOUND', 2, 0),
(1206, 'TXTUPDATELABEL', 2, 0),
(1207, 'TXTUPDATEMODULE', 2, 0),
(1208, 'TXTTICKETACTIVITY', 2, 0),
(1209, 'TXTEDITPROFILE', 2, 0),
(1210, 'TXTPREFERENCE', 2, 0),
(1211, 'TXTRECENTBLABS', 2, 0),
(1212, 'TXTINTERNALTICKET', 2, 0),
(1213, 'TXTADDCOMMENT', 2, 0),
(1214, 'TXTUPDATEINVOICE', 2, 0),
(1215, 'TXTATTACHFILE', 2, 0),
(1216, 'TXTLASTTICKETACTIVITY', 2, 0),
(1217, 'TXTREPLIED', 2, 0),
(1218, 'TXTAWAITING', 2, 0),
(1219, 'TXTCLOSED', 2, 0),
(1220, 'TXTSTAFFMEMBER', 2, 0),
(1221, 'TXTSKILLS', 2, 0),
(1223, 'TXTPHONENO', 2, 0),
(1224, 'TXTEMPTY', 2, 0),
(1225, 'TXTSENTMAILLOG', 2, 0),
(1226, 'TXTGATEWAYTRANSACTIONSLOG', 2, 0),
(1227, 'MSGCOREMODULESTATUS', 2, 0),
(1228, 'TXTDISPPAGES', 2, 0),
(1229, 'TXTPRODUCTID', 2, 0),
(1230, 'TXTENTRYDATE', 2, 0),
(1231, 'TXTSTAFFCOMMENT', 2, 0),
(1232, 'TXTRECENTACTIVITYCOUNT', 2, 0),
(1233, 'TXTUPLOADIMG', 2, 0),
(1234, 'TXTONLINESTAFF', 2, 0),
(1235, 'TXTPOST', 2, 0),
(1236, 'TXTINSERTURL', 2, 0),
(1237, 'TXTATTACHEDMEDIA', 2, 0),
(1238, 'TXTUPLOADFROMLOCAL', 2, 0),
(1239, 'TXTATTACHMEDIA', 2, 0),
(1240, 'TXTADDORGANIZATION', 2, 0),
(1241, 'TXTUPDATEORGANIZATION', 2, 0),
(1242, 'TXTBILLINGCYCLE', 2, 0),
(2262, 'MSGSUBJECTMISS', 1, 0),
(1244, 'TXTMODIFICATIONDATE', 2, 0),
(1245, 'MSGDEPTMISS', 2, 0),
(1246, 'TXTSELFHELPTICKETSEARCH', 2, 0),
(1247, 'TXTSAVEFILTER', 2, 0),
(1248, 'TXTSAVE', 2, 0),
(1249, 'TXTCREATEDBY', 2, 0),
(1250, 'TXTPARENT', 2, 0),
(1251, 'MSGFILTIDNTFND', 2, 0),
(1252, 'TXTUPDATEFILTER', 2, 0),
(1253, 'TXTRECENTARTICLES', 2, 0),
(1254, 'TXTTOTARTICLES', 2, 0),
(1255, 'TXTTOTCATEGORY', 2, 0),
(1256, 'TXTHELPFULLARTICLES', 2, 0),
(1257, 'TXTMOSTARTICLES', 2, 0),
(1258, 'TXTARTICLES', 2, 0),
(1260, 'TXTCATEGORY', 2, 0),
(1261, 'TXTCOMMENT', 2, 0),
(1262, 'TXTUPDATECOMMENT', 2, 0),
(1263, 'TXTUPDATECATEGORY', 2, 0),
(1264, 'TXTUPDATEARTICLE', 2, 0),
(1265, 'TXTSORTEDBY', 2, 0),
(1266, 'TXTDELCOMMENT', 2, 0),
(1267, 'TXTGRAPHICAL', 2, 0),
(1268, 'TXTNOW', 2, 0),
(1269, 'TXTWORK', 2, 0),
(1270, 'TXTDEPTSLA', 2, 0),
(1271, 'TXTRESPONSE', 2, 0),
(1272, 'TXTPERFORMANCE', 2, 0),
(1273, 'TXTCLIENTSLA', 2, 0),
(1274, 'TXTTKTRATINGS', 2, 0),
(1275, 'TXTTRACKINGSTAFF', 2, 0),
(1276, 'TXTTRACKINGDEPT', 2, 0),
(1277, 'TXTSTAFFSLA', 2, 0),
(1278, 'TXTTOPPERFORMER', 2, 0),
(1279, 'TXTDEPTSTATI', 2, 0),
(1280, 'TXTDURATION', 2, 0),
(1281, 'TXTPURCHASE', 2, 0),
(1282, 'TXTMYPRODUCTS', 2, 0),
(1283, 'TXTMYINVOICES', 2, 0),
(1284, 'TXTDAYS', 2, 0),
(1285, 'TXTTEAM', 2, 0),
(1286, 'TXTSELECTEDSTAFF', 2, 0),
(1287, 'TXTSEARCHBLABS', 2, 0),
(1288, 'TXTSEARCHSTAFF', 2, 0),
(1289, 'TXTYEAR', 2, 0),
(1290, 'TXTEMAILADDRESS', 2, 0),
(1291, 'TXTWEBSITEURL', 2, 0),
(1292, 'TXTLOGOURL', 2, 0),
(1293, 'TXTPAYTOTEXT', 2, 0),
(1294, 'TXTSHIPTO', 2, 0),
(1295, 'TXTQTY', 2, 0),
(1296, 'TXTNOTEHEADERCOLOR', 2, 0),
(1297, 'TXTUPDATEPROFILE', 2, 0),
(1298, 'MSGDOMAINVAL', 2, 0),
(1299, 'MSGCLPORTURL', 2, 0),
(1300, 'MSGREQFILDOM', 2, 0),
(1301, 'MSGREQFILCLPORURL', 2, 0),
(1302, 'MSGREQFILDEFEMAIL', 2, 0),
(1303, 'MSGREQFILDATFOR', 2, 0),
(1304, 'MSGREQFILDATTMFOR', 2, 0),
(1305, 'TXTSELDOM', 2, 0),
(1306, 'TXTMARKASSUPADM', 2, 0),
(1307, 'TXTMARKASDOMADM', 2, 0),
(1308, 'MSGREQFILFRMEMAIL', 2, 0),
(1309, 'MSGREQFILFOREMAIL', 2, 0),
(1310, 'MSGINVFLDFOREMAIL', 2, 0),
(1311, 'MSGINVFLDFRMEMAIL', 2, 0),
(1312, 'TXTRMADMACC', 2, 0),
(1313, 'MSGADMNOTUP', 2, 0),
(1314, 'TXTLABELSTAGS', 2, 0),
(1315, 'MSGTILALPHNUM', 2, 0),
(1317, 'TXTLANGUAGE_SELECT', 2, 0),
(1318, 'TXTDEFAULTVARIABLES', 2, 0),
(1319, 'TXTDASHBOARD', 2, 0),
(1320, 'TXTCHANNELS', 2, 0),
(1321, 'TXTTICKETTYPES', 2, 0),
(1322, 'TXTDISPLAYIPADDRESSTOSTAFF', 2, 0),
(1323, 'TXTNOTHINGTODISPLAY', 2, 0),
(1324, 'TXTIPADDRESS', 2, 0),
(1326, 'TXTINVOICEID', 2, 0),
(1327, 'TXTTRANSACTIONDATE', 2, 0),
(1328, 'TXTTAXX', 2, 0),
(1329, 'TXTNOTEPOSTEDBY', 2, 0),
(1330, 'TXTCOMMENTPOSTEDBY', 2, 0),
(1331, 'MSGBLABCNTNUM', 2, 0),
(1332, 'MSGDUETIMEFORMAT', 2, 0),
(1333, 'MSGRECENTACTIVITYNUM', 2, 0),
(1334, 'MSGATTACHMENTNUM', 2, 0),
(1335, 'MSGMAXATTACHMENTNUM', 2, 0),
(1336, 'MSGTKTHASHPREFIX', 2, 0),
(1337, 'MSGTKTSTARTEMPTY', 2, 0),
(1338, 'MSGTKTPOSTCNTNUM', 2, 0),
(1339, 'MSGFORWARDTO', 2, 0),
(1340, 'MSGFORWARDEMAILMISS', 2, 0),
(1341, 'TXTMARKASBAN', 2, 0),
(1342, 'TXTMARKASSPAM', 2, 0),
(1343, 'MSGREQFILEXEORDER', 2, 0),
(1344, 'MSGREQFILEXEORDERNUM', 2, 0),
(1345, 'MSGDEFAULTCRITERIA', 2, 0),
(1346, 'TXTAUTORESPONDEREMAIL', 2, 0),
(1347, 'TXTUPDATEPRODUCT', 2, 0),
(1348, 'TXTUPDATEPPAYMNT', 2, 0),
(1349, 'TXTUPDATETAX', 2, 0),
(1350, 'TXTPAYPALEMAIL', 2, 0),
(1351, 'TXTAUTHORIZE', 2, 0),
(1352, 'MSGAPIEMPTY', 2, 0),
(1353, 'MSGTRANSACTIONKEYEMPTY', 2, 0),
(1354, 'TXTFORWARDEDTO', 2, 0),
(1355, 'TXTREPLIEDTO', 2, 0),
(1356, 'TXTADDLOCALISATION', 2, 0),
(1357, 'TXTSEARCHWORDPHRESES', 2, 0),
(1358, 'TXTLANGVAR', 2, 0),
(1359, 'TXTLANGVAL', 2, 0),
(1360, 'MSGLANGTRANS', 2, 0),
(1361, 'MSGLANGVARCAP', 2, 0),
(1362, 'MSGREQFILDLANGVAL', 2, 0),
(1363, 'MSGLANGVARAVIL', 2, 0),
(1364, 'MSGSERBOX', 2, 0),
(1365, 'TXTDELLOCAL', 2, 0),
(1366, 'TXTPER', 2, 0),
(1367, 'TXTWEEK', 2, 0),
(1368, 'TXTTICKETSBYTYPE', 2, 0),
(1369, 'TXTTICKETSBYCHANNELS', 2, 0),
(1370, 'TXTTICKETSBYPRIORITIES', 2, 0),
(1371, 'TXTTICKETCREATEDBY', 2, 0),
(1372, 'TXTVIACLIENTPORTAL', 2, 0),
(1373, 'TXTPOINTS', 2, 0),
(1374, 'TXTTKTREPLIEDAFTEROVERDUETIME', 2, 0),
(1375, 'TXTTKTREPLIEDWITHOUTSLA', 2, 0),
(1376, 'TXTTKTREPLIEDWITHINDUETIME', 2, 0),
(1377, 'TXTSELECTDURATION', 2, 0),
(1378, 'TXTLAST24HOURS', 2, 0),
(1379, 'TXTLAST7DAYS', 2, 0),
(1380, 'TXTLAST30DAYS', 2, 0),
(1381, 'TXTALLDOMAIN', 2, 0),
(1382, 'MSGDURATIONEMPTY', 2, 0),
(1383, 'MSGSUCCOTKT', 2, 0),
(1384, 'TXTSHOWRECIPIENTNPEOPLE', 2, 0),
(1385, 'TXTHIDERECIPIENTNPEOPLE', 2, 0),
(1386, 'TXTUPDATECHANNEL', 2, 0),
(1387, 'TXTDELCHANNEL', 2, 0),
(1388, 'MSGCHNCNDEL', 2, 0),
(1389, 'MSGCHLNOTUP', 2, 0),
(1390, 'MSGIMGSIZE', 2, 0),
(1391, 'TXTIMG', 2, 0),
(1392, 'MSGCORECHANNELSTATUS', 2, 0),
(1393, 'TXTMAINTAIN', 2, 0),
(1394, 'MSGSTAFFMISS', 2, 0),
(1395, 'MSGENABLETICKCONV', 2, 0),
(1396, 'MSGRECORDNOTFOUND', 2, 0),
(1397, 'MSGVALIDURL', 2, 0),
(1398, 'MSGSEARCHING', 2, 0),
(1399, 'MSGREQFLDSEMTY', 2, 0),
(1400, 'MSGREQFLDPSWD', 2, 0),
(1401, 'TXTADDTAG', 2, 0),
(1402, 'TXTDELETEBLABCOMMENT', 2, 0),
(1403, 'TXTLOGINTIME', 2, 0),
(1404, 'TXTONLINE', 2, 0),
(1405, 'TXTOFFLINE', 2, 0),
(1406, 'TXTTYPECOMMENTHERE', 2, 0),
(1407, 'TXTBLABSHAREDWITH', 2, 0),
(1408, 'TXTREPLYWITHQUOTE', 2, 0),
(1409, 'TXTDISPLAYNOTEONTICKETDETAILS', 2, 0),
(1410, 'TXTNOTES', 2, 0),
(1411, 'TXTNOMATCHFOUND', 2, 0),
(1412, 'TXTENTTXTLOGO', 2, 0),
(1413, 'TXTTYPETOSEARCHEXISTINGCLIENTSEMAILADDRESS', 2, 0),
(1414, 'TXTTYPEHEREANDPRESSENTERTOSAVE', 2, 0),
(1415, 'MSGCOREORGSTATUS', 2, 0),
(1417, 'MSGWELCOMELINEONE', 1, 0),
(1418, 'MSGWELCOMELINETWO', 1, 0),
(1419, 'TXTTKTBAL', 1, 0),
(1421, 'MSGINFOMISS', 1, 0),
(1426, 'MSGERROPRT', 1, 0),
(1425, 'MSGSUCCOPRT', 1, 0),
(1427, 'TXTLINK', 2, 0),
(1428, 'TXTRELATESTO', 2, 0),
(1429, 'TXTISRELATEDTO', 2, 0),
(1430, 'TXTISAPARENTOF', 2, 0),
(1431, 'TXTISACHILDOF', 2, 0),
(1432, 'TXTDEPENDSON', 2, 0),
(1433, 'TXTISDEPENDEDON', 2, 0),
(1434, 'TXTDUPLICATES', 2, 0),
(1435, 'TXTISADUPLICATEDBY', 2, 0),
(1436, 'TXTVALIDITYONETIME', 1, 0),
(1437, 'TXTVALIDITYMONTHLY', 1, 0),
(1438, 'TXTVALIDITYQUARTERLY', 1, 0),
(1439, 'TXTVALIDITYSEMIANNUALLY', 1, 0),
(1440, 'TXTVALIDITYANNUALLY', 1, 0),
(1441, 'TXTPROFURL', 2, 0),
(1517, 'TXTENTERTICKETSUBJECT', 2, 0),
(1513, 'TXTSPLIT', 2, 0),
(1514, 'TXTSPLITTICKETPOST', 2, 0),
(1515, 'TXTSPLITINTO', 2, 0),
(1516, 'TXTEXISTINGTICKET', 2, 0),
(1462, 'TXTDELETELINK', 2, 0),
(1463, 'TXTUNLINK', 2, 0),
(1464, 'TXTLINKTICKET', 2, 0),
(1518, 'TXTENTERTICKETHASH', 2, 0),
(1519, 'MSGINVOICEITEMNOTFOUND', 2, 0),
(1520, 'TXTINVOICEDATE', 2, 0),
(1521, 'TXTPDF', 2, 0),
(1522, 'TXTINVOICEITEMS', 2, 0),
(1523, 'TXTDESCRIPTIONS', 2, 0),
(1524, 'TXTTAXED', 2, 0),
(1525, 'TXTAPPLYCREDIT', 2, 0),
(1526, 'MSGSELECTEMAILTEMPLATE', 2, 0),
(1527, 'MSGINVAMT', 2, 0),
(1528, 'TXTAVAILABLECREDIT', 2, 0),
(1529, 'TXTDELINVOICEITEM', 2, 0),
(1530, 'TXTREMOVECREDIT', 2, 0),
(1531, 'TXTCREDITAPPLIED', 2, 0),
(1532, 'MSGNUMCREDITVAL', 2, 0),
(1533, 'MSGGREATERCREDITREMOVE', 2, 0),
(1534, 'MSGNOTSUFFICIENTCREDIT', 2, 0),
(1535, 'TXTBALANCE', 2, 0),
(1536, 'TXTSELECTMAILTEMPLATE', 2, 0),
(1537, 'TXTDELORDER', 2, 0),
(1538, 'MSGNOMORECREDITTHANTOTAL', 2, 0),
(1539, 'MSGARTNTSEL', 2, 0),
(1540, 'MSGREQFLDCOT', 2, 0),
(1541, 'TXTDISAPPROVE', 2, 0),
(1542, 'MSGCOMNTSEL', 2, 0),
(1543, 'MSGSERART', 2, 0),
(1544, 'MSGSERARTBOX', 2, 0),
(1545, 'MSGCONTNONUM', 2, 0),
(1546, 'TXTSOCIALMEDIADETAILS', 2, 0),
(1547, 'TXTGOOGLEID', 2, 0),
(1548, 'TXTLINKEDINID', 2, 0),
(1550, 'TXTGAMIFICATION', 2, 0),
(1551, 'TXTADDPOINT', 2, 0),
(1552, 'TXTBONUSPOINT', 2, 0),
(1553, 'TXTAWARDPOINT', 2, 0),
(1554, 'TXTSTAFFLEVEL', 2, 0),
(1555, 'TXTKING', 2, 0),
(1556, 'TXTQUEEN', 2, 0),
(1557, 'TXTROOK', 2, 0),
(1558, 'TXTBISHOP', 2, 0),
(1559, 'TXTKNIGHT', 2, 0),
(1560, 'TXTPAWN', 2, 0),
(1561, 'TXTNUMERICVALIDATIONERROR', 2, 0),
(1562, 'TXTQUEST', 2, 0),
(1563, 'TXTQUESTADD', 2, 0),
(1564, 'TXTQUESTTYPE', 2, 0),
(1565, 'TXTRESOLVINGTYPE', 2, 0),
(1566, 'TXTQUESTOBJECTIVE', 2, 0),
(1567, 'TXTRESOLVE', 2, 0),
(1568, 'TXTBADGE', 2, 0),
(1569, 'TXTNAMEYOURQUEST', 2, 0),
(1570, 'TXTQUESTDESCRIPTION', 2, 0),
(1571, 'TXTARTICLECOUNT', 2, 0),
(1572, 'TXTARTICLERATING', 2, 0),
(1573, 'TXTTICKETSLOVEDSPAN', 2, 0),
(1574, 'TXTTICKETMATCHINGBELOWCONTAIN', 2, 0),
(1575, 'TXTARTICLEQUESTTIMEKNOW', 2, 0),
(1576, 'TXTCREATE', 2, 0),
(1577, 'TXTDELQUEST', 2, 0),
(1578, 'TXTUPDATEQUEST', 2, 0),
(1579, 'TXTSELECTBADGE', 2, 0),
(1580, 'TXTBADGEIMAGEMSG', 2, 0),
(1585, 'MSGINVOICENOTSELECTED', 2, 0),
(1586, 'TXTTHISTICKETISLINKEDWITHOTHER', 2, 0),
(1587, 'TXTTRANSACTION', 2, 0),
(1588, 'TXTUPDATEORDER', 2, 0),
(1589, 'TXTACTIVE', 2, 0),
(1590, 'TXTPENDING', 2, 0),
(1591, 'TXTINCOMPLETE', 2, 0),
(1592, 'TXTPAYMENTSTATUS', 2, 0),
(1593, 'TXTNOINVOICE', 2, 0),
(1594, 'TXTADDINVOICEPAYMENT', 2, 0),
(1595, 'TXTPAYMENTMETHOD', 2, 0),
(1596, 'MSGNUMERICDATAREQ', 2, 0),
(1597, 'MSGSERACHTEXTEMPTY', 1, 0),
(1598, 'TXTNOTHINGTODISPLAY', 1, 0),
(1599, 'TXTTODAYS', 2, 0),
(1600, 'TXTPAYMENTFORINVOICE', 2, 0),
(1601, 'TXTSEARCHINVOICE', 2, 0),
(1602, 'TXTFILTERRESULT', 2, 0),
(1603, 'TXTSORTBY', 1, 0),
(1604, 'TXTSELECTSTAFF', 2, 0),
(1605, 'MSGLISTCNTNUMERIC', 2, 0),
(1606, 'TXTACTIVE', 1, 0),
(1607, 'TXTPENDING', 1, 0),
(1608, 'TXTINCOMPLETE', 1, 0),
(1609, 'TXTINVOICEDUEONDAYS', 2, 0),
(1610, 'MSGNUMERICVALIDATIONFORINVDUE', 2, 0),
(1611, 'MSGNUMERICVALIDATIONFORBILLRT', 2, 0),
(1612, 'TXTOVERVIEW', 2, 0),
(1613, 'TXTTOTALTICKETS', 2, 0),
(1614, 'TXTTICKETSPERHOUR', 2, 0),
(1615, 'TXTTOTALTICKETSREPLIED', 2, 0),
(1616, 'TICKETSREPLEDPERHOUR', 2, 0),
(1617, 'TXTTOTALTICKETSCLOSED', 2, 0),
(1618, 'TXTTICKETSCLOSEDPERHOUR', 2, 0),
(1619, 'TXTOTALOVERDUETICKETS', 2, 0),
(1620, 'TXTAVGSLAMAINTAINED', 2, 0),
(1621, 'TXTYESTERDAY', 2, 0),
(1622, 'TXTSELFHELFARTICLE', 2, 0),
(1623, 'TXTTICKSBYSTATUS', 2, 0),
(1624, 'TXTTEXT', 2, 0),
(1625, 'TXTLASTMONTH', 2, 0),
(1626, 'TXTLASTWEEK', 2, 0),
(1627, 'MSGINVCRED', 2, 0),
(1628, 'MSGPWDRESET', 2, 0),
(1629, 'MSGPLSSELECTDOMAIN', 2, 0),
(1630, 'TXTLOCKED', 2, 0),
(1631, 'TXTUNLOCKED', 2, 0),
(1632, 'TXTCLIENTLANGUAGE', 2, 0),
(1633, 'TXTTOEMAIL', 2, 0),
(1634, 'TXTDELPIN', 2, 0),
(1635, 'MSGMOVETODEPT', 2, 0),
(1636, 'TXTSENDTO', 2, 0),
(1637, 'TXTALLTEAM', 2, 0),
(1638, 'TXTSMALLMORE', 2, 0),
(1640, 'TXTASSIGNEDTO', 2, 0),
(1641, 'MSGTICKHASHTOMRG', 2, 0),
(1642, 'MSGTICKHASHLINK', 2, 0),
(1643, 'TXTMULTIPLEOWNERS', 2, 0),
(1644, 'TXTOWNERS', 2, 0),
(1645, 'TXTSENDNOTIFORNEWBLAB', 2, 0),
(1646, 'TXTCLIENTGRPTICKS', 2, 0),
(1647, 'TXTCHANGELABEL', 2, 0),
(1650, 'TXTSTAFFNM', 2, 0),
(1651, 'TXTTIMETRCK', 2, 0),
(1652, 'TXTFORWARDEDTO', 1, 0),
(1653, 'TXTTO', 1, 0),
(1654, 'TXTREPLIEDTO', 1, 0),
(1655, 'TXTSECURITY', 2, 0),
(1656, 'MSGSENDREGISTRATIONEMAIL', 2, 0),
(1657, 'MSGOPTIONVALREQ', 2, 0),
(1658, 'MSGAUTOGENERATEPASSWORD', 2, 0),
(1659, 'TXTADDSECURITY', 2, 0),
(1660, 'TXTIPSECURITY', 2, 0),
(1661, 'TXTPASSWORDSECURITY', 2, 0),
(1662, 'TXTSECURITYIPCHK', 2, 0),
(1684, 'TXTMACROS', 2, 0),
(1664, 'TXTSINGLE', 2, 0),
(1666, 'TXTRANGE', 2, 0),
(1667, 'TXTIPFROM', 2, 0),
(1668, 'TXTIPTO', 2, 0),
(1669, 'TXTPASSWORDLENGTH', 2, 0),
(1670, 'TXTPASSWORDFORMAT', 2, 0),
(1671, 'MSGSHOWPASSWORD', 2, 0),
(1672, 'MSGIMGVERIFY', 1, 0),
(1673, 'TXTDISPLAYCUSTOMONTICKETDETAILS', 2, 0),
(1674, 'MSGREQFLDARTICLEURL', 2, 0),
(1675, 'MSGMORETHANONEREQFORSPLIT', 2, 0),
(1677, 'ADDIPORRANGE', 2, 0),
(1678, 'TXTIPEX', 2, 0),
(1679, 'TXTIPORIPRANGE', 2, 0),
(1680, 'TXTDELSECURITY', 2, 0),
(1681, 'MSGINVALIDIPR', 2, 0),
(1682, 'MSGINVALIDIP', 2, 0),
(1683, 'MSGIPBAN', 2, 0),
(1685, 'TXTADDMACRO', 2, 0),
(1686, 'TXTUPDATEMACRO', 2, 0),
(1689, 'TXTAPPLYMACRO', 2, 0),
(1688, 'TXTIPORIPRANGELIST', 2, 0),
(1690, 'TXTPASSWORDSRENGTH', 2, 0),
(1695, 'TXTWEAK', 2, 0),
(1693, 'TXTSTRONG', 2, 0),
(1694, 'TXTVERYSTRONG', 2, 0),
(1696, 'TXTALLOWED', 2, 0),
(1697, 'TXTNOTALLOWED', 2, 0),
(1698, 'TXTPASSWORDNOTALLOWED', 2, 0),
(1699, 'TXTPASSWORDSRENGTH', 1, 0),
(1700, 'TXTWEAK', 1, 0),
(1701, 'TXTMEDIUM', 1, 0),
(1702, 'TXTSTRONG', 1, 0),
(1703, 'TXTVERYSTRONG', 1, 0),
(1704, 'TXTNOTALLOWED', 1, 0),
(1705, 'TXTALLOWED', 1, 0),
(1706, 'TXTPASSWORDNOTALLOWED', 1, 0),
(1708, 'TXTGMAIL', 2, 0),
(1709, 'TXTACTIVEDIRECTORY', 2, 0),
(1710, 'TXTDISPLAYSETTINGS', 2, 0),
(1711, 'TXTSHOWPRIORITY', 1, 0),
(1712, 'TXTSHOWPRIORITY', 2, 0),
(1713, 'TXTSHOWTICKETTYPE', 2, 0),
(1714, 'TXTSHOWSTAFFNM', 2, 0),
(1715, 'TXTAPPSECRETE', 2, 0),
(1716, 'TXTREDIRECTURL', 2, 0),
(1717, 'TXTSHOWSLA', 2, 0),
(1718, 'TXTDEVELOPERKEY', 2, 0),
(1720, 'TXTACTIVITYLOG', 2, 0),
(1722, 'TXTACTIVITY', 2, 0),
(1723, 'MSGEMACTIVITYLOG', 2, 0),
(1724, 'TXTSURVEY', 2, 0),
(1725, 'TXTSURVEYGRP', 2, 0),
(1726, 'TXTADDSURVEYGRP', 2, 0),
(1727, 'TXTUPDATESURVEYGRP', 2, 0),
(1728, 'TXTDELETESURVEYGROUP', 2, 0),
(1729, 'MSGDELSURVEYGRP', 1, 0),
(1730, 'MSGDELSURVEYGRP', 2, 0),
(1731, 'TXTADDSURVEY', 2, 0),
(1735, 'TXTDELETESURVEY', 2, 0),
(1733, 'TXTUPDATESURVEY', 2, 0),
(1736, 'TXTSURVEYFIELD', 2, 0),
(1737, 'TXTADDSURVEYFIELD', 2, 0),
(1738, 'TXTDELETESURVEYFIELD', 2, 0),
(1739, 'TXTUPDATESURVEYFIELD', 2, 0),
(1740, 'TXTLIVECHAT', 2, 0),
(1741, 'TXTSURVEY', 1, 0),
(1742, 'MSGALREADYSUBMIT', 1, 0),
(1743, 'TXTNAME', 2, 0),
(1744, 'TXTVISITOR', 2, 0),
(1754, 'MSGPASSMISSMTCH', 1, 0),
(1746, 'TXTCHATDETAILS', 2, 0),
(1747, 'TXTCHATTRANSCRIPT', 2, 0),
(1749, 'TXTCONVERSATIONS', 2, 0),
(1756, 'TXTSCRIPT', 2, 0),
(1753, 'TXTCHAT', 2, 0),
(1757, 'TXTDATEFROM', 2, 0),
(1758, 'TXTDATETO', 2, 0),
(1759, 'TXTVISITOREMAIL', 2, 0),
(1760, 'TXTVISITORNAME', 2, 0),
(1761, 'TXTSTAFFNAME', 2, 0),
(1762, 'TXTCHATDURATION', 2, 0),
(1763, 'TXTSELECTMODULE', 2, 0),
(1764, 'MSGEMAILMISS', 1, 0),
(1765, 'MSGINVALIDLOGINDETAILS', 1, 0),
(1766, 'TXTCLEANUP', 2, 0),
(1767, 'TXTCONVERTTOTICKET', 2, 0),
(1768, 'TXTSYSTEMCLEANUP', 2, 0),
(1769, 'TXTUPTODATE', 2, 0),
(1770, 'MSGCLIENDEMLMISS', 1, 0),
(1771, 'TXTCLEANERROLOG', 2, 0),
(1772, 'TXTCLEANPARSERLOG', 2, 0),
(1773, 'TXTCLEANSENTMAIL', 2, 0),
(1774, 'TXTCLEANGATWAYTLOG', 2, 0),
(1775, 'TXTCLEANACTIVITYLOG', 2, 0),
(1776, 'TXTCLEANAUDITLOG', 2, 0),
(1777, 'MSGFNAMEMISS', 1, 0),
(1778, 'TXTDATEMISS', 2, 0),
(1779, 'MSGREQFLDPSWD', 1, 0),
(1780, 'TXTREPORT', 2, 0),
(1781, 'MSGSURVEYERR', 2, 0),
(1782, 'MSGSURVEYERR', 1, 0),
(1783, 'TXTCHECKOUT', 1, 0),
(1784, 'TXTSELECTEDPRODUCT', 1, 0),
(1785, 'TXTSUBTOTAL', 1, 0),
(1786, 'TXTLIVEZILLA', 2, 0),
(1787, 'TXTSELSURVEY', 2, 0),
(1788, 'MSGERRSELSURVEY', 2, 0),
(1789, 'TXTTASKTITLE', 2, 0),
(1790, 'TXTIMPORT', 2, 0),
(1791, 'MSGSLECTUPLOADCSVFILE', 2, 0),
(1792, 'TXTSELECTCSV', 2, 0),
(1793, 'MSGACCSSDND', 1, 0),
(1794, 'TXTSEARCHSTRING', 2, 0),
(1795, 'TXTCLICKHERE', 2, 0),
(1796, 'TXTSETSCHEDULE', 2, 0),
(1797, 'TXTSENDLOGINDETAILS', 2, 0),
(1798, 'TXTDONOTSENDEMAIL', 2, 0),
(1799, 'MSGSELCLIENT', 2, 0),
(1800, 'TXTGOTOMEETINGS', 2, 0),
(1801, 'MSGFIELDSNTSELECTED', 2, 0),
(1802, 'TXTSURVEYDATE', 2, 0),
(1804, 'TXTCALLBACKURL', 2, 0),
(1805, 'TXTSURVEYDETAILS', 2, 0),
(1806, 'TXTUSERLIKE', 2, 0),
(1807, 'TXTMARKASCOMPLETE', 2, 0),
(1808, 'TXTAPITOKEN', 2, 0),
(1809, 'TXTOR', 1, 0),
(1810, 'TXTEDITCUSTOMFIELD', 1, 0),
(1811, 'TXTNOTSPECIFIED', 2, 0),
(1812, 'TXTCHATURL', 2, 0),
(1813, 'TXTMEETINGID', 2, 0),
(1860, 'MSGSERACHTASKBOX', 2, 0),
(1815, 'TXTMAXPARTICIPANTS', 2, 0),
(1816, 'TXTMEETINGKEY', 2, 0),
(1817, 'TXTMEETINGTYPE', 2, 0),
(1818, 'TXTMEETINGUNIQUEID', 2, 0),
(1819, 'TXTADDMEETING', 2, 0),
(1820, 'TXTPASSWORDREQUIRED', 2, 0),
(1821, 'TXTIMMEDIATE', 2, 0),
(1823, 'TXTSCHEDULED', 2, 0),
(1824, 'TXTREMOTEACCESS', 2, 0),
(1825, 'TXTGOTOASSIST', 2, 0);
INSERT INTO `avis_language_variables` (`variable_id`, `title`, `location_area`, `is_itil`) VALUES
(1844, 'TXTTEAMVIEWER', 2, 0),
(1827, 'TXTCOMMCHAT', 2, 0),
(1828, 'TXTINTEGRATIONAPP', 2, 0),
(1829, 'TXTSELECTINTEGRATIONAPP', 2, 0),
(1830, 'TXTDOWNLOAD', 2, 0),
(1831, 'TXTNEXTOVERDUETICKETS', 2, 0),
(1832, 'TXTFIFTEENMINUTES', 2, 0),
(1833, 'TXTTHIRTYMINUTES', 2, 0),
(1834, 'TXTSIXTYMINUTES', 2, 0),
(1835, 'TXTONEDAY', 2, 0),
(1836, 'TXTTASK', 2, 0),
(1837, 'TXTTODAYTASK', 2, 0),
(1838, 'TXTMYTASK', 2, 0),
(1839, 'TXTASSIGNEDTASK', 2, 0),
(1840, 'TXTOVERDUETASK', 2, 0),
(1841, 'SSS', 2, 0),
(1842, 'TXTMARKASCANCEL', 2, 0),
(1845, 'TXTUPDATETASK', 2, 0),
(1846, 'MSGTASKMARKASCANCELLED', 2, 0),
(1847, 'MSGTASKMARKASCOMPLETED', 2, 0),
(1849, 'TXTDELETEGOTOMEETING', 2, 0),
(1850, 'MSGTASKOVERDUE', 2, 0),
(1852, 'TXTADDSESSION', 2, 0),
(1853, 'TXTADDUSER', 2, 0),
(1854, 'TXTBILLINGACCESS', 1, 0),
(1855, 'TXTWEBLINK', 2, 0),
(1856, 'MSGSEARCHTASK', 2, 0),
(1859, 'TXTCONFERENCECALLINFO', 2, 0),
(1861, 'TXTBILLINGACCESS', 2, 0),
(1862, 'TXTCREATEMEETING', 2, 0),
(1863, 'TXTCREATESESSION', 2, 0),
(1864, 'TXTSEESION', 2, 0),
(1866, 'TXTMEETING', 2, 0),
(1867, 'TXTJOINURL', 2, 0),
(1868, 'TXTJOINDATE', 2, 0),
(1869, 'TXTADDASSIST', 2, 0),
(1870, 'TXTMYFAVOURITES', 2, 0),
(1871, 'TXTCUSTOMDATA', 2, 0),
(1872, 'TXTCOPYTOCLIPBOARD', 2, 0),
(1873, 'TXTGROUPID', 2, 0),
(1874, 'TXTSETASFEATUREDARTICLE', 2, 0),
(1875, 'TXTDELETESESSION', 1, 0),
(1876, 'TXTASSIGNEDUSERID', 2, 0),
(1877, 'TXTASSIGNEDAT', 2, 0),
(1878, 'TXTENDCUSTOMERLINK', 2, 0),
(1879, 'TXTSUPPORTERLINK', 2, 0),
(1880, 'TXTCREATEDAT', 2, 0),
(1881, 'TXTVALIDUNTIL', 2, 0),
(1883, 'TXTGOTOASSISTSESSION', 2, 0),
(1884, 'TXTSESSIONTOKEN', 2, 0),
(1885, 'MSGREQFLDCATEGORY', 2, 0),
(1886, 'MSGCLTUSERNAMEEXIST', 2, 0),
(1887, 'TXTCLIENTEXEC', 2, 0),
(1888, 'TXTSEARCHSTATE', 2, 0),
(1889, 'TXTEXPERTNAME', 2, 0),
(1890, 'TXTEXPERTEMAIL', 2, 0),
(1891, 'TXTMERGEINTO', 2, 0),
(1892, 'TXTRESETPASSWORD', 1, 0),
(1894, 'TXTLINKEDIN', 2, 0),
(1895, 'TXTUNASSIGNED', 1, 0),
(1896, 'TXTDOWNLOADQUEUE', 2, 0),
(1898, 'TXTSAVEREPORT', 2, 0),
(1899, 'TXTWORDPRESS', 2, 0),
(1900, 'TXTREPORTTITLE', 2, 0),
(1901, 'TXTDELETESELFHELPCOMMENT', 2, 0),
(1902, 'TXTCOMPLETEDDATE', 2, 0),
(1903, 'TXTWEBEX', 2, 0),
(1904, 'MSGSURE', 1, 0),
(1905, 'MSGCLTUSERNAMEEXIST', 1, 0),
(1906, 'TXTDELETEWEBEX', 2, 0),
(1907, 'TXTSITEID', 2, 0),
(1908, 'TXTPARTNERID', 2, 0),
(1909, 'TXTDRUPAL', 2, 0),
(1910, 'TXTTOTALPOSTCOUNT', 2, 0),
(1911, 'TXTTOTALTICKETREPLIED', 2, 0),
(1912, 'TXTTOTALAVGRESPONSETIME', 2, 0),
(1913, 'TXTTOTALAVGSLAMAINTAINED', 2, 0),
(1914, 'TXTTOTALAVGSLATIME', 2, 0),
(1915, 'TXTTOTALAVGRESOLVETIME', 2, 0),
(1916, 'TXTWORST', 2, 0),
(1917, 'TXTNORMAL', 2, 0),
(1918, 'TXTGOOD', 2, 0),
(1919, 'TXTBETTER', 2, 0),
(1920, 'TXTBEST', 2, 0),
(1921, 'TXTTOTALBILLTIME', 2, 0),
(1922, 'TXTTOTALWORKTIME', 2, 0),
(1923, 'TXTTOTALAMOUNT', 2, 0),
(1924, 'TXTSURVEYURL', 2, 0),
(1925, 'TXTSUGARCRM', 2, 0),
(1926, 'MSGARTICLEIDNTFND', 2, 0),
(1936, 'TXTSUGARSITEURL', 2, 0),
(1928, 'MSGMAXIMAGEWIDTHSIZE', 2, 0),
(1929, 'MSGREPORTNAME', 2, 0),
(1930, 'TXTSELECTDATE', 2, 0),
(1935, 'MSGSNGLTKTLINK', 2, 0),
(1932, 'TXTSELECTFORGENERATE', 2, 0),
(1933, 'TXTSELSTAFFFORGEN', 2, 0),
(1934, 'TXTSELDURATIONFORGEN', 2, 0),
(1937, 'TXTSELECTDEPTFORGEN', 2, 0),
(1938, 'TXTSELDOMAINFORRES', 2, 0),
(1940, 'TXTHOSTBILL', 2, 0),
(1941, 'TXTCLOSETKT', 2, 0),
(1942, 'TXTSELCLIENTFORGEN', 2, 0),
(1943, 'TXTSELORG', 2, 0),
(1944, 'TXTTWILIO', 2, 0),
(1945, 'TXTACCOUNTSID', 2, 0),
(1946, 'TXTAUTHTOKEN', 2, 0),
(1947, 'TXTAPPSSID', 2, 0),
(1948, 'TXTORGNIZATIONTICKET', 2, 0),
(1949, 'TXTOPERATIONDATE', 2, 0),
(1950, 'TXTCONTENT', 1, 0),
(1951, 'TXTCLIENTSURVEY', 2, 0),
(1952, 'TXTTICKETRATINGPERCLIENT', 2, 0),
(1953, 'MSGREQFLDTIT', 1, 0),
(1954, 'TXTCALL', 2, 0),
(1955, 'TXTSECONDS', 2, 0),
(1956, 'TXTPRICEUNIT', 2, 0),
(1957, 'TXTRECORDING', 2, 0),
(1958, 'TXTINCOMING', 2, 0),
(1959, 'TXTOUTGOING', 2, 0),
(1960, 'TXTCALLDETAILS', 2, 0),
(1961, 'TXTTWILIOMSG', 2, 0),
(1962, 'TXTSENDDATE', 1, 0),
(1963, 'TXTMSGDEATILS', 2, 0),
(1964, 'TXTUPDATEDATE', 2, 0),
(1965, 'TXTSENDDATE', 2, 0),
(1966, 'TXTSENDMESSAGE', 2, 0),
(1967, 'TXTHANGUP', 2, 0),
(1968, 'TXTCALLLIST', 2, 0),
(1969, 'TXTADDITIONALFIELDS', 1, 0),
(1970, 'TXTEDIT', 1, 0),
(1971, 'TXTBALANCE', 1, 0),
(1972, 'TXTRESOLUTIONTIME', 1, 0),
(1973, 'TXTDUETIME', 1, 0),
(1974, 'TXTOFFLINEPAYMENT', 1, 0),
(1975, 'TXTOFFLINEPAYMENT', 2, 0),
(1976, 'TXTGATEWAY', 1, 0),
(1977, 'TXTPAYPALEMAIL', 1, 0),
(1978, 'TXTAUTHORIZE', 1, 0),
(1979, 'TXTPAYMENTMETHOD', 1, 0),
(1982, 'TXTCREDIT', 1, 0),
(1981, 'TXTLEADERBOARD', 2, 0),
(1983, 'TXTHOWCANWEHELP', 1, 0),
(1984, 'TXTITIL', 2, 0),
(1985, 'TXTCONFIGURATIONITEMTYPE', 2, 1),
(1986, 'TXTIMPACT', 2, 1),
(1987, 'TXTADDIMPACT', 2, 1),
(1988, 'TXTDELCONFIGURATIONITEM', 2, 1),
(1989, 'TXTUPDATEIMPACT', 2, 1),
(1990, 'TXTUPDATEITEM', 2, 1),
(1991, 'MSGLANGTRANSFORIMPACT', 2, 1),
(1992, 'TXTDELIMPACT', 2, 1),
(1993, 'TXTADDRISK', 2, 1),
(1994, 'TXTRISK', 2, 1),
(1995, 'TXTUPDATERISK', 2, 1),
(1996, 'MSGLANGTRANSFORRISK', 2, 1),
(1997, 'MSGREQFLDNAME', 2, 0),
(1999, 'MSGREQFLDTDESC', 2, 0),
(2000, 'TXTDELRISK', 2, 1),
(2001, 'TXTDELCHANGETYPE', 2, 1),
(2002, 'TXTADDCHANGETYPE', 2, 1),
(2003, 'TXTUPDATECHANGETYPE', 2, 1),
(2004, 'TXTRELEASETYPE', 2, 1),
(2005, 'TXTDELRELEASETYPE', 2, 1),
(2006, 'TXTUPDATERELEASETYPE', 2, 1),
(2007, 'TXTADDRELEASETYPE', 2, 1),
(2008, 'TXTCONTRACTTYPE', 2, 1),
(2009, 'TXTASSETSTATE', 2, 1),
(2010, 'TXTADDASSETSTATE', 2, 1),
(2011, 'TXTUPDATEASSETSTATE', 2, 1),
(2012, 'TXTDELASSETSTATE', 2, 1),
(2013, 'TXTREQUESTSTAGE', 2, 1),
(2014, 'TXTADDCONTRACTTYPE', 2, 1),
(2015, 'TXTUPDATECONTRACTTYPE', 2, 1),
(2016, 'TXTVENDOR', 2, 1),
(2017, 'TXTADDVENDOR', 2, 1),
(2018, 'TXTUPDATEVENDOR', 2, 1),
(2019, 'TXTDELVENDOR', 2, 1),
(2020, 'MSGLANGTRANSFORVENDOR', 2, 1),
(2021, 'MSGLANGTRANSFORRELEASETYPE', 2, 1),
(2022, 'MSGLANGTRANSFORASSESTATE', 2, 1),
(2023, 'MSGLANGTRANSFORCHANGETYPE', 2, 1),
(2024, 'MSGLANGTRANSFORCONTRACTTYPE', 2, 1),
(2025, 'TXTPRICONTACT', 2, 1),
(2026, 'MSGREQFLDPRICONTACT', 2, 1),
(2027, 'MSGREQFLDADDRESS', 2, 0),
(2028, 'TXTDELREQUESTSTAGE', 2, 0),
(2029, 'TXTADDREQUESTSTAGE', 2, 0),
(2030, 'MSGLANGTRANSFORREQSTAGE', 2, 0),
(2031, 'TXTUPDATEREQUESTSTAGE', 2, 0),
(2032, 'MSGLANGTRANSFORCONFIGITEM', 2, 1),
(2033, 'TXTFINANCEMANAGEMENT', 2, 1),
(2034, 'TXTFINANCETYPE', 2, 1),
(2035, 'TXTDELFINANCETYPE', 2, 1),
(2036, 'TXTADDFINANCETYPE', 2, 1),
(2037, 'TXTUPDATEFINANCETYPE', 2, 1),
(2038, 'TXTADDDEPRECIATION', 2, 1),
(2039, 'MSGLANGTRANSFORFINANCETYPE', 2, 1),
(2040, 'TXTSELECTFINANCETYPE', 2, 1),
(2041, 'TXTUSEFULLIFE', 2, 1),
(2042, 'TXTDELFINANCE', 2, 1),
(2043, 'TXTCICUSTOMFIELD', 2, 1),
(2160, 'TXTFIELDNAME', 2, 0),
(2045, 'TXTCITYPE', 2, 1),
(2046, 'TXTLICENSETYPE', 2, 1),
(2047, 'MSGLANGTRANSFORLICENSETYPE', 2, 1),
(2048, 'TXTUPDATELICENSETYPE', 2, 1),
(2049, 'TXTADDLICENSETYPE', 2, 1),
(2050, 'TXTDELLICENSETYPE', 2, 1),
(2051, 'TXTDELCICUSTOMFIELD', 2, 1),
(2052, 'TXTADDCICUSTOMFIELD', 2, 1),
(2053, 'TXTCIPRODUCT', 2, 1),
(2054, 'TXTADDCIPRODUCT', 2, 1),
(2055, 'TXTUPDATECIPRODUCT', 2, 1),
(2056, 'TXTDELCIPRODUCT', 2, 1),
(2057, 'TXTADDCIPRODSTATUS', 2, 1),
(2058, 'TXTCIPRODSTATUS', 2, 1),
(2059, 'TXTUPDATECIPRODSTATUS', 2, 1),
(2060, 'TXTUPDATECICUSTOMFIELD', 2, 1),
(2061, 'TXTADDLOCATION', 2, 1),
(2062, 'MSGLANGTRANSFORCIPRODSTATUS', 2, 1),
(2063, 'TXTPROCUREMODE', 2, 1),
(2064, 'TXTADDPROCUREMODE', 2, 1),
(2065, 'TXTUPDATEPROCUREMODE', 2, 1),
(2066, 'TXTDELPROCUREMODE', 2, 1),
(2067, 'MSGLANGTRANSFORPROCUREMODE', 2, 1),
(2068, 'TXTDEPRECIATIONTYPE', 2, 1),
(2069, 'TXTADDDEPRECIATIONTYPE', 2, 1),
(2070, 'TXTUPDATEDEPRECIATIONTYPE', 2, 1),
(2071, 'TXTDELDEPRECIATIONTYPE', 2, 1),
(2072, 'MSGLANGTRANSFORDEPRECIATIONTYPE', 2, 1),
(2073, 'TXTCONTRACT', 2, 1),
(2074, 'TXTCONTRACTNUMBER', 2, 1),
(2075, 'TXTEXPIRY', 2, 1),
(2076, 'TXTPHONENUM', 2, 1),
(2077, 'TXTMANUFACTURER', 2, 1),
(2078, 'MSGREQFLDCITYPE', 2, 1),
(2079, 'TXTDELLOCATION', 2, 1),
(2080, 'TXTADDCONTRACT', 2, 1),
(2081, 'TXTLICENSECOUNT', 2, 1),
(2082, 'TXTAPROVER', 2, 1),
(2083, 'TXTCOST', 2, 0),
(2084, 'TXTNOTIFYEXPIRY', 2, 1),
(2085, 'TXTNOTIFYBEFORE', 2, 1),
(2086, 'TXTNOTIFYTO', 2, 1),
(2087, 'TXTCHOOSEFILE', 2, 1),
(2088, 'TXTTWOFACTORAUTHENTICATION', 2, 0),
(2089, 'TXTSUCCVERIFY', 1, 0),
(2090, 'TXTERRVERIFY', 1, 0),
(2091, 'TXTVERIFICATIONPENDING', 1, 0),
(2094, 'TXTADDCI', 2, 1),
(2093, 'TXTUPDATECI', 2, 1),
(2095, 'TXTUSEDBY', 2, 1),
(2096, 'TXTASSETS', 2, 1),
(2097, 'TXTSELECTGROUPTYPE', 2, 1),
(2098, 'TXTADDURL', 2, 0),
(2099, 'TXTUPDATECONTRACT', 2, 1),
(2100, 'MSGREQNOTIEXP', 2, 1),
(2102, 'MSGREQDATE', 2, 1),
(2104, 'MSGREQLICCNT', 2, 1),
(2105, 'MSGREQVENDOR', 2, 1),
(2107, 'MSGREQCNTRTTYP', 2, 1),
(2108, 'MSGINVCNTRTNUM', 2, 1),
(2109, 'MSGREQCNTRTNUM', 2, 1),
(2111, 'MSGREQFLDCNTRNAME', 2, 1),
(2112, 'TXTDELCONTRACT', 2, 1),
(2113, 'TXTAUTOAPPROVECOMMENT', 2, 0),
(2114, 'TXTASSIGNEDON', 2, 1),
(2115, 'TXTATTACHCI', 2, 1),
(2116, 'TXTSELECTCI', 2, 1),
(2117, 'TXTPLEASESELECTFROMDATE', 2, 1),
(2118, 'TXTPLEASESELECTTODATE', 2, 1),
(2119, 'TXTCMDB', 2, 1),
(2120, 'TXTEDITCIPRODUCT', 2, 1),
(2121, 'TXTCIVENDOR', 2, 1),
(2122, 'TXTQUANTITY', 2, 0),
(2123, 'TXTWARRANTYNVALIDITY', 2, 1),
(2124, 'TXTSELECTVENDOR', 2, 1),
(2125, 'TXTSELECTPRODUCT', 2, 1),
(2126, 'TXTATTACH', 2, 0),
(2127, 'TXTITEMNAME', 2, 1),
(2128, 'MSGREQFLDCIPRODUCT', 2, 1),
(2129, 'MSGREQFLDCIVENDOR', 2, 1),
(2130, 'MSGREQFIELDPRICE', 2, 1),
(2131, 'MSGPRICENUM', 2, 1),
(2132, 'MSGREQFLDQUANTITY', 2, 0),
(2133, 'MSGQUANTITYNUM', 2, 0),
(2134, 'TXTSERVICECATEGORY', 2, 1),
(2135, 'TXTADDSERVICECATEGORY', 2, 1),
(2136, 'TXTPROBLEMS', 2, 1),
(2137, 'TXTUPDATESERVICECATEGORY', 2, 1),
(2138, 'TXTADDPROBLEMS', 2, 1),
(2139, 'TXTSEARCHREQUESTER', 2, 1),
(2140, 'TXTSERVICEITEM', 2, 1),
(2141, 'TXTDUEBY', 2, 1),
(2142, 'TXTAGENT', 2, 1),
(2143, 'TXTADDSERVICEITEM', 2, 1),
(2144, 'TXTQUANTITYVISIBLE', 2, 0),
(2145, 'TXTPUBLISHED', 2, 0),
(2146, 'TXTVISIBLETOCLIENTPORTAL', 2, 0),
(2147, 'TXTESTIMATEDDELIVERY', 2, 1),
(2148, 'TXTPROBLEM', 2, 1),
(2149, 'TXTOPENNEWPROBLEM', 2, 1),
(2150, 'TXTUPDATESERVICEITEM', 2, 1),
(2151, 'MSGCOSTNUM', 2, 0),
(2152, 'MSGREQFIELDCOST', 2, 0),
(2153, 'MSGREQFLDPRODUCT', 2, 0),
(2154, 'TXTDELSERVICEITEM', 2, 1),
(2155, 'TXTDELETETICKETBASE', 2, 1),
(2156, 'TXTDELETETIMEBASE', 2, 0),
(2157, 'TXTDELETEPAYGATEWAY', 2, 0),
(2158, 'TXTDELSERVICECATEGORY', 2, 0),
(2159, 'TXTADDCUSTOMFIELD', 2, 0),
(2161, 'TXTDELCI', 2, 1),
(2162, 'TXTCI', 2, 1),
(2163, 'TXTASSIGNMENT', 2, 1),
(2164, 'TXTDELSERVICECUSTOMFIELD', 2, 1),
(2166, 'TXTSERVICECUSTOMFIELD', 2, 1),
(2167, 'MSGREQFLDSERVICEITEM', 2, 1),
(2169, 'TXTITEMIMAGE', 2, 0),
(2171, 'TXTCHANGES', 2, 1),
(2174, 'TXTITILSERVICECATALOG', 1, 1),
(2173, 'TXTMANAGEDBY', 2, 1),
(2178, 'TXTITILREQUEST', 1, 1),
(2179, 'TXTSUBMITAPROVAL', 2, 1),
(2180, 'MSGLINKEDINIDMISS', 2, 1),
(2181, 'MSGFACEBOOKID', 2, 0),
(2182, 'MSGTWITTERID', 2, 0),
(2183, 'MSGGOOGLEIDMISS', 2, 0),
(2184, 'TXTITILITEMREQUEST', 1, 1),
(2185, 'TXTITILPLACEREQUEST', 1, 1),
(2186, 'TXTITILAPROVE', 2, 1),
(2187, 'TXTITILREJECT', 2, 1),
(2188, 'TXTITILREQUESTFOR', 1, 1),
(2189, 'TXTITILTERMINATE', 2, 1),
(2190, 'TXTITILREJECTED', 2, 1),
(2191, 'TXTITILCANCELED', 2, 1),
(2192, 'TXTITILEXPIRED', 2, 1),
(2193, 'TXTITILREQUESTSERVICE', 1, 1),
(2194, 'TXTSENDEMAILTOCLIENT', 2, 0),
(2195, 'TXTASSIGNTEAM', 2, 0),
(2196, 'TXTCREATIONTIME', 2, 0),
(2197, 'TXTAFTER', 2, 0),
(2198, 'TXTBEFORE', 2, 0),
(2199, 'TXTSENDEMAILTOSTAFF', 2, 0),
(2200, 'TXTRESOLUTIONDUETIME', 2, 0),
(2201, 'MSGCORETYPESTATUS', 2, 0),
(2202, 'TXTITILSERVICECATALOG', 2, 1),
(2203, 'MSGAPPROVEPENDING', 1, 0),
(2204, 'MSGSIZEERROR', 1, 0),
(2205, 'ERRORMSGEXTENSION', 1, 0),
(2206, 'TXTVIEWREPLYSELFTICKET', 1, 0),
(2207, 'TXTVIEWREPLYSELFTICKET', 2, 0),
(2208, 'MSGPRBNTACC', 2, 1),
(2209, 'MSGPRBMIDMISS', 2, 1),
(2210, 'TXTROOTCAUSE', 2, 1),
(2211, 'TXTSYMPTONS', 2, 1),
(2212, 'TXTPERMANANTSOLUTION', 2, 1),
(2213, 'TXTWORKAROUNDSOLUTION', 2, 1),
(2214, 'TXTPROBLEMANLSIS', 2, 1),
(2215, 'TXTADDROOTCAUSE', 2, 1),
(2216, 'TXTPROBLEMDETAILS', 2, 1),
(2217, 'TXTPROBLEMTNOTE', 2, 1),
(2218, 'TXTNOROOTCAUSE', 2, 1),
(2219, 'TXTADDNEW', 2, 0),
(2220, 'TXTNOIMPACT', 2, 1),
(2221, 'TXTNOSYMPTONS', 2, 1),
(2222, 'TXTADDNEWSOLUTION', 2, 1),
(2223, 'TXTLINKSOLUTION', 2, 1),
(2224, 'TXTRELEASES', 2, 1),
(2225, 'MSGSELECTMULTIPLEPROBLMESTOLINK', 2, 1),
(2226, 'TXTSEARCHPROBLEM', 2, 1),
(2227, 'TXTSEARCHCHANGE', 2, 1),
(2228, 'TXTSEARCHRELEASE', 2, 1),
(2229, 'MSGPOSTMESSAGENOTFOUND', 1, 0),
(2230, 'TXTSERVICEITEM', 1, 1),
(2231, 'TXTITILSERVICEREQUEST', 2, 1),
(2232, 'TXTITILNOCIASSOCIATED', 2, 1),
(2233, 'TXTITILNOPROBLEMLINKED', 2, 1),
(2234, 'TXTITILLINKPROBLEM', 2, 1),
(2235, 'TXTITILNOCHANGESLINKED', 2, 1),
(2236, 'TXTITILLINKCHANGES', 2, 1),
(2237, 'TXTITILDETACH', 2, 1),
(2238, 'TXTITILSEARCHPROBLEM', 2, 1),
(2239, 'TXTITILSEARCHCHANGES', 2, 1),
(2240, 'TXTITILSELECTCITYPE', 2, 1),
(2241, 'TXTITILSELECTCITYPEORITEM', 2, 1),
(2242, 'TXTITILSERVICEREQUESTFOR', 2, 1),
(2243, 'TXTRECIPIENTNPEOPLE', 2, 0),
(2244, 'TXTTICKETORTIMEBASE', 2, 0),
(2246, 'TXTSHOWONLYINTERNALTICKETS', 2, 0),
(2249, 'TXTADDITIONALFIELDS', 2, 0),
(2250, 'TXTITILREATIONSHIPS', 2, 1),
(2251, 'TXTASSETSDETAIL', 2, 1),
(2252, 'TXTITILINCIDENCE', 2, 1),
(2253, 'TXTITILADDCIVENDOR', 2, 1),
(2254, 'TXTITILADDCIPRODUCT', 2, 1),
(2255, 'TXTITILRELATIONSHIP', 2, 1),
(2256, 'TXTITILINVERSERELATIONSHIP', 2, 1),
(2257, 'TXTITILATTACHRELATIONSHIP', 2, 1),
(2258, 'TXTOPENNEWRELEASE', 2, 1),
(2259, 'TXTRELEASE', 2, 1),
(2260, 'TXTPLANNEDSTARTDATE', 2, 1),
(2261, 'TXTPLANNEDENDDATE', 2, 1),
(2263, 'TXTMATCHANDCONDITIONS', 2, 0),
(2264, 'TXTMATCHORCONDITIONS', 2, 0),
(2265, 'TXTINSUFFICIENTCREDIT', 1, 0),
(2266, 'TXTPAIDDEPARTMENTNOTFOUND', 2, 0),
(2267, 'TXTPROBLEMSOLUTION', 2, 1),
(2268, 'TXTPERMANANT', 2, 1),
(2269, 'TXTWORKAROUND', 2, 1),
(2270, 'TXTSERACHPROBLEMSOLUTION', 2, 1),
(2271, 'TXTDETACHCI', 2, 1),
(2272, 'TXTNOTICKETATTACHED', 2, 0),
(2273, 'TXTSEARCHTICKET', 2, 0),
(2274, 'MSGSEARCHTICKET', 2, 0),
(2275, 'TXTNOCHANGESATTACHED', 2, 0),
(2276, 'TXTNOTASKATTACHED', 2, 0),
(2277, 'TXTLINKTASK', 2, 0),
(2278, 'TXTADDNEWTASK', 2, 1),
(2279, 'TXTOPENNEWCHANGE', 2, 1),
(2280, 'TXTPROBLEMHASH', 2, 1),
(2281, 'TXTRELEASEHASH', 2, 1),
(2282, 'TXTCHANGSHASH', 2, 1),
(2283, 'TXTDELETECHANGE', 2, 1),
(2284, 'TXTDELETEPROBLEM', 1, 1),
(2285, 'TXTDELETEPROBLEM', 2, 1),
(2286, 'MSGDELETEDEPARTMENTASSIGNEDTOTEAM', 2, 0),
(2287, 'TXTAPPLYAMOUNTCREDIT', 2, 0),
(2288, 'TXTRECENTACTIVITY', 2, 0),
(2289, 'TXTMANAGECREDIT', 2, 0),
(2290, 'MSGRELEASEIDMISS', 2, 1),
(2291, 'TXTRELEASEDETAILS', 2, 1),
(2292, 'TXTBUILDPLAN', 2, 1),
(2293, 'TXTTESTPLAN', 2, 1),
(2294, 'TXTNOBUILDPLAN', 2, 1),
(2295, 'TXTNOTESTPLAN', 2, 1),
(2296, 'TXTRELEASEAPPROVAL', 2, 1),
(2297, 'MSGNEWRELEASE', 2, 1),
(2298, 'TXTCHANGEFILTERS', 2, 1),
(2299, 'TXTRELEASEFILTERS', 2, 1),
(2300, 'TXTPROBLEMFILTERS', 2, 1),
(2301, 'MSGCANNOTMERGEOTHERCLIENTEMAIL', 2, 0),
(2302, 'TXTDELETEORGANIZATION', 2, 0),
(2303, 'TXTSURVEYFIELDGROUPREQUIRED', 2, 0),
(2304, 'TXTPROGRESS', 2, 0),
(2305, 'MSGEMAILSENTTORESETPASSWORD', 1, 0),
(2306, 'MSGRESETPASSWORDLINKEXPIRED', 1, 0),
(2307, 'TXTBACKTOLOGIN', 1, 0),
(2308, 'MSGCOREPRIORITYSTATUS', 2, 0),
(2309, 'MSGCORESTATUS', 2, 0),
(2310, 'MSGCOREFLAGSTATUS', 2, 0),
(2311, 'MSGCOREVIEWSTATUS', 2, 0),
(2312, 'MSGCHANGESIDMISS', 2, 1),
(2313, 'MSGCHANGESNOTACC', 2, 1),
(2314, 'TXTADDPROBLEM', 2, 1),
(2315, 'MSGPROBLEMMOVETODEPT', 2, 1),
(2316, 'MSGCHANGESMOVETODEPT', 2, 1),
(2317, 'MSGNEWPROBLEM', 2, 1),
(2318, 'MSGNEWCHANGE', 2, 1),
(2319, 'TXTDETACH', 2, 1),
(2320, 'TXTCHANGESDETAILS', 2, 1),
(2321, 'TXTLINKRELEASE', 2, 1),
(2322, 'TXTNORELEASEATTACHED', 2, 1),
(2323, 'TXTSEARCHRELEASES', 2, 1),
(2324, 'TXTNOPROBLEMATTACHED', 2, 1),
(2325, 'TXTLINKPROBLEM', 2, 1),
(2326, 'TXTCHANGEREASON', 2, 1),
(2327, 'TXTNOREASON', 2, 1),
(2328, 'TXTROLLOUTPLAN', 2, 1),
(2329, 'TXTBACKOUTPLAN', 2, 1),
(2330, 'TXTNOROLLOUT', 2, 1),
(2331, 'TXTNOBACKOUT', 2, 1),
(2332, 'TXTSEND', 1, 0),
(2333, 'TXTUPDATEPASSWORD', 2, 0),
(2334, 'TXTSELECTPAYMENTGATEWAY', 2, 0),
(2335, 'MSGGATEWAYTRANSACTIONDETAILS', 2, 0),
(2336, 'MSGPARSERDETAILS', 2, 0),
(2337, 'MSGMAILDETAILS', 2, 0),
(2338, 'MSGSELECTDATE', 2, 0),
(2339, 'MSGSELECTMONTH', 2, 0),
(2340, 'TXTJANUARY', 2, 0),
(2341, 'TXTFEBRUARY', 2, 0),
(2342, 'TXTMARCH', 2, 0),
(2343, 'TXTAPRIL', 2, 0),
(2344, 'TXTMAY', 2, 0),
(2345, 'TXTJUNE', 2, 0),
(2346, 'TXTJULY', 2, 0),
(2347, 'TXTAUGUST', 2, 0),
(2348, 'TXTSEPTEMBER', 2, 0),
(2349, 'TXTOCTOBER', 2, 0),
(2350, 'TXTNOVEMBER', 2, 0),
(2351, 'TXTDECEMBER', 2, 0),
(2352, 'TXTUPDATEPASSWORD', 1, 0),
(2353, 'MSGRESETPASSWORDLINKEXPIRED', 2, 0),
(2354, 'TXTSENDRESETPASSWORDEMAIL', 1, 0),
(2355, 'TXTSENDRESETPASSWORDEMAIL', 2, 0),
(2356, 'MSGEMAILSENTTORESETPASSWORD', 2, 0),
(2357, 'TXTITILDELRELATIONSHIP', 2, 1),
(2358, 'MSGPLEASESELECTCIITEM', 2, 1),
(2359, 'TXTNORECORDFOUND', 2, 1),
(2360, 'TXTITILDETACHLINKPROBLEM', 2, 1),
(2361, 'TXTITILDETACHLINKCHANGES', 2, 1),
(2362, 'TXTITILSOFTWAREPROPERTY', 2, 1),
(2363, 'TXTITILWARRANTY', 2, 1),
(2364, 'TXTITILHARDWAREPROPERTY', 2, 1),
(2365, 'TXTITILACQUISITIONDATE', 2, 1),
(2366, 'TXTITILWARRANTYEXPDATE', 1, 1),
(2367, 'TXTITILLASTAUDITDATE', 2, 1),
(2368, 'TXTITILASSETTAG', 2, 1),
(2369, 'TXTITILSERIALNUMBER', 2, 1),
(2370, 'TXTITILLICENSEVALIDITY', 2, 1),
(2371, 'TXTITILINSTALLATIONDATE', 2, 1),
(2372, 'TXTITILLICENSEEXPDATE', 2, 1),
(2373, 'TXTITILLICENSEKEY', 2, 1),
(2374, 'TXTITILLICENSETYPE', 2, 1),
(2375, 'TXTITILINSTALLATIONPATH', 2, 1),
(2376, 'MSGREQFLDASSETSTATE', 2, 1),
(2377, 'TXTITILSTRAIGHTLINE', 2, 1),
(2378, 'TXTITILDECLINEBALANCE', 2, 1),
(2379, 'TXTITILSUMOFYEARDIGIT', 2, 1),
(2380, 'TXTITILDOUBLEDECLINEBALANCE', 2, 1),
(2381, 'TXTITILSALVAGE', 2, 1),
(2382, 'TXTITILDEPRECIATIONTYPE', 2, 1),
(2383, 'TXTITILDEPRECIATIONDETAILS', 2, 1),
(2384, 'MSGREQFILUSEFULYEARNUM', 2, 1),
(2385, 'TXTITILBOOKVALUE', 2, 1),
(2386, 'TXTITILDEPRECIATIONSCHEDULE', 2, 1),
(2387, 'TXTITILDEPRECIATION', 2, 1),
(2388, 'TXTSELECTDEPRECIATIONMETHOD', 2, 1),
(2390, 'TXTDELETED', 2, 0),
(2391, 'TXTUPDATESTAFFDEPARTMENT', 2, 0),
(2392, 'TXTADDREMARK', 2, 1),
(2393, 'TXTITILEVENT', 2, 1),
(2394, 'TXTNEWPROBLEM', 2, 1),
(2395, 'TXTUPDATEPROBLEMDEPT', 2, 1),
(2396, 'TXTUPDATEPROBLEMSTATUS', 2, 1),
(2397, 'TXTUPDATEPROBLEMPRIORITY', 2, 1),
(2398, 'TXTUPDATEPROBLEMIMPACT', 2, 1),
(2399, 'TXTPROBLEMASSIGN', 2, 1),
(2400, 'TXTADDPROBLEMIMPACT', 2, 1),
(2401, 'TXTADDPROBLEMSYMPTOMS', 2, 1),
(2402, 'TXTLINKPERMANENTSOLUTION', 2, 1),
(2403, 'TXTLINKWORKAROUNDSOLUTION', 2, 1),
(2404, 'TXTNEWCHANGE', 2, 1),
(2405, 'TXTUPDATECHANGEDEPT', 2, 1),
(2406, 'TXTUPDATECHANGESTATUS', 2, 1),
(2407, 'TXTUPDATEPCHANGEPRIORITY', 2, 1),
(2408, 'TXTUPDATEPCHANGEIMPACT', 2, 1),
(2409, 'TXTUPDATEPCHANGERISK', 2, 1),
(2410, 'TXTCHANGEASSIGN', 2, 1),
(2411, 'TXTUPDATEPCHANGETYPE', 2, 1),
(2412, 'TXTADDCHANGEIMPACT', 2, 1),
(2413, 'TXTADDROLLOUTPLAN', 2, 1),
(2414, 'TXTADDBACKOUTPLAN', 2, 1),
(2415, 'TXTUPDATERELEASEEDEPT', 2, 1),
(2416, 'TXTUPDATERELEASESTATUS', 2, 1),
(2417, 'TXTUPDATEPRELEASEPRIORITY', 2, 1),
(2418, 'TXTRELEASEASSIGN', 2, 1),
(2419, 'TXTADDBUILDPLAN', 2, 1),
(2420, 'TXTADDTESTPLAN', 2, 1),
(2421, 'TXTCHANGEAPPROVAL', 2, 1),
(2422, 'TXTCONTRACTAPPROVAL', 2, 1),
(2423, 'TXTCALLCLIENT', 1, 0),
(2424, 'TXTEMAILCLIENT', 1, 0),
(2425, 'TXTCLIENTTYPE', 2, 0),
(2426, 'TXTITILREMAININGLIFE', 2, 1),
(2427, 'TXTITILACCUMULATEDDEPRECIATION', 2, 1),
(2428, 'TXTITILDEPRECIATIONEXPENSE', 2, 1),
(2429, 'MSGURLMUSTBEVALID', 2, 0),
(2430, 'TXTRESTORE', 2, 0),
(2431, 'TXTNOACCESS', 2, 0),
(2432, 'TXTCLIENTUSERNAMEMISSING', 2, 0),
(2433, 'TXTCLIENTUSERNAMEMISSING', 1, 0),
(2434, 'TXTEMAILCLIENT', 2, 0),
(2435, 'TXTCALLCLIENT', 2, 0),
(2436, 'TXTSELECTIMAGE', 2, 0),
(2437, 'MSGINVALIDENDDATE', 2, 0),
(2438, 'TXTDELCLIENTEXEC', 2, 0),
(2439, 'TXTDELCONTRACTTYPE', 2, 1),
(2440, 'TXTMODIFYRECEPIENTANDPEOPLE', 2, 0),
(2441, 'TXTTIMETRACKING', 2, 0),
(2442, 'TXTADDCITYPE', 2, 1),
(2443, 'TXTUPDATECITYPE', 2, 0),
(2444, 'TXTUPDATELOCATION', 2, 0),
(2445, 'TXTPRODUCTCATALOG', 2, 1),
(2446, 'TXTADDPACKAGE', 2, 0),
(2447, 'TXTUPDATEPACKAGE', 2, 0),
(2448, 'TXTDELCIPRODSTATUS', 2, 1),
(2449, 'TXTDELSERVICECATEGORYDELSERVICEITEM', 2, 1),
(2450, 'TXTREPLYORREPLYALLTICKET', 2, 0),
(2451, 'TXTITILDELCITYPEERROR', 2, 1),
(2452, 'TXTEDITASSETS', 2, 1),
(2453, 'TXTITILWARRANTYEXPDATE', 2, 1),
(2454, 'TXTAPPROVALSTATUS', 2, 1),
(2455, 'TXTNOTREQUESTED', 2, 0),
(2456, 'TXTREQUESTED', 2, 0),
(2457, 'TXTREJECTED', 2, 0),
(2458, 'TXTAPPROVALS', 2, 0),
(2459, 'TXTNOAPROVALS', 2, 0),
(2460, 'TXTREQUESTAPROVALS', 2, 0),
(2461, 'TXTSENTON', 2, 0),
(2462, 'TXTAPPROVEDON', 2, 1),
(2463, 'TXTCANCELEDON', 2, 1),
(2464, 'TXTREJECTEDON', 2, 1),
(2465, 'TXTSENDREMINDER', 2, 1),
(2466, 'TXTREMARKS', 2, 1),
(2467, 'TXTADDRELEASE', 2, 1),
(2468, 'TXTCHANGEHASH', 2, 1),
(2469, 'TXTALERTMESSAGE', 2, 0),
(2470, 'MSGCHANGESTATUSMESSAGE', 2, 0),
(2471, 'TXTITILDELCONTRACTTYPEERROR', 2, 1),
(2472, 'TXTITILDELCHANGESTYPEERROR', 2, 1),
(2473, 'TXTITILDELRELEASETYPEERROR', 2, 1),
(2474, 'TXTITILDELASSETSSTATEERROR', 2, 1),
(2475, 'TXTITILDELLICENSETYPEERROR', 2, 1),
(2476, 'TXTITILDELIMPACTERROR', 2, 1),
(2477, 'TXTITILDELRISKERROR', 2, 1),
(2478, 'MSGREQUIREDFIELDIPORIPRANGE', 2, 0),
(2479, 'TXTITILSEARCHITEM', 2, 1),
(2480, 'MSGREQFILDDEPRECIATIONTYPE', 2, 1),
(2481, 'MSGREQFLDPRODUCTSTATUS', 2, 1),
(2482, 'MSGREQFLDMODEOFPROCUREMENT', 2, 1),
(2483, 'TXTITILDELPROCUREMENTERROR', 2, 1),
(2484, 'TXTINPROGRESSTASK', 2, 0),
(2485, 'TXTCOMPLETEDTASK', 2, 0),
(2486, 'TXTCANCELLEDTASK', 2, 0),
(2487, 'TXTLOWPRIORITYTASK', 2, 0),
(2488, 'TXTMEDIUMPRIORITYTASK', 2, 0),
(2489, 'TXTHIGHPRIORITYTASK', 2, 0),
(2490, 'TXTITILDELPRODUCTSTATUSERROR', 2, 1),
(2491, 'TXTITILDELVENDORERROR', 2, 1),
(2492, 'TXTITILDELSERVICEITEMERROR', 2, 1),
(2493, 'TXTQUANTITY', 1, 0),
(2494, 'TXTCOST', 1, 0),
(2495, 'TXTENTERTASKTITLE', 2, 0),
(2496, 'TXTADDTASKDESCRIPTION', 2, 0),
(2497, 'TXTSTAFFACCESS', 2, 0),
(2498, 'TXTSEARCHTASK', 2, 0),
(2499, 'TXTSEARCHCHANGES', 2, 1),
(2500, 'MSGMOBILENONUM', 2, 0),
(2501, 'MESSAGEFORSMTPADDOPERATION', 2, 0),
(2502, 'TXTNEWCLIENTREPLY', 1, 0),
(2503, 'MSGCLIENTREMOVED', 1, 0),
(2504, 'TXTCLIENTADD', 1, 0),
(2505, 'TXTDELFACEBOOKPAGE', 2, 0),
(2506, 'TXTHASHGENERATION', 2, 1),
(2507, 'TXTSERVICESPREFIX', 1, 1),
(2508, 'TXTPROBLEMSPREFIX', 2, 1),
(2509, 'TXTCHANGESPREFIX', 2, 1),
(2510, 'TXTRELEASESPREFIX', 2, 1),
(2511, 'TXTCONTRACTSPREFIX', 2, 1),
(2512, 'MSGLABELCNDEL', 2, 0),
(2513, 'TXTTKTMOVEINBOCFROMTRASH', 2, 0),
(2514, 'TXTTIMESHOULDNOTNEGATIVE', 2, 0),
(2515, 'TXTEDITPAGE', 2, 0),
(2516, 'MSGDELFBPAGES', 2, 0),
(2517, 'TXTGOTOMEETINGDETAILS', 2, 0),
(2518, 'MSGTICKHASHLINKERROR', 2, 0),
(2519, 'TXTSESSIONDETAILS', 2, 0),
(2520, 'TXTNEWCLIENT', 2, 0),
(2521, 'TXTCLIENTREPLY', 2, 0),
(2522, 'TXTNEWARTICLE', 2, 0),
(2523, 'TXTNEWCOMMENT', 2, 0),
(2524, 'TXTNEWBLAB', 2, 0),
(2525, 'TXTTASKASSIGNED', 2, 0),
(2526, 'TXTTASKCOMMENT', 2, 0),
(2527, 'TXTNEWORDER', 2, 0),
(2528, 'TXTINVOICECREATED', 2, 0),
(2529, 'TXTINVOICEDESCRIPTION', 2, 0),
(2530, 'TXTDELPRODUCTVENDOR', 2, 1),
(2531, 'TXTSERVICESPREFIX', 2, 1),
(2532, 'MSGMAILDETAILSLOG', 2, 0),
(2533, 'TXTSTAFFNAMEPROFILEIMAGE', 2, 0),
(2534, 'MSGSERVICESHASHPREFIX', 2, 0),
(2535, 'MSGSERVICESHASHPREFIXERROR', 2, 0),
(2536, 'MSGPROBLEMSHASHPREFIX', 2, 0),
(2537, 'MSGPROBLEMSHASHPREFIXERROR', 2, 0),
(2538, 'MSGCHANGESHASHPREFIX', 2, 0),
(2539, 'MSGCHANGESHASHPREFIXERROR', 2, 0),
(2540, 'MSGRELEASESHASHPREFIX', 2, 0),
(2541, 'MSGRELEASESHASHPREFIXERROR', 2, 0),
(2542, 'MSGCONTRACTSHASHPREFIX', 2, 0),
(2543, 'MSGCONTRACTSHASHPREFIXERROR', 2, 0),
(2544, 'MSGITILSTARTEMPTY', 2, 1),
(2545, 'MSGITILNUMERINGSTARTSFROMERROR', 2, 1),
(2546, 'MSGREQFLDCODE', 2, 0),
(2547, 'MSGREQFLDCHARACTERSET', 2, 0),
(2548, 'MSGPOSTMESSAGENOTFOUND', 2, 0),
(2549, 'TXTVALUESNOTBENEGATIVE', 2, 0),
(2550, 'MSGTASKLINKED', 2, 1),
(2551, 'TXTNEWRELEASE', 2, 1),
(2552, 'MSGCHANGESLINKED', 2, 1),
(2553, 'MSGPROBLEMLINKED', 2, 1),
(2554, 'MSGCILINKED', 2, 1),
(2555, 'MSGTICKETSPLIT', 2, 0),
(2556, 'MSGTICKETLINKED', 2, 0),
(2557, 'TXTSEARCHSERVICEITEM', 1, 1),
(2558, 'TXTSERVICECATEGORY', 1, 1),
(2559, 'MSGDURATIONLESSTHANTHREEMONTHS', 2, 0),
(2560, 'MSGFROMLESSTHANTO', 2, 0),
(2561, 'TXTSERVICESEARCHRESULT', 1, 1),
(2562, 'TXTMARKPAID', 2, 0),
(2563, 'TXTNOMATCHFOUND', 1, 0),
(2564, 'TXTDELETERELEASE', 2, 1),
(2565, 'TXTTICKETRATING', 2, 0),
(2566, 'TXTITILREQUESTSERVICE', 2, 1),
(2567, 'TXTSELSERVICECATEGORY', 2, 1),
(2568, 'TXTITILPLACEREQUEST', 2, 1),
(2569, 'MSGTICKETPOSTDELETE', 2, 0),
(2570, 'TXTITILSERVICEREQUESTFOR', 1, 1),
(2571, 'TXTTICKETPOSTNOTAVAILABLE', 2, 0),
(2572, 'MSGDEPTMISS', 1, 0),
(2573, 'TXTITILSELECTSERVICECATEGORY', 2, 1),
(2574, 'MSGREQCONTACTNUM', 2, 0),
(2575, 'MSGREQUIREDFIELDDEPARTMENT', 2, 0),
(2576, 'MSGREQUIREDFIELDAPPROVER', 2, 0),
(2577, 'MSGREQCONTRACTTYPE', 2, 1),
(2579, 'TXTESTIMATEDDELIVERY', 1, 1),
(2580, 'MSGREQFLDQUANTITYMUSTBENUM', 1, 1),
(2581, 'MSGREQFLDQUANTITYMUSTBENUM', 2, 1),
(2582, 'MSGRELEASEMOVETODEPT', 2, 1),
(2583, 'TXTJOOMLA', 2, 0),
(2584, 'TXTSALESFORCE', 2, 0),
(2585, 'TXTBADGEEARN', 2, 0),
(2586, 'MSGNOBADGE', 2, 0),
(2587, 'TXTNEWTWILIO', 2, 0),
(2588, 'TXTKEY', 2, 0),
(2589, 'TXTTWILIONUMBER', 2, 0),
(2590, 'TXTAPP', 2, 0),
(2591, 'TXTWELCOMEMSG', 2, 0),
(2592, 'TXTINVALIDPHONE', 2, 0),
(2593, 'TXTALLOWOUTBOUND', 2, 0),
(2594, 'MSGREQAPPSID', 2, 0),
(2595, 'MSGWELMSG', 2, 0),
(2596, 'TXTCALLFORWARDING', 2, 0),
(2597, 'TXTTOPHONE', 2, 0),
(2598, 'TXTTOSTAFFBROWSER', 2, 0),
(2599, 'TXTFORWARDINGNUM', 2, 0),
(2600, 'TXTUPDATETWILIO', 2, 0),
(2601, 'MSGINVALIDTWILIO', 2, 0),
(2602, 'TXTDELETETWILIO', 2, 0),
(2603, 'TXTALL', 1, 0),
(2604, 'TXTKEYMSG', 2, 0),
(2605, 'MSGREQFLDKEYMSG', 2, 0),
(2606, 'TXTKEYMSGPLACEHOLDER', 2, 0),
(2607, 'MSGFORWARNUMBER', 2, 0),
(2608, 'MSGTAGALREDEYUSED', 2, 0),
(2609, 'TXTCLIENTID', 2, 0),
(2610, 'TXTCLIENTSECRETE', 2, 0),
(2611, 'MSGLANGTRANSFORDEPARTMENT', 2, 0),
(2612, 'TXTCAMPAIGNNAME', 2, 0),
(2613, 'TXTDONOTHAVEANACCOUNT', 1, 0),
(2614, 'TXTCONSUMERKEY', 2, 0),
(2615, 'TXTCONSUMERSECRETE', 2, 0),
(2616, 'TXTCLOSETICKET', 1, 0),
(2617, 'TXTLICENSEOWNER', 2, 0),
(2618, 'TXTNUMBEROFCOMPANIES', 2, 0),
(2619, 'TXTNUMBEROFSTAFFAGENTS', 2, 0),
(2620, 'TXTCOPYRIGHT', 2, 0),
(2621, 'TXTMAILCHIMP', 2, 0),
(2622, 'TXTPOSTYOURCOMMENTHERE', 2, 0),
(2623, 'TXTSTATUSCHANGEDFROM', 2, 0),
(2624, 'TXTPRIORITYCHANGEDFROM', 2, 0),
(2625, 'TXTDEPARTMENTCHANGEDFROM', 2, 0),
(2626, 'TXTTICKETTYPECHANGEDFROM', 2, 0),
(2627, 'TXTFLAGCHANGEDFROM', 2, 0),
(2628, 'TXTTICKETUNASSIGNEDFROM', 2, 0),
(2629, 'TXTTICKETASSIGNEDTONOBODY', 2, 0),
(2630, 'TXTSLASETTO', 2, 0),
(2631, 'TXTAPPLIEDCUSTOMSLAPLAN', 2, 0),
(2632, 'TXTNOTSPAMMARKED', 2, 0),
(2633, 'TXTNEWTASKATTACHED', 2, 1),
(2634, 'TXTDETACHEDATTACHEDTASK', 2, 1),
(2635, 'TXTNEWCIATTACHED', 2, 1),
(2636, 'TXTDETACHEDATTACHEDCI', 2, 1),
(2637, 'TXTNEWPROBLEMATTACHED', 2, 1),
(2638, 'TXTDETACHEDATTACHEDPROBLEM', 2, 1),
(2639, 'TXTNEWCHANGEATTACHED', 2, 1),
(2640, 'TXTDETACHEDATTACHEDCHANGE', 2, 1),
(2641, 'TXTTICKETPOSTSPLITWITH', 2, 0),
(2642, 'TXTSLACHANGEDFROM', 2, 0),
(2643, 'TXTLINKEDTO', 2, 0),
(2644, 'TXTITILACCEPT', 2, 1),
(2645, 'TXTINCOMINGCALLON', 2, 1),
(2646, 'MSGCONNECTING', 2, 1),
(2647, 'MSGCALLCONNECTED', 2, 1),
(2648, 'MSGCALLENDED', 2, 0),
(2649, 'TXTSEARCHCLIENT', 2, 0),
(2650, 'TXTPHONEEG', 2, 0),
(2651, 'TXTCUSTOMREPORT', 2, 0),
(2652, 'TXTACCESSTOKEN', 2, 0),
(2653, 'TXTTICKETUNASSIGNED', 2, 0),
(2654, 'TXTFACEBOOKPAGEID', 2, 0),
(2655, 'TXTWIDGET', 2, 0),
(2656, 'TXTBUTTONNAME', 2, 0),
(2657, 'TXTCLONE', 2, 0);
INSERT INTO `avis_language_variables` (`variable_id`, `title`, `location_area`, `is_itil`) VALUES 
(2658, 'TXTMAGENTO', 2, 0),
(2659, 'TXTADDMAGENTO', 2, 0),
(2660, 'TXTUPDATEMAGENTO', 2, 0),
(2661, 'TXTDELMAGENTO', 2, 0),
(2662, 'TXTBILLTONAME', 2, 0),
(2663, 'TXTORDERDATE', 2, 0),
(2664, 'TXTCLICKDESK', 2, 0),
(2665, 'TXTMORECONVERSATION', 2, 0),
(2666, 'TXTFETCHCHAT', 2, 0),
(2667, 'MSGENTERVISITOREMAILADDRESS', 2, 0),
(2668, 'TXTNOTMAINTAIN', 2, 0),
(2669, 'TXTRESOLUTIONTSLA', 2, 0),
(2670, 'TXTRESPONSESLA', 2, 0),
(2671, 'TXTTOTALAVGRESPONSESLAMAINTAIN', 2, 0),
(2672, 'TXTTOTALAVGRESOLUTIONSLAMAINTAIN', 2, 0),
(2673, 'TXTFRESHBOOKS', 2, 0),
(2674, 'TXTFRESHBOOKSDOMAIN', 2, 0),
(2675, 'TXTDELETEFRESHBOOKS', 2, 0),
(2676, 'TXTPROJECTNAME', 2, 0),
(2677, 'TXTPROJECTS', 2, 0),
(2678, 'TXTAMOUNTOUTSTANDING', 2, 0),
(2679, 'TXTDISCOUNT', 2, 0),
(2680, 'TXTSEARCHBY', 2, 0),
(2681, 'TXTZOPIM', 2, 0),
(2682, 'TXTSATELLITEHELPDESK', 2, 0),
(2683, 'TXTINSIGHTLY', 2, 0),
(2684, 'TXTADDINSIGHTLY', 2, 0),
(2685, 'TXTUPDATEINSIGHTLY', 2, 0),
(2686, 'TXTDELINSIGHTLY', 2, 0),
(2687, 'TXTINSIGHTLYAPIURL', 2, 0),
(2688, 'TXTORGANIZATIONEMAIL', 2, 0),
(2689, 'TXTROLE', 2, 0),
(2690, 'TXTLEAVEAMSG', 1, 0),
(2691, 'TXTWIDGETHELP', 1, 0),
(2692, 'TXTWIDGETSEARCHRESULT', 1, 0),
(2693, 'TXTWIDGETSEARCHSOLUTIONS', 1, 0),
(2694, 'TXTWIDNORECORDFOUND', 1, 0),
(2695, 'TXTBUTTONNAME', 1, 0),
(2696, 'TXTSELECTCODE', 2, 0),
(2697, 'TXTWIDGETCODE', 2, 0),
(2698, 'TXTWIDPREVIEW', 2, 0),
(2699, 'TXTWIDROUNDED', 2, 0),
(2700, 'TXTWIDSQUARE', 2, 0),
(2701, 'TXTWIDBUTTONTYPE', 2, 0),
(2702, 'TXTWIDRIGHTBOTTOM', 2, 0),
(2703, 'TXTWIDLEFTBOTTOM', 2, 0),
(2704, 'TXTWIDRIGHTTOP', 2, 0),
(2705, 'TXTWIDPOSITION', 2, 0),
(2706, 'TXTWIDFEATURE', 2, 0),
(2707, 'TXTWIDBOTH', 2, 0),
(2708, 'TXTWIDRQUESTSUBMITED', 1, 0),
(2709, 'TXTWIDNOTHINGTODISPLAY', 1, 0),
(2710, 'TXTWIDFIELDMISSING', 1, 0),
(2711, 'TXTBIGCOMMERCE', 2, 0),
(2712, 'TXTADDBIGCOMMERCE', 2, 0),
(2713, 'TXTAPIPATH', 2, 0),
(2714, 'TXTUPDATEBIGCOMMERCE', 2, 0),
(2715, 'TXTDELBIGCOMMERCE',2, 0),
(2716, 'TXTSTRIPE', 2, 0),
(2717, 'TXTSTRIPE', 1, 0),
(2718, 'TXTSECRETKEY', 2, 0),
(2719, 'TXTPUBLISHABLEKEY', 2, 0),
(2720, 'MSGSECRETKEYEMPTY', 2, 0),
(2721, 'MSGPUBLISHABLEKEYEMPTY', 2, 0),
(2722, 'MSGFACEBOOKERROR', 2, 0),
(2723, 'TXTTLINKSFORTICKET', 2, 0),
(2724, 'TXTMSGEMAILSENDTOVERIFICATIONLINK', 1, 0),
(2725, 'TXTRESENDVERIFICATIONLINK', 1, 0),
(2726, 'TXTERRORMSGCLIENTSTATUSISNOTVERIFY', 2, 0),
(2727, 'TXTERRORMSGCLIENTSTATUSISUNAPPROVE', 2, 0),
(2728, 'TXTERRORMSGCLIENTSTATUSISSPAM', 2, 0),
(2729, 'TXTERRORMSGCLIENTSTATUSISBAN', 2, 0),
(2730, 'TXTNOTVERIFIED', 2, 0),
(2731, 'TXTVERIFIED', 2, 0),
(2732, 'TXTVERIFYEMAIL', 2, 0),
(2733, 'TXTJIRA', 2, 0),
(2734, 'TXTJIRAURL', 2, 0),
(2735, 'TXTCREATEISSUE', 2, 0),
(2736, 'TXTISSUETYPE', 2, 0),
(2737, 'TXTISSUEHASH', 2, 0),
(2738, 'TXTLINKISSUE', 2, 0),
(2739, 'TXTUNLINKISSUE', 2, 0),
(2740, 'TXTVIEWISSUEINJIRA', 2, 0),
(2741, 'TXTBLESTA', 2, 0),
(2742, 'TXTADDBLESTA', 2, 0),
(2743, 'TXTUPDATEBLESTA', 2, 0),
(2744, 'TXTDELBLESTA', 2, 0),
(2745, 'TXTAPIUSER', 2, 0),
(2746, 'TXTDUE', 2, 0),
(2747, 'TXTPACKAGENAME', 2, 0),
(2748, 'TXTPACKAGES', 2, 0),
(2749, 'TXTTERM', 2, 0);
INSERT INTO `avis_language_values` (`language_id`, `variable_id`, `description`, `is_custom`) VALUES
(0, 2658, 'Magento', 0),
(1, 2658, 'Magento', 0),
(0, 2659, 'Add magento', 0),
(1, 2659, 'Add magento', 0),
(0, 2660, 'Update magento', 0),
(1, 2660, 'Update magento', 0),
(0, 2661, 'Delete magento', 0),
(1, 2661, 'Delete magento', 0),
(0, 2662, 'Bill to name', 0),
(1, 2662, 'Bill to name', 0),
(0, 2663, 'Order date', 0),
(1, 2663, 'Order date', 0),
(0, 2664, 'ClickDesk', 0),
(1, 2664, 'ClickDesk', 0),
(0, 2665, 'More conversation', 0),
(1, 2665, 'More conversation', 0),
(0, 2666, 'Fetch chat', 0),
(1, 2666, 'Fetch chat', 0),
(0, 2667, 'Please enter Visitor email address', 0),
(1, 2667, 'Please enter Visitor email address', 0),
(0, 2668, 'Not maintain', 0),
(1, 2668, 'Not maintain', 0),
(0, 2669, 'Resolution SLA', 0),
(1, 2669, 'Resolution SLA', 0),
(0, 2670, 'Response SLA', 0),
(1, 2670, 'Response SLA', 0),
(0, 2671, 'Total avg. response SLA maintained', 0),
(1, 2671, 'Total avg. response SLA maintained', 0),
(0, 2672, 'Total avg. resolution SLA maintained', 0),
(1, 2672, 'Total avg. resolution SLA maintained', 0),
(0, 2673, 'Freshbooks', 0),
(1, 2673, 'Freshbooks', 0),
(0, 2674, 'Freshbooks domain', 0),
(1, 2674, 'Freshbooks domain', 0),
(0, 2675, 'Delete freshbooks', 0),
(1, 2675, 'Delete freshbooks', 0),
(0, 2676, 'Project name', 0),
(1, 2676, 'Project name', 0),
(0, 2677, 'Projects', 0),
(1, 2677, 'Projects', 0),
(0, 2678, 'Amount outstanding', 0),
(1, 2678, 'Amount outstanding', 0),
(0, 2679, 'Discount', 0),
(1, 2679, 'Discount', 0),
(0, 2680, 'Search by', 0),
(1, 2680, 'Search by', 0),
(0, 2681, 'Zopim', 0),
(1, 2681, 'Zopim', 0),
(0, 2682, 'Satellite helpdesk', 0),
(1, 2682, 'Satellite helpdesk', 0),
(0, 2683, 'Insightly', 0),
(1, 2683, 'Insightly', 0),
(0, 2684, 'Add insightly', 0),
(1, 2684, 'Add insightly', 0),
(0, 2685, 'Update insightly', 0),
(1, 2685, 'Update insightly', 0),
(0, 2686, 'Delete insightly', 0),
(1, 2686, 'Delete insightly', 0),
(0, 2687, 'Insightly api url', 0),
(1, 2687, 'Insightly api url', 0),
(0, 2688, 'Organization email', 0),
(1, 2688, 'Organization email', 0),
(0, 2689, 'Role', 0),
(1, 2689, 'Role', 0),
(0, 2690, 'Leave us a message', 0),
(1, 2690, 'Leave us a message', 0),
(0, 2691, 'Help', 0),
(1, 2691, 'Help', 0),
(0, 2692, 'Search result', 0),
(1, 2692, 'Search result', 0),
(0, 2693, 'Search solutions', 0),
(1, 2693, 'Search solutions', 0),
(0, 2694, 'No record found', 0),
(1, 2694, 'No record found', 0),
(0, 2695, 'Button name', 0),
(1, 2695, 'Button name', 0),
(0, 2696, 'Select code', 0),
(1, 2696, 'Select code', 0),
(0, 2697, 'Widget code', 0),
(1, 2697, 'Widget code', 0),
(0, 2698, 'Preview', 0),
(1, 2698, 'Preview', 0),
(0, 2699, 'Rounded', 0),
(1, 2699, 'Rounded', 0),
(0, 2700, 'Square', 0),
(1, 2700, 'Square', 0),
(0, 2701, 'Button type', 0),
(1, 2701, 'Button type', 0),
(0, 2702, 'Right bottom', 0),
(1, 2702, 'Right bottom', 0),
(0, 2703, 'Left bottom', 0),
(1, 2703, 'Left bottom', 0),
(0, 2704, 'Right top', 0),
(1, 2704, 'Right top', 0),
(0, 2705, 'Widget position', 0),
(1, 2705, 'Widget position', 0),
(0, 2706, 'Feature', 0),
(1, 2706, 'Feature', 0),
(0, 2707, 'Both', 0),
(1, 2707, 'Both', 0),
(0, 2708, 'Request submitted', 0),
(1, 2708, 'Request submitted', 0),
(0, 2709, 'Nothing to display here yet..', 0),
(1, 2709, 'Nothing to display here yet..', 0),
(0, 2710, 'Field misssing', 0),
(1, 2710, 'Field misssing', 0),
(0, 2711, 'Bigcommerce', 0),
(1, 2711, 'Bigcommerce', 0),
(0, 2712, 'Add bigcommerce', 0),
(1, 2712, 'Add bigcommerce', 0),
(0, 2713, 'API path', 0),
(1, 2713, 'API path', 0),
(0, 2714, 'Update bigcommerce', 0),
(1, 2714, 'Update bigcommerce', 0),
(0, 2715, 'Delete bigcommerce', 0),
(1, 2715, 'Delete bigcommerce', 0),
(0, 2716, 'Stripe', 0),
(1, 2716, 'Stripe', 0),
(0, 2717, 'Stripe', 0),
(1, 2717, 'Stripe', 0),
(0, 2718, 'Secret key', 0),
(1, 2718, 'Secret key', 0),
(0, 2719, 'Publishable key', 0),
(1, 2719, 'Publishable key', 0),
(0, 2720, 'Secret key missing', 0),
(1, 2720, 'Secret key missing', 0),
(0, 2721, 'Publishable key missing', 0),
(1, 2721, 'Publishable key missing', 0),
(0, 2722, 'Facebook details missing', 0),
(1, 2722, 'Facebook details missing', 0),
(0, 2723, 'Links for ticket', 0),
(1, 2723, 'Links for ticket', 0),
(1, 2724, 'Email has been sent to verification link', 0),
(0, 2724, 'Email has been sent to verification link', 0),
(1, 2725, 'Resend verification link', 0),
(0, 2725, 'Resend verification link', 0),
(1, 2726, 'Operation can not be performed, client is not verify', 0),
(0, 2726, 'Operation can not be performed, client is not verify', 0),
(1, 2727, 'Operation can not be performed, client is  not approve', 0),
(0, 2727, 'Operation can not be performed, client is  not approve', 0),
(1, 2728, 'Operation can not be performed, client is spam', 0),
(0, 2728, 'Operation can not be performed, client is spam', 0),
(1, 2729, 'Operation can not be performed, client is ban', 0),
(0, 2729, 'Operation can not be performed, client is ban', 0),
(1, 2730, 'Not verified', 0),
(0, 2730, 'Not verified', 0),
(1, 2731, 'Verified', 0),
(0, 2731, 'Verified', 0),
(1, 2732, 'Verify email', 0),
(0, 2732, 'Verify email', 0),
(1, 2733, 'Jira', 0),
(0, 2733, 'Jira', 0),
(1, 2734, 'Jira URL', 0),
(0, 2734, 'Jira URL', 0),
(1, 2735, 'Create issue', 0),
(0, 2735, 'Create issue', 0),
(1, 2736, 'Issue type', 0),
(0, 2736, 'Issue type', 0),
(1, 2737, 'Issue hash', 0),
(0, 2737, 'Issue hash', 0),
(1, 2738, 'Link issue', 0),
(0, 2738, 'Link issue', 0),
(1, 2739, 'Unlink issue', 0),
(0, 2739, 'Unlink issue', 0),
(1, 2740, 'View issue in jira', 0),
(0, 2740, 'View issue in jira', 0),
(1, 2741, 'Blesta', 0),
(0, 2741, 'Blesta', 0),
(1, 2742, 'Add blesta', 0),
(0, 2742, 'Add blesta', 0),
(1, 2743, 'Update blesta', 0),
(0, 2743, 'Update blesta', 0),
(1, 2744, 'Delete blesta', 0),
(0, 2744, 'Delete blesta', 0),
(1, 2745, 'API user', 0),
(0, 2745, 'API user', 0),
(1, 2746, 'Due', 0),
(0, 2746, 'Due', 0),
(1, 2747, 'Package name', 0),
(0, 2747, 'Package name', 0),
(1, 2748, 'Packages', 0),
(0, 2748, 'Packages', 0),
(1, 2749, 'Term', 0),
(0, 2749, 'Term', 0);
INSERT INTO `avis_language_variables` (`variable_id`, `title`, `location_area`, `is_itil`) VALUES 
(2750, 'TXTCREATESUBTASK', 2, 0),
(2751, 'TXTCHILDOF', 2, 0),
(2752, 'TXTSUBTASK', 2, 0),
(2753, 'TXTTARGATEDATE', 2, 0),
(2754, 'TXTITILPLZSELECTCITYPE', 2, 0),
(2755, 'MSGPLZSELFILE', 2, 0),
(2756, 'TXTTRACKINGCLIENT', 2, 0),
(2757, 'TXTTRACKINGORG', 2, 0),
(2758, 'TXTRECURSIVETASK ', 2, 0),
(2759, 'TXTMASSREPLY', 2, 0),
(2760, 'TXTREPLYALLLINKEDTICKET', 2, 1),
(2761, 'MSGCHANGESTATUSMESSAGEFORORANIZATION', 2, 0),
(2762, 'MSGMOVETOORG', 2, 0),
(2763, 'TXTMOVECLIENTORG', 2, 0),
(2764, 'MSGFEEDBACKERR', 1, 0),
(2765, 'TXTRATETICKET', 1, 0),
(2766, 'TXTCANCLIENTCLOSETICKET', 2, 0),
(2767, 'TXTSOLUTIONANDTICKETSEARCH', 2, 0),
(2768, 'MSGTICKHASHLINK', 2, 0),
(2769, 'TXTUNLINKEDFROM', 2, 0),
(2770, 'TXTPINNED', 2, 0),
(2771, 'TXTREMOVEDLABEL', 2, 0),
(2772, 'MSGTICKETPROPERTYUPDATED', 2, 0),
(2773, 'MSGTICKETNOTEADDED', 2, 0),
(2774, 'MSGTICKETNOTEDELETED', 2, 0),
(2775, 'MSGTICKETCOMMENTADDED', 2, 0),
(2776, 'MSGTICKETCOMMENTDELETED', 2, 0),
(2777, 'MSGTICKETPOSTUPDATED', 2, 0),
(2778, 'MSGADDEDNEWRECIPIENT', 2, 0),
(2779, 'MSGADDEDNEWPEOPLE', 2, 0),
(2780, 'MSGREMOVEDRECIPIENT', 2, 0),
(2781, 'MSGREMOVEDPEOPLE', 2, 0),
(2782, 'MSGADDEDNEWTAG', 2, 0),
(2783, 'MSGTICKHASHLINK', 2, 0),
(2784, 'TXTSENDNOTIFORNEWTASKANDTASKCOMMENT', 2, 0);
INSERT INTO `avis_language_values` (`language_id`, `variable_id`, `description`, `is_custom`) VALUES
(1, 2750, 'Create Subtask', 0),
(0, 2750, 'Create Subtask', 0),
(1, 2751, 'Child of', 0),
(0, 2751, 'Child of', 0),
(1, 2752, 'Subtask', 0),
(0, 2752, 'Subtask', 0),
(1, 2753, 'Target date', 0),
(0, 2753, 'Target date', 0),
(1, 2754, 'Please select CI type', 0),
(0, 2754, 'Please select CI type', 0),
(1, 2755, 'Please select file', 0),
(0, 2755, 'Please select file', 0),
(1, 2756, 'Time tracking per client', 1),
(0, 2756, 'Time tracking per client', 1),
(1, 2757, 'Time tracking per organization', 1),
(0, 2757, 'Time tracking per organization', 1),
(1, 2758, 'Recursive task', 0),
(0, 2758, 'Recursive task', 0),
(1, 2759, 'Mass reply', 0),
(0, 2759, 'Mass reply', 0),
(1, 2760, 'Reply all linked tickets', 0),
(0, 2760, 'Reply all linked tickets', 0),
(1, 2761, 'Changing organization status to disable will ban all clients & their tickets.<br/>This operation is irreversible<br />Are you sure you want to proceed?', 0),
(0, 2761, 'Changing organization status to disable will ban all clients & their tickets.<br/>This operation is irreversible<br />Are you sure you want to proceed?', 0),
(1, 2762, 'Organization can not set to other domain clients', 0),
(0, 2762, 'Organization can not set to other domain clients', 0),
(1, 2763, 'Move clients to any organization', 0),
(0, 2763, 'Move clients to any organization', 0),
(1, 2764, 'You have already submited feedback', 0),
(0, 2764, 'You have already submited feedback.', 0),
(1, 2765, 'Rate this ticket', 0),
(0, 2765, 'Rate this ticket', 0),
(1, 2766, 'Can client close ticket', 0),
(0, 2766, 'Can client close ticket', 0),
(1, 2767, 'Solution and ticket search', 0),
(0, 2767, 'Solution and ticket search', 0),
(1, 2768, 'Select multiple tickets to link', 0),
(0, 2768, 'Select multiple tickets to link', 0),
(1, 2769, 'unlinked from', 0),
(0, 2769, 'unlinked from', 0),
(1, 2770, 'Pinned', 0),
(0, 2770, 'Pinned', 0),
(1, 2771, 'Removed label', 0),
(0, 2771, 'Removed label', 0),
(1, 2772, 'Ticket property updated', 0),
(0, 2772, 'Ticket property updated', 0),
(1, 2773, 'Ticket note added', 0),
(0, 2773, 'Ticket note added', 0),
(1, 2774, 'Ticket note deleted', 0),
(0, 2774, 'Ticket note deleted', 0),
(1, 2775, 'Ticket comment added', 0),
(0, 2775, 'Ticket comment added', 0),
(1, 2776, 'Ticket comment deleted', 0),
(0, 2776, 'Ticket comment deleted', 0),
(1, 2777, 'Ticket post updated', 0),
(0, 2777, 'Ticket post updated', 0),
(1, 2778, 'Added new recipient', 0),
(0, 2778, 'Added new recipient', 0),
(1, 2779, 'Added new people', 0),
(0, 2779, 'Added new people', 0),
(1, 2780, 'Removed recipient', 0),
(0, 2780, 'Removed recipient', 0),
(1, 2781, 'Removed people', 0),
(0, 2781, 'Removed people', 0),
(1, 2782, 'Added new tag', 0),
(0, 2782, 'Added new tag', 0),
(1, 2783, 'Removed tag', 0),
(0, 2783, 'Removed tag', 0),
(1, 2784, 'Send notification for new task and task comment', 0),
(0, 2784, 'Send notification for new task and task comment', 0);
INSERT INTO `avis_language_variables` (`variable_id`, `title`, `location_area`, `is_itil`) VALUES
(2785, 'TXTFORUMS', 2, 0),
(2786, 'TXTSEARCHTOPICS', 2, 0),
(2787, 'TXTALLACTIVITY', 2, 0),
(2788, 'TXTWAITINGFORAPPROVAL', 2, 0),
(2789, 'TXTYOURTOPICACTIVITY', 2, 0),
(2790, 'TXTALLCATEGORY', 2, 0),
(2791, 'TXTEDITFORUM', 2, 0),
(2792, 'TXTFORUMCATEGORY', 2, 0),
(2793, 'TXTADDFORUMCATEGORY', 2, 0),
(2794, 'TXTADDFORUM', 2, 0),
(2795, 'TXTADDTOPIC', 2, 0),
(2796, 'TXTDELETEFORUMCATEGORY', 2, 0),
(2797, 'MSGDELETEFORUMCATEGORY', 2, 0),
(2798, 'MSGLANGTRANSFORFORUM', 2, 0),
(2799, 'TXTSENDEMAILNOTIFICATION', 2, 0),
(2800, 'TXTDELETETOPICCOMMENT', 2, 0),
(2801, 'MSGDELETETOPIC', 2, 0),
(2802, 'TXTDELETETOPIC', 2, 0),
(2803, 'TXTUPDATETOPIC', 2, 0),
(2804, 'MSGLANGTRANSFORFORUMCATEGORY', 2, 0),
(2805, 'TXTDELETEFORUM', 2, 0),
(2806, 'MSGDELETEFORUM', 2, 0),
(2807, 'TXTLOCK', 2, 0),
(2808, 'TXTUNLOCK', 2, 0),
(2809, 'TXTNEWTOPICS', 2, 0),
(2810, 'TXTTOPICFOLLOWERS', 2, 0),
(2811, 'TXTFORUMS', 1, 0),
(2812, 'TXTADDTOPIC', 1, 0),
(2813, 'TXTTOPICTITLE', 1, 0),
(2814, 'TXTPOSTTOPICIN', 1, 0),
(2815, 'TXTATTACHFILES', 1, 0),
(2816, 'TXTCREATEDBY', 1, 0),
(2817, 'TXTVOTE', 1, 0),
(2818, 'TXTCOMMENT', 1, 0),
(2819, 'TXTFOLLOW', 1, 0),
(2820, 'TXTUNFOLLOW', 1, 0),
(2821, 'TXTDELETEFORUMACTIVITY', 2, 0),
(2822, 'TXTNEWTOPIC', 2, 0),
(2823, 'TXTNEWTOPICCOMMENT', 2, 0),
(2824, 'TXTTOPIC', 2, 0),
(2825, 'TXTPEOPLEWHOLIKED', 1, 0),
(2826, 'TXTPEOPLEWHOLIKED', 2, 0),
(2827, 'TXTRECENT', 2, 0),
(2828, 'TXTPOPULARITY', 2, 0),
(2829, 'TXTUNFOLLOW', 2, 0),
(2830, 'TXTFOLLOW', 2, 0),
(2831, 'MSGREQADDFORUMCAT', 2, 0),
(2832, 'MSGREQADDFORUM', 2, 0),
(2833, 'TXTMARKASSTICKY', 2, 0),
(2834, 'TXTPOSTTOPIC', 2, 0),
(2835, 'TXTUNANSWERED', 2, 0),
(2836, 'TXTISTOPICMOVE', 2, 0),
(2837, 'TXTSCHEDULETICKET', 2, 0),
(2838, 'TXTSCHEDULEDATE', 2, 0),
(2839, 'MSGREQUIREDAY', 2, 0),
(2840, 'MSGSCHEDULEDATE', 2, 0),
(2841, 'MSGSCHEDULEENDDATE', 2, 0),
(2842, 'TXTREPEATSCHEDULE', 2, 0),
(2843, 'MSGNEWSCHEDULETKTCRT', 2, 0),
(2844, 'TXTVERIFYEMAIL', 1, 0),
(2845, 'TXTSEARCHRESULT', 1, 0),
(2846, 'TXTRECENT', 1, 0),
(2847, 'TXTPOPULAR', 1, 0),
(2848, 'TXTUNANSWERED', 1, 0),
(2849, 'TXTTICKETCATEGORY', 2, 0),
(2850, 'TXTADDTICKETCATEGORY', 2, 0),
(2851, 'TXTDELTICKETCATEGORY', 2, 0),
(2852, 'TXTDELTICKETCATEGORYMSG', 2, 0),
(2853, 'TXTUPDATETICKETCATEGORY', 2, 0),
(2854, 'MSGREQFLDSTAFF', 2, 0),
(2855, 'TXTTICKETSUBCATEGORY', 2, 0),
(2856, 'TXTADDTICKETSUBCATEGORY', 2, 0),
(2857, 'TXTUPDATETICKETSUBCATEGORY', 2, 0),
(2858, 'TXTDELTICKETSUBCATEGORY', 2, 0),
(2859, 'TXTDELTICKETSUBCATEGORYMSG', 2, 0),
(2860, 'TXTTICKETITEM', 2, 0),
(2861, 'TXTADDTICKETITEM', 2, 0),
(2862, 'TXTDELTICKETITEM', 2, 0),
(2863, 'TXTUPDATETICKETITEM', 2, 0),
(2864, 'TXTDELTICKETITEMMSG', 2, 0),
(2865, 'TXTTICKETLEVEL', 2, 0),
(2866, 'TXTADDTICKETLEVEL', 2, 0),
(2867, 'TXTDELTICKETLEVEL', 2, 0),
(2868, 'TXTUPDATETICKETLEVEL', 2, 0),
(2869, 'TXTDELTICKETLEVELMSG', 2, 0),
(2870, 'MSGENABLETICKETCATEGORY', 2, 0),
(2871, 'MSGENABLETICKETLEVEL', 2, 0),
(2872, 'TXTSUGGESTSEARCH', 2, 1),
(2873, 'TXTLOCATION', 1, 1),
(2874, 'TXTMOSTCOMMENTED', 1, 0),
(2875, 'TXTBCC', 2, 0),
(2876, 'TXTCHANGECATEGORY', 2, 0),
(2877, 'TXTCHANGESUBCATEGORY', 2, 0),
(2878, 'TXTCHANGEITEM', 2, 0),
(2879, 'TXTCHANGELEVEL', 2, 0),
(2880, 'TXTCHANGELOCATION', 2, 0),
(2881, 'TXTSELECT', 1, 0),
(2882, 'TXTTICKETCATEGORY', 1, 0),
(2883, 'TXTTICKETSUBCATEGORY', 1, 0),
(2884, 'TXTTICKETITEM', 1, 0),
(2885, 'TXTTICKETLEVEL', 1, 0),
(2886, 'TXTCATEGORY', 1, 0),
(2887, 'TXTMANGAEANDCLIENTPORTAL', 2, 0),
(2888, 'TXTDISPSUBCATEGORY', 2, 0),
(2889, 'TXTDISPITEM', 2, 0),
(2890, 'MSGTICKETLEVELCHANGED', 2, 0),
(2891, 'MSGTICKETCATEGORYCHANGED', 2, 0),
(2892, 'MSGTICKETSUBCATEGORYCHANGED', 2, 0),
(2893, 'MSGTICKETITEMCHANGED', 2, 0),
(2894, 'MSGITILLOCATIONCHANGED', 2, 0),
(2895, 'TXTUNAPPROVEMESSAGE', 2, 0),
(2896, 'TXTRECURRENCE', 2, 0),
(2897, 'TXTCATEGORYCHANGE', 2, 0),
(2898, 'TXTSUBCATEGORYCHANGE', 2, 0),
(2899, 'TXTITEMCHANGE', 2, 0),
(2900, 'TXTLEVELCHANGE', 2, 0),
(2901, 'TXTLOCATIONCHANGE', 2, 0),
(2902, 'TXTTICKETSCHEDULE', 2, 0),
(2903, 'TXTFORUMSIGNATURE', 2, 0),
(2904, 'MSGDOMNTFND', 2, 0),
(2905, 'TXTFORUMACTIVITY', 1, 0),
(2906, 'TXTAPPROVEDTOPICS', 1, 0),
(2907, 'TXTFOLLOWEDTOPICS', 1, 0),
(2908, 'TXTFORUMSIGNATURE', 1, 0),
(2909, 'TXTOK', 1, 0),
(2910, 'MSGEMAILNOTIFICATION', 1, 0),
(2911, 'TXTPENDINGTOPICS', 1, 0),
(2912, 'TXTAUTOAPPROVETOPICANDCOMMENT', 2, 0),
(2913, 'TXTDEFAULTPAGEAFTERLOGIN', 2, 0),
(2914, 'TXTDEFAULTPAGEBEFORELOGIN', 2, 0),
(2915, 'TXTUSERTYPE', 2, 0),
(2916, 'TXTFORUM', 2, 0),
(2917, 'TXTPREVIOUS', 2, 0),
(2918, 'MSGCOMMENTAWITINGMOD', 1, 0),
(2919, 'MSGTOPICAWITINGMOD', 1, 0),
(2920, 'TXTREPEAT', 2, 0),
(2921, 'TXTOCCURANCELEFT', 2, 0),
(2922, 'TXTQUEUEOUTGOINGMAILS', 2, 0),
(2923, 'MSGNOLINKTICKETFOUND', 2, 0),
(2924, 'MSGLANGTRANSFORCUSTOMFIELDS', 2, 0),
(2925, 'MSGLANGTRANSFORCUSTOMFIELDGROUP', 2, 0),
(2926, 'TXTPAUSESLA', 2, 0),
(2927, 'TXTRESUMESLA', 2, 0),
(2928, 'TXTSLAPAUSED', 2, 0),
(2929, 'TXTSLARESUMED', 2, 0),
(2930, 'TXTPAUSEORRESUMESLA', 2, 0),
(2931, 'TXTWITH', 2, 0),
(2932, 'TXTTYPEHEREART', 2, 0),
(2933, 'TXTARTICLESUGGESTIONS', 2, 0),
(2934, 'TXTKEYWORDS', 2, 0),
(2935, 'TXTDESTINATION', 2, 0),
(2936, 'TXTISSUEID', 2, 0),
(2937, 'TXTREADMINE', 2, 0),
(2938, 'TXTREADMINEURL', 2, 0),
(2939, 'TXTCREATEISSUEWITHREADMINE', 2, 0),
(2940, 'TXTTRACKER', 2, 0),
(2941, 'TXTISSUE', 2, 0),
(2942, 'TXTPROJECTNAME', 2, 0),
(2943, 'MSGISSUELIKED', 2, 0),
(2944, 'TXTSELCTPROJECT', 2, 0),
(2945, 'TXTSELECTISSUE', 2, 0),
(2946, 'TXTSELECTTRACKER', 2, 0),
(2947, 'TXTVIEWISSUEINREDMINE', 2, 0),
(2948, 'TXTENABLED', 1, 0),
(2949, 'TXTDISABLED', 1, 0),
(2950, 'TXTAUTOGENRATEORG', 2, 0),
(2951, 'TXTIGNOREORGANIZATION', 2, 0),
(2952, 'TXTENABLESUBJECTMATCHING', 2, 0),
(2953, 'TXTVISIBLRTOLEFTPANEL', 2, 0),
(2954, 'TXTDEFAULT', 2, 0),
(2955, 'TXTBOTHTICKETCREATION', 2, 0),
(2956, 'TXTSHOWONLINESTAFF', 2, 0),
(2957, 'TXTBASEDTICKHASSUBJLINE', 2, 0),
(2958, 'TXTBASEDTICKSUB', 2, 0),
(2959, 'TXTADDITIONALEMAILS', 1, 0),
(2960, 'TXTADDITIONALEMAILS', 2, 0),
(2961, 'TXTBLANKFIELD', 1, 0),
(2962, 'TXTBLANKFIELD', 2, 0),
(2963, 'TXTEMAILALREADYEXIST', 1, 0),
(2964, 'TXTEMAILALREADYEXIST', 2, 0),
(2965, 'TXTFAX', 1, 0),
(2966, 'TXTMOBILENUMBER', 1, 0),
(2967, 'TXTTEMPLATE', 2, 0),
(2968, 'TXTONLASTACTIVITY', 2, 0),
(2969, 'TXTSLASTATE', 2, 0),
(2970, 'TXTFAVICON', 2, 0),
(2971, 'MSGINVALIDCHARACTER', 2, 0),
(2972, 'TXTRESEND', 1, 0),
(2973, 'TXTRESEND', 2, 0),
(2974, 'TXTTASKLISTCOUNT', 2, 0),
(2975, 'TXTDISPLAYAMOUNTONTIMETRACK', 2, 0),
(2976, 'MSGNUMERICVALIDATIONFORMINUTES', 2, 0),
(2977, 'TXTHELP', 2, 0),
(2978, 'TXTISMANAGER', 2, 0),
(2979, 'TXTADVSEARCH', 1, 0),
	(2980, 'TXTFLAG', 1, 0),
	(2981, 'TXTOWNER', 1, 0),
	(2982, 'TXTREPORTS', 1, 0),
 (2983, 'TXTBYSTATUS', 1, 0),
 (2984, 'TXTPRIPORTY', 1, 0),
	(2985, 'TXTBYTYPE', 1, 0),
	(2986, 'TXTBYOWNER', 1, 0),
	(2987, 'TXTSELECTDURATION', 1, 0),
	(2988, 'TXTLASTDAYS', 1, 0),
	(2989, 'TXTLASTSEVENDAYS', 1, 0),
	(2990, 'TXTLASTTWENTYFOURHOURS', 1, 0),
	(2991, 'TXTFROM', 1, 0),
	(2992, 'TXTTO', 1, 0),
 (2993, 'TXTSTATUS', 1, 0),
 (2994, 'TXTPRIORITY', 1, 0),
 (2995, 'TXTTPYE', 1, 0),
 (2996, 'TXTOWNER', 1, 0),
 (2997, 'TXTVALIDSTATUS', 1, 0),
	(2998, 'TXTVALIDDURATION', 1, 0),
	(2999, 'TXTVALIDDATE', 1, 0),
	(3000, 'TXTVALIDPRIORITY', 1, 0),
	(3001, 'TXTVALIDOWNER', 1, 0),
	(3002, 'TXTVALIDTYPE', 1, 0),
	(3003, 'TXTCLIENTBYORGNATION', 1, 0),
	(3004, 'TXTCLIENTBYTICKET', 1, 0),
	(3005, 'TXTVALIDCLIENT', 1, 0),
	(3006, 'TXTVIEWRESULT', 1, 0),
	(3007, 'TXTGENERATE', 1, 0),
	(3008, 'TXTCUSTOM', 1, 0),
	(3009, 'TXTEXOTEL', 2, 0),
	(3010, 'TXTEXOTELAPPS', 2, 0),
	(3011, 'TXTEXOTELPHONES', 2, 0),	
	(3012, 'TXTDELETEEXOTEL', 2, 0),	
	(3013, 'TXTUPDATEEXOTELAPP', 2, 0),	
	(3014, 'TXTEXOPHONE', 2, 0),	
	(3015, 'MSGEXOPHONEREQ', 2, 0),	
	(3016, 'TXTADDEXOTELAPP', 2, 0),	
	(3017, 'TXTCONNECTCUSTTOAGENT', 2, 0),	
	(3018, 'TXTCONNECTCUSTTOFLOW', 2, 0),	
	(3019, 'TXTSENDBULKSMS', 2, 0),	
	(3020, 'TXTTIMELIMIT', 2, 0),
	(3021, 'TXTOUT', 2, 0),
	(3022, 'TXTOPTIONAL', 2, 0),
	(3023, 'TXTCALLERID', 2, 0),
	(3024, 'TXTCALLTYPE', 2, 0),
	(3025, 'TXTTRANS', 2, 0),
	(3026, 'TXTPROMO', 2, 0),
	(3027, 'TXTCONNECT', 2, 0),
	(3028, 'MSGSELECTAPP', 2, 0),
	(3029, 'MSGSELECTCALLER', 2, 0),
	(3030, 'MSGFROM', 2, 0),
	(3031, 'MSGTO', 2, 0),
	(3032, 'TXTMSGBODY', 2, 0),
	(3033, 'TXTSENADSMS', 2, 0),
	(3034, 'MSGBODY', 2, 0),
	(3035, 'TXTAUTOTICKETECREATION', 2, 0),
	(3036, 'TXTFROM', 1, 0),
	(3037, 'TXTSTARTDATE', 1, 0),
	(3038, 'TXTENDDATE', 1, 0),
	(3039, 'TXTDURATION', 1, 0),
	(3040, 'TXTPRICE', 1, 0),
	(3041, 'TXTDIRECTION', 1, 0),	
	(3042, 'TXTSENSTDATE', 2, 0),
	(3043, 'TXTBODY', 2, 0),
	(3044, 'TXTSMSDETAILS', 2, 0),
	(3045, 'TXTOUTWARDCALL', 2, 0),
	(3046, 'TXTINWARDCALL', 2, 0),
	(3047, 'TXTOUTWARDMSG', 2, 0),
	(3048, 'TXTINWARDMSG', 2, 0),
	(3049, 'TXTORDERREPORT', 2, 0),
	(3050, 'TXTBILLINGSTATUS', 2, 0),
	(3051, 'TXTSELECTSTATUS', 2, 0),
	(3052, 'TXTTOTALINVOICEID', 2, 0),
	(3053, 'TXTTOTALPAID', 2, 0),
	(3054, 'TXTREFRENCTICKET', 2, 0),
	(3055, 'TXTBILLINGSTATUSSEL', 2, 0),
	(3056, 'TXTBONUSPOINTREPOT', 2, 0),
	(3057, 'TXTSTAFFPOINTREPORT', 2, 0),
	(3058, 'TXTCLIENTTRANSACTIONREPORT', 2, 0),
	(3059, 'TXTCLIENTORDERREPORT', 2, 0),
	(3060, 'TXTTRANSACTIONREPORT', 2, 0),
	(3061, 'TXTTICKETSTATUSCOUNTPERDOMAIN', 2, 0),
	(3062, 'TXTFIRSTRESPONSE', 2, 0),
	(3063, 'TXTBILLINGINVOICEREPORT', 2, 0),
	(3064, 'TXTTRANSACTIONREPORT', 2, 0),
	(3065, 'TXTTOTALTICKET', 2, 0),
	(3066, 'TXTTOTALOPEN', 2, 0),
	(3067, 'TXTTOTALCLOSE', 2, 0),
	(3068, 'TXTTOTALPROGRESS', 2, 0),
	(3069, 'TXTDEPARTMENTNAME', 2, 0),
	(3070, 'TXTPROINPROGRESS', 2, 0),
	(3071, 'TXTUPDATECUSTOM', 2, 0),
	(3072, 'TXTCREATECUSTOMREPORT', 2, 0),
	(3073, 'TXTCUSTOMVIEWREPORT', 2, 0),
	(3074, 'TXTTOTALRESPONSE', 2, 0),
	(3075, 'TXTPAIDSTATUS', 2, 0),
	(3076, 'TXTREFERENCETICKET', 2, 0),
	(3077, 'TXTORDERID', 2, 0),
	(3078, 'TXTDURATIONPOINT', 2, 0),
	(3079, 'TXTGENRATE', 2, 0),
	(3080, 'TXTTKTCHNLGRP', 2, 0),
	(3081, 'TXTDELETEDTICKETS', 2, 0),
	(3082, 'TXTDELETEDATE', 2, 0),
	(3083, 'TXTMERGEDDATE', 2, 0),
	(3084, 'TXTMERGEDTICKETS', 2, 0),
	(3085, 'CHNLNAME', 2, 0),
	(3086, 'TXTTOTALNOTKT', 2, 0),
	(3087, 'TXTRSLVDATE', 2, 0),
	(3088, 'TXTITILPRBSOLVE', 2, 0),
	(3089, 'TXTPRBFRM', 2, 0),
	(3090, 'TXTCSTFLDRPT', 2, 0),
	(3091, 'TXTFLDVAL', 2, 0),
	(3092, 'TXTCSTRPTUSRREG', 2, 0),
	(3093, 'TXTREPLYDATE', 2, 0),
	(3094, 'TXTFIRSTAVGRESPONSE', 2, 0),
	(3095, 'TXTTOTALPOINT', 2, 0),
	(3096, 'TXTCURRENTRANK', 2, 0),
	(3097, 'TXTNOTANSWEREDTICKET', 2, 0),
	(3098, 'TXTTICKETESCGROUPSTAFFOWNER', 2, 0),
	(3099, 'TXTTICKETESCGROUPDEPARTMENT', 2, 0),
	(3100, 'TXTNEXTASSIGNED', 2, 0),
	(3101, 'TXTEXPORTTYPE', 2, 0),
	(3102, 'TXTSCHEDULEREPORT', 2, 0),
	(3103, 'TXTSCHEDULETYPE', 2, 0),	
	(3104, 'TXTRECEIVECONTACTMAIL', 2, 0),
	(3105, 'TXTRECIEVEPCLIENTANDCONTACTSMAIL', 2, 0),
	(3106, 'TXTRECEIVECONTACTMAIL', 1, 0),
	(3107, 'TXTRECIEVEPCLIENTANDCONTACTSMAIL', 1, 0),
	(3108, 'TXTDEPTPER', 2, 0),
	(3109, 'TXTTOTALTICKETSRESOLVED', 2, 0),
	(3110, 'TXTLOGINACTIVITY', 2, 0),
	(3111, 'TXTSTAFFACTIVITIES', 2, 0),
	(3112, 'TXTACTIVITYTRACKING', 2, 0),
	(3113, 'TXTAVGRESPONSETIMEGROUPBYSTAFF', 2, 0),
	(3114, 'TXTLASTREPLIERTIME', 2, 0),
	(3115, 'TXTCREATENEW', 2, 0),
	(3116, 'TXTCUSTOMREPORTS', 2, 0),
	(3117, 'TXTDISPLAYCOUNT', 2, 0),
	(3118, 'MSGNEWCMDB',2,0),
	(3119, 'DEPTSETTO',2,0),
	(3120, 'CITYPESETTO',2,0),
	(3121, 'IMPACTSETTO',2,0),
	(3122, 'TXTLOCSETTO',2,0),
	(3123, 'TXTSETTO',2,0),
	(3124, 'MSGUPDATECMDB',2,0),
	(3125, 'TXTUPDATEDTO',2,0),
	(3126, 'TXTCLIENTWITHMAXTICKET',2,0),
	(3127, 'TXTMAXCOUNT',2,0),
	(3128, 'TXTTEN',2,0),
	(3129, 'TXTTWENTY',2,0),
	(3130, 'TXTFIFTY',2,0),
	(3131, 'TXTHUNDRED',2,0),
	(3132, 'TXTCLIENTWITHMAXREPLYTICKET',2,0),
	(3133, 'TXTDOMAINREPORT',2,0),
	(3134, 'TXTQUESTSTAFF',2,0),
	(3135, 'TXTCAPSULECRM', 2, 0),
	(3136, 'TXTCAPSULEURL', 2, 0),
	(3137, 'TXTUPDATECAPCRM', 2, 0),
	(3138, 'TXTADDCAPSULECRM', 2, 0),
	(3139, 'TXTFORUM', 1, 0),
	(3140, 'TXTSUBMITATICKET', 1, 0),
	(3141, 'TXTLETSHELPU', 1, 0),
	(3142, 'TXTHIPCHAT', 2, 0),
	(3143, 'TXTHIPCHATALERT', 2, 0),
	(3144, 'TXTDELHIPCHAT', 2, 0),
	(3145, 'TXTSLACK', 2, 0),
	(3146, 'TXTSLACKALERT', 2, 0),
	(3147, 'TXTDELSLACK', 2, 0),
	(3148, 'MSGCONTACHNUMBERREQ', 2, 0),
	(3149, 'TXTMATCHFOUND', 2, 0),
	(3150, 'MSGCONTACTNOEXISTED', 2, 0),
	(3151, 'TXTTOTALCLIENT', 2, 0),
	(3152, 'MSGORGIDMISS', 2, 0),
	(3153, 'TXTCASES', 2, 0),
	(3154, 'TXTMOSTCOMMETEDARTICLE', 2, 0),
	(3155, 'TXTMOSTVIEWEDARTICLE', 2, 0),
	(3156, 'TXTMOSTRAREDARTICLE', 2, 0),
	(3157, 'TXTFORMGROUP', 2, 0),
	(3158, 'TXTADDFORMGROUP', 2, 0),
	(3159, 'TXTFORMGROUPNAME', 2, 0),
	(3160, 'MSGREQFLDGRNAME', 2, 0),
	(3161, 'TXTDELETEFORM', 2, 0),
	(3162, 'MSGFORMGRPDEL', 2, 0),
	(3163, 'TXTUPDATEFORMGROUP', 2, 0),
	(3164, 'TXTFORMFIELD', 2, 0),
	(3165, 'TXTADDNEWFORMFIELD', 2, 0),
	(3166, 'TXTDELETEFORMFIELD', 2, 0),
	(3167, 'TXTPLACEHOLDER', 2, 0),
	(3168, 'TXTTOOLTIP', 2, 0),
	(3169, 'TXTIMAGE', 2, 0),
	(3170, 'TXTTEXT', 2, 0),
	(3171, 'TXTAPPLICATION', 2, 0),
	(3172, 'TXTHTMLATTRIBUTE', 2, 0),
	(3173, 'TXTDISPLAYTITLE', 2, 0),
	(3174, 'TXTFORMTYPE', 2, 0),
	(3175, 'TXTEMAILBASE', 2, 0),
	(3176, 'TXTCALLBASE', 2, 0),
	(3177, 'MSGMANDATORYEMAILFIELD', 2, 0),
	(3178, 'MSGMANDATORYCALLFIELD', 2, 0),
	(3179, 'MSGREQFILDSUBJECT', 2, 0),
	(3180, 'TXTEBABLECAPTCHA', 2, 0),
	(3181, 'TXTHELPDESKURL', 2, 0),
	(3182, 'TXTIFRAMEURL', 2, 0),
	(3183, 'TXTISINLINE', 2, 0),
	(3184, 'TXTISEDITOR', 2, 0),
	(3185,'TXTNOOFATTACHMENTS', 2, 0),
	(3186,'TXTFORMNAME', 2, 0),
	(3187,'TXTTHANKYOU', 1, 0),
	(3188,'TXTINVALIDEMAIL', 1, 0),
	(3189,'TXTINVALIDNUMERIC', 1, 0),
	(3190,'TXTINVALIDAPHA', 1, 0),
	(3191,'TXTINVALIDALPGHANUM', 1, 0),
	(3192,'TXTFORMNAME', 1, 0),
	(3193,'TXTFORMBUILDER', 2, 0),
	(3194,'TXTEDITFORMFIELD', 2, 0),
	(3195,'TXTUPDATEFORMFIELD', 2, 0),
	(3196, 'TXTMAILQUEUENOTEXIST', 2, 0),
	(3197, 'TXTCLIENTEMAILNOTVERIFIED', 2, 0),
	(3198, 'TXTCONTACTACCESS', 2, 0),
	(3199, 'TXTCLIENTREGISTRATIONERROR', 2, 0),
	(3200, 'TXTTICKETCREATIONERROR', 2, 0),
	(3201,'MSGCONTACTNO', 1, 0),
	(3202,'MSGNOFORM', 1, 0),
	(3203,'TXTPROBLEMGROUPBYSTATUS', 2, 0),
	(3204,'TXTPROBLEMGROUPBYPRIORITY', 2, 0),
	(3205,'TXTPROBLEMGROUPBYIMPACT', 2, 0),
	(3206,'TXTINVOICEHASH', 2, 0),
	(3207,'TXTORDERHASH', 2, 0),
	(3208,'TXTBACKTOLISTING', 2, 0),
	(3209,'MSGINVALIDCLIENTFORMERGE', 2, 0),
	(3210,'MSGMANDATORYFIELDS', 1, 0),
	(3211,'TXTSCHEDULEDREPORT', 2, 0),
	(3212,'TXTTASKNOTIFICATION', 2, 0),
	(3213,'TXTNOTSTARTEDTASK', 2, 0),
	(3214,'TXTHIDECLIENTPORTAL', 2, 0),
	(3215,'TXTPROBLEMSPERDEPT', 2, 0),
	(3216,'TXTCHANGESPERDEPT', 2, 0),
	(3217,'TXTRELEASESPERDEPT', 2, 0),
	(3218,'TXTSLAANDESCALATION', 2, 0),
	(3219,'TXTRATINGANDSURVEY', 2, 0),
	(3220,'TXTASSIGNSTAFFTASKREPORT', 2, 0),
	(3221,'TXTOVERDUETASK', 2, 0),
	(3222,'TXTASSETNAME', 2, 0),
	(3223,'TXTASSETSUSEDBYCLIENT', 2, 0),
	(3224,'TXTASSETMANAGEDBYSTAFF', 2, 0),
	(3225,'TXTTICKETLINKREPORT', 2, 0),
	(3226,'TXTCOMMENTEDREPORT', 2, 0),
	(3227,'TXTASSETLINKTOTICKETS', 2, 0),
	(3228,'TXTTYPETOSEARCHEXISTINGTICKETHASH', 2, 0),
	(3229,'TXTTASKLINKED', 2, 0),
	(3230,'TXTCITEMLINKED', 2, 0),
	(3231,'TXTPROBLEMLINKED', 2, 0),
	(3232,'TXTCHANGESLINKED', 2, 0),
	(3233,'TXTTICKETLINKED', 2, 0),
	(3234,'TXTRELEASELINKEDTOCHANGES', 2, 0),
	(3235,'TXTCHANGESRESOLVEDBYSTAFF', 2, 0),
	(3236,'TXTTOTALREPLIEDTICKET', 2, 0),
	(3237,'TXTCLOSETICKETDATE', 2, 0),
	(3238,'TXTMARKREAD', 2, 0),
	(3239,'TXTMARKUNREAD', 2, 0),
	(3240,'TXTAVGRESPONSEREPORT', 2, 0),
	(3241,'TXTDEPTSLAREPORT', 2, 0),
	(3242,'TXTAVGRESOLUTIONTIME', 2, 0),
	(3243,'TXTSTAFFWORK', 2, 0),
	(3244,'TXTSTAFFAVGRESPONSETIME', 2, 0),
	(3245,'TXTQUESTTOPPERFORMER', 2, 0),
	(3246,'TXTBILLINGSUMMARY', 2, 0),
	(3247,'TXTGOOGLEAPP', 2, 0),
	(3248,'TXTGOOGLECALENDER', 2, 0),
	(3249,'TXTGUESTEMAIL', 2, 0),
	(3250,'TXTCALENDEREVENTS', 2, 0),
	(3251,'TXTCALENDERTASKS', 2, 0),
	(3252,'TXTADDCALENDEREVENT', 2, 0),
	(3253,'TXTADDCALENDERTASK', 2, 0),
	(3254,'TXTGCALEVENTSDETAILS', 2, 0),
	(3255,'TXTGCALTASKSDETAILS', 2, 0),
	(3256,'TXTCALENDARLIST', 2, 0),
	(3257,'TXTTASKLIST', 2, 0),
	(3258,'TXTEVENTS', 2, 0),
	(3259,'TXTTICKETOVERVIEW', 2, 0),
	(3260,'TXTCLIENTOVERVIEW', 2, 0),
	(3261,'TXTCLIENTINVOICESREPORT', 2, 0),
	(3262,'TXTTOTALUNPAID', 2, 0),
	(3263,'TXTTOTALCANCELLED', 2, 0),
	(3264,'TXTTOTALINPROCESS', 2, 0),
	(3265,'TXTTICKETBYCHANNEL', 2, 0),
	(3266,'TXTQUEUESUMMARY', 2, 0),
	(3267,'TXTTOTALREPORTQUEUE', 2, 0),
	(3268,'TXTMYREPORTQUEUE', 2, 0),
	(3269,'TXTMYCOMPLITEDQUEUE', 2, 0),
	(3270,'TXTREPORTINQUEUE', 2, 0),
	(3271,'MSGSTARTDATEVALIDATION', 2, 0),
	(3272,'TXTMODIFICATIONDATE', 1, 0),
	(3273,'TXTVIEW', 1, 0),
	(3274,'TXTSTAFFLEAD', 2, 0),
	(3275,'TXTSOLVEDTICKETS', 2, 0),
	(3276,'AVGFIRSTREPLY', 2, 0),
	(3277,'TXTAVGRESPONSETIME', 2, 0),
	(3278,'TXTAVGSLATIME', 2, 0),
	(3279,'TXTCREATEFILTER', 2, 0),
	(3280,'TXTSUBMITTEDBY', 1, 0),
	(3281,'TXTTYPETOSEARCHEXISTINGSTAFFSEMAILADDRESS ', 2, 0),
	(3282,'TXTRESOLVEDBY', 2, 0),
	(3283,'TXTAPPLYFILTERCLIENT', 1, 0),
	(3284,'TXTWASTHISARTICLEHELPFUL', 1, 0),
	(3285,'TXTOUTOF', 1, 0),
	(3286,'TXTFOUNDTHISHELPFUL', 1, 0),
	(3287,'TXTARTICLELIKE', 2, 0),
	(3288,'TXTFEEDBACKCLIENT', 2, 0),
	(3289,'TXTORGNAME', 2, 0),
	(3290,'MSGCONTACTNOINVALIDEORMISSING', 2, 0),
	(3291, 'TXTACCOUNT', 2, 0),
	(3292, 'TXTHARVEST', 2, 0),
	(3293, 'TXTCREATEINVOICEWITHHARVEST', 2, 0),
	(3294, 'TXTISSUEDATE', 2, 0),
	(3295, 'TXTBALENCE', 2, 0),
	(3296, 'TXTUSER', 2, 0),
	(3297, 'TXTSELECTTOP', 2, 0),
	(3298, 'TXTSELECTALLREAD', 2, 0),
	(3299, 'TXTSELECTALLUNREAD', 2, 0),
	(3300, 'TXTADDNWTASK', 2, 0),
	(3301, 'MSGCSVFILENOTEXTST', 2, 0),
	(3302, 'TXTSELECTFORGENERATE', 1, 0),
	(3303, 'TXTUPDATEHARVEST', 2, 0),
	(3304, 'TXTDELHARVEST', 2, 0),
	(3305, 'TXTADDHARVEST', 2, 0),
	(3306, 'TXTTAWKTO', 2, 0),
	(3307, 'TXTOLARK', 2, 0),
	(3308, 'TXTFORM', 1, 0),
	(3309, 'TXTTICKETREPLIEDBYSTAFF', 2, 0),
	(3310, 'TXTTICKETFORWARDEDBYSTAFF', 2, 0),
	(3311, 'TXTFORWARDCOUNT', 2, 0),
	(3312, 'TXTREADTICKETENTRYTOADUITLOG', 2, 0),
	(3313, 'TXTREADTICKETFORSTAFF', 2, 0),
	(3314, 'TXTTICKETVIEWEDBYSTAFF', 2, 0),
	(3315, 'TXTASSETLINKTOPROBLEM', 2, 0),
	(3316, 'TXTASSETGROUPSTATUS', 2, 0),
	(3317, 'TXTNOTEXPIRED', 2, 0),
	(3318, 'TXTEXPIRED', 2, 0),
	(3319, 'TXTASSETGROUPBYLOCATIONS', 2, 0),
	(3320, 'TXTCRISPAPP', 2, 0),
	(3321, 'TXTSTATUSTASK', 2, 0),
	(3322, 'TXTASSETTYPE', 2, 0),
	(3323, 'TXTASSTEPRODUCT', 2, 0),
	(3324, 'TXTHARDWREASSETBYSTATE', 2, 0),
	(3325, 'TXTASSETDEPRECIATION', 2, 0),
	(3326, 'TXTINTERCOM', 2, 0),
	(3327, 'TXTDELINTERCOM', 2, 0),
	(3328, 'TXTASSETDEPRECIATIONNOTIFY', 2, 0),
	(3329, 'TXTREMAININGWARRANTY', 2, 0),
	(3330, 'TXTTICKETLOAD', 2, 0),
	(3331, 'TXTSHOW', 2, 0),
	(3332, 'TXTTOTALASSIGNED', 2, 0),
	(3333, 'TXTTOTALUNASSIGNED', 2, 0),
	(3334, 'TXTTOTALMULASSIGNED', 2, 0),
	(3335, 'TXTBETWEEN', 2, 0),
	(3336, 'TXTMORETHAN', 2, 0),
	(3337, 'TXTSELECTTEAM', 2, 0),
	(3338, 'TXTSENDTICKETAPPROVAL', 2, 0),
	(3339, 'TXTCHANGETICKETAPPROVALSTATUS', 2, 0),
	(3340, 'TXTSENDTICKETAPPROVALREMINDER', 2, 0),
	(3341, 'TXTVTIGER', 2, 0),
	(3342, 'TXTPORTALURL', 2, 0),
	(3343, 'TXTADDVTIGER', 2, 0),
	(3344, 'TXTUPDATEVTIGER', 2, 0),
	(3345, 'TXTDELVTIGER', 2, 0),
	(3346, 'TXTCREATECONTACTINVTIGER', 2, 0),	
	(3347, 'TXTVTIGERLICENSE', 2, 0),
	(3348, 'TXTOPENSOURCE', 2, 0),
	(3349, 'TXTCLOUD', 2, 0),
	(3350, 'TXTROUNDROBIN', 2, 0),
	(3351, 'TXTADDRONDROBIN', 2, 0),
	(3352, 'TXTUPDATEROUNDROBIN', 2, 0),
	(3353, 'TXTDELROUNDROBIN', 2, 0),
	(3354, 'TXTESCALATIONRULE', 2, 0),
	(3355, 'MSGTICKETASSIGNBYESCALATIONRULE', 2, 0),
	(3356, 'MSGSENDESCALATIONEMAIL', 2, 0),
	(3357, 'TXTAUTOASSIGN', 2, 0),
	(3358, 'TXTAVILABLEAGENTS', 2, 0),
	(3359, 'TXTAGENTAVAILABILITY', 2, 0),
	(3360, 'TXTACCEPTING', 2, 0),
	(3361, 'TXTNOTACCEPTING', 2, 0),
	(3362, 'TXTTICKETASSIGNMENT', 2, 0),
	(3363, 'TXTAIRCALL', 2, 0),
	(3364, 'TXTVOICEMAIL', 2, 0),
	(3365, 'TXTSSO', 2, 0),
	(3366, 'TXTSAML', 2, 0),
	(3367, 'TXTJWT', 2, 0),
	(3368, 'TXTREMOTELOGINURL', 2, 0),
	(3369, 'TXTREMOTELOGOUTURL', 2, 0),
	(3370, 'TXTSHAREDSECRET', 2, 0),
	(3371, 'TXTSSOTYPE', 2, 0),
	(3372, 'TXTADDSSO', 2, 0),
	(3373, 'TXTSAMLSSOURL', 2, 0),
	(3374, 'TXTCERTIFICATEFPRINT', 2, 0),
	(3375, 'TXTUPDATESSO', 2, 0),
	(3376, 'TXTDELCAPCRM', 2, 0),
	(3377, 'TXTDELSSO', 2, 0),
	(3378, 'TXTCONTACT', 2, 0),
	(3379, 'TXTCREATETICKETEWITHVTIGER', 2, 0),
	(3380, 'TXTTWILIOMESSAGE', 2, 0),
	(3381, 'TXTCONFIGTWILIO', 2, 0),
	(3382, 'TXTOPPORTUNITIES', 2, 0),
	(3383, 'TXTCREATEOPPORTUNITIES', 2, 0),
	(3384, 'TXTOPPORTUNITIESLIST', 2, 0),
	(3385, 'TXTCLOSEDATE', 2, 0),
	(3386, 'TXTSALSESTAGE', 2, 0),
	(3387, 'TXTCREATEPROJECT', 2, 0),
	(3388, 'TXTSELFAUTOTICKETASSIGN', 2, 0),
	(3389, 'TXTCREATEPROJECT', 2, 0),
	(3390, 'TXTPROJECTLIST', 2, 0),
	(3391, 'TXTDRIVE', 2, 0),
	(3392, 'TXTMYDRIVE', 2, 0),
	(3393, 'TXTDRIVELISTCOUNT', 2, 0),
	(3394, 'TXTTICKETATTACHMENTS', 2, 0),
	(3395, 'MSGREQSTAFFSEMAIL', 2, 0),
	(3396, 'TXTGOOGLEDRIVE', 2, 0),
	(3397, 'TXTTOTALOPENTICKET', 2, 0),
	(3398, 'TXTVIEWBYSTAFFDATE', 2, 0),
	(3399, 'TXTGOOGLEDRIVESEARCHERROR', 2, 0),
	(3400, 'TXTCLTSBYORG', 2, 0),
	(3401, 'TXTHARDWARE', 2, 0),
	(3402, 'TXTSOFTWARE', 2, 0),
	(3403, 'TXTINVOICEBYORGANIZATION', 2, 0),
	(3404, 'TXTOPENCART', 2, 0),
	(3405, 'TXTDROPBOX', 2, 0),
	(3406, 'MSGCUSTOMEFIELDDATAMODIFIED', 2, 0),
	(3407, 'TXTDAY', 1, 0),
	(3408, 'TXTDAYS', 1, 0),
	(3409, 'TXTHOUR', 1, 0),
	(3410, 'TXTHOURS', 1, 0),
    (3411, 'TXTUNDUEREPORT', 2, 0),
    (3412, 'TXTSEARCHCLIENTS', 2, 0),
    (3413, 'TXTORGN', 2, 0),
	(3414, 'TXTTICKETCIRELATION', 2, 0),
	(3415, 'TXTPROBLEMCIRELATION', 2, 0),
	(3416, 'TXTCHANGESCIRELATION', 2, 0),
	(3417, 'TXTWINDOWS', 2, 0),
	(3418, 'TXTTENANT', 2, 0),
	(3419, 'TXTCLIENTBYORGANIZATION', 2, 0),
	(3420, 'TXTFORMHEADER', 2, 0),
	(3421, 'TXTTICKETSBYLABEL', 2, 0),
	(3422, 'TXTSTAFFLEADERFIRSTRESPONSE', 2, 0),
	(3423, 'TXTSTAFFLEADERAVGRESPONSE', 2, 0),
	(3424, 'TXTSTAFFLEADERAVDSLA', 2, 0),
	(3425, 'MSGFORMRQGR', 2, 0),
	(3426, 'TXTTICKETACTIVITYBYDEPTREP', 2, 0),
	(3427, 'TXTSEARCHDRIVE', 2, 0),
	(3428, 'TXTUPLOAD', 2, 0),
	(3429, 'TXTSELECTLOCATION', 2, 0),
	(3430, 'TXTSELECTCITYPE', 2, 0),
	(3431, 'TXTSELECTASSETTYPE', 2, 0),
	(3432, 'TXTSELECTASSETDEP', 2, 0),
	(3433, 'TXTALLFILE', 2, 0),
	(3434, 'TXTMYFILE', 2, 0),
	(3435, 'TXTVALIDSTATUS', 2, 0),
	(3436, 'MSGNEWTKTCRT', 1, 0),
	(3437, 'TXTSTATUSCHANGE', 1, 0),
	(3438, 'TXTPRIORITYCHANGE', 1, 0),
	(3439, 'TXTSPACEERRORDOMAINLIST', 2, 0),
	(3440, 'TXTERRORDOMAINLIST', 2, 0),
	(3441, 'TXTHASHERRORDOMAINLIST', 2, 0),
	(3442, 'TXTSPECIFIC', 2, 0),
	(3443, 'TXTMANAGEROUNDROBINPARTICIPANT', 2, 0),
	(3444, 'TXTCONTXTNUMERIC', 1, 0),
	(3445, 'TXTMAXCONTACT', 1, 0),
	(3446, 'TXTDOMAINLIST', 2, 0),
	(3447, 'TXTCOMMENTDATE', 2, 0),
	(3448, 'MSGBILLINVTIME', 2, 0),
	(3449, 'MSGWORKINVTIME', 2, 0),
	(3450, 'TXTASTERISK', 2, 0),
	(3451, 'TXTDBHOST', 2, 0),
	(3452, 'TXTDBUSER', 2, 0),
	(3453, 'TXTDBPASSWORD', 2, 0),
	(3454, 'TXTDBNAME', 2, 0),
	(3455, 'TXTASTCONFIGURATION', 2, 0),
	(3456, 'TXTASTDBCONFIGURATION', 2, 0),	
	(3457, 'TXTCONNECTTIMEOUT', 2, 0),
	(3458, 'TXTREADTIMEOUT', 2, 0),
	(3459, 'TXTSCHEM', 2, 0),
	(3460, 'TXTXCALLDATE', 2, 0),	
	(3461, 'TXTCHILD', 2, 0),
	(3462, 'TXTSRC', 2, 0),
	(3463, 'TXTDST', 2, 0),
	(3464, 'TXTDCONTEXT', 2, 0),
	(3465, 'TXTDSTCHANEL', 2, 0),
	(3466, 'TXTLASTAPP', 2, 0),
	(3467, 'TXTLASTDATA', 2, 0),
	(3468, 'TXTBILLSEC', 2, 0),
	(3469, 'TXTDISPOSITION', 2, 0),
	(3470, 'TXTAMAFLAGS', 2, 0),	
	(3471, 'TXTACCOUNTCODE', 2, 0),
	(3472, 'TXTUNIQUEID', 2, 0),
	(3473, 'TXTUSERFIELD', 2, 0),
	(3474, 'TXTRECORDINGFILE', 2, 0),
	(3475, 'TXTCNUM', 2, 0),
	(3476, 'TXTCNAM', 2, 0),
	(3477, 'TXTOUTBOUNDCNUM', 2, 0),
	(3478, 'TXTOUTBOUNDCNAM', 2, 0),
	(3479, 'TXTDSTCNAM', 2, 0),
	(3480, 'TXTDID', 2, 0),	
	(3481, 'TXTLINKEDID', 2, 0),
	(3482, 'TXTRECORDINGPATH', 2, 0),
	(3483, 'TXTASTDIALPLANS', 2, 0),
	(3484, 'TXTADDDIALPLAN', 2, 0),
	(3485, 'TXTCONTEXT', 2, 0),
	(3486, 'TXTEXTEN', 2, 0),
	(3487, 'TXTDELETEASTERISK', 2, 0),
	(3488, 'TXTUPDATEDIALPLAN', 2, 0),
	(3489, 'TXTASYNC', 2, 0),
	(3490, 'MSQREQ', 2, 0),
	(3491, 'TXTCALLUS', 1, 0),
	(3492, 'TXTTASKATTACHTOTICKET', 2, 0),
	(3493, 'MSGURLEXIST', 2, 0),
	(3494, 'MSGLANGTRANSFORFORMFIELDS', 2, 0),
	(3495, 'MSGLANGTRANSFORFORMFIELDGROUP', 2, 0),
	(3496, 'TXTCIATTACHED', 2, 0),
	(3497, 'TXTSIZE', 2, 0),
	(3498, 'TXTDELSELFDRIVE', 2, 0),
	(3499, 'MSGDELSELFDRIVE', 2, 0),
	(3500, 'MSGLANGTRANSFORSURVEYGROUP', 2, 0),
	(3501, 'MSGLANGTRANSFORSURVEYFIELDGROUP', 2, 0),
	(3502, 'MSGLANGTRANSFORTICKETCATTITLE', 2, 0),
	(3503, 'MSGLANGTRANSFORLEVEL', 2, 0),
	(3504, 'MSGLANGTRANSFORFLAG', 2, 0),
	(3505, 'MSGLANGTRANSFORCATEGORYTITLE', 2, 0),
	(3506, 'TXTTAXENABLED', 2, 0),
	(3507, 'TXTCOMPOUNDTAX', 2, 0),
	(3508, 'TXTTAXRULESETTING', 2, 0),
	(3509, 'TXTROOM', 2, 0),
	(3510, 'TXTNOTIFICATIONTO', 2, 0),
	(3511, 'TXTCITYPE', 1, 0),
	(3512, 'TXTCISELECT', 1, 0),
	(3513,'TXTMERGEINVOICE', '2', '0'),
	(3514,'TXTMERGETIMETRACK', '2', '0'),
	(3515,'TXTMERGENOTES', '2', '0'),
	(3516,'TXTMERGECOMMENTS', '2', '0'),
	(3517,'TXTMERGEOPTIONS', '2', '0'),
	(3518, 'TXTUPDATECICICUSTOMFIELD', '2', '0'),
	(3519, 'MSGLANGTRANSFORCICUSTOMFIELDS', '2', '0'),
	(3520, 'TXTADDNEWCICUSTOMFIELD', '2', '0'),
	(3521, 'TXTAUTOLOCK', '2', '0'),
	(3522, 'MSGSTAFFTEAM', '2', '0'),
	(3523, 'TXTMERGEPOST', '2', '0'),
	(3524, 'TXTSTATUSCHANGEREPORT', '2', '0'),
	(3525, 'TXTCFRFSTCRPT', '2', '0'),
	(3526, 'TXTREQUIEREDCIFIELD', '2', '0'),
	(3527, 'TXTCSTRPTORGREG', '2', '0'),
	(3528, 'MSGINVALIDASSETNAME', '2', '0'),
	(3529, 'TXTIMPLEMENTED', '2', '0'),
	(3530, 'TXTDIFERRED', '2', '0'),
	(3531, 'TXTXERO', 2, 0),
	(3532, 'TXTADDXERO', 2, 0),
	(3533, 'TXTDELXERO', 2, 0),
	(3534, 'TXTCONAME', 2, 0),
	(3535, 'TXTSTREET', 2, 0),
	(3536, 'TXTPOSTAL', 2, 0),
	(3537, 'TXTSKYPENAME', 2, 0),
	(3538, 'TXTNUMBER', 2, 0),
	(3539, 'TXTREF', 2, 0),
	(3540, 'TXTDIRECT', 2, 0),
	(3541, 'TXTREGION', 2, 0),
	(3542, 'TXTTKTCLOSEDUSER', 2, 0),
	(3543, 'TXTTICKETFLAGTOUSRREP', 2, 0),
	(3544, 'TXTSELFLAG', 2, 0),
	(3545, 'TXTALLFLAG', 2, 0),
	(3546, 'TXTORGANIZATIONADD', 2, 0),
	(3547, 'TXTORGANIZATIONEDIT', 2, 0),
	(3548, 'TXTORGANIZATIONDELETE', 2, 0),
	(3549, 'TXTASSETS', 1, 0),
	(3550, 'TXTNAME', 1, 0),
	(3551, 'TXTIMPACT', 1, 0),
	(3552, 'TXTASSIGNEDON', 1, 0),
	(3553, 'TXTITILEXPIRED', 1, 0),
	(3554, 'TXTUSEDBY', 1, 0),
	(3555, 'TXTMANAGEDBY', 1, 0),
	(3556, 'TXTITILACQUISITIONDATE', 1, 0),
	(3557, 'TXTITILBOOKVALUE', 1, 0),
	(3558, 'TXTITILSALVAGE', 1, 0),
	(3559, 'TXTITILDEPRECIATIONTYPE', 1, 0),
	(3560, 'TXTUSEFULLIFE', 1, 0),
	(3561, 'TXTCIPRODUCT', 1, 0),
	(3562, 'TXTMANUFACTURER', 1, 0),
	(3563, 'TXTWARRANTYTEAR', 1, 0),
	(3564, 'TXTWARRANTYMONTH', 1, 0),
	(3565, 'TXTASSETSTAG', 1, 0),
	(3566, 'TXTITILLASTAUDITDATE', 1, 0),
	(3567, 'TXTITILINSTALLATIONPATH', 1, 0),
	(3568, 'TXTITILLICENSEKEY', 1, 0),
	(3569, 'TXTITILLICENSEEXPDATE', 1, 0),
	(3570, 'TXTITILINSTALLATIONDATE', 1, 0),
	(3571, 'TXTTASKAUTO', 2, 0),
	(3572,'TXTINVALIDEMAIL', 2, 0),
	(3573,'TXTINVALIDNUMERIC', 2, 0),
	(3574,'TXTINVALIDAPHA', 2, 0),
	(3575,'TXTINVALIDALPGHANUM', 2, 0),
	(3576,'TXTFETCHALLPOST', 2, 0);


INSERT INTO `avis_language_values` (`language_id`, `variable_id`, `description`, `is_custom`) VALUES
(0, 2785, 'Forums', 0),
(1, 2785, 'Forums', 0),
(0, 2786, 'Search topic', 0),
(1, 2786, 'Search topic', 0),
(0, 2787, 'All activity', 0),
(1, 2787, 'All activity', 0),
(0, 2788, 'Waiting for approval', 0),
(1, 2788, 'Waiting for approval', 0),
(0, 2789, 'My topics activity', 0),
(1, 2789, 'My topics activity', 0),
(0, 2790, 'All category', 0),
(1, 2790, 'All category', 0),
(0, 2791, 'Edit forum', 0),
(1, 2791, 'Edit forum', 0),
(0, 2792, 'Category', 0),
(1, 2792, 'Category', 0),
(0, 2793, 'Add forum category', 0),
(1, 2793, 'Add forum category', 0),
(0, 2794, 'Add forum', 0),
(1, 2794, 'Add forum', 0),
(0, 2795, 'Add topic', 0),
(1, 2795, 'Add topic', 0),
(0, 2796, 'Category delete', 0),
(1, 2796, 'Category delete', 0),
(0, 2797, 'Deleting this category will delete all  forums and topics in it.', 0),
(1, 2797, 'Deleting this category will delete all  forums and topics in it.', 0),
(0, 2798, 'Language translation for forum title', 0),
(1, 2798, 'Language translation for forum title', 0),
(0, 2799, 'Forum notification', 0),
(1, 2799, 'Forum notification', 0),
(0, 2800, 'Delete topic comment', 0),
(1, 2800, 'Delete topic comment', 0),
(0, 2801, 'Deleting topic will delete topic and comments on it. <br />This operation \n\nis irreversible. <br />Are you sure you want to proceed?', 0),
(1, 2801, 'Deleting topic will delete topic and comments on it. <br />This operation \n\nis irreversible. <br />Are you sure you want to proceed?', 0),
(0, 2802, 'Delete topic', 0),
(1, 2802, 'Delete topic', 0),
(0, 2803, 'Update topic', 0),
(1, 2803, 'Update topic', 0),
(0, 2804, 'Language translation for forum category title', 0),
(1, 2804, 'Language translation for forum category title', 0),
(0, 2805, 'Delete forum', 0),
(1, 2805, 'Delete forum', 0),
(0, 2806, 'Deleting forum will delete  all its topics and comments on that topic. <br />This operation is irreversible. <br />Are you  sure you want to proceed?', 0),
(1, 2806, 'Deleting forum will delete  all its topics and comments on that topic. <br />This operation is irreversible. <br />Are you  sure you want to proceed?', 0),
(0, 2807, 'Lock', 0),
(1, 2807, 'Lock', 0),
(0, 2808, 'Unlock', 0),
(1, 2808, 'Unlock', 0),
(0, 2809, 'New topics', 0),
(1, 2809, 'New topics', 0),
(0, 2810, 'Topic followers', 0),
(1, 2810, 'Topic followers', 0),
(0, 2811, 'Forums', 0),
(1, 2811, 'Forums', 0),
(0, 2812, 'Add topic', 0),
(1, 2812, 'Add topic', 0),
(0, 2813, 'Topic title', 0),
(1, 2813, 'Topic title', 0),
(0, 2814, 'Post topic in', 0),
(1, 2814, 'Post topic in', 0),
(0, 2815, 'Attach files', 0),
(1, 2815, 'Attach files', 0),
(0, 2816, 'Created by', 0),
(1, 2816, 'Created by', 0),
(0, 2817, 'Vote', 0),
(1, 2817, 'Vote', 0),
(0, 2818, 'Comment', 0),
(1, 2818, 'Comment', 0),
(0, 2819, 'Follow', 0),
(1, 2819, 'Follow', 0),
(0, 2820, 'Unfollow', 0),
(1, 2820, 'Unfollow', 0),
(0, 2821, 'Delete forum activity', 0),
(1, 2821, 'Delete forum activity', 0),
(0, 2822, 'New topic', 0),
(1, 2822, 'New topic', 0),
(0, 2823, 'New topic comment', 0),
(1, 2823, 'New topic comment', 0),
(0, 2824, 'Topic', 0),
(1, 2824, 'Topic', 0),
(0, 2825, 'People who liked', 0),
(1, 2825, 'People who liked', 0),
(0, 2827, 'Recent', 0),
(1, 2827, 'Recent', 0),
(0, 2828, 'Popularity', 0),
(1, 2828, 'Popularity', 0),
(0, 2829, 'Unfollow', 0),
(1, 2829, 'Unfollow', 0),
(0, 2830, 'Follow', 0),
(1, 2830, 'Follow', 0),
(0, 2831, 'Required to add forum category', 0),
(1, 2831, 'Required to add forum category', 0),
(0, 2832, 'Required to add forum', 0),
(1, 2832, 'Required to add forum', 0),
(0, 2833, 'Mark as sticky', 0),
(1, 2833, 'Mark as sticky', 0),
(0, 2834, 'Post topic', 0),
(1, 2834, 'Post topic', 0),
(0, 2835, 'Un-answered', 0),
(1, 2835, 'Un-answered', 0),
(0, 2836, 'Show modified topic up', 0),
(1, 2836, 'Show modified topic up', 0),
(0, 2837, 'Schedule ticket', 0),
(1, 2837, 'Schedule ticket', 0),
(0, 2838, 'Schedule date', 0),
(1, 2838, 'Schedule date', 0),
(0, 2839, 'Requires at least one day', 0),
(1, 2839, 'Requires at least one day', 0),
(0, 2840, 'Schedule date must be greater than current date', 0),
(1, 2840, 'Schedule date must be greater than current date', 0),
(0, 2841, 'End date must be greater than schedule date', 0),
(1, 2841, 'End date must be greater than schedule date', 0),
(0, 2842, 'Repeat schedule', 0),
(1, 2842, 'Repeat schedule', 0),
(0, 2843, 'New scheduled ticket created', 0),
(1, 2843, 'New scheduled ticket created', 0),
(0, 2844, 'Verify email', 0),
(1, 2844, 'Verify email', 0),
(0, 2845, 'Search result', 0),
(1, 2845, 'Search result', 0),
(0, 2846, 'Recent', 0),
(1, 2846, 'Recent', 0),
(0, 2847, 'Popular', 0),
(1, 2847, 'Popular', 0),
(0, 2848, 'Un-answered', 0),
(1, 2848, 'Un-answered', 0),
(0, 2849, 'Ticket category', 0),
(1, 2849, 'Ticket category', 0),
(0, 2850, 'Add ticket category', 0),
(1, 2850, 'Add ticket category', 0),
(0, 2851, 'Delete ticket category', 0),
(1, 2851, 'Delete ticket category', 0),
(0, 2852, 'Deleting ticket category will also delete its subcategory and items', 0),
(1, 2852, 'Deleting ticket category will also delete its subcategory and items', 0),
(0, 2853, 'Update ticket category', 0),
(1, 2853, 'Update ticket category', 0),
(0, 2854, 'Required field assign to staff', 0),
(1, 2854, 'Required field assign to staff', 0),
(0, 2855, 'Subcategory', 0),
(1, 2855, 'Subcategory', 0),
(0, 2856, 'Add subcategory', 0),
(1, 2856, 'Add subcategory', 0),
(0, 2857, 'Update subcategory', 0),
(1, 2857, 'Update subcategory', 0),
(0, 2858, 'Delete subcategory', 0),
(1, 2858, 'Delete subcategory', 0),
(0, 2859, 'Deleting subcategory will also delete its items', 0),
(1, 2859, 'Deleting subcategory will also delete its items', 0),
(0, 2860, 'Item', 0),
(1, 2860, 'Item', 0),
(0, 2861, 'Add ticket item', 0),
(1, 2861, 'Add ticket item', 0),
(0, 2862, 'Delete item', 0),
(1, 2862, 'Delete item', 0),
(0, 2863, 'Update item', 0),
(1, 2863, 'Update item', 0),
(0, 2864, 'Deleting item', 0),
(1, 2864, 'Deleting item', 0),
(0, 2865, 'Level', 0),
(1, 2865, 'Level', 0),
(0, 2866, 'Add level', 0),
(1, 2866, 'Add level', 0),
(0, 2867, 'Delete level', 0),
(1, 2867, 'Delete level', 0),
(0, 2868, 'Update level', 0),
(1, 2868, 'Update level', 0),
(0, 2869, 'Deleting level', 0),
(1, 2869, 'Deleting level', 0),
(0, 2870, 'Please enable ticket category from ticket module to access category.<br/> Setting > module > ticket > Ticket category', 0),
(1, 2870, 'Please enable ticket category from ticket module to access category.<br/> Setting > module > ticket > Ticket category', 0),
(0, 2871, 'Please enable ticket level from ticket module to access level.<br/> Setting > module > ticket > Ticket level', 0),
(1, 2871, 'Please enable ticket level from ticket module to access level.<br/> Setting > module > ticket > Ticket level', 0),
(0, 2872, 'Suggest search', 0),
(1, 2872, 'Suggest search', 0),
(0, 2873, 'Location', 0),
(1, 2873, 'Location', 0),
(0, 2874, 'Most commented', 0),
(1, 2874, 'Most commented', 0),
(0, 2875, 'Bcc', 0),
(1, 2875, 'Bcc', 0),
(0, 2876, 'Change category', 0),
(1, 2876, 'Change category', 0),
(0, 2877, 'Change subcategory', 0),
(1, 2877, 'Change subcategory', 0),
(0, 2878, 'Change item', 0),
(1, 2878, 'Change item', 0),
(0, 2879, 'Change level', 0),
(1, 2879, 'Change level', 0),
(0, 2880, 'Change location', 0),
(1, 2880, 'Change location', 0),
(0, 2881, 'Select', 0),
(1, 2881, 'Select', 0),
(0, 2882, 'Ticket category', 0),
(1, 2882, 'Ticket category', 0),
(0, 2883, 'Subcategory', 0),
(1, 2883, 'Subcategory', 0),
(0, 2884, 'Item', 0),
(1, 2884, 'Item', 0),
(0, 2885, 'Level', 0),
(1, 2885, 'Level', 0),
(0, 2886, 'Category', 0),
(1, 2886, 'Category', 0),
(0, 2887, 'Manage portal and client portal', 0),
(1, 2887, 'Manage portal and client portal', 0),
(0, 2888, 'Display subcategory', 0),
(1, 2888, 'Display subcategory', 0),
(0, 2889, 'Display item', 0),
(1, 2889, 'Display item', 0),
(0, 2890, 'Ticket level changed', 0),
(1, 2890, 'Ticket level changed', 0),
(0, 2891, 'Ticket category changed', 0),
(1, 2891, 'Ticket category changed', 0),
(0, 2892, 'Ticket subcategory changed', 0),
(1, 2892, 'Ticket subcategory changed', 0),
(0, 2893, 'Ticket item changed', 0),
(1, 2893, 'Ticket item changed', 0),
(0, 2894, 'Location changed', 0),
(1, 2894, 'Location changed', 0),
(0, 2895, 'This comment is waiting for approval.', 0),
(1, 2895, 'This comment is waiting for approval.', 0),
(0, 2896, 'Recurrence', 0),
(1, 2896, 'Recurrence', 0),
(0, 2897, 'Category change', 0),
(1, 2897, 'Category change', 0),
(0, 2898, 'Subcategory change', 0),
(1, 2898, 'Subcategory change', 0),
(0, 2899, 'Item change', 0),
(1, 2899, 'Item change', 0),
(0, 2900, 'Level change', 0),
(1, 2900, 'Level change', 0),
(0, 2901, 'Location change', 0),
(1, 2901, 'Location change', 0),
(0, 2902, 'Ticket schedule', 0),
(1, 2902, 'Ticket schedule', 0),
(0, 2903, 'Forum signature', 0),
(1, 2903, 'Forum signature', 0),
(0, 2904, 'Domain not found', 0),
(1, 2904, 'Domain not found', 0),
(0, 2905, 'Forum activity', 0),
(1, 2905, 'Forum activity', 0),
(0, 2906, 'Approved topics', 0),
(1, 2906, 'Approved topics', 0),
(0, 2907, 'Followed topics', 0),
(1, 2907, 'Followed topics', 0),
(0, 2908, 'Forum signature', 0),
(1, 2908, 'Forum signature', 0),
(0, 2909, 'Ok', 0),
(1, 2909, 'Ok', 0),
(0, 2910, 'Forum comment notification', 0),
(1, 2910, 'Forum comment notification', 0),
(0, 2911, 'Pending topics', 0),
(1, 2911, 'Pending topics', 0),
(0, 2912, 'Auto approve comments', 0),
(1, 2912, 'Auto approve comments', 0),
(0, 2913, 'Default page after login', 0),
(1, 2913, 'Default page after login', 0),
(0, 2914, 'Default page before login', 0),
(1, 2914, 'Default page before login', 0),
(0, 2915, 'User type', 0),
(1, 2915, 'User type', 0),
(0, 2916, 'Forum', 0),
(1, 2916, 'Forum', 0),
(0, 2917, 'Previous', 0),
(1, 2917, 'Previous', 0),
(0, 2918, 'Your comment is awaiting moderation.', 0),
(1, 2918, 'Your comment is awaiting moderation.', 0),
(0, 2919, 'Your topic is awaiting moderation', 0),
(1, 2919, 'Your topic is awaiting moderation', 0),
(0, 2920, 'Repeat', 0),
(1, 2920, 'Repeat', 0),
(0, 2921, 'occurance(s) left', 0),
(1, 2921, 'occurance(s) left', 0),
(0, 2922, 'Queue outgoing emails for delivery', 0),
(1, 2922, 'Queue outgoing emails for delivery', 0),
(0, 2923, 'No link ticket found', 0),
(1, 2923, 'No link ticket found', 0),
(0, 2924, 'Language translation for custom fields', 0),
(1, 2924, 'Language translation for custom fields', 0),
(0, 2925, 'Language translation for custom field group', 0),
(1, 2925, 'Language translation for custom field group', 0),
(0, 2926, 'Pause SLA', 0),
(1, 2926, 'Pause SLA', 0),
(0, 2927, 'Resume SLA', 0),
(1, 2927, 'Resume SLA', 0),
(0, 2928, 'SLA paused', 0),
(1, 2928, 'SLA paused', 0),
(0, 2929, 'SLA resumed', 0),
(1, 2929, 'SLA resumed', 0),
(0, 2930, 'Pause / Resume SLA', 0),
(1, 2930, 'Pause / Resume SLA', 0),
(0, 2931, 'with', 0),
(1, 2931, 'with', 0),
(0, 2932, 'Type here', 0),
(1, 2932, 'Type here', 0),
(0, 2933, 'Related solutions', 0),
(1, 2933, 'Related solutions', 0),
(0, 2934, 'Keywords', 0),
(1, 2934, 'Keywords', 0),
(0, 2935, 'destination', 0),
(1, 2935, 'destination', 0),
(0, 2936, 'Issue id', 0),
(1, 2936, 'Issue id', 0),	
(0, 2937, 'Redmine', 0),
(1, 2937, 'Redmine', 0),	
(0, 2938, 'Redmine URL', 0),
(1, 2938, 'Redmine URL', 0),		
(0, 2939, 'Create issue with redmine', 0),
(1, 2939, 'Create issue with redmine', 0),	
(0, 2940, 'Tracker', 0),
(1, 2940, 'Tracker', 0),	
(0, 2941, 'Issue', 0),
(1, 2941, 'Issue', 0),	
(0, 2942, 'Project name', 0),
(1, 2942, 'Project name', 0),	
(0, 2943, 'Issue linked successfully', 0),
(1, 2943, 'Issue linked successfully', 0),	
(0, 2944, 'Select project', 0),
(1, 2944, 'Select project', 0),	
(0, 2945, 'Select issue', 0),
(1, 2945, 'Select issue', 0),	
(0, 2946, 'Select tracker', 0),
(1, 2946, 'Select tracker', 0),
(0, 2947, 'View issue in redmine', 0),
(1, 2947, 'View issue in redmine', 0),
(0, 2948, 'Enabled', 0),
(1, 2948, 'Enabled', 0),
(0, 2949, 'Disabled', 0),
(1, 2949, 'Disabled', 0),
(0, 2950, 'Auto generate organization', 0),
(1, 2950, 'Auto generate organization', 0),
(0, 2951, 'Ignore organization (use comma to add multiple organization )', 0),
(1, 2951, 'Ignore organization (use comma to add multiple organization )', 0),
(0, 2952, 'Append ticket post', 0),
(1, 2952, 'Append ticket post', 0),
(0, 2953, 'Visible to left panel', 0),
(1, 2953, 'Visible to left panel', 0),
(0, 2954, 'Default', 0),
(1, 2954, 'Default', 0),	
(0, 2955, 'Both ticket creation', 0),
(1, 2955, 'Both ticket creation', 0),
(0, 2956, 'Show online staff', 0),
(1, 2956, 'Show online staff', 0),
(0, 2957, 'Based on ticket hash in subject line', 0),
(1, 2957, 'Based on ticket hash in subject line', 0),
(0, 2958, 'Based on ticket subject', 0),
(1, 2958, 'Based on ticket subject', 0),
(0, 2959, 'Additional emails', 0),
(1, 2959, 'Additional emails', 0),
(0, 2960, 'Additional emails', 0),
(1, 2960, 'Additional emails', 0),
(0, 2961, 'Field can not be blank', 0),
(1, 2961, 'Field can not be blank', 0),
(0, 2962, 'Field can not be blank', 0),
(1, 2962, 'Field can not be blank', 0),
(0, 2963, 'Email already exists', 0),
(1, 2963, 'Email already exists', 0),
(0, 2964, 'Email already exists', 0),
(1, 2964, 'Email already exists', 0),
(0, 2965, 'Fax', 0),
(1, 2965, 'Fax', 0),
(0, 2966, 'Mobile number', 0),
(1, 2966, 'Mobile number', 0),
(0, 2967, 'template', 0),
(1, 2967, 'template', 0),
(0, 2968, 'On last activity', 0),
(1, 2968, 'On last activity', 0),
(0, 2969, 'SLA state', 0),
(1, 2969, 'SLA state', 0),
(1, 2970, 'Favicon', 0),
(0, 2970, 'Favicon', 0),
(1, 2971, 'Invalid characters', 0),
(0, 2971, 'Invalid characters', 0),
(1, 2972, 'Resend', 0),
(0, 2972, 'Resend', 0),
(1, 2973, 'Resend', 0),
(0, 2973, 'Resend', 0),
(1, 2974, 'Task list count', 0),
(0, 2974, 'Task list count', 0),
(1, 2975, 'Display amount on time track', 0),
(0, 2975, 'Display amount on time track', 0),
(1, 2976, 'Numeric value required for minutes field', 0),
(0, 2976, 'Numeric value required for minutes field', 0),
(1, 2977, 'Help', 0),
(0, 2977, 'Help', 0),
(1, 2978, 'Manager', 0),
(0, 2978, 'Manager', 0),
(0, 2979, 'Advanced search', 0),
(1, 2979, 'Advanced search', 0),
(0, 2980, 'Flag', 0),
(1, 2980, 'Flag', 0),
(0, 2981, 'Owner', 0),
(1, 2981, 'Owner', 0),
(0, 2982, 'Report', 0),
(1, 2982, 'Report', 0),
(0, 2983, 'Ticket by status', 0),
(1, 2983, 'Ticket by status', 0),
(0, 2984, 'Tickets by priority', 0),
(1, 2984, 'Tickets by priority', 0),
(0, 2985, 'Ticket by type', 0),
(1, 2985, 'Ticket by type', 0),	
(0, 2986, 'Ticket by owner', 0),
(1, 2986, 'Ticket by owner', 0),	
(0, 2987, 'Select duration', 0),
(1, 2987, 'Select duration', 0),
(0, 2988, 'Last 30 days', 0),
(1, 2988, 'Last 30 days', 0),
(0, 2989, 'Last 7 days', 0),
(1, 2989, 'Last 7 days', 0),
(0, 2990, 'Last 24 hours', 0),
(1, 2990, 'Last 24 hours', 0),
(0, 2991, 'Form', 0),
(1, 2991, 'Form', 0),
(0, 2992, 'To', 0),
(1, 2992, 'To', 0),
(0, 2993, 'Status', 0),
(1, 2993, 'Status', 0),
(0, 2994, 'Priority', 0),
(1, 2994, 'Priority', 0),
(0, 2995, 'Type', 0),
(1, 2995, 'Type', 0),
(0, 2996, 'Owner', 0),
(1, 2996, 'Owner', 0),
(0, 2997, 'Please select status', 0),
(1, 2997, 'Please select status', 0),
(0, 2998, 'Please select duration', 0),
(1, 2998, 'Please select duration', 0),
(0, 2999, 'Please select date', 0),
(1, 2999, 'Please select date', 0),
(0, 3000, 'Please select priority', 0),
(1, 3000, 'Please select priority', 0),
(0, 3001, 'Please select owner', 0),
(1, 3001, 'Please select owner', 0),
(1, 3002, 'Please select type', 0),
(0, 3002, 'Please select type', 0),
(1, 3003, 'Ticket by organization', 0),
(0, 3003, 'Ticket by organization', 0),
(1, 3004, 'Ticket by client', 0),
(0, 3004, 'Ticket by client', 0),
(1, 3005, 'Please select client', 0),
(0, 3005, 'Please select client', 0),
(1, 3006, 'view result', 0),
(0, 3006, 'view result', 0),
(1, 3007, 'Generate', 0),
(0, 3007, 'Generate', 0),
(1, 3008, 'Custom', 0),
(0, 3008, 'Custom', 0),
(0, 3009, 'Exotel', 0),
(1, 3009, 'Exotel', 0),		
(0, 3010, 'Exotel apps', 0),
(1, 3010, 'Exotel apps', 0),		
(0, 3011, 'Exo phones', 0),
(1, 3011, 'Exo phones', 0),		
(0, 3012, 'Delete exotel', 0),
(1, 3012, 'Delete exotel', 0),	
(0, 3013, 'Update exotel app', 0),
(1, 3013, 'Update exotel app', 0),	
(0, 3014, 'Exo-phone', 0),
(1, 3014, 'Exo-phone', 0),	
(0, 3015, 'Exophone required', 0),
(1, 3015, 'Exophone required', 0),	
(0, 3016, 'Add exotel app', 0),
(1, 3016, 'Add exotel app', 0),		
(0, 3017, 'Connect customer to agent', 0),
(1, 3017, 'Connect customer to agent', 0),		
(0, 3018, 'Connect customer to flow', 0),
(1, 3018, 'Connect customer to flow', 0),		
(0, 3019, 'Send bulk sms', 0),
(1, 3019, 'Send bulk sms', 0),	
(0, 3020, 'Time limit', 0),
(1, 3020, 'Time limit', 0),
(0, 3021, 'Time out', 0),
(1, 3021, 'Time out', 0),	
(0, 3022, 'Optional', 0),
(1, 3022, 'Optional', 0),	
(0, 3023, 'Caller-id', 0),
(1, 3023, 'Caller-id', 0),	
(0, 3024, 'Call type', 0),
(1, 3024, 'Call type', 0),	
(0, 3025, 'Trans', 0),
(1, 3025, 'Trans', 0),	
(0, 3026, 'Promo', 0),
(1, 3026, 'Promo', 0),		
(0, 3027, 'Connect', 0),
(1, 3027, 'Connect', 0),		
(0, 3028, 'Select app', 0),
(1, 3028, 'Select app', 0),		
(0, 3029, 'Select caller-id', 0),
(1, 3029, 'Select caller-id', 0),	
(0, 3030, 'Enter from number', 0),
(1, 3030, 'Enter from number', 0),	
(0, 3031, 'Enter to number', 0),
(1, 3031, 'Enter to number', 0),		
(0, 3032, 'Body', 0),
(1, 3032, 'Body', 0),	
(0, 3033, 'Send sms', 0),
(1, 3033, 'Send sms', 0),	
(0, 3034, 'Enter body', 0),
(1, 3034, 'Enter body', 0),		
(0, 3035, 'Auto tickete creation', 0),
(1, 3035, 'Auto tickete creation', 0),		
(0, 3036, 'From', 0),
(1, 3036, 'From', 0),		
(0, 3037, 'Start date', 0),
(1, 3037, 'Start date', 0),		
(0, 3038, 'End date', 0),
(1, 3038, 'End date', 0),	
(0, 3039, 'Duration', 0),	
(1, 3039, 'Duration', 0),	
(0, 3040, 'Price', 0),
(1, 3040, 'Price', 0),	
(0, 3041, 'Direction', 0),
(1, 3041, 'Direction', 0),	
(0, 3042, 'Sent date', 0),
(1, 3042, 'Sent date', 0),	
(0, 3043, 'Msg body', 0),
(1, 3043, 'Msg body', 0),	
(0, 3044, 'SMS details', 0),
(1, 3044, 'SMS details', 0),	
(0, 3045, 'Outward-call', 0),
(1, 3045, 'Outward-call', 0),	
(0, 3046, 'Inward-call', 0),
(1, 3046, 'Inward-call', 0),	
(0, 3047, 'Outward-msg', 0),
(1, 3047, 'Outward-msg', 0),	
(0, 3048, 'Inward-msg', 0),
(1, 3048, 'Inward-msg', 0),
(0, 3049, 'Order report', 0),
(1, 3049, 'Order report', 0),
(0, 3050, 'Billing status', 0),
(1, 3050, 'Billing status', 0),
(0, 3051, 'Select status', 0),
(1, 3051, 'Select status', 0),
(0, 3052, 'Total invoices', 0),
(1, 3052, 'Total invoices', 0),
(0, 3053, 'Total paid', 0),
(1, 3053, 'Total paid', 0),
(0, 3054, 'Reference ticket', 0),
(1, 3054, 'Reference ticket', 0),
(0, 3055, 'Select', 0),
(1, 3055, 'Select', 0),
(0, 3056, 'Staff bonus point report', 0),
(1, 3056, 'Staff bonus point report', 0),
(0, 3057, 'Staff point report', 0),
(1, 3057, 'Staff point report', 0),
(0, 3058, 'Client transaction report', 0),
(1, 3058, 'Client transaction report', 0),
(0, 3059, 'Client wise order report', 0),
(1, 3059, 'Client wise order report', 0),
(0, 3060, 'Transaction report', 0),
(1, 3060, 'Transaction report', 0),
(0, 3061, 'View issue in redmine', 0),
(1, 3061, 'View issue in redmine', 0),
(0, 3062, 'First response time', 0),
(1, 3062, 'First response time', 0),
(0, 3063, 'Invoice report', 0),
(1, 3063, 'Invoice report', 0),
(0, 3064, 'Transaction report', 0),
(1, 3064, 'Transaction report', 0),
(0, 3065, 'Total ticket', 0),
(1, 3065, 'Total ticket', 0),
(0, 3066, 'Total open', 0),
(1, 3066, 'Total open', 0),
(0, 3067, 'Total close', 0),
(1, 3067, 'Total close', 0),
(0, 3068, 'Total in progress', 0),
(1, 3068, 'Total in progress', 0),
(0, 3069, 'Department name', 0),
(1, 3069, 'Department name', 0),
(0, 3070, 'Other than open and close', 0),
(1, 3070, 'Other than open and close', 0),
(0, 3071, 'Update custom report', 0),
(1, 3071, 'Update custom report', 0),
(0, 3072, 'Create custom report', 0),
(1, 3072, 'Create custom report', 0),
(0, 3073, 'View custom report', 0),
(1, 3073, 'View custom report', 0),
(0, 3074, 'Total response time', 0),
(1, 3074, 'Total response time', 0),
(0, 3075, 'Paid status', 0),
(1, 3075, 'Paid status', 0),
(0, 3076, 'Reference ticket', 0),
(1, 3076, 'Reference ticket', 0),
(0, 3077, 'Order id', 0),
(1, 3077, 'Order id', 0),
(0, 3078, 'Duration point', 0),
(1, 3078, 'Duration point', 0),
(0, 3079, 'Generate', 0),
(1, 3079, 'Generate', 0),
(0, 3080, 'Tickets grouped by channel', 0),
(1, 3080, 'Tickets grouped by channel', 0),
(0, 3081, 'Tickets deleted', 0),
(1, 3081, 'Tickets deleted', 0),
(0, 3082, 'Deleted date', 0),
(1, 3082, 'Deleted date', 0),
(0, 3083, 'Merged date', 0),
(1, 3083, 'Merged date', 0),
(0, 3084, 'Merged tickets', 0),
(1, 3084, 'Merged tickets', 0),
(0, 3085, 'Channel name', 0),
(1, 3085, 'Channel name', 0),
(0, 3086, 'Total number of tickets', 0),
(1, 3086, 'Total number of tickets', 0),
(0, 3087, 'Resolved date', 0),
(1, 3087, 'Resolved date', 0),
(0, 3088, 'Problems solved per staff', 0),
(1, 3088, 'Problems solved per staff', 0),
(0, 3089, 'Problem from', 0),
(1, 3089, 'Problem from', 0),
(0, 3090, 'Custom field report for user ticket creation', 0),
(1, 3090, 'Custom field report for user ticket creation', 0),
(0, 3091, 'Field value', 0),
(1, 3091, 'Field value', 0),
(0, 3092, 'Custom field report for user registration', 0),
(1, 3092, 'Custom field report for user registration', 0),
(0, 3093, 'Reply date', 0),
(1, 3093, 'Reply date', 0),
(0, 3094, 'First response time', 0),
(1, 3094, 'First response time', 0),
(0, 3095, 'Total point', 0),
(1, 3095, 'Total point', 0),
(0, 3096, 'Current rank', 0),
(1, 3096, 'Current rank', 0),
(0, 3097, 'Total unanswered tickets', 0),
(1, 3097, 'Total unanswered tickets', 0),
(0, 3098, 'Ticket escalation group by staff owner', 0),
(1, 3098, 'Ticket escalation group by staff owner', 0),
(0, 3099, 'Ticket escalation group by department', 0),
(1, 3099, 'Ticket escalation group by department', 0),
(0, 3100, 'Next assigned', 0),
(1, 3100, 'Next assigned', 0),
(0, 3101, 'Export type', 0),
(1, 3101, 'Export type', 0),
(0, 3102, 'Schedule report', 0),
(1, 3102, 'Schedule report', 0),
(0, 3103, 'Schedule type', 0),
(1, 3103, 'Schedule type', 0),	
(0, 3104, 'Parent client should receive a copy of emails submitted by this contact', 0),
(1, 3104, 'Parent client should receive a copy of emails submitted by this contact', 0),	
(0, 3105, 'Receive a copy of emails submitted by parent client and other contacts', 0),
(1, 3105, 'Receive a copy of emails submitted by parent client and other contacts', 0),	
(0, 3106, 'Parent client should receive a copy of emails submitted by this contact', 0),
(1, 3106, 'Parent client should receive a copy of emails submitted by this contact', 0),	
(0, 3107, 'Receive a copy of emails submitted by parent client and other contacts', 0),
(1, 3107, 'Receive a copy of emails submitted by parent client and other contacts', 0),
(0, 3108, 'Department performance', 0),
(1, 3108, 'Department performance', 0),
(0, 3109, 'Total tickets resolved', 0),
(1, 3109, 'Total tickets resolved', 0),
(0, 3110, 'Login activity', 0),
(1, 3110, 'Login activity', 0),
(0, 3111, 'Staff activities', 0),
(1, 3111, 'Staff activities', 0),
(0, 3112, 'Staff activity tracking', 0),
(1, 3112, 'Staff activity tracking', 0),
(0, 3113, 'Average response time group by staff', 0),
(1, 3113, 'Average response time group by staff', 0),
(0, 3114, 'Last replier time', 0),
(1, 3114, 'Last replier time', 0),
(0, 3115, 'Create new', 0),
(1, 3115, 'Create new', 0),
(0, 3116, 'Custom reports', 0),
(1, 3116, 'Custom reports', 0),
(0, 3117, 'Display count', 0),
(1, 3117, 'Display count', 0),
(0, 3118, 'CMDB created',0),
(1, 3118, 'CMDB created',0),
(0, 3119, 'Department set to',0),
(1, 3119, 'Department set to',0),
(0, 3120, 'CI type set to',0),
(1, 3120, 'CI type set to',0),
(0, 3121, 'Impact set to',0),
(1, 3121, 'Impact set to',0),
(0, 3122, 'Location set to',0),
(1, 3122, 'Location set to',0),
(0, 3123, 'set to',0),
(1, 3123, 'set to',0),
(0, 3124, 'CMDB updated',0),
(1, 3124, 'CMDB updated',0),
(0, 3125, 'Updated to',0),
(1, 3125, 'Updated to',0),
(0, 3126, 'Client with maximum ticket',0),
	(1, 3126, 'Client with maximum ticket',0),
	(0, 3127, 'Top',0),
	(1, 3127, 'Top',0),
	(0, 3128, '10',0),
	(1, 3128, '10',0),
	(0, 3129, '20',0),
	(1, 3129, '20',0),
	(0, 3130, '50',0),
	(1, 3130, '50',0),
	(0, 3131, '100',0),
	(1, 3131, '100',0),
	(0, 3132, 'Client with max ticket reply',0),
	(1, 3132, 'Client with max ticket reply',0),
	(0, 3133, 'Domain ticket overview',0),
	(1, 3133, 'Domain ticket overview',0),
	(0, 3134, 'Staff quest performer',0),
	(1, 3134, 'Staff quest performer',0),
	(0, 3135, 'Capsule CRM',0),
	(1, 3135, 'Capsule CRM',0),
	(0, 3136, 'Capsule CRM URL',0),
	(1, 3136, 'Capsule CRM URL',0),
	(0, 3137, 'Update capsule CRM',0),
	(1, 3137, 'Update capsule CRM',0),
	(0, 3138, 'Add capsule CRM',0),
	(1, 3138, 'Add capsule CRM',0),
	(0, 3139, 'Forum',0),
	(1, 3139, 'Forum',0),
	(0, 3140, 'Submit a ticket',0),
	(1, 3140, 'Submit a ticket',0),
	(0, 3141, 'Can\'t find what you\'re looking for? Let us help you',0),
	(1, 3141, 'Can\'t find what you\'re looking for? Let us help you',0),
	(0, 3142, 'Hipchat', 0),
	(1, 3142, 'Hipchat', 0),
	(0, 3143, 'Hipchat alert', 0),
	(1, 3143, 'Hipchat alert', 0),
	(0, 3144, 'Delete hipchat', 0),
	(1, 3144, 'Delete hipchat', 0),
	(0, 3145, 'Slack', 0),
	(1, 3145, 'Slack', 0),
	(0, 3146, 'Slack alert', 0),
	(1, 3146, 'Slack alert', 0),
	(0, 3147, 'Delete Slack', 0),
	(1, 3147, 'Delete Slack', 0),
	(0, 3148, 'Require field contact number', 0),
	(1, 3148, 'Require field contact number', 0),
	(0, 3149, 'Match found', 0),
	(1, 3149, 'Match found', 0),
 (0, 3150, 'Contact number already exists', 0),
	(1, 3150, 'Contact number already exists', 0),
	(0, 3151, 'Total client', 0),
	(1, 3151, 'Total client', 0),
	(0, 3152, 'Organization ID missing', 0),
	(1, 3152, 'Organization ID missing', 0),
	(0, 3153, 'Cases', 0),
	(1, 3153, 'Cases', 0),
	(0, 3154, 'Most commented article', 0),
	(1, 3154, 'Most commented article', 0),
	(0, 3155, 'Most viewed articles', 0),
	(1, 3155, 'Most viewed articles', 0),
	(0, 3156, 'Most rated articles', 0),
	(1, 3156, 'Most rated articles', 0),
	(0, 3157, 'Forms', 0),
	(1, 3157, 'Forms', 0),	
	(0, 3158, 'Add form', 0),
	(1, 3158, 'Add form', 0),	
	(0, 3159, 'Form name', 0),
	(1, 3159, 'Form name', 0),	
	(0, 3160, 'Required field title', 0),
	(1, 3160, 'Required field title', 0),	
	(0, 3161, 'Delete form group', 0),
	(1, 3161, 'Delete form group', 0),	
	(0, 3162, 'Deletion of form group will delete form fields in this form group', 0),
	(1, 3162, 'Deletion of form group will delete form fields in this form group', 0),	
	(0, 3163, 'Update form group', 0),
	(1, 3163, 'Update form group', 0),	
	(0, 3164, 'Form fields', 0),
	(1, 3164, 'Form fields', 0),	
	(0, 3165, 'Add form field', 0),
	(1, 3165, 'Add form field', 0),	
	(0, 3166, 'Delete form field', 0),
	(1, 3166, 'Delete form field', 0),	
	(0, 3167, 'Placeholder', 0),
	(1, 3167, 'Placeholder', 0),	
	(0, 3168, 'Tooltip', 0),
	(1, 3168, 'Tooltip', 0),	
	(0, 3169, 'Image', 0),
	(1, 3169, 'Image', 0),	
	(0, 3170, 'Text', 0),
	(1, 3170, 'Text', 0),	
	(0, 3171, 'Video/Audio/Octet-stream', 0),
	(1, 3171, 'Video/Audio/Octet-stream', 0),	
	(0, 3172, 'Html attribute', 0),
	(1, 3172, 'Html attribute', 0),	
	(0, 3173, 'Display title', 0),
	(1, 3173, 'Display title', 0),	
	(0, 3174, 'Form type', 0),
	(1, 3174, 'Form type', 0),	
	(0, 3175, 'Email base', 0),
	(1, 3175, 'Email base', 0),	
	(0, 3176, 'Call base', 0),
	(1, 3176, 'Call base', 0),	
	(0, 3177, 'Note: For email based form, three fields will be auto added to form (First Name, Last Name and Email)', 0),
	(1, 3177, 'Note: For email based form, three fields will be auto added to form (First Name, Last Name and Email)', 0),	
	(0, 3178, 'Note: For call based form, three fields will be auto added to form (First Name, Last Name and Contact number)', 0),
	(1, 3178, 'Note: For call based form, three fields will be auto added to form (First Name, Last Name and Contact number)', 0),	
	(0, 3179, 'Required field subject', 0),
	(1, 3179, 'Required field subject', 0),	
	(0, 3180, 'Enable captcha', 0),
	(1, 3180, 'Enable captcha', 0),	
	(0, 3181, 'Form URL', 0),
	(1, 3181, 'Form URL', 0),	
	(0, 3182, 'Iframe URL', 0),
	(1, 3182, 'Iframe URL', 0),	
	(0, 3183, 'Display in line', 0),
	(1, 3183, 'Display in line', 0),	
	(0, 3184, 'Is editor', 0),
	(1, 3184, 'Is editor', 0),	
	(0, 3185, 'No of attachments', 0),
	(1, 3185, 'No of attachments', 0),	
	(0, 3186, 'Form name', 0),
	(1, 3186, 'Form name', 0),	
	(0, 3187, 'Thank you ...!', 0),
	(1, 3187, 'Thank you ...!', 0),	
	(0, 3188, 'invalid email', 0),
	(1, 3188, 'invalid email', 0),	
	(0, 3189, 'enter only numeric characters', 0),
	(1, 3189, 'enter only numeric characters', 0),	
	(0, 3190, 'enter only alphabetics', 0),
	(1, 3190, 'enter only alphabetics', 0),	
	(0, 3191, 'enter only alphanumeric characters', 0),
	(1, 3191, 'enter only alphanumeric characters', 0),	
	(0, 3192, 'Form name', 0),
	(1, 3192, 'Form name', 0),	
	(0, 3193, 'Form builder', 0),
	(1, 3193, 'Form builder', 0),	
	(0, 3194, 'Edit form field', 0),
	(1, 3194, 'Edit form field', 0),	
	(0, 3195, 'Update form field', 0),
	(1, 3195, 'Update form field', 0),
	(0, 3196, 'Mail queue not exist', 0),
	(1, 3196, 'Mail queue not exist', 0),
	(0, 3197, 'Client email not verified ', 0),
	(1, 3197, 'Client email not verified ', 0),
	(0, 3198, 'Contact access', 0),
	(1, 3198, 'Contact access', 0),
	(0, 3199, 'Client registration error', 0),
	(1, 3199, 'Client registration error', 0),
	(0, 3200, 'Ticket creation error', 0),
	(1, 3200, 'Ticket creation error', 0),
	(0, 3201, 'Contact number missing', 0),
	(1, 3201, 'Contact number missing', 0),
	(0, 3202, 'Form not available..!', 0),
	(1, 3202, 'Form not available..!', 0),
	(0, 3203, 'Problems group by status', 0),
	(1, 3203, 'Problems group by status', 0),
	(0, 3204, 'Problems group by priority', 0),
	(1, 3204, 'Problems group by priority', 0),
	(0, 3205, 'Problems group by impact', 0),
	(1, 3205, 'Problems group by impact', 0),
	(0, 3206, 'Invoice hash', 0),
	(1, 3206, 'Invoice hash', 0),
	(0, 3207, 'Order hash', 0),
	(1, 3207, 'Order hash', 0),
	(0, 3208, 'Redirect to ticket listing on reply', 0),
	(1, 3208, 'Redirect to ticket listing on reply', 0),
	(0, 3209, 'Client missing or invalid client for merge', 0),
	(1, 3209, 'Client missing or invalid client for merge', 0),
	(0, 3210, 'Fields marked with <span class=\"vh-red\">*</span> are mandatory', 0),
 (1, 3210, 'Fields marked with <span class=\"vh-red\">*</span> are mandatory', 0),
	(0, 3211, 'Scheduled report', 0),
	(1, 3211, 'Scheduled report', 0),
	(0, 3212, 'Task email notification', 0),
	(1, 3212, 'Task email notification', 0),
	(0, 3213, 'Not started task', 0),
	(1, 3213, 'Not started task', 0),
	(0, 3214, 'Disable client portal', 0),
	(1, 3214, 'Disable client portal', 0),
	(0, 3215, 'Problems per department', 0),
	(1, 3215, 'Problems per department', 0),
	(0, 3216, 'Changes per department', 0),
	(1, 3216, 'Changes per department', 0),
	(0, 3217, 'Releases per department', 0),
	(1, 3217, 'Releases per department', 0),
	(0, 3218, 'SLA & Escalation', 0),
	(1, 3218, 'SLA & Escalation', 0),
	(0, 3219, 'Rating and survey', 0),
	(1, 3219, 'Rating and survey', 0),
	(0, 3220, 'Staff assigned tasks', 0),
	(1, 3220, 'Staff assigned tasks', 0),
	(0, 3221, 'Overdue task', 0),
	(1, 3221, 'Overdue task', 0),
	(0, 3222, 'Asset name', 0),
	(1, 3222, 'Asset name', 0),
	(0, 3223, 'Assets used by client', 0),
	(1, 3223, 'Assets used by client', 0),
	(0, 3224, 'Assets managed by staff', 0),
	(1, 3224, 'Assets managed by staff', 0),
	(0, 3225, 'Ticket link report', 0),
	(1, 3225, 'Ticket link report', 0),
	(0, 3226, 'Task comment report', 0),
	(1, 3226, 'Task comment report', 0),
	(0, 3227, 'Assets linked to tickets', 0),
	(1, 3227, 'Assets linked to tickets', 0),
	(0, 3228, 'Type to existing ticket hash', 0),
	(1, 3228, 'Type to existing ticket hash', 0),
	(0, 3229, 'Task linked', 0),
	(1, 3229, 'Task linked', 0),
	(0, 3230, 'CI linked', 0),
	(1, 3230, 'CI linked', 0),
	(0, 3231, 'Problem linked', 0),
	(1, 3231, 'Problem linked', 0),
	(0, 3232, 'Change linked', 0),
	(1, 3232, 'change linked', 0),
	(0, 3233, 'Ticket linked', 0),
	(1, 3233, 'Ticket linked', 0),
	(0, 3234, 'Releases linked to changes', 0),
	(1, 3234, 'Releases linked to changes', 0),
	(0, 3235, 'Changes resolved by staff', 0),
	(1, 3235, 'Changes resolved by staff', 0),
	(0, 3236, 'Total replied ticket', 0),
	(1, 3236, 'Total replied ticket', 0),
	(0, 3237, 'Close ticket date', 0),
	(1, 3237, 'Close ticket date', 0),
	(0, 3238, 'Mark read', 0),
	(1, 3238, 'Mark read', 0),
	(0, 3239, 'Mark unread', 0),
	(1, 3239, 'Mark unread', 0),
	(0, 3240, 'Avg response time', 0),
	(1, 3240, 'Avg response time', 0),
 (0, 3241, 'Department wise SLA', 0),
	(1, 3241, 'Department wise SLA', 0),
 (0, 3242, 'Avg. resolution time', 0),
	(1, 3242, 'Avg. resolution time', 0),
	(0, 3243, 'Staff work', 0),
	(1, 3243, 'Staff work', 0),
	(0, 3244, 'Staff avg response time', 0),
	(1, 3244, 'Staff avg response time', 0),
	(0, 3245, 'Quest top performer', 0),
	(1, 3245, 'Quest top performer', 0),
	(0, 3246, 'Billing summary', 0),
	(1, 3246, 'Billing summary', 0),
	(0, 3247, 'Google apps', 0),
	(1, 3247, 'Google apps', 0),
	(0, 3248, 'Google calendar', 0),
	(1, 3248, 'Google calendar', 0),
	(0, 3249, 'Guest email', 0),
	(1, 3249, 'Guest email', 0),
	(0, 3250, 'Events', 0),
	(1, 3250, 'Events', 0),
	(0, 3251, 'Tasks', 0),
	(1, 3251, 'Tasks', 0),
	(0, 3252, 'Add event', 0),
	(1, 3252, 'Add event', 0),
	(0, 3253, 'Add task', 0),
	(1, 3253, 'Add task', 0),
	(0, 3254, 'Event details', 0),
	(1, 3254, 'Event details', 0),
	(0, 3255, 'Task details', 0),
	(1, 3255, 'Task details', 0),
	(0, 3256, 'Calendar list', 0),
	(1, 3256, 'Calendar list', 0),
	(0, 3257, 'Task list', 0),
	(1, 3257, 'Task list', 0),
	(0, 3258, 'Events', 0),
	(1, 3258, 'Events', 0),
	(0, 3259, 'Tickets overview', 0),
	(1, 3259, 'Tickets overview', 0),
	(0, 3260, 'Client overview', 0),
	(1, 3260, 'Client overview', 0),
	(0, 3261, 'Client invoices', 0),
	(1, 3261, 'Client invoices', 0),
	(0, 3262, 'Total unpaid', 0),
	(1, 3262, 'Total unpaid', 0),
	(0, 3263, 'Total cancelled', 0),
	(1, 3263, 'Total cancelled', 0),
	(0, 3264, 'Total in process', 0),
	(1, 3264, 'Total in process', 0),
	(0, 3265, 'Ticket by channel', 0),
	(1, 3265, 'Ticket by channel', 0),
	(0, 3266, 'Queue summary', 0),
	(1, 3266, 'Queue summary', 0),
	(0, 3267, 'Total reports in queue', 0),
	(1, 3267, 'Total reports in queue', 0),
	(0, 3268, 'My reports in queue', 0),
	(1, 3268, 'My reports in queue', 0),
	(0, 3269, 'My completed reports', 0),
	(1, 3269, 'My completed reports', 0),
	(0, 3270, 'reports in queue', 0),
	(1, 3270, 'reports in queue', 0),
	(0, 3271,"Start date not be less than today's date", 0),
	(1, 3271,"Start date not be less than today's date", 0),
	(0, 3272, 'Modified date', 0),
	(1, 3272, 'Modified date', 0),
	(0, 3273, 'View', 0),
	(1, 3273, 'View', 0),
	(0, 3274, 'Staff leaderboard', 0),
	(1, 3274, 'Staff leaderboard', 0),
	(0, 3275, 'Solved tickets', 0),
	(1, 3275, 'Solved tickets', 0),
	(0, 3276, 'avg. First reply time', 0),
	(1, 3276, 'avg. First reply time', 0),
	(0, 3277, 'avg. response time', 0),
	(1, 3277, 'avg. response time', 0),
	(0, 3278, 'avg. sla maintain', 0),
	(1, 3278, 'avg. sla maintain', 0),
	(0, 3279, 'Create filter', 0),
	(1, 3279, 'Create filter', 0),
	(0, 3280, 'Submitted by', 0),
	(1, 3280, 'Submitted by', 0),
	(0, 3281, 'Type to search existing staffs email address', 0),
	(1, 3281, 'Type to search existing staffs email address', 0),
	(0, 3282, 'Resolved by', 0),
	(1, 3282, 'Resolved by', 0),
	(0, 3283, 'Filter', 0),
	(1, 3283, 'Filter', 0),
	(0, 3284, 'Was this article helpful?', 0),
	(1, 3284, 'Was this article helpful?', 0),
	(0, 3285, 'out of', 0),
	(1, 3285, 'out of', 0),
	(0, 3286, 'found this helpful', 0),
	(1, 3286, 'found this helpful', 0),
	(0, 3287, 'Article like', 0),
	(1, 3287, 'Article like', 0),
	(0, 3288, 'Client feedback', 0),
	(1, 3288, 'Client feedback', 0),
	(0, 3289, 'Organization name', 0),
	(1, 3289, 'Organization name', 0),
	(0, 3290, 'Contact number is missing or invalid format',0),
	(1, 3290, 'Contact number is missing or invalid format',0),	
	(0, 3291, 'Account', 0),
	(1, 3291, 'Account', 0),	
	(0, 3292, 'Harvest', 0),
	(1, 3292, 'Harvest', 0),	
	(0, 3293, 'Create invoice with harvest', 0),
	(1, 3293, 'Create invoice with harvest', 0),	
	(0, 3294, 'Issue date', 0),
	(1, 3294, 'Issue date', 0),	
	(0, 3295, 'Balance', 0),
	(1, 3295, 'Balance', 0),
	(0, 3296, 'User', 0),
	(1, 3296, 'User', 0),
	(0, 3297, 'Select top for generate', 0),
	(1, 3297, 'Select top for generate', 0),
	(0, 3298, 'Select all read', 0),
	(1, 3298, 'Select all read', 0),
	(0, 3299, 'Select all unread', 0),
	(1, 3299, 'Select all unread', 0),
	(0, 3300, 'Add new task', 0),
	(1, 3300, 'Add new task', 0),
	(0, 3301, 'file does not exist.', 0),
	(1, 3301, 'file does not exist.', 0),
	(0, 3302, 'Select field for generate', 0),
	(1, 3302, 'Select field for generate', 0),
	(0, 3303, 'Update harvest', 0),
	(1, 3303, 'Update harvest', 0),	
	(0, 3304, 'Delete harvest', 0),
	(1, 3304, 'Delete harvest', 0),
	(0, 3305, 'Add harvest', 0),
	(1, 3305, 'Add harvest', 0),
	(0, 3306, 'Tawk.to', 0),
	(1, 3306, 'Tawk.to', 0),
	(0, 3307, 'Olark', 0),
	(1, 3307, 'Olark', 0),
	(0, 3308, 'Form', 0),
	(1, 3308, 'Form', 0),
	(0, 3309, 'Ticket replied by staff report', 0),
	(1, 3309, 'Ticket replied by staff report', 0),
	(0, 3310, 'Ticket forwarded by staff report', 0),
	(1, 3310, 'Ticket forwarded by staff report', 0),
	(0, 3311, 'Forward count', 0),
	(1, 3311, 'Forward count', 0),
	(0, 3312, 'Add ticket read entry to audit log', 0),
	(1, 3312, 'Add ticket read entry to audit log', 0),
	(0, 3313, 'Ticket read', 0),
	(1, 3313, 'Ticket read', 0),
	(0, 3314, 'Ticket viewed by staff report', 0),
	(1, 3314, 'Ticket viewed by staff report', 0),
	(0, 3315, 'Asset link to problems', 0),
	(1, 3315, 'Asset link to problems', 0),
	(0, 3316, 'Asset group by status', 0),
	(1, 3316, 'Asset group by status', 0),
	(0, 3317, 'Not expired', 0),
	(1, 3317, 'Not expired', 0),
	(0, 3318, 'Expired', 0),
	(1, 3318, 'Expired', 0),
	(0, 3319, 'Asset group by location', 0),
	(1, 3319, 'Asset group by location', 0),
	(0, 3320, 'Crisp', 0),
	(1, 3320, 'Crisp', 0),
	(0, 3321, 'Task by status', 0),
	(1, 3321, 'Task by status', 0),
	(0, 3322, 'Assets by asset Type', 0),
	(1, 3322, 'Assets by asset Type', 0),
	(0, 3323, 'Asset by asset product', 0),
	(1, 3323, 'Asset by asset product', 0),
	(0, 3324, 'Hardware assets by state', 0),
	(1, 3324, 'Hardware assets by state', 0),
	(0, 3325, 'Assets by depreciation', 0),
	(1, 3325, 'Assets by depreciation', 0),
    (0, 3326, 'Intercom', 0),
	(1, 3326, 'Intercom', 0),
	(0, 3327, 'Delete intercom', 0),
	(1, 3327, 'Delete intercom', 0),
	(0, 3328, 'Assets depreciation notification', 0),
	(1, 3328, 'Assets depreciation notification', 0),
	(0, 3329, 'Remaining Warranty', 0),
	(1, 3329, 'Remaining Warranty', 0),
	(0, 3330, 'Ticket load', 0),
	(1, 3330, 'Ticket load', 0),
	(0, 3331, 'Show', 0),
	(1, 3331, 'Show', 0),
	(0, 3332, 'Assigned tickets', 0),
	(1, 3332, 'Assigned tickets', 0),
	(0, 3333, 'Unassigned tickets', 0),
	(1, 3333, 'Unassigned tickets', 0),
	(0, 3334, 'Multiple assigned tickets', 0),
	(1, 3334, 'Multiple assigned tickets', 0),
	(0, 3335, 'Between', 0),
	(1, 3335, 'Between', 0),
	(0, 3336, 'More than', 0),
	(1, 3336, 'More than', 0),
	(0, 3337, 'Select team', 0),
	(1, 3337, 'Select team', 0),
	(0, 3338, 'Send ticket approval', 0),
	(1, 3338, 'Send ticket approval', 0),
	(0, 3339, 'Change ticket approve status', 0),
	(1, 3339, 'Change ticket approve status', 0),
	(0, 3340, 'Send ticket approval reminder', 0),
	(1, 3340, 'Send ticket approval reminder', 0),
	(0, 3341, 'Vtiger', 0),
	(1, 3341, 'Vtiger', 0),	
	(0, 3342, 'Portal url', 0),
	(1, 3342, 'Portal url', 0),	
	(0, 3343, 'Add vtiger', 0),
	(1, 3343, 'Add vtiger', 0),	
	(0, 3344, 'Update vtiger', 0),
	(1, 3344, 'Update vtiger', 0),	
	(0, 3345, 'Delete vtiger', 0),
	(1, 3345, 'Delete vtiger', 0),
	(0, 3346, 'Create contacts in Vtiger', 0),
	(1, 3346, 'Create contacts in Vtiger', 0),
	(0, 3347, 'Vtiger license', 0),
	(1, 3347, 'Vtiger license', 0),
	(0, 3348, 'Open source', 0),
	(1, 3348, 'Open source', 0),
	(0, 3349, 'Cloud', 0),
	(1, 3349, 'Cloud', 0),
	(0, 3350, 'Round robin', 0),
	(1, 3350, 'Round robin', 0),
	(0, 3351, 'Add round robin', 0),
	(1, 3351, 'Add round robin', 0),
	(0, 3352, 'Update round robin', 0),
	(1, 3352, 'Update round robin', 0),
	(0, 3353, 'Delete round robin', 0),
	(1, 3353, 'Delete round robin', 0),
	(0, 3354, 'Escalation rule', 0),
	(1, 3354, 'Escalation rule', 0),
	(0, 3355, 'If a ticket remains un-assigned for more than:', 0),
	(1, 3355, 'If a ticket remains un-assigned for more than:', 0),
	(0, 3356, 'Send escalation email to :', 0),
	(1, 3356, 'Send escalation email to :', 0),
	(0, 3357, 'Round robin assign', 0),
	(1, 3357, 'Round robin assign', 0),
	(0, 3358, 'Round robin participants', 0),
	(1, 3358, 'Round robin participants', 0),
	(0, 3359, 'View round robin participants', 0),
	(1, 3359, 'View round robin participants', 0),
	(0, 3360, 'Accepting', 0),
	(1, 3360, 'Accepting', 0),
	(0, 3361, 'Not accepting', 0),
	(1, 3361, 'Not accepting', 0),
	(0, 3362, 'Ticket assignment', 0),
	(1, 3362, 'Ticket assignment', 0),
	(0, 3363, 'Aircall', 0),
	(1, 3363, 'Aircall', 0),
	(0, 3364, 'Voice mail', 0),
	(1, 3364, 'Voice mail', 0),
	(0, 3365, 'Single Sign On', 0),
	(1, 3365, 'Single Sign On', 0),
	(0, 3366, 'SAML', 0),
	(1, 3366, 'SAML', 0),
	(0, 3367, 'JWT', 0),
	(1, 3367, 'JWT', 0),
	(0, 3368, 'Return to URL', 0),
	(1, 3368, 'Return to URL', 0),
	(0, 3369, 'Remote logout URL', 0),
	(1, 3369, 'Remote logout URL', 0),
	(0, 3370, 'Shared secret', 0),
	(1, 3370, 'Shared secret', 0),
	(0, 3371, 'SSO type', 0),
	(1, 3371, 'SSO type', 0),
	(0, 3372, 'Add SSO', 0),
	(1, 3372, 'Add SSO', 0),
	(0, 3373, 'SAML SSO URL', 0),
	(1, 3373, 'SAML SSO URL', 0),
	(0, 3374, 'Certificate fingerprint', 0),
	(1, 3374, 'Certificate fingerprint', 0),
	(0, 3375, 'Update SSO', 0),
	(1, 3375, 'Update SSO', 0),
	(0, 3376, 'Delete Capsul CRM', 0),
	(1, 3376, 'Delete Capsul CRM', 0),
	(0, 3377, 'Delete SSO', 0),
	(1, 3377, 'Delete SSO', 0),
	(0, 3378, 'Contact', 0),
	(1, 3378, 'Contact', 0),	
	(0, 3379, 'Create ticket with vtiger', 0),
	(1, 3379, 'Create ticket with vtiger', 0),
	(0, 3380, 'Enable Twilio messaging', 0),
	(1, 3380, 'Enable Twilio messaging', 0),
	(0, 3381, 'Required twilio Configuration - Settings/Integrations/Twilio', 0),
	(1, 3381, 'Required twilio Configuration - Settings/Integrations/Twilio', 0),	
	(0, 3382, 'Opportunities', 0),
	(1, 3382, 'Opportunities', 0),
	(0, 3383, 'Create opportunities', 0),
	(1, 3383, 'Create opportunities', 0),	
	(0, 3384, 'Opportunities list', 0),
	(1, 3384, 'Opportunities list', 0),	
	(0, 3385, 'Close date', 0),
	(1, 3385, 'Close date', 0),	
	(0, 3386, 'Sales stage', 0),
	(1, 3386, 'Sales stage', 0),
	(0, 3387, 'Create project', 0),
    (1, 3387, 'Create project', 0),
    (0, 3388, 'Staff can decide self round robin participation', 0),
	(1, 3388, 'Staff can decide self round robin participation', 0),
	(0, 3389, 'Create project', 0),
	(1, 3389, 'Create project', 0),	
	(0, 3390, 'Project List', 0),
	(1, 3390, 'Project List', 0),
	(0, 3391, 'Drive', 0),
	(1, 3391, 'Drive', 0),
	(0, 3392, 'My drive', 0),
	(1, 3392, 'My drive', 0),
	(0, 3393, 'Drive list count', 0),
	(1, 3393, 'Drive list count', 0),
	(0, 3394, 'Ticket attachments', 0),
	(1, 3394, 'Ticket attachments', 0),
	(0, 3395, 'Enter staff\'s email', 0),
	(1, 3395, 'Enter staff\'s email', 0),
	(0, 3396, 'Google drive', 0),
	(1, 3396, 'Google drive', 0),
	(0, 3397, 'Total open ticket', 0),
	(1, 3397, 'Total open ticket', 0),
	(0, 3398, 'Ticket view date', 0),
	(1, 3398, 'Ticket view date', 0),
	(0, 3399, 'Please enter minimum 4 characters', 0),
	(1, 3399, 'Please enter minimum 4 characters', 0),
	(0, 3400, 'Clients by organizations', 0),
	(1, 3400, 'Clients by organizations', 0),
	(0, 3401, 'Hardware', 0),
	(1, 3401, 'Hardware', 0),
	(0, 3402, 'Software', 0),
	(1, 3402, 'Software', 0),
	(0, 3403, 'Organization wise invoice report', 0),
	(1, 3403, 'Organization wise invoice report', 0),
	(0, 3404, 'Opencart', 0),
	(1, 3404, 'Opencart', 0),
	(0, 3405, 'Dropbox', 0),
	(1, 3405, 'Dropbox', 0),	
	(0, 3406, 'Modified ticket custom fields data', 0),
	(1, 3406, 'Modified ticket custom fields data', 0),
	(0, 3407, 'day', 0),
	(1, 3407, 'day', 0),	
	(0, 3408, 'days', 0),
	(1, 3408, 'days', 0),	
	(0, 3409, 'hour', 0),
	(1, 3409, 'hour', 0),	
	(0, 3410, 'hours', 0),
	(1, 3410, 'hours', 0),
    (0, 3411, 'Total undue ticket report', 0),
	(1, 3411, 'Total undue ticket report', 0),
    (0, 3412, 'Search Clients', 0),
	(1, 3412, 'Search Clients', 0),
	(0, 3413, 'Organization', 0),
	(1, 3413, 'Organization', 0),
	(0, 3414, 'Ticket CI relation', 0),
	(1, 3414, 'Ticket CI relation', 0),
	(0, 3415, 'Problem CI relation', 0),
	(1, 3415, 'Problem CI relation', 0),
	(0, 3416, 'Changes CI relation', 0),
	(1, 3416, 'Changes CI relation', 0),
	(0, 3417, 'Office 365', 0),
	(1, 3417, 'Office 365', 0),
	(0, 3418, 'Tenant', 0),
	(1, 3418, 'Tenant', 0),
	(0, 3419, 'Clients by organization', 0),
	(1, 3419, 'Clients by organization', 0),
	(0, 3420, 'Helpdesk form header', 0),
	(1, 3420, 'Helpdesk form header', 0),
	(0, 3421, 'Tickets by label', 0),
	(1, 3421, 'Tickets by label', 0),
	(0, 3422, 'Staff leaderboard first avg response report', 0),
	(1, 3422, 'Staff leaderboard first avg response report', 0),
	(0, 3423, 'Staff leaderboard avg response report', 0),
	(1, 3423, 'Staff leaderboard avg response report', 0),
	(0, 3424, 'Staff leaderboard avg sla maintain report', 0),
	(1, 3424, 'Staff leaderboard avg sla maintain report', 0),
	(0, 3425, 'To add form fields you require minimum one form field group', 0),
	(1, 3425, 'To add form fields you require minimum one form field group', 0),
	(0, 3426, 'Ticket activity by department', 0),
	(1, 3426, 'Ticket activity by department', 0),
	(0, 3427, 'Search drive', 0),
	(1, 3427, 'Search drive', 0),
	(0, 3428, 'Upload', 0),
	(1, 3428, 'Upload', 0),
	(0, 3429, 'Select location for report generation', 0),
	(1, 3429, 'Select location for report generation', 0),
	(0, 3430, 'Select ci type for report generation', 0),
	(1, 3430, 'Select ci type for report generation', 0),
	(0, 3431, 'Select type for report generation', 0),
	(1, 3431, 'Select type for report generation', 0),
	(0, 3432, 'Select depreciation type for generate report', 0),
	(1, 3432, 'Select depreciation type for generate report', 0),
	(0, 3433, 'All files', 0),
	(1, 3433, 'All files', 0),
	(0, 3434, 'My files', 0),
	(1, 3434, 'My files', 0),
	(0, 3435, 'Please select status', 0),
	(1, 3435, 'Please select status', 0),
	(0, 3436, 'New ticket created', 0),
	(1, 3436, 'New ticket created', 0),
	(0, 3437, 'Status changed', 0),
	(1, 3437, 'Status changed', 0),
	(0, 3438, 'Priority changed', 0),
	(1, 3438, 'Priority changed', 0),
	(0, 3439, 'Domain list must not contain space', 0),
	(1, 3439, 'Domain list must not contain space', 0),
	(0, 3440, 'Domain list must not contain @', 0),
	(1, 3440, 'Domain list must not contain @', 0),
	(0, 3441, 'Domain list must not contain #', 0),
	(1, 3441, 'Domain list must not contain #', 0),
	(0, 3442, 'Specific', 0),
	(1, 3442, 'Specific', 0),
	(0, 3443, 'Manage round robin participants', 0),
	(1, 3443, 'Manage round robin participants', 0),
	(0, 3444, 'Contact number should be numerics', 0),
	(1, 3444, 'Contact number should be numeric', 0),
	(0, 3445, 'Max contact number length should be 20', 0),
	(1, 3445, 'Max contact number length should be 20', 0),
	(0, 3446, 'Domain list', 0),
	(1, 3446, 'Domain list', 0),
	(0, 3447, 'Comment date', 0),
	(1, 3447, 'Comment date', 0),
	(0, 3448, 'Bill time should be numeric', 0),
	(1, 3448, 'Bill time should be numeric', 0),
	(0, 3449, 'Work time should be numeric', 0),
	(1, 3449, 'Work time should be numeric', 0),
	(0, 3450, 'Asterisk', 0),
	(1, 3450, 'Asterisk', 0),	
	(0, 3451, 'Database host', 0),
	(1, 3451, 'Database host', 0),	
	(0, 3452, 'Database user', 0),
	(1, 3452, 'Database user', 0),	
	(0, 3453, 'Database  password', 0),
	(1, 3453, 'Database  password', 0),	
	(0, 3454, 'Database name', 0),
	(1, 3454, 'Database name', 0),	
	(0, 3455, 'Asterisk configuration', 0),
	(1, 3455, 'Asterisk configuration', 0),	
	(0, 3456, 'Asterisk databade configuration', 0),
	(1, 3456, 'Asterisk databade configuration', 0),	
	(0, 3457, 'Connection timeout', 0),
	(1, 3457, 'Connection timeout', 0),	
	(0, 3458, 'Read timeout', 0),
	(1, 3458, 'Read timeout', 0),	
	(0, 3459, 'Scheme', 0),
	(1, 3459, 'Scheme', 0),	
	(0, 3460, 'Calldate', 0),
	(1, 3460, 'Calldate', 0),	
	(0, 3461, 'Clid', 0),
	(1, 3461, 'Clid', 0),	
	(0, 3462, 'Src', 0),
	(1, 3462, 'Src', 0),	
	(0, 3463, 'Dst', 0),
	(1, 3463, 'Dst', 0),	
	(0, 3464, 'Dcontext', 0),
	(1, 3464, 'Dcontext', 0),	
	(0, 3465, 'Dstchannel', 0),
	(1, 3465, 'Dstchannel', 0),	
	(0, 3466, 'Lastapp', 0),
	(1, 3466, 'Lastapp', 0),	
	(0, 3467, 'Lastdata', 0),
	(1, 3467, 'Lastdata', 0),	
	(0, 3468, 'Billsec', 0),
	(1, 3468, 'Billsec', 0),	
	(0, 3469, 'Disposition', 0),
	(1, 3469, 'Disposition', 0),	
	(0, 3470, 'Amaflags', 0),
	(1, 3470, 'Amaflags', 0),	
	(0, 3471, 'Accountcode', 0),
	(1, 3471, 'Accountcode', 0),	
	(0, 3472, 'Uniqueid', 0),
	(1, 3472, 'Uniqueid', 0),	
	(0, 3473, 'Userfield', 0),
	(1, 3473, 'Userfield', 0),	
	(0, 3474, 'Recordingfile', 0),
	(1, 3474, 'Recordingfile', 0),	
	(0, 3475, 'Cnum', 0),
	(1, 3475, 'Cnum', 0),	
	(0, 3476, 'Cnam', 0),
	(1, 3476, 'Cnam', 0),	
	(0, 3477, 'Outbound_cnum', 0),
	(1, 3477, 'Outbound_cnum', 0),	
	(0, 3478, 'Outbound_cnam', 0),
	(1, 3478, 'Outbound_cnam', 0),	
	(0, 3479, 'Dst_cnam', 0),
	(1, 3479, 'Dst_cnam', 0),	
	(0, 3480, 'Did', 0),
	(1, 3480, 'Did', 0),	
	(0, 3481, 'LinkedId', 0),
	(1, 3481, 'LinkedId', 0),	
	(0, 3482, 'Recording path', 0),
	(1, 3482, 'Recording path', 0),	
	(0, 3483, 'Asterisk dial plans', 0),
	(1, 3483, 'Asterisk dial plans', 0),	
	(0, 3484, 'Add dialplan', 0),
	(1, 3484, 'Add dialplan', 0),	
	(0, 3485, 'Context', 0),
	(1, 3485, 'Context', 0),	
	(0, 3486, 'Exten', 0),
	(1, 3486, 'Exten', 0),	
	(0, 3487, 'Delete asterisk', 0),
	(1, 3487, 'Delete asterisk', 0),	
	(0, 3488, 'Update dialplan', 0),
	(1, 3488, 'Update dialplan', 0),	
	(0, 3489, 'Async', 0),
	(1, 3489, 'Async', 0),	
	(0, 3490, 'Required field', 0),
	(1, 3490, 'Required field', 0),	
	(0, 3491, 'Call us', 0),
	(1, 3491, 'Call us', 0),
	(1, 3491, 'Call us', 0),
	(0, 3492, 'Task linked to tickets', 0),
	(1, 3492, 'Task linked to tickets', 0),
	(0, 3493, 'URL already exist. Enter unique URL', 0),
	(1, 3493, 'URL already exist. Enter unique URL', 0),
	(0, 3494, 'Language translation for form fields', 0),
	(1, 3494, 'Language translation for form fields', 0),
	(0, 3495, 'Language translation for form field group', 0),
	(1, 3495, 'Language translation for form field group', 0),
	(0, 3496, 'CI attached', 0),
	(1, 3496, 'CI attached', 0),
	(0, 3497, 'Size', 0),
	(1, 3497, 'Size', 0),
	(0, 3498, 'Delete file', 0),
	(1, 3498, 'Delete file', 0),
	(0, 3499, 'Are you sure you want to proceed?', 0),
	(1, 3499, 'Are you sure you want to proceed?', 0),
	(0, 3500, 'Language translation for survey group', 0),
	(1, 3500, 'Language translation for survey group', 0),
	(0, 3501, 'Language translation for survey field group', 0),
	(1, 3501, 'Language translation for survey field group', 0),
	(0, 3502, 'Language translation for ticket category title', 0),
	(1, 3502, 'Language translation for ticket category title', 0),
	(0, 3503, 'Language translation for level title', 0),
	(1, 3503, 'Language translation for level title', 0),
	(0, 3504, 'Language translation for flag title', 0),
	(1, 3504, 'Language translation for flag title', 0),
	(0, 3505, 'Language translation for category title', 0),
	(1, 3505, 'Language translation for category title', 0),
	(0, 3506, 'Tax Enabled', 0),
	(1, 3506, 'Tax Enabled', 0),
	(0, 3507, 'Compound Tax', 0),
	(1, 3507, 'Compound Tax', 0),
	(0, 3508, 'Tax rule settings', 0),
	(1, 3508, 'Tax rule settings', 0),
	(0, 3509, 'Room', 0),
	(1, 3509, 'Room', 0),
	(0, 3510, 'Sent notification', 0),
	(1, 3510, 'Sent notification', 0),
	(0, 3511, 'CI type', 0),
	(1, 3511, 'CI type', 0),
	(0, 3512, 'Select CI', 0),
	(1, 3512, 'Select CI', 0),
	(0, 3513, 'Merge Invoice', 0),
	(1, 3513, 'Merge Invoice', 0),
	(0, 3514, 'Merge Time Tracking Entries', 0),
	(1, 3514, 'Merge Time Tracking Entries', 0),
	(0, 3515, 'Merge Notes', 0),
	(1, 3515, 'Merge Notes', 0),
	(0, 3516, 'Merge Comments', 0),
	(1, 3516, 'Merge Comments', 0),
	(0, 3517, 'Select atleast one merge option', 0),
	(1, 3517, 'Select atleast one merge option', 0),
	(0, 3518, 'Update CI custom field', 1),
	(1, 3518, 'Update CI custom field', 1),
	(0, 3519, 'Language translation for CI custom fields', 1),
	(1, 3519, 'Language translation for CI custom fields', 1),
	(0, 3520, 'Add CI custom field', 1),
	(1, 3520, 'Add CI custom field', 1),
	(0, 3521, 'On reply auto ticket lock and unlock', 1),
	(1, 3521, 'On reply auto ticket lock and unlock', 1),
	(0, 3522, 'Please select at least one team or one staff.', 1),
	(1, 3522, 'Please select at least one team or one staff.', 1),
	(0, 3523, 'Merge Post', 1),
	(1, 3523, 'Merge Post', 1),
	(0, 3524, 'Status change report', 1),
	(1, 3524, 'Status change report', 1),
	(0, 3525, 'Custom field report for staff ticket creation', 1),
	(1, 3525, 'Custom field report for staff ticket creation', 1),
	(0, 3526, 'Required at least one CI custom field', 1),
	(1, 3526, 'Required at least one CI custom field', 1),
	(0, 3527, 'Custom field report for organization registration', 1),
	(1, 3527, 'Custom field report for organization registration', 1),
	(0, 3528, 'Invalid Asset Name', 0),
	(1, 3528, 'Invalid Asset Name', 0),
	(0, 3529, 'Implemented', 0),
	(1, 3529, 'Implemented', 0),
	(0, 3530, 'Deferred', 0),
	(1, 3530, 'Deferred', 0),
	(0, 3531, 'Xero', 0),
	(1, 3531, 'Xero', 0),
	(0, 3532, 'Add xero', 0),
	(1, 3532, 'Add xero', 0),
	(0, 3533, 'Delete Xero', 0),
	(1, 3533, 'Delete Xero', 0),
	(0, 3534, 'Contact Name', 0),
	(1, 3534, 'Contact Name', 0),
	(0, 3535, 'Street', 0),
	(1, 3535, 'Street', 0),	
	(0, 3536, 'Postal', 0),
	(1, 3536, 'Postal', 0),	
	(0, 3537, 'Skype Name', 0),
	(1, 3537, 'Skype Name', 0),	
	(0, 3538, 'Number', 0),
	(1, 3538, 'Number', 0),
	(0, 3539, 'Ref', 0),
	(1, 3539, 'Ref', 0),	
	(0, 3540, 'Direct', 0),
	(1, 3540, 'Direct', 0),
	(0, 3541, 'Region', 0),
	(1, 3541, 'Region', 0),
	(0, 3542, 'Total ticket closed by staff', 0),
	(1, 3542, 'Total ticket closed by staff', 0),
	(0, 3543, 'Flagged tickets to user', 0),
	(1, 3543, 'Flagged tickets to user', 0),
	(0, 3544, 'Select flag', 0),
	(1, 3544, 'Select flag', 0),
	(0, 3545, 'All flag', 0),
	(1, 3545, 'All flag', 0),
	(0,3546, 'Organization add',0),
	(1,3546, 'Organization add',0),
	(0,3547, 'Organization edit',0),
	(1,3547, 'Organization edit',0),
	(0,3548, 'Organization delete',0),
	(1,3548, 'Organization delete',0),
	(0,3549, 'Assets', 1),
	(1,3549, 'Assets', 1),
	(0,3550, 'Name', 1),
	(1,3550, 'Name', 1),
	(0,3551, 'Impact', 1),
	(1,3551, 'Impact', 1),
	(0,3552, 'Assigned on', 1),
	(1,3552, 'Assigned on',1),
	(0,3553, 'Expired', 1),
	(1,3553, 'Expired', 1),
	(0,3554, 'Used by', 1),
	(1,3554, 'Used by', 1),
	(0,3555, 'Managed by', 1),
	(1,3555, 'Managed by', 1),
	(0,3556, 'Acquisition date', 1),
	(1,3556, 'Acquisition date', 1),
	(0,3557, 'Book value', 1),
	(1,3557, 'Book value', 1),
	(0,3558, 'Salvage', 1),
	(1,3558, 'Salvage', 1),
	(0,3559, 'Depreciation type', 1),
	(1,3559, 'Depreciation type', 1),
	(0,3560, 'Useful life (in years)', 1),
	(1,3560, 'Useful life (in years)', 1),
	(0,3561, 'Product', 1),
	(1,3561, 'Product', 1),
	(0,3562, 'Manufacturer', 1),
	(1,3562, 'Manufacturer', 1),
	(0,3563, 'Warranty year', 1),
	(1,3563, 'Warranty year', 1),
	(0,3564, 'Warranty month', 1),
	(1,3564, 'Warranty month', 1),
	(0,3565, 'Asset tag', 1),
	(1,3565, 'Asset tag', 1),
	(0,3566, 'Last audit date', 1),
	(1,3566, 'Last audit date', 1),
	(0,3567, 'Installation path', 1),
	(1,3567, 'Installation path', 1),
	(0,3568, 'Licence key', 1),
	(1,3568, 'Licence key', 1),
	(0,3569, 'Expiry date', 1),
	(1,3569, 'Expiry date', 1),
	(0,3570, 'Installation date', 1),
	(1,3570, 'Installation date',1),
	(0,3571, 'Task Automation',1),
	(1,3571, 'Task Automation',1),
	(0, 3572, 'invalid email', 0),
	(1, 3572, 'invalid email', 0),	
	(0, 3573, 'enter only numeric characters', 0),
	(1, 3573, 'enter only numeric characters', 0),	
	(0, 3574, 'enter only alphabetics', 0),
	(1, 3574, 'enter only alphabetics', 0),	
	(0, 3575, 'enter only alphanumeric characters', 0),
	(1, 3575, 'enter only alphanumeric characters', 0),
	(0, 3576, 'Fetch all ( self+client ) post', 0),
	(1, 3576, 'Fetch all ( self+client ) post', 0);

DROP TABLE IF EXISTS `avis_level_points`;
CREATE TABLE IF NOT EXISTS `avis_level_points` (
  `level_id` int(11) NOT NULL AUTO_INCREMENT,
  `level_name` varchar(255) CHARACTER SET utf8 NOT NULL,
  `level_points` varchar(15) CHARACTER SET utf8 NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`level_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_level_points` (`level_id`, `level_name`, `level_points`, `status`) VALUES
(1, 'Pawn', '100', 0),
(2, 'Knight', '2500', 0),
(3, 'Bishop', '10000', 0),
(4, 'Rook', '25000', 0),
(5, 'Queen', '50000', 0),
(6, 'King', '100000', 0);
DROP TABLE IF EXISTS `avis_macros`;
CREATE TABLE IF NOT EXISTS `avis_macros` (
  `macro_id` int(11) NOT NULL AUTO_INCREMENT,
  `macro_title` varchar(255) NOT NULL,
  `department` int(11) NOT NULL,
  `sla` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `priority` int(11) NOT NULL,
  `owner` text,
  `labels` text,
  `tags` text,
  `comment` text,
  `post_content` text,
  `staff_id` int(11) NOT NULL,
  `display_order` int(15) NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `category_id` INT( 11 ) NOT NULL,
  `subcategory_id` INT( 11 ) NOT NULL,
  `item_id` INT( 11 ) NOT NULL,
  `level_id` INT( 11 ) NOT NULL,
  `location_id` INT( 11 ) NOT NULL,
  `access` int(10) DEFAULT '0',
		`flag_id` int(10) NOT NULL,
  PRIMARY KEY (`macro_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_mailqueue`;
CREATE TABLE IF NOT EXISTS `avis_mailqueue` (
  `mailqueue_id` int(15) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `mailqueue_type` int(3) DEFAULT '0',
  `host_name` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `authentication` varchar(255) DEFAULT NULL,
  `port_number` int(4) DEFAULT NULL,
  `department_id` int(15) DEFAULT NULL,
  `override_name` varchar(255) DEFAULT NULL,
  `override_email` varchar(255) DEFAULT NULL,
  `signature` text,
  `registered_client` tinyint(1) DEFAULT '0',
  `fetch_count` int(15) DEFAULT '20',
  `last_count` int(15) DEFAULT '0',
  `can_delete` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `forward_email_flag` tinyint(1) NOT NULL DEFAULT '0',
  `forward_email` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`mailqueue_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_module`;
CREATE TABLE IF NOT EXISTS `avis_module` (
  `module_id` int(15) NOT NULL AUTO_INCREMENT,
  `module` varchar(255) DEFAULT NULL,
  `module_name` varchar(255) DEFAULT NULL,
  `header_title` varchar(255) DEFAULT NULL,
  `access_type` int(4) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `quick_view` tinyint(1) DEFAULT '0',
  `quick_view_open` tinyint(1) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`module_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_module` (`module_id`, `module`, `module_name`, `header_title`, `access_type`, `is_enabled`, `quick_view`, `quick_view_open`, `is_custom`) VALUES
(1, 'home', 'Home', 'Home', 1, 1, 0, 0, 1),
(2, 'ticket', 'Tickets', 'Inbox', 1, 1, 0, 1, 1),
(3, 'client', 'Clients', 'Clients', 1, 1, 0, 0, 1),
(4, 'solutions', 'Solutions', 'Solutions', 1, 1, 0, 0, 1),
(5, 'billing', 'Billing', 'Billing', 1, 0, 0, 0, 1),
(6, 'blabber', 'Blabby', 'Blabby', 1, 1, 1, 0, 1),
(7, 'report', 'Report', 'Reports', 1, 1, 1, 0, 1),
(8, 'setting', 'Settings', 'Settings', 1, 1, 0, 0, 0),
(9, 'gamification', 'Gamification', 'gamification', 1, 1, 0, 0, 1),
(11, 'task', 'Task', 'Task', 1, 1, 1, 1, 1),
(10, 'itil', 'ITIL', 'ITIL', 1, 1, 0, 0, 1),
(12, 'forums', 'Forums', 'Forums', 1, 1, 0, 0, 1);
CREATE TABLE IF NOT EXISTS `avis_module_integrate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_hash` varchar(50) NOT NULL,
  `ticket_id` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `link_id` int(11) NOT NULL,
  `integration_type` INT(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_notification`;
CREATE TABLE IF NOT EXISTS `avis_notification` (
  `notification_id` int(15) NOT NULL AUTO_INCREMENT,
  `operation_id` int(15) DEFAULT NULL,
  `operator_id` int(15) DEFAULT NULL,
  `parent_id` int(15) DEFAULT NULL,
  `access_ids` varchar(255) DEFAULT '0',
  `module_id` int(15) DEFAULT NULL,
  `operation_time` int(15) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_client` TINYINT(4) NOT NULL,
  PRIMARY KEY (`notification_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_order`;
CREATE TABLE IF NOT EXISTS `avis_order` (
  `order_id` int(15) NOT NULL AUTO_INCREMENT,
  `order_hash` int(15) DEFAULT NULL,
  `product_id` int(15) DEFAULT NULL,
  `client_id` int(15) DEFAULT NULL,
  `balance` float(10,2) DEFAULT '0.00',
  `balance_type` tinyint(1) DEFAULT '0',
  `expiry` int(15) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `order_status` int(4) NOT NULL DEFAULT '2',
  `validity` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_pages`;
CREATE TABLE IF NOT EXISTS `avis_pages` (
  `page_id` int(15) NOT NULL AUTO_INCREMENT,
  `app_id` int(15) NOT NULL,
  `unique_page_id` varchar(50) NOT NULL,
  `page_name` varchar(255) DEFAULT NULL,
  `department_id` int(15) DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`page_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_parserlog`;
CREATE TABLE IF NOT EXISTS `avis_parserlog` (
  `parserlog_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(15) DEFAULT NULL,
  `ticket_post_id` int(15) DEFAULT NULL,
  `entry_date` int(15) DEFAULT NULL,
  `mail_report` int(15) DEFAULT '0',
  `mailqueue_id` int(15) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `from_email` varchar(255) DEFAULT NULL,
  `to_email` varchar(255) DEFAULT NULL,
  `channel` int(4) DEFAULT '0',
  `message_id` varchar(255) DEFAULT NULL,
  `source_type` tinyint(3) DEFAULT '0',
		`filename` VARCHAR( 255 ) NOT NULL,
		`status` INT( 11 ) NOT NULL COMMENT '1=Success,2=Mail-queue not exist, 3=Client email Not varified, 4=registration_required,5=Contact access,6=client register error,7=ban_client,8=client approved pending,9=Ignore email,10=Staff access,11=ticket creation error',
  PRIMARY KEY (`parserlog_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_parser_data`;
CREATE TABLE IF NOT EXISTS `avis_parser_data` (
  `parser_data_id` int(15) NOT NULL AUTO_INCREMENT,
  `parserlog_id` int(15) NOT NULL DEFAULT '0',
  `mail_content` longtext,
  PRIMARY KEY (`parser_data_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_pinup`;
CREATE TABLE IF NOT EXISTS `avis_pinup` (
  `pin_id` int(15) NOT NULL AUTO_INCREMENT,
  `pin_title` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT NULL,
  `pin_value` varchar(255) DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  `owner` int(15) DEFAULT NULL,
  `pin_image` varchar(255) DEFAULT NULL,
  `channel_id` int(11) NULL DEFAULT '0',
  PRIMARY KEY (`pin_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_points_criteria`;
CREATE TABLE IF NOT EXISTS `avis_points_criteria` (
  `point_criteria_id` int(11) NOT NULL AUTO_INCREMENT,
  `point_criteria` text NOT NULL,
  `point_id` int(11) NOT NULL,
  `points` varchar(15) NOT NULL,
  PRIMARY KEY (`point_criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_points_criteria` (`point_criteria_id`, `point_criteria`, `point_id`, `points`) VALUES
(1, 'Fast reply (< 10 min)', 1, '5'),
(2, 'Reply within SLA time', 2, '10'),
(3, 'Overdue ticket reply', 3, '-5'),
(4, 'Happy customer (> 3 like)', 1, '10'),
(5, 'Unhappy customer (< 3 like)', 2, '-10'),
(6, 'Selfhelp article', 3, '5'),
(7, 'Note', 4, '10'),
(8, 'Comment', 5, '100');
DROP TABLE IF EXISTS `avis_product`;
CREATE TABLE IF NOT EXISTS `avis_product` (
  `product_id` int(15) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `balance_type` tinyint(1) DEFAULT '0',
  `balance` int(4) DEFAULT '0',
  `validity` int(4) DEFAULT '0',
  `amount` decimal(10,2) DEFAULT '0.00',
  `is_recurring` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_quest`;
CREATE TABLE IF NOT EXISTS `avis_quest` (
  `quest_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` varchar(255) CHARACTER SET utf8 NOT NULL,
  `quest_title` varchar(255) NOT NULL,
  `quest_type` varchar(255) NOT NULL,
  `quest_points` varchar(15) NOT NULL,
  `quest_discription` text NOT NULL,
  `quest_status` int(11) NOT NULL,
  `quest_duration` varchar(100) NOT NULL,
  `quest_start_date` text NOT NULL,
  `image_path` varchar(255) NOT NULL,
  PRIMARY KEY (`quest_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_quest_criteria`;
CREATE TABLE IF NOT EXISTS `avis_quest_criteria` (
  `criteria_id` int(11) NOT NULL AUTO_INCREMENT,
  `quest_id` int(11) NOT NULL,
  `base_criteria` int(11) NOT NULL,
  `sub_criteria` int(11) NOT NULL,
  `content` text NOT NULL,
  `criteria_type` int(11) NOT NULL,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_remotescreen`;
CREATE TABLE IF NOT EXISTS `avis_remotescreen` (
  `remoteapp_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) NOT NULL,
  `domain_id` int(15) NOT NULL,
  `remoteapp_type` int(15) NOT NULL,
  `user_name` varchar(255) NOT NULL,
  `user_password` varchar(255) NOT NULL,
  `client_id` varchar(255) NOT NULL,
  `extra_info` tinyint(4) NULL DEFAULT '0',
  PRIMARY KEY (`remoteapp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_report`;
CREATE TABLE IF NOT EXISTS `avis_report` (
  `report_id` int(15) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(255) DEFAULT NULL,
  `owner` int(15) DEFAULT NULL,
  `entry_date` int(15) DEFAULT NULL,
  `query` text,
  `sortby_1` int(4) DEFAULT '1',
  `sortby_2` int(4) DEFAULT '1',
  `sortby_3` int(4) DEFAULT '1',
  `groupby_1` int(4) DEFAULT '1',
  `groupby_2` int(4) DEFAULT '1',
  `groupby_3` int(4) DEFAULT '1',
  `report_type` tinyint(2) DEFAULT '0',
  `module` tinyint(2) DEFAULT '0',
  `page_count` int(4) DEFAULT '50',
  `concate_option` enum('and','or') DEFAULT 'and',
  PRIMARY KEY (`report_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_report_criteria`;
CREATE TABLE IF NOT EXISTS `avis_report_criteria` (
  `criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `report_id` int(15) DEFAULT NULL,
  `base_criteria` int(15) DEFAULT NULL,
  `sub_criteria` int(4) DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_report_field`;
CREATE TABLE IF NOT EXISTS `avis_report_field` (
  `field_id` int(15) NOT NULL AUTO_INCREMENT,
  `field_name` varchar(255) DEFAULT NULL,
  `report_id` int(15) DEFAULT NULL,
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_schedule`;
CREATE TABLE IF NOT EXISTS `avis_schedule` (
  `schedule_id` int(15) NOT NULL AUTO_INCREMENT,
  `schedule_name` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `sunday_time` varchar(255) DEFAULT '0',
  `monday_time` varchar(255) DEFAULT '0, 1440',
  `tuesday_time` varchar(255) DEFAULT '0, 1440',
  `wednesday_time` varchar(255) DEFAULT '0, 1440',
  `thursday_time` varchar(255) DEFAULT '0, 1440',
  `friday_time` varchar(255) DEFAULT '0, 1440',
  `saturday_time` varchar(255) DEFAULT '0, 1440',
  PRIMARY KEY (`schedule_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_schedule` values (1,'24x7 schedule',1,'0, 1440','0, 1440','0, 1440','0, 1440','0, 1440','0, 1440','0, 1440');
DROP TABLE IF EXISTS `avis_selfhelp_article`;
CREATE TABLE IF NOT EXISTS `avis_selfhelp_article` (
  `article_id` int(15) NOT NULL AUTO_INCREMENT,
  `article_title` text,
  `article_keywords` varchar(1000) DEFAULT NULL,
  `content` longtext,
  `parent_id` int(15) DEFAULT NULL,
  `can_comment` tinyint(1) DEFAULT '1',
  `can_rate` tinyint(1) DEFAULT '1',
  `is_stick` tinyint(1) DEFAULT '0',
  `auto_subscribe` tinyint(1) DEFAULT '1',
  `can_attach` tinyint(1) DEFAULT '0',
  `need_login` tinyint(1) DEFAULT '0',
  `rate_count` int(15) DEFAULT '0',
  `rating` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT NULL,
  `modified_date` int(15) DEFAULT NULL,
  `author_id` int(15) DEFAULT NULL,
  `author_type` tinyint(1) DEFAULT '0',
  `author` varchar(255) DEFAULT NULL,
  `author_image` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `article_url` varchar(255) DEFAULT NULL,
  `art_parent_id` int(15) DEFAULT NULL,
  `language` int(15) DEFAULT NULL,
		`view_count` int(15) DEFAULT '0',
		`like_count` INT( 15 ) NOT NULL DEFAULT '0',
		`art_likes` INT( 15 ) NOT NULL DEFAULT '0',
  PRIMARY KEY (`article_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_selfhelp_category`;
CREATE TABLE IF NOT EXISTS `avis_selfhelp_category` (
  `selfhelp_id` int(15) NOT NULL AUTO_INCREMENT,
  `selfhelp_title` varchar(255) DEFAULT NULL,
  `description` text,
  `parent_id` int(15) DEFAULT '0',
  `content_type` int(4) DEFAULT NULL,
  `display_order_type` int(4) DEFAULT '0',
  `display_status` int(4) DEFAULT NULL,
  `article_access` int(4) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `domain_id` int(15) DEFAULT NULL,
  `language_id` int(15) NOT NULL,
  `solution_id` int(5) NOT NULL DEFAULT '0',
  `client_display` varchar(100) NOT NULL,
  `org_display` varchar(100) NOT NULL,
  PRIMARY KEY (`selfhelp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_selfhelp_category` values (1,'Knowledgebase','',0,0,0,0,0,1,1,1,0,'','');
insert into `avis_selfhelp_category` values (2,'Downloads','',0,0,0,0,0,1,1,1,0,'','');
DROP TABLE IF EXISTS `avis_selfhelp_comment`;
CREATE TABLE IF NOT EXISTS `avis_selfhelp_comment` (
  `comment_id` int(15) NOT NULL AUTO_INCREMENT,
  `article_id` int(15) DEFAULT NULL,
  `poster_id` int(15) DEFAULT NULL,
  `poster_name` varchar(255) DEFAULT NULL,
  `poster_email` varchar(255) DEFAULT NULL,
  `poster_type` tinyint(1) DEFAULT '0',
  `content` text,
  `is_publish` tinyint(1) DEFAULT '1',
  `poster_image` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT NULL,
  `is_approved` tinyint(1) DEFAULT '0',
  `is_spam` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`comment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_sent_mail_log`;
CREATE TABLE IF NOT EXISTS `avis_sent_mail_log` (
  `sent_mail_id` int(15) NOT NULL AUTO_INCREMENT,
  `mail_from` varchar(123) DEFAULT NULL,
  `mail_to` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `content` text,
  `mail_type` int(4) DEFAULT NULL,
  `mail_status` tinyint(1) DEFAULT NULL,
  `failure_reason` text,
  `send_date` int(15) DEFAULT NULL,
  `mail_cc` varchar(255) DEFAULT NULL,
  `mail_bcc` varchar(255) DEFAULT NULL,
  `department_id` int(11) NOT NULL,
  `domain_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`sent_mail_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_sessions`;
CREATE TABLE IF NOT EXISTS `avis_sessions` (
  `session_id` varchar(63) DEFAULT NULL,
  `user_id` int(15) DEFAULT NULL,
  `ip` varchar(31) DEFAULT NULL,
  `session_type` tinyint(2) DEFAULT NULL,
  `last_operation` int(15) DEFAULT NULL,
  `logintime` int(15) DEFAULT NULL,
  `crontime` int(15) DEFAULT NULL,
  `useragent` varchar(255) DEFAULT NULL,
  `referer` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_settings`;
CREATE TABLE IF NOT EXISTS `avis_settings` (
  `setting_id` int(15) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `content` text,
  `domain_id` int(15) DEFAULT NULL,
  `department_id` int(15) DEFAULT '0',
  `module_id` int(15) DEFAULT '0',
  PRIMARY KEY (`setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_settings` values (1,'language_id','1',0,0,0);
insert into `avis_settings` values (2,'last_mailqueue','0',0,0,0);
insert into `avis_settings` values (3,'mailqueue_count','20',0,0,0);
insert into `avis_settings` values (4,'vis_first_time_login','3',0,0,0);
insert into `avis_settings` values (5,'vis_queue_outgoing_mail_status','0',0,0,0);
DROP TABLE IF EXISTS `avis_signature`;
CREATE TABLE IF NOT EXISTS `avis_signature` (
  `signature_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT NULL,
  `department_id` int(15) DEFAULT NULL,
  `content` text,
		`is_forum` TINYINT( 1 ) NOT NULL DEFAULT '0',
  PRIMARY KEY (`signature_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_single_login`;
CREATE TABLE IF NOT EXISTS `avis_single_login` (
  `single_login_id` int(15) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT NULL,
  `login_type` int(15) DEFAULT NULL,
  `host_name` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `db_name` varchar(255) DEFAULT NULL,
  `db_password` varchar(255) DEFAULT NULL,
  `db_prefix` varchar(31) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`single_login_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_sla`;
CREATE TABLE IF NOT EXISTS `avis_sla` (
  `sla_id` int(15) NOT NULL AUTO_INCREMENT,
  `sla_name` varchar(255) DEFAULT NULL,
  `overdue_time` int(15) DEFAULT '0',
  `resolution_time` int(15) DEFAULT '0',
  `schedule_id` int(15) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`sla_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_sla` (`sla_id`, `sla_name`, `overdue_time`, `resolution_time`, `schedule_id`, `is_enabled`) VALUES
(1, 'Default', 720, 1440, 1, 1),
(2, '5 Days SLA', 7200, 7200, 1, 1);

DROP TABLE IF EXISTS `avis_smtpmail`;
CREATE TABLE IF NOT EXISTS `avis_smtpmail` (
  `smtp_id` int(15) NOT NULL AUTO_INCREMENT,
  `smtp_port` int(4) DEFAULT '25',
  `smtp_host` varchar(255) DEFAULT NULL,
  `smtp_user` varchar(255) DEFAULT NULL,
  `smtp_password` varchar(255) DEFAULT NULL,
  `smtp_ssl` tinyint(2) DEFAULT '0',
  `authentication` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `department_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`smtp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_social_search`;
CREATE TABLE IF NOT EXISTS `avis_social_search` (
  `search_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `media_type` int(4) DEFAULT '0',
  `content` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `status` tinyint(1) DEFAULT '0',
  `channel_id` int(15) DEFAULT '0',
  PRIMARY KEY (`search_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_staff`;
CREATE TABLE IF NOT EXISTS `avis_staff` (
  `staff_id` int(15) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `initials` varchar(15) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `authentication` varchar(255) DEFAULT NULL,
  `group_id` int(15) DEFAULT NULL,
  `contact_number` varchar(255) DEFAULT NULL,
  `mobile_number` varchar(255) DEFAULT NULL,
  `temporary_address` text,
  `permanent_address` text,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip_code` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `website` text,
  `fax` varchar(255) DEFAULT NULL,
  `office_name` varchar(255) DEFAULT NULL,
  `office_email` varchar(255) DEFAULT NULL,
  `office_website` varchar(255) DEFAULT NULL,
  `other_contact_no` varchar(255) DEFAULT NULL,
  `other_fax` varchar(255) DEFAULT NULL,
  `job_title` varchar(255) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `gender` tinyint(1) DEFAULT '0',
  `birthdate` int(15) DEFAULT NULL,
  `netmeetingid` varchar(255) DEFAULT NULL,
  `other_im` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `session_time` int(4) DEFAULT '30',
  `timezone` varchar(6) DEFAULT '0',
  `timezone_dst` tinyint(1) DEFAULT '0',
  `sound_alert` tinyint(1) DEFAULT '1',
  `html_editor` tinyint(1) DEFAULT '1',
  `theme` varchar(255) DEFAULT 'nature',
  `image_name` varchar(255) DEFAULT NULL,
  `department_access` varchar(255) DEFAULT '0',
  `level_id` int(11) NULL DEFAULT '0',
  `staff_point` varchar(15) DEFAULT '0',
  `twitter_id` varchar(255) DEFAULT NULL,
  `facebook_id` varchar(255) DEFAULT NULL,
  `google_id` varchar(255) DEFAULT NULL,
  `linkedin_id` varchar(255) DEFAULT NULL,
  `timezone_name` text NOT NULL,
  `password_auth` int(3) DEFAULT NULL,
  `api_key` varchar(256) NOT NULL,
  `schedule_id` INT( 12 ) NULL DEFAULT '0',
  PRIMARY KEY (`staff_id`),
  KEY `group_id` (`group_id`),
  KEY `is_enabled` (`is_enabled`,`department_access`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_staff_badge`;
CREATE TABLE IF NOT EXISTS `avis_staff_badge` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quest_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_staff_group`;
CREATE TABLE IF NOT EXISTS `avis_staff_group` (
  `group_id` int(15) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access` varchar(255) DEFAULT NULL,
  `module` varchar(32) DEFAULT NULL,
  `department_access` text,
  `schedule_id` INT( 12 ) NULL DEFAULT '0',
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_staff_group` values (1, 'Default', 1, '0,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1', '1,1,1,1,1,1,1,1,1,1,1,1', '0', '1');
insert into `avis_staff_group` values (2, 'Trainee', 1,'1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,1,1', '1,1,1,1,0,1,0,1,1,1,0','0','1');
DROP TABLE IF EXISTS `avis_subaccount_settings`;
CREATE TABLE IF NOT EXISTS `avis_subaccount_settings` (
  `subaccount_setting_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) DEFAULT NULL,
  `setting_id` int(15) DEFAULT NULL,
  `is_set` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`subaccount_setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_task`;
CREATE TABLE IF NOT EXISTS `avis_task` (
   `task_id` int(11) NOT NULL AUTO_INCREMENT,
    `task_title` varchar(255) NOT NULL,
    `description` text,
    `startdate` text NOT NULL,
    `enddate` text NOT NULL,
    `task_status` int(11) NOT NULL DEFAULT '0',
    `priority` int(11) NOT NULL DEFAULT '0',
    `staff_id` int(11) NOT NULL,
    `task_repeat_schedule` int(15) DEFAULT NULL,
    `task_repeat_occurence` varchar(255) DEFAULT NULL,
    `owner_favourite` varchar(255) DEFAULT NULL,
	`parent_id` INT NOT NULL,
	`is_repeat` int(11) NOT NULL DEFAULT '0',
    `recurrence_flag` int(11) NOT NULL DEFAULT '0',
				`task_email_flag` INT( 11 ) NOT NULL DEFAULT '0',
    PRIMARY KEY (`task_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_task_assign`;
CREATE TABLE IF NOT EXISTS `avis_task_assign` (
  `assign_id` int(15) NOT NULL AUTO_INCREMENT,
  `task_id` int(15) DEFAULT NULL,
  `owner_id` int(15) DEFAULT NULL,
  PRIMARY KEY (`assign_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_task_comment`;
CREATE TABLE IF NOT EXISTS `avis_task_comment` (
  `comment_id` int(15) NOT NULL AUTO_INCREMENT,
  `task_id` int(15) DEFAULT NULL,
  `content` text,
  `entry_date` int(15) DEFAULT NULL,
  `owner` int(15) DEFAULT NULL,
  PRIMARY KEY (`comment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_tax`;
CREATE TABLE IF NOT EXISTS `avis_tax` (
  `tax_id` int(4) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT NULL,
  `tax_name` varchar(255) DEFAULT NULL,
  `exec_order` int(4) DEFAULT NULL,
  `tax_type` tinyint(1) DEFAULT '0',
  `rate` decimal(10,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) DEFAULT '1',
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`tax_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket`;
CREATE TABLE IF NOT EXISTS `avis_ticket` (
  `ticket_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) NOT NULL,
  `department_id` int(15) DEFAULT NULL,
  `domain_id` int(15) NOT NULL,
  `status_id` int(15) NOT NULL,
  `priority_id` int(15) NOT NULL,
  `subject` text,
  `channel_id` int(15) DEFAULT '1',
  `type_id` int(4) NOT NULL DEFAULT '0',
  `receive_date` int(15) DEFAULT NULL,
  `modify_date` int(15) DEFAULT NULL,
  `client_id` int(15) NOT NULL,
  `flag_id` int(15) DEFAULT '1',
  `language_id` int(15) DEFAULT '1',
  `attachment_count` int(15) DEFAULT '0',
  `post_count` int(15) DEFAULT '0',
  `last_replier_name` varchar(255) DEFAULT NULL,
		`last_replier_time` INT( 15 ) NOT NULL,
  `last_replier_email` varchar(255) DEFAULT NULL,
  `last_replier_id` varchar(512) DEFAULT NULL,
  `slaplan_id` int(15) DEFAULT '0',
  `due_time` int(15) DEFAULT '0',
  `resolution_time` int(15) DEFAULT '0',
  `source_from` tinyint(4) DEFAULT '0',
  `user_replied` tinyint(1) DEFAULT '0',
  `is_spam` tinyint(1) DEFAULT '0',
  `is_read` tinyint(1) DEFAULT '0',
  `is_deleted` tinyint(2) DEFAULT '0',
  `is_important` tinyint(1) DEFAULT '0',
  `recipients` text,
  `people` text,
  `draft_id` int(15) DEFAULT '0',
  `rating` int(4) DEFAULT '0',
  `integration_link` VARCHAR( 256 ) NOT NULL,
  `schedule_id` int(15) DEFAULT '0',
  `level_id` int(15) DEFAULT '0',
  `category_id` int(15) DEFAULT '0',
  `subcategory_id` int(15) DEFAULT '0',
  `item_id` int(15) DEFAULT '0',
  `location_id` int(15) DEFAULT '0',
  `closed_time` VARCHAR( 30 ) NOT NULL ,
  `pause_dtime` VARCHAR( 255 ) NOT NULL ,
  `pause_rtime` VARCHAR( 255 ) NOT NULL ,
		`sla_schedule_id` int(11) DEFAULT '0',
		`owner` VARCHAR( 255 ) DEFAULT NULL ,
		`message_id` TEXT NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `ticket_hash` (`ticket_hash`,`domain_id`),
  KEY `department_id` (`department_id`,`channel_id`,`flag_id`,`language_id`),
  KEY `is_spam` (`status_id`,`is_spam`,`is_deleted`,`draft_id`,`department_id`,`client_id`),
  KEY `receive_date` (`receive_date`,`modify_date`,`due_time`,`resolution_time`),
  KEY `client_id` (`client_id`),
  KEY `last_replier_id` (`last_replier_id`(256))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_assign`;
CREATE TABLE IF NOT EXISTS `avis_ticket_assign` (
  `assign_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(15) DEFAULT NULL,
  `owner_id` int(15) DEFAULT NULL,
  PRIMARY KEY (`assign_id`),  
  UNIQUE KEY `ticket_owner` (`ticket_id`,`owner_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_count`;
CREATE TABLE IF NOT EXISTS `avis_ticket_count` (
  `department_id` int(15) NOT NULL,
  `status_id` int(15) NOT NULL,
  `total_count` int(15) DEFAULT NULL,
  `group_id` INT(15) NOT NULL,
  PRIMARY KEY (`department_id`,`status_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_flag`;
CREATE TABLE IF NOT EXISTS `avis_ticket_flag` (
  `flag_id` int(15) NOT NULL AUTO_INCREMENT,
  `flag_color` varchar(63) DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`flag_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_ticket_flag` values (1,'#ffffff',1,1,1,0,'0');
insert into `avis_ticket_flag` values (2,'#00ff00',1,2,1,0,'0');
insert into `avis_ticket_flag` values (3,'#ff0000',1,3,1,0,'0');
DROP TABLE IF EXISTS `avis_ticket_link`;
CREATE TABLE IF NOT EXISTS `avis_ticket_link` (
  `link_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_ticket_id` int(11) NOT NULL,
  `link_type` tinyint(1) NOT NULL COMMENT '1-relates to, 2-is related to, 3-is a parent of, 4-is a child of, 5-depends on, 6-is depended on, 7-duplicates, 8-is duplicated by',
  `ticket_ids` text CHARACTER SET utf8 NOT NULL COMMENT 'Comma separated ticket ids',
  `id_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-Ticket, 1-Problem',
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_post`;
CREATE TABLE IF NOT EXISTS `avis_ticket_post` (
  `post_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(15) DEFAULT NULL,
  `content` longtext,
  `modify_date` int(15) DEFAULT NULL,
  `receive_date` int(15) DEFAULT NULL,
  `submitter_name` varchar(255) DEFAULT NULL,
  `submitter_email` varchar(255) DEFAULT NULL,
  `submitter` tinyint(1) DEFAULT '0' COMMENT '0-client, 1-staff',
  `submitter_id` int(15) DEFAULT NULL,
  `ipaddress` varchar(63) DEFAULT NULL,
  `commentid` varchar(200) DEFAULT NULL,
  `forward` varchar(255) DEFAULT NULL,
  `read_mark` tinyint(1) DEFAULT '0',
  `is_visible` tinyint(1) DEFAULT '1',
  `draft_id` int(15) DEFAULT '0',
  `from_dept_email` VARCHAR( 100 ) NOT NULL,
  `receiver_to` text,
  `receiver_cc` text,
  `receiver_bcc` text,
  `apply_macro` INT(11) NOT NULL,
  `reply_forward` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-reply, 2-forward',
  `received_via` tinyint(1) NULL DEFAULT '0' COMMENT '1-portal, 2-email, 3-api',
  `as_client` tinyint(1) NULL DEFAULT '0' COMMENT '1-vis_as_client',
  `integration_link` VARCHAR( 256 ) NOT NULL,
  PRIMARY KEY (`post_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_priority`;
CREATE TABLE IF NOT EXISTS `avis_ticket_priority` (
  `priority_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT '1',
  `color`  VARCHAR( 25 ) NULL DEFAULT '#788288',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`priority_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_ticket_priority` values (1,'',1,0,1,1,'#788288','0');
insert into `avis_ticket_priority` values (2,'',1,0,2,1,'#788288','0');
insert into `avis_ticket_priority` values (3,'',1,0,3,1,'#788288','0');
insert into `avis_ticket_priority` values (4,'',1,0,4,1,'#788288','0');
DROP TABLE IF EXISTS `avis_ticket_remark`;
CREATE TABLE IF NOT EXISTS `avis_ticket_remark` (
  `remark_id` int(15) NOT NULL AUTO_INCREMENT,
  `remark_type` int(4) NULL DEFAULT  '0' COMMENT  '3-problem,4-change,5-release',
  `remark_subtype` int(4) DEFAULT '0',
  `remark_method` int(1) NOT NULL DEFAULT '0' COMMENT '0 for comment, 1 for error',
  `parent_id` int(15) DEFAULT NULL,
  `content` text,
  `staff_id` int(15) DEFAULT NULL,
  `remark_date` int(15) DEFAULT NULL,
  `remark_header_bg_color` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`remark_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_status`;
CREATE TABLE IF NOT EXISTS `avis_ticket_status` (
  `status_id` int(15) NOT NULL AUTO_INCREMENT,
  `color` VARCHAR( 25 ) NOT NULL DEFAULT '#788288',
  `is_custom` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_ticket_status` values (1,'#788288',1,1,1,0,'0');
insert into `avis_ticket_status` values (2,'#788288',1,2,1,0,'0');
insert into `avis_ticket_status` values (3,'#788288',1,3,1,0,'0');
DROP TABLE IF EXISTS `avis_ticket_type`;
CREATE TABLE IF NOT EXISTS `avis_ticket_type` (
  `type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `image` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT NULL,
  `department_access` varchar(512) DEFAULT '0',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_ticket_type` values (1,'','',1,0,1,'0');
insert into `avis_ticket_type` values (2,'','',1,0,2,'0');
insert into `avis_ticket_type` values (3,'','',1,0,3,'0');
DROP TABLE IF EXISTS `avis_time_tracker`;
CREATE TABLE IF NOT EXISTS `avis_time_tracker` (
  `time_tracker_id` int(15) NOT NULL AUTO_INCREMENT,
  `bill_time` int(15) NOT NULL,
  `work_time` int(15) NOT NULL,
  `amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `description` text DEFAULT NULL,
  `ticket_id` int(15) DEFAULT NULL,
  `staff_id` int(15) DEFAULT NULL,
  `created_date` int(15) DEFAULT NULL,
  `modified_date` int(15) DEFAULT NULL,
  PRIMARY KEY (`time_tracker_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_toolbar`;
CREATE TABLE IF NOT EXISTS `avis_toolbar` (
  `toolbar_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT NULL,
  `ticket_all` tinyint(1) DEFAULT '1',
  `ticket_new` tinyint(1) DEFAULT '1',
  `ticket_overdue` tinyint(1) DEFAULT '1',
  `ticket_add` tinyint(1) DEFAULT '1',
  `fitler` tinyint(1) DEFAULT '1',
  `label` tinyint(1) DEFAULT '1',
  `client_all` tinyint(1) DEFAULT '1',
  `client_add` tinyint(1) DEFAULT '1',
  `client_group` tinyint(1) DEFAULT '1',
  `client_group_add` tinyint(1) DEFAULT '1',
  `staff_profile` tinyint(1) DEFAULT '1',
  `staff_setting` tinyint(1) DEFAULT '1',
  `staff_alert` tinyint(1) DEFAULT '1',
  `staff_calendar` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`toolbar_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_toolbar` values (1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
DROP TABLE IF EXISTS `avis_view`;
CREATE TABLE IF NOT EXISTS `avis_view` (
  `view_id` int(15) NOT NULL AUTO_INCREMENT,
  `view_name` varchar(255) DEFAULT NULL,
  `display_order` int(4) DEFAULT NULL,
  `owner` int(4) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `page_count` int(4) DEFAULT NULL,
  `navigate_to` int(4) DEFAULT NULL,
  `is_set` tinyint(1) DEFAULT '0',
  `is_default` tinyint(1) DEFAULT '0',
  `sort_by1` varchar(255) DEFAULT NULL,
  `sort_order1` enum('asc','desc') DEFAULT 'asc',
  `sort_by2` varchar(255) DEFAULT NULL,
  `sort_order2` enum('asc','desc') DEFAULT 'asc',
  `sort_by3` varchar(255) DEFAULT NULL,
  `sort_order3` enum('asc','desc') DEFAULT 'asc',
  PRIMARY KEY (`view_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_view` values (1,'Default',1,0,1,20,NULL,1,1,'user_replied','desc','modify_date','desc','due_time','asc');
DROP TABLE IF EXISTS `avis_view_access`;
CREATE TABLE IF NOT EXISTS `avis_view_access` (
  `access_id` int(15) NOT NULL AUTO_INCREMENT,
  `view_id` int(15) DEFAULT NULL,
  `tab_id` int(15) DEFAULT NULL,
  `sort_order` int(4) DEFAULT NULL,
  PRIMARY KEY (`access_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_view_access` values (1,1,1,NULL);
insert into `avis_view_access` values (2,1,2,NULL);
insert into `avis_view_access` values (3,1,3,NULL);
insert into `avis_view_access` values (4,1,5,NULL);
insert into `avis_view_access` values (5,1,6,NULL);
insert into `avis_view_access` values (6,1,10,NULL);
insert into `avis_view_access` values (7,1,9,NULL);
DROP TABLE IF EXISTS `avis_view_tab`;
CREATE TABLE IF NOT EXISTS `avis_view_tab` (
  `view_tab_id` int(15) NOT NULL AUTO_INCREMENT,
  `tab_name` varchar(255) DEFAULT NULL,
  `tab_title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`view_tab_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_view_tab` values (1,'ticket_hash','TXTTICKETHASH');
insert into `avis_view_tab` values (2,'subject','TXTSUBJECT');
insert into `avis_view_tab` values (3,'email','TXTEMAIL');
insert into `avis_view_tab` values (4,'domain_name','TXTDOMAIN');
insert into `avis_view_tab` values (5,'department_name','TXTDEPARTMENT');
insert into `avis_view_tab` values (6,'ticket_priority','TXTPRIORITY');
insert into `avis_view_tab` values (7,'modify_date','TXTMODIFIEDON');
insert into `avis_view_tab` values (8,'due_time','TXTDUETIME');
insert into `avis_view_tab` values (9,'flag_color','TXTFLAG');
insert into `avis_view_tab` values (10,'ticket_status','TXTSTATUS');
insert into `avis_view_tab` values (11,'owner','TXTOWNER');
insert into `avis_view_tab` values (12,'first_name','TXTFIRSTNAME');
insert into `avis_view_tab` values (13,'last_name','TXTLASTNAME');
insert into `avis_view_tab` values (14,'receive_date','TXTCREATEDATE');
insert into `avis_view_tab` values (15,'language_name','TXTLANGUAGE');
insert into `avis_view_tab` values (16,'last_replier_name','TXTLASTREPLIER');
insert into `avis_view_tab` values (17,'ticket_type','TXTTICKETTYPE');
insert into `avis_view_tab` values (18,'resolution_time','TXTRESOLUTIONTIME');
insert into `avis_view_tab` values (19, 'star', 'TXTSTAR');
insert into `avis_view_tab` values (20, 'label', 'TXTLABEL');
insert into `avis_view_tab` values (21, 'link', 'TXTLINK');
insert into `avis_view_tab` values (22,'attachment','TXTATTACHMENT');
insert into `avis_view_tab` (`view_tab_id`, `tab_name`, `tab_title`) VALUES (23, 'organization', 'TXTORGANIZATION'), (24, 'company_name', 'TXTCOMPANYNAME');
INSERT INTO `avis_view_tab` (`view_tab_id`, `tab_name`, `tab_title`) VALUES ('25', 'last_replier_time', 'TXTLASTREPLIERTIME');
INSERT INTO `avis_view_tab` (`view_tab_id`, `tab_name`, `tab_title`) VALUES (26, 'ticket_category', 'TXTCATEGORY'), (27, 'ticket_sub_cateogy', 'TXTTICKETSUBCATEGORY'), (28, 'ticket_item', 'TXTTICKETITEM'), (29, 'ticket_level', 'TXTTICKETLEVEL'), (30, 'location', 'TXTLOCATION');

DROP TABLE IF EXISTS `avis_workflow`;
CREATE TABLE IF NOT EXISTS `avis_workflow` (
  `workflow_id` int(15) NOT NULL AUTO_INCREMENT,
  `workflow_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT NULL,
  `concat_type` varchar(63) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT NULL,
  `creation_date` int(15) DEFAULT NULL,
  `event` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`workflow_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_workflow` values (1,'Default workflow',1,'or',1,1,unix_timestamp(),'0,1');
DROP TABLE IF EXISTS `avis_workflow_action`;
CREATE TABLE IF NOT EXISTS `avis_workflow_action` (
  `waction_id` int(15) NOT NULL AUTO_INCREMENT,
  `workflow_id` int(15) DEFAULT NULL,
  `action_id` int(15) DEFAULT NULL,
  `content` text,
  PRIMARY KEY (`waction_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_workflow_action` values (1,1,1,'0');
insert into `avis_workflow_action` values (2,1,2,'');
insert into `avis_workflow_action` values (3,1,3,'1');
insert into `avis_workflow_action` values (4,1,4,'0');
insert into `avis_workflow_action` values (5,1,5,'0');
insert into `avis_workflow_action` values (6,1,6,'0');
insert into `avis_workflow_action` values (7,1,7,'1');
insert into `avis_workflow_action` values (8,1,8,'0');
insert into `avis_workflow_action` values (9,1,9,'0');
insert into `avis_workflow_action` values (10,1,10,'1');
insert into `avis_workflow_action` values (11,1,11,'1');
insert into `avis_workflow_action` values (12,1,12,'0');
insert into `avis_workflow_action` values (13,1,13,'');
insert into `avis_workflow_action` values (14,1,14,'0');
insert into `avis_workflow_action` values (15,1,15,'0');
insert into `avis_workflow_action` values (16,1,16,'');
insert into `avis_workflow_action` values (17,1,17,'0');
insert into `avis_workflow_action` values (18,1,18,'');
insert into `avis_workflow_action` values (19,1,19,'0');
insert into `avis_workflow_action` values (20,1,20,'');
DROP TABLE IF EXISTS `avis_workflow_criteria`;
CREATE TABLE IF NOT EXISTS `avis_workflow_criteria` (
  `wcriteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `workflow_id` int(15) NOT NULL,
  `base_criteria` int(15) DEFAULT NULL,
  `sub_criteria` int(15) DEFAULT '0',
  `content` text,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`wcriteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_workflow_criteria` values (1,1,0,0,'','or');
insert into `avis_workflow_criteria` values (2,1,0,0,'','and');
DROP TABLE IF EXISTS `avis_exportlist`;
CREATE TABLE IF NOT EXISTS `avis_exportlist` (
  `export_id` int(15) NOT NULL AUTO_INCREMENT,
  `export_name` varchar(255) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `filter` text NOT NULL,
  `department_id` int(15) NOT NULL,
  `is_completed` int(2) NOT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `report_time` int(15) NULL DEFAULT '0',
  `database_name` varchar(255) NOT NULL,
  `database_user` varchar(255) NOT NULL,
  `database_password` varchar(255) NOT NULL,
  `report_type` int(2) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `staff_email` varchar(255) NOT NULL,
  `request_date` datetime NOT NULL,
		`export_type` INT( 11 ) NOT NULL COMMENT '1=csv,2=html,3=xls',
		`send_email` INT NOT NULL COMMENT '1=yes,no=0',
		`email_id` VARCHAR( 100 ) NOT NULL,
		`receive_date` INT( 15 ) NOT NULL,
  PRIMARY KEY (`export_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_twilio`;
CREATE TABLE IF NOT EXISTS `avis_twilio` (
  `twilio_id` int(11) NOT NULL AUTO_INCREMENT,
  `integration_id` int(11) NOT NULL,
  `title` varchar(250) NOT NULL,
  `twilio_number` varchar(50) NOT NULL,
  `app_sid` varchar(250) NOT NULL,
  `message` varchar(250) NOT NULL,
  `is_outbound` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`twilio_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_twilio_staff`;
CREATE TABLE IF NOT EXISTS `avis_twilio_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `twilio_id` int(11) NOT NULL,
  `key_press` int(11) NOT NULL,
  `key_messages` VARCHAR( 250 ) NOT NULL,
  `department_id` int(11) NOT NULL,
  `staff` varchar(500) NOT NULL,
  `forward_to` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `avis_twilio_forward` (
  `forward_id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `forward_number` varchar(250) CHARACTER SET latin1 NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`forward_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `avis_settings` (`title`, `content`, `domain_id`, `department_id`, `module_id`) VALUES ('vis_task_mail_send', '1', '0', '0', '11');
INSERT INTO `avis_emailtemplate` (`etemplate_id` ,`etemplate_name` ,`subject` ,`content` ,`is_enabled` ,`default_id` ,`is_itil`) VALUES ( '23' , 'New task assigned', 'New task assigned', 'Hello {first_name} {last_name}<br>New task has been assigned to you by {staff_name}<br><br><strong><strong>Following are task details :</strong><strong></strong> </strong><br>Title: {title}<br>Description: {description}<br>Status: {status}<br>Priority: {priority}<br>Start date: {start date}<br>End date: {end date}<br><br>Please click on following link to see task details :<br>{view_task_link}<br><br>', '1', '23', '0');
INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `is_enabled`, `default_id`, `is_itil`) VALUES ('24', 'New comment added to task', 'New comment added to task : {title}', 'Hello {first_name} {last_name},<br> New comment added to task by {staff_name}<br><br><strong>Task comment details : </strong><br>Title: {title}<br>Comment: {comment}<br><br>Please click on following link to see task details :<br>{view_task_link}<br><br>', '1', '24', '0');
INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `is_enabled`, `default_id`, `is_itil`) VALUES ('25', 'New forum topic', 'New forum topic added :{topic_title}', 'Hello {username},<br><br>New forum topic added <strong>{topic_title} </strong>in [{domain} > {forum_category} > {forum_title}]<br><strong>Created by</strong> : {poster_name}<br><strong>Details </strong>:<br>{details}<strong><br></strong><strong>Please follow below link </strong>:<br>{topic_link}', '1', '25', '0');
INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `is_enabled`, `default_id`, `is_itil`) VALUES ('26', 'New reply for forum topic', 'New forum topic comment added : {topic_title}', 'Hello {username},<br><br>New forum topic added <strong>{topic_title}</strong> in [{domain} > {forum_category} > {forum_title}]<br><strong>Created by</strong> : {poster_name}<br><strong>Details</strong>:<br>{details}<br><br>Please follow below link<br>{topic_link}', '1', '26', '0');
DROP TABLE IF EXISTS `avis_forum`;
CREATE TABLE IF NOT EXISTS `avis_forum` (
  `forum_id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_cat_id` int(11) NOT NULL,
  `description` text NOT NULL,
  `creation_date` int(15) NOT NULL,
  `topic_access` INT(4) NULL DEFAULT NULL,
  `display_status` tinyint(1) NOT NULL COMMENT '0-everyone,1-logged in,2-only staff client',
  `display_order` int(15) NOT NULL,
  `is_topic_move` tinyint(4) NOT NULL COMMENT '0 for No, 1 for Yes',
  PRIMARY KEY (`forum_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_forum_activity_log`;
CREATE TABLE IF NOT EXISTS `avis_forum_activity_log` (
  `activity_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `parent_type` tinyint(4) NOT NULL COMMENT '0 for topc, 1 for comment',
  `entry_date` int(15) NOT NULL,
  `content` varchar(255) NOT NULL,
  `domain_id` int(11) NOT NULL,
  `is_spam` tinyint(4) NOT NULL,
  `is_approved` tinyint(4) NOT NULL,
  `is_client` tinyint(4) NOT NULL COMMENT '0 for staff,1 for client',
  `poster_id` int(11) NOT NULL,
		`topic_id` INT( 11 ) NOT NULL,
  PRIMARY KEY (`activity_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_forum_category`;
CREATE TABLE IF NOT EXISTS `avis_forum_category` (
  `forum_cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) NOT NULL,
  `description` text NOT NULL,
  `display_order` int(15) NOT NULL,
  `access_type` tinyint(2) NOT NULL COMMENT '0 for public,1 for private',
  PRIMARY KEY (`forum_cat_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_forum_comment`;
CREATE TABLE IF NOT EXISTS `avis_forum_comment` (
  `comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) NOT NULL,
  `poster_id` int(11) NOT NULL,
  `poster_type` tinyint(1) NOT NULL COMMENT '1 for client, 0 for staff',
  `content` longtext NOT NULL,
  `entry_date` int(15) NOT NULL,
  `is_approved` tinyint(1) NOT NULL,
  `is_spam` tinyint(1) NOT NULL,
  PRIMARY KEY (`comment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_forum_topic`;
CREATE TABLE IF NOT EXISTS `avis_forum_topic` (
  `topic_id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_id` int(11) NOT NULL,
  `title` text NOT NULL,
  `topic_url`varchar(255) NOT NULL,
  `description` longtext NOT NULL,
  `user_id` int(11) NOT NULL,
  `is_client` int(11) NOT NULL,
  `is_lock` int(11) NOT NULL,
  `creation_date` int(15) NOT NULL,
  `modify_date` int(15) NOT NULL,
  `is_spam` int(11) NOT NULL,
  `is_approved` tinyint(1) NOT NULL COMMENT '0 for disapprove, 1 for approve',
  `is_sticky` tinyint(2) NOT NULL,
  PRIMARY KEY (`topic_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_forum_topic_followers`;
CREATE TABLE IF NOT EXISTS `avis_forum_topic_followers` (
  `follow_id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) NOT NULL,
  `follower_id` int(11) NOT NULL,
  `follower_type` tinyint(1) NOT NULL COMMENT '1 for client, 0 for staff',
  `entry_date` int(15) NOT NULL,
  PRIMARY KEY (`follow_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_forum_topic_likes`;
CREATE TABLE IF NOT EXISTS `avis_forum_topic_likes` (
  `like_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `parent_type` tinyint(4) NOT NULL COMMENT '0 for topc, 1 for comment',
  `poster_id` int(11) NOT NULL,
  `poster_type` tinyint(1) NOT NULL COMMENT '1 for client, 0 for staff',
  `entry_date` int(15) NOT NULL,
  PRIMARY KEY (`like_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_schedule`;
CREATE TABLE IF NOT EXISTS `avis_ticket_schedule` (
  `schedule_id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) NOT NULL,
  `startdate` int(15) NOT NULL,
  `enddate` int(15) NOT NULL,
  `scedule_type` tinyint(1) NOT NULL COMMENT '0=Never, 1 = Daily, 2=weekly, 3=monthly',
  `days` varchar(250) NOT NULL COMMENT '1=sun, 2=mon, 3=tue, 4=wen, 5=thu, 6=fri, 7=sat',
  `creation_date` int(11) NOT NULL COMMENT 'time stamp for create tickit once per day/week/month',
  `send_email` tinyint(1) NOT NULL COMMENT '1=yes, 0= no',
  `auto_responder` tinyint(1) NOT NULL COMMENT '1 = yes 0 = no',
  PRIMARY KEY (`schedule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `avis_ticket_category`;
CREATE TABLE IF NOT EXISTS `avis_ticket_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `access_type` TINYINT( 2 ) NOT NULL DEFAULT '0',
  `display_order` int(15) NOT NULL,
  `department_access` varchar(512) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
INSERT INTO `avis_ticket_category` (`category_id`, `access_type`, `display_order`, `department_access`, `is_enabled`) VALUES
(1, 0, 1, '0', 1),
(2, 0, 2, '0', 1);
DROP TABLE IF EXISTS `avis_ticket_item`;
CREATE TABLE IF NOT EXISTS `avis_ticket_item` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `subcategory_id` int(11) NOT NULL,
  `access_type` tinyint(2) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '1',
  `display_order` int(15) NOT NULL,
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=9 ;
INSERT INTO `avis_ticket_item` (`item_id`, `subcategory_id`, `access_type`, `is_enabled`, `display_order`) VALUES
(1, 1, 0, 1, 1),
(2, 1, 0, 1, 2),
(3, 1, 0, 1, 3),
(4, 2, 0, 1, 4),
(5, 2, 0, 1, 5),
(6, 2, 0, 1, 6),
(7, 3, 0, 1, 7),
(8, 3, 0, 1, 8);
DROP TABLE IF EXISTS `avis_ticket_level`;
CREATE TABLE IF NOT EXISTS `avis_ticket_level` (
  `level_id` int(11) NOT NULL AUTO_INCREMENT,
  `access_type` TINYINT( 2 ) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '1',
  `display_order` tinyint(4) NOT NULL DEFAULT '0',
  `department_access` VARCHAR(512) NOT NULL DEFAULT '0',
  PRIMARY KEY (`level_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
INSERT INTO `avis_ticket_level` (`level_id`, `access_type`, `is_enabled`, `display_order`, `department_access`) VALUES
(1, 0, 1, 1, '0'),
(2, 0, 1, 2, '0'),
(3, 0, 1, 3, '0');
DROP TABLE IF EXISTS `avis_ticket_subcategory`;
CREATE TABLE IF NOT EXISTS `avis_ticket_subcategory` (
  `subcategory_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `access_type` TINYINT( 2 ) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '1',
  `display_order` int(15) NOT NULL,
  PRIMARY KEY (`subcategory_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
INSERT INTO `avis_ticket_subcategory` (`subcategory_id`, `category_id`, `access_type`, `is_enabled`, `display_order`) VALUES
(1, 1, 0, 1, 1),
(2, 1, 0, 1, 2),
(3, 2, 0, 1, 3);

DROP TABLE IF EXISTS `avis_sendmail_queue`;
CREATE TABLE IF NOT EXISTS `avis_sendmail_queue` (  `queue_id` int(15) NOT NULL AUTO_INCREMENT,  `content` longtext CHARACTER SET utf8,  `operation` varchar(255) CHARACTER SET utf8 DEFAULT NULL,  `staff_id` int(15) NOT NULL,  `location` int(15) NOT NULL, `flag` TINYINT( 1 ) NOT NULL DEFAULT '1',  PRIMARY KEY (`queue_id`)) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `is_enabled`, `default_id`, `is_itil`) VALUES ('27', 'Forum topic approved', 'Forum topic approved :{topic_title}', '<p>Hello {username},</p><p><br>Forum topic <strong>{topic_title} </strong>in [{domain} > {forum_category} > {forum_title}] is approved<br><strong>Created by</strong> : {poster_name}<br><strong>Details </strong>:<br>{details}<strong><br></strong><strong>Please visit below link </strong>:<br>{topic_link}</p>', '1', '27', '0');

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `is_enabled`, `default_id`, `is_itil`) VALUES ('28', 'Topic comment approved', 'Forum topic comment approved', '<p>Hello {username},</p><p><br>Forum topic <strong>{topic_title} </strong>in [{domain} > {forum_category} > {forum_title}] comment is approved<br><strong>Created by</strong> : {poster_name}<br><strong>Details </strong>:<br>{details}<strong><br></strong><strong>Please visit below link </strong>:<br>{topic_link}</p>', '1', '28', '0');

DROP TABLE IF EXISTS `avis_dst_setting`;
CREATE TABLE IF NOT EXISTS `avis_dst_setting` (
  `timezone_id` int(11) NOT NULL AUTO_INCREMENT,
  `timezone` varchar(50) NOT NULL,
  `dst_timezone` int(11) NOT NULL COMMENT '0=No DST,1=DST',
  `dst_start_date` varchar(50) NOT NULL,
  `dst_end_date` varchar(50) NOT NULL,
  `dst_flag` int(11) NOT NULL DEFAULT '0' COMMENT '0 for same year, 1 for previous year, 2 for next year ',
  PRIMARY KEY (`timezone_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=47 ;

INSERT INTO `avis_dst_setting` (`timezone_id`, `timezone`, `dst_timezone`, `dst_start_date`, `dst_end_date`, `dst_flag`) VALUES
(1, '-43200', 0, '', '', 0),
(2, '-39600', 0, '', '', 0),
(3, '-36000', 0, '', '', 0),
(4, '-34200', 0, '', '', 0),
(5, '-32400', 0, '', '', 0),
(6, '-28800', 0, '', '', 0),
(7, '-28800', 1, '13-03', '06-11', 0),
(8, '-25200', 0, '', '', 0),
(9, '-25200', 1, '13-03', '06-11', 0),
(10, '-21600', 0, '', '', 0),
(11, '-21600', 1, '03-04', '30-10', 0),
(12, '-18000', 0, '', '', 0),
(13, '-18000', 1, '13-03', '06-11', 0),
(14, '-14400', 0, '', '', 0),
(15, '-14400', 1, '13-03', '06-11', 0),
(16, '-12600', 1, '13-03', '06-11', 0),
(17, '-10800', 0, '', '', 0),
(18, '-10800', 1, '16-10', '21-02', 1),
(19, '-7200', 0, '', '', 0),
(20, '-3600', 0, '', '', 0),
(21, '-3600', 1, '27-03', '30-10', 0),
(22, '+0', 0, '', '', 0),
(23, '+0', 1, '27-03', '30-10', 0),
(24, '+3600', 0, '', '', 0),
(25, '+3600', 1, '27-03', '30-10', 0),
(26, '+7200', 0, '', '', 0),
(27, '+7200', 1, '27-03', '30-10', 0),
(28, '+10800', 0, '', '', 0),
(29, '+10800', 1, '27-03', '30-10', 0),
(30, '+12600', 1, '21-03', '21-09', 0),
(31, '+14400', 0, '', '', 0),
(32, '+16200', 0, '', '', 0),
(33, '+18000', 0, '', '', 0),
(34, '+19800', 0, '', '', 0),
(35, '+21600', 0, '', '', 0),
(36, '+23400', 0, '', '', 0),
(37, '+25200', 0, '', '', 0),
(38, '+28800', 0, '', '', 0),
(39, '+32400', 0, '', '', 0),
(40, '+34200', 0, '', '', 0),
(41, '+36000', 0, '', '', 0),
(42, '+37800', 1, '02-10', '03-04', 1),
(43, '+39600', 0, '', '', 0),
(44, '+39600', 1, '02-10', '03-04', 1),
(45, '+43200', 0, '', '', 0),
(46, '+43200', 1, '06-11', '17-01', 1),
(47, '+46800', 0, '', '', 0),
(48, '+46800', 1, '25-09', '03-04', 1);

DROP TABLE IF EXISTS `avis_client_email`;
CREATE TABLE IF NOT EXISTS `avis_client_email` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `additional_email` varchar(255) NOT NULL,
  `is_verified` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`email_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=11 ;

INSERT INTO `avis_settings` (`title`, `content`, `domain_id`, `department_id`, `module_id`) VALUES ('vis_show_time_track_amount', '1', '0', '0', '2');

CREATE TABLE IF NOT EXISTS `avis_exotel_apps` (
`exotel_id` int(11) NOT NULL AUTO_INCREMENT,
`integration_id` int(11) NOT NULL,
`app_name` varchar(255) NOT NULL,
`exophones` text NOT NULL,
`app_id` int(11) NOT NULL,
`department` VARCHAR( 20 ) NOT NULL,
`status` tinyint(1) NOT NULL,
`auto_ticket` tinyint(1) NOT NULL,
PRIMARY KEY (`exotel_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `avis_exo_call_details` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`api_response` text NOT NULL,
`success_status` tinyint(1) NOT NULL,
`staff_id` int(11) NOT NULL,
`sid` varchar(500) NOT NULL,
`domain` int(11) NOT NULL,
`request_type` tinyint(1) NOT NULL COMMENT '0=call, 1=sms',
`from_no` varchar(500) NOT NULL,
`to_no` varchar(500) NOT NULL,
`auto_ticket` int(11) NOT NULL DEFAULT '0',
`department` VARCHAR( 255 ) NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `avis_schedule_report`;
CREATE TABLE IF NOT EXISTS `avis_schedule_report` (
  `rschedule_id` int(11) NOT NULL AUTO_INCREMENT,
  `report_type` int(2) NOT NULL,
  `report_title` varchar(255) NOT NULL,
  `start_date` int(15) NOT NULL,
  `end_date` int(15) NOT NULL,
  `total_recurrence` INT NOT NULL,
  `schedule_type` tinyint(4) NOT NULL COMMENT '0=once,1=daily,2=weekly, 3=monthly,4=quaterly,5=yearly',
  `export_type` int(11) NOT NULL COMMENT '1=csv,2=html,3=xls',
  `send_email` tinyint(4) NOT NULL,
  `email_id` varchar(255) NOT NULL,
  `creation_date` int(15) NOT NULL,
  `report_filter` text NOT NULL,
  `date_range_filter` text NOT NULL,
  `domain_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `staff_email` varchar(255) NOT NULL,
  `domain` varchar(255) NOT NULL,
  PRIMARY KEY (`rschedule_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`) VALUES
(29, 'Report download', ' Helpdesk report - {report_title}', '<p>Report available for download .<br><a href="{download_report_link}">{download_report_link}</a><br><br></p>', 1, 29, 0, 1, 0);


DROP TABLE IF EXISTS `avis_formgroup`;
CREATE TABLE IF NOT EXISTS `avis_formgroup` (
  `formgroup_id` int(15) NOT NULL AUTO_INCREMENT,
  `formgroup_name` varchar(255) DEFAULT NULL,
  `form_name` varchar(500) NOT NULL,
  `description` text,
  `display_order` int(15) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `script` longtext NOT NULL,
  `form_type` tinyint(1) NOT NULL COMMENT '1=email base,0=call base',
  `department` varchar(10) NOT NULL,
  `subject` varchar(250) NOT NULL,
  `captcha` tinyint(4) NOT NULL COMMENT '1=yes,0=no',
  `hdformheader` TINYINT( 1 ) NOT NULL DEFAULT '1',
  PRIMARY KEY (`formgroup_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_formfield`;
CREATE TABLE IF NOT EXISTS `avis_formfield` (
  `formfield_id` int(15) NOT NULL AUTO_INCREMENT,
  `formgroup_id` int(15) DEFAULT NULL,
  `ci_type` int(4) DEFAULT '0',
  `field_type` int(4) DEFAULT '1',
  `field_group` int(15) DEFAULT NULL,
  `field_name` varchar(255) DEFAULT NULL,
  `field_description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `display_order` int(15) DEFAULT NULL,
  `default_value` varchar(255) DEFAULT NULL,
  `is_selected` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) NOT NULL,
  `is_required` tinyint(1) DEFAULT '0',
  `is_staff_editable` tinyint(1) DEFAULT '0',
  `is_user_editable` tinyint(1) DEFAULT '0',
  `regular_expression` varchar(255) DEFAULT NULL,
  `is_editor` tinyint(1) NOT NULL COMMENT '1=yes,0=no',
  `placeholder` varchar(200) NOT NULL,
  `tooltip` varchar(500) NOT NULL,
  `html_attribute` text NOT NULL,
  `inline` tinyint(4) NOT NULL COMMENT '1=yes,0=no',
  `no_of_file` int(11) NOT NULL,
  PRIMARY KEY (`formfield_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`) VALUES
(30, 'Task overdue reminder', 'Task overdue reminder', 'Hello,<br>Task created by you or assigned to you will be overdue in next 24 hour.<br><br><strong><strong>Task details :</strong><strong></strong> </strong><br>Task title: {title}<br>Task Description: {description}<br>Task Status: {status}<br>Task Priority: {priority}<br>Start date: {start date}<br>End date: {end date}<br><br>Please visit below link to view more details<br>{view_task_link}<br><br><br>', 1, 30, 0, 1, 0);

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`) VALUES
(31, 'Task overdue', 'Task overdue', 'Hello,<br>Task created by you or assigned to you is overdue today.<br><br><strong><strong>Overdue task details :</strong><strong></strong> </strong><br>Task title: {title}<br>Task description: {description}<br>Task status: {status}<br>Task priority: {priority}<br>Start date: {start date}<br>End date: {end date}<br><br>Please visit below link to view more details<br>{view_task_link}<br><br>', 1, 31, 0, 1, 0);


INSERT INTO `avis_workflow` (`workflow_id`, `workflow_name`, `execution_order`, `concat_type`, `is_enabled`, `owner`, `creation_date`, `event`) VALUES
(2, 'Client feedback on ticket close', 2, NULL, 0, 1, 1467882193, '6'),
(3, 'Self assign ticket on staff reply', 3, NULL, 0, 1, 1467882481, '2'),
(4, 'Apply 5 days workflow for auto close', 4, NULL, 0, 1, 1467882550, '14,15'),
(5, 'Auto close awaiting tickets after 5 days', 5, NULL, 0, 1, 1467882663, '14,15'); 
INSERT INTO `avis_workflow_action` (`waction_id`, `workflow_id`, `action_id`, `content`) VALUES
(21, 2, 1, '0'),
(22, 2, 2, ''),
(23, 2, 3, '0'),
(24, 2, 4, '0'),
(25, 2, 5, '0'),
(26, 2, 6, '0'),
(27, 2, 7, '0'),
(28, 2, 9, '0'),
(29, 2, 10, '1'),
(30, 2, 11, '1'),
(31, 2, 12, '0'),
(32, 2, 13, ''),
(33, 2, 14, '0'),
(34, 2, 15, '0'),
(35, 2, 16, ''),
(36, 2, 17, '0'),
(37, 2, 18, ''),
(38, 2, 19, '0'),
(39, 2, 21, '0'),
(40, 2, 22, '0'),
(41, 2, 23, '0'),
(42, 2, 24, '0'),
(43, 2, 25, ''),
(44, 2, 26, '22'),
(45, 2, 27, ''),
(46, 2, 28, '0'),
(47, 3, 1, '0'),
(48, 3, 2, 'VIS_STAFF_ID'),
(49, 3, 3, '0'),
(50, 3, 4, '0'),
(51, 3, 5, '0'),
(52, 3, 6, '0'),
(53, 3, 7, '0'),
(54, 3, 9, '0'),
(55, 3, 10, '1'),
(56, 3, 11, '1'),
(57, 3, 12, '0'),
(58, 3, 13, ''),
(59, 3, 14, '0'),
(60, 3, 15, '0'),
(61, 3, 16, ''),
(62, 3, 17, '0'),
(63, 3, 18, ''),
(64, 3, 19, '0'),
(65, 3, 21, '0'),
(66, 3, 22, '0'),
(67, 3, 23, '0'),
(68, 3, 24, '0'),
(69, 3, 25, ''),
(70, 3, 26, '0'),
(71, 3, 27, ''),
(72, 3, 28, '0'),
(73, 4, 1, '0'),
(74, 4, 2, ''),
(75, 4, 3, '0'),
(76, 4, 4, '0'),
(77, 4, 5, '0'),
(78, 4, 6, '0'),
(79, 4, 7, '2'),
(80, 4, 9, '0'),
(81, 4, 10, '1'),
(82, 4, 11, '1'),
(83, 4, 12, '0'),
(84, 4, 13, ''),
(85, 4, 14, '0'),
(86, 4, 15, '0'),
(87, 4, 16, ''),
(88, 4, 17, '0'),
(89, 4, 18, ''),
(90, 4, 19, '0'),
(91, 4, 21, '0'),
(92, 4, 22, '0'),
(93, 4, 23, '0'),
(94, 4, 24, '0'),
(95, 4, 25, ''),
(96, 4, 26, '0'),
(97, 4, 27, ''),
(98, 4, 28, '0'),
(99, 5, 1, '0'),
(100, 5, 2, ''),
(101, 5, 3, '3'),
(102, 5, 4, '0'),
(103, 5, 5, '0'),
(104, 5, 6, '0'),
(105, 5, 7, '0'),
(106, 5, 9, '0'),
(107, 5, 10, '1'),
(108, 5, 11, '1'),
(109, 5, 12, '0'),
(110, 5, 13, ''),
(111, 5, 14, '0'),
(112, 5, 15, '0'),
(113, 5, 16, ''),
(114, 5, 17, '0'),
(115, 5, 18, ''),
(116, 5, 19, '0'),
(117, 5, 21, '0'),
(118, 5, 22, '0'),
(119, 5, 23, '0'),
(120, 5, 24, '0'),
(121, 5, 25, ''),
(122, 5, 26, '7'),
(123, 5, 27, ''),
(124, 5, 28, '0'); 
INSERT INTO `avis_workflow_criteria` (`wcriteria_id`, `workflow_id`, `base_criteria`, `sub_criteria`, `content`, `concat_type`) VALUES
(3, 2, 8, 0, '3', 'and'),
(4, 2, 0, 0, '', 'or'),
(5, 3, 0, 0, '', 'and'),
(6, 3, 0, 0, '', 'or'),
(7, 4, 8, 0, '2', 'and'),
(8, 4, 0, 0, '', 'or'),
(9, 5, 15, 0, '', 'and'),
(10, 5, 8, 0, '2', 'and'),
(11, 5, 0, 0, '', 'or'); 
INSERT INTO `avis_alert` (`alert_id`, `alert_name`, `owner`, `vscope`, `sms_enabled`, `is_enabled`, `display_order`, `concat_type`, `event`, `template`, `reciever`, `reciever_team`) VALUES
(1, 'New ticket notification to default team', 1, 0, 0, 0, 1, 'and', '0', 8, '1', '1'),
(2, 'Ticket assigned to default team', 1, 0, 0, 0, 2, 'and', '8', 8, '1', '1'); 
INSERT INTO `avis_alert_criteria` (`criteria_id`, `alert_id`, `base_criteria`, `sub_criteria`, `content`, `concat_type`) VALUES
(1, 1, 0, 0, '', 'and'),
(2, 1, 0, 0, '', 'or'),
(3, 2, 10, 0, '0', 'and'),
(4, 2, 0, 0, '', 'or'); 
INSERT INTO `avis_client` (`client_id`, `group_id`, `first_name`, `last_name`, `initials`, `user_name`, `email`, `authentication`, `salt`, `contact_number`, `mobile_number`, `temporary_address`, `permanent_address`, `city`, `state`, `zip_code`, `country`, `website`, `fax`, `office_name`, `office_email`, `office_contact_num`, `office_address`, `office_phone`, `office_fax`, `office_website`, `job_title`, `department`, `gender`, `birthdate`, `netmeetingid`, `twitter_id`, `facebook_id`, `otherim`, `is_spam`, `is_banned`, `is_approved`, `is_verified`, `parent_id`, `domain_id`, `optionB_domain_id`, `credit`, `balance`, `image_path`, `language`, `login_as`, `department_access`, `client_type`, `password_auth`, `forum_signature_content`, `forum_email_notification`, `is_manager`) VALUES
(1, 1, 'Sample', 'Customer', NULL, 'customer@iamdemo.com', 'customer@iamdemo.com', 'xZisoLyXrao=', 'ce9a9a5bfc188d0f632db45561d6fda5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1, 0, 1, 1, '0.00', 0, NULL, 1, 0, '0', 0, NULL, NULL, 1, 0); 

INSERT INTO `avis_ticket` (`ticket_id`, `ticket_hash`, `department_id`, `domain_id`, `status_id`, `priority_id`, `subject`, `channel_id`, `type_id`, `receive_date`, `modify_date`, `client_id`, `flag_id`, `language_id`, `attachment_count`, `post_count`, `last_replier_name`, `last_replier_time`, `last_replier_email`, `last_replier_id`, `slaplan_id`, `due_time`, `resolution_time`, `source_from`, `user_replied`, `is_spam`, `is_read`, `is_deleted`, `is_important`, `recipients`, `people`, `draft_id`, `rating`, `integration_link`, `schedule_id`, `level_id`, `category_id`, `subcategory_id`, `item_id`, `location_id`, `closed_time`, `pause_dtime`, `pause_rtime`, `sla_schedule_id`, `owner`, `message_id`) VALUES
(2, 'ZSYJ-432161', 1, 1, 1, 1, 'Sample internal ticket', 1, 1, UNIX_TIMESTAMP(NOW()), UNIX_TIMESTAMP(NOW()), 0, 1, 1, 0, 1, 'Administrator', '', 'admin@test.com', '1', 1, '', '', 0, 0, 0, 0, 0, 0, NULL, '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', '', 0, '', ''),
(1, 'DEDU-770596', 1, 1, 1, 1, 'Sample ticket', 5, 1, UNIX_TIMESTAMP(NOW()), UNIX_TIMESTAMP(NOW()), 1, 1, 1, 0, 1, 'Sample Customer', '', 'customer@iamdemo.com', '1', 1, '', '', 0, 1, 0, 0, 0, 0, 'customer@iamdemo.com', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', '', 0, '', ''); 
INSERT INTO `avis_ticket_post` (`post_id`, `ticket_id`, `content`, `modify_date`, `receive_date`, `submitter_name`, `submitter_email`, `submitter`, `submitter_id`, `ipaddress`, `commentid`, `forward`, `read_mark`, `is_visible`, `draft_id`, `from_dept_email`, `receiver_to`, `receiver_cc`, `receiver_bcc`, `apply_macro`, `reply_forward`, `received_via`, `as_client`, `integration_link`) VALUES
(1, 2, 'This is sample ticket message.<br>', NULL, UNIX_TIMESTAMP(NOW()), 'Administrator', 'admin@test.com', 0, 1, '127.0.0.1', NULL, NULL, 0, 1, 0, 'Vision helpdesk <admin@test.com>', '', '', '', 0, 0, 1, 0, ''),
(2, 1, 'This is sample ticket message', NULL, UNIX_TIMESTAMP(NOW()), 'Sample Customer', 'customer@iamdemo.com', 1, 1, '127.0.0.1', NULL, NULL, 0, 1, 0, '', 'General', '', '', 0, 0, 1, 0, '');

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`) VALUES
(32, 'Task status changed', 'Task status changed', 'Hello {first_name} {last_name},<br>Task status changed by {staff_name}<br><br>Following are task details : <br>Title: {title}<br>Description: {description}<br>Status: {status}<br>Priority: {priority}<br>Start date: {start date}<br>End date: {end date}<br><br>Please click on following link to see task details :<br>{view_task_link}<br><br>', 1, 32, 0, 1, 0);

DROP TABLE IF EXISTS `avis_ticket_approvals`;
CREATE TABLE IF NOT EXISTS `avis_ticket_approvals` (
  `approvals_id` int(11) NOT NULL AUTO_INCREMENT,
  `approvals_type` tinyint(2) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `approvals_status` tinyint(2) NOT NULL COMMENT '0-requested, 1-approved, 2-cancelled, 3-rejected',
  `send_date` varchar(20) NOT NULL,
  `status_date` varchar(20) NOT NULL,
  `remark` text NOT NULL,
  `is_enabled` int(11) NOT NULL,
  PRIMARY KEY (`approvals_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `display_order`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`) VALUES (33, 'Ticket approval', 'Approval request for ticket ', 'Hello {first_name} {last_name},<br><br>Approval request for ticket {ticket_hash} {subject} is waiting for your approval. <br>Please visit <a href="{ticket_approval_link}">{ticket_approval_link}</a> and confirm your approval.', 0, 1, 33, 1, 1, 0);

DROP TABLE IF EXISTS `avis_roundrobin`;
CREATE TABLE IF NOT EXISTS `avis_roundrobin` (
  `roundrobin_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT NULL,
  `schedule_id` int(15) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT NULL,
  `creation_date` int(15) DEFAULT NULL,
  PRIMARY KEY (`roundrobin_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_roundrobin_action`;
CREATE TABLE IF NOT EXISTS `avis_roundrobin_action` (
  `raction_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(15) DEFAULT NULL,
  `action_id` int(15) DEFAULT NULL,
  `content` text,
  PRIMARY KEY (`raction_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_roundrobin_criteria`;
CREATE TABLE IF NOT EXISTS `avis_roundrobin_criteria` (
  `rcriteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(15) NOT NULL,
  `base_criteria` int(15) DEFAULT NULL,
  `sub_criteria` int(15) NOT NULL DEFAULT '0',
  `content` text,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`rcriteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_assign_queue`;
CREATE TABLE IF NOT EXISTS `avis_assign_queue` (
  `queue_id` int(11) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `queue_flag` int(11) NOT NULL,
  PRIMARY KEY (`queue_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_auto_assign_ticket_setting`;
CREATE TABLE IF NOT EXISTS `avis_auto_assign_ticket_setting` (
  `assign_setting_id` int(12) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `access` int(11) DEFAULT NULL,
  `modified_time` int(15) DEFAULT NULL,
  PRIMARY KEY (`assign_setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_drive`;
CREATE TABLE IF NOT EXISTS `avis_drive` (
  `drive_id` int(15) NOT NULL AUTO_INCREMENT,
  `department_id` int(15) NOT NULL DEFAULT '0',
  `owner` int(4) DEFAULT NULL,
  `file_location` int(15) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `file_size` varchar(255) DEFAULT NULL,
  `file_type` varchar(255) DEFAULT NULL,
  `content` longtext,
  `creation_date` int(15) DEFAULT NULL,
  PRIMARY KEY (`drive_id`),
  KEY `department_id` (`department_id`),
  KEY `file_name` (`file_name`),
  KEY `file_type` (`file_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

INSERT INTO `avis_module` (`module_id`, `module`, `module_name`, `header_title`, `access_type`, `is_enabled`, `quick_view`, `quick_view_open`, `is_custom`) VALUES ('13', 'drive', 'Drive', 'Drive', '1', '1', '1', '1', '1');

INSERT INTO `avis_settings` (`setting_id`, `title`, `content`, `domain_id`, `department_id`, `module_id`) VALUES (NULL, 'vis_last_cron_time', NULL, '0', '0', '0');
DROP TABLE IF EXISTS `avis_token_drive`;
CREATE TABLE IF NOT EXISTS `avis_token_drive` (
  `token_id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `creation_date` int(15) NOT NULL,
  `attach_id` int(11) NOT NULL,
  `attach_type` int(2) NOT NULL COMMENT '0-attachment,1-drive',
  PRIMARY KEY (`token_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

INSERT INTO `avis_view_tab` (`view_tab_id`, `tab_name`, `tab_title`) VALUES (31, 'CI_attached', 'TXTCIATTACHED');

DROP TABLE IF EXISTS `avis_tax_setting`;
CREATE TABLE IF NOT EXISTS `avis_tax_setting` (
  `stax_id` int(4) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT NULL,
  `tax_stype` tinyint(1) NOT NULL DEFAULT '0',
  `tax_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `compound_tax` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stax_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_invoice_tax_mapping`;
CREATE TABLE IF NOT EXISTS `avis_invoice_tax_mapping` (
  `invoice_tax_map_id` int(15) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(15) DEFAULT NULL,
  `invoice_detail_id` int(15) DEFAULT NULL,
  `tax_id` int(15) DEFAULT NULL,
  `tax_status` int(15) DEFAULT NULL,
  PRIMARY KEY (`invoice_tax_map_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

ALTER TABLE `avis_forum` ADD `forum_status` TINYINT(1) NOT NULL COMMENT '0-Planned,1-In progress,2-Implemented,3-Solved,4-Unsolved,5-Deferred' AFTER `is_topic_move`;

DROP TABLE IF EXISTS `avis_autotask`;
CREATE TABLE `avis_autotask` (
			  `autotask_id` int(1) NOT NULL AUTO_INCREMENT,
			  `autotask_name` varchar(255) DEFAULT NULL,
			  `execution_order` int(15) DEFAULT NULL,
			  `concat_type` varchar(63) DEFAULT NULL,
			  `is_enabled` tinyint(1) DEFAULT '1',
			  `owner` int(15) DEFAULT NULL,
			  `creation_date` int(15) DEFAULT NULL,
			  `event` varchar(255) DEFAULT NULL,
			   PRIMARY KEY (`autotask_id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `avis_autotask_criteria`;	
CREATE TABLE `avis_autotask_criteria` (
			`atcriteria_id` int(1) NOT NULL AUTO_INCREMENT,
			`autotask_id` int(15) NOT NULL,
			`base_criteria` int(15) DEFAULT NULL,
			`sub_criteria` int(15) DEFAULT '0',
			`content` text,
			`concat_type` varchar(25) DEFAULT NULL,
			 PRIMARY KEY (`atcriteria_id`)
			)  ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
	
ALTER TABLE `avis_task` ADD `autotask_flag` TINYINT(1) NOT NULL AFTER `task_email_flag`, ADD `autotask_id` INT(15) NOT NULL AFTER `autotask_flag`, ADD `ticket_id` INT(15) NOT NULL AFTER `autotask_id`, ADD `auto_parent_id` INT(15) NOT NULL AFTER `ticket_id`;
	